(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    139905,       3122]
NotebookOptionsPosition[    128030,       2926]
NotebookOutlinePosition[    128514,       2944]
CellTagsIndexPosition[    128471,       2941]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"AppendTo", "[", 
   RowBox[{"$Path", ",", 
    RowBox[{"path", "<>", "\"\<SpinDynamica\\\\\>\""}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Needs", "[", "\"\<SpinDynamica`\>\"", "]"}]}], "Input",
 CellChangeTimes->{{3.852095012818228*^9, 3.852095018232193*^9}, {
   3.8529170086447225`*^9, 3.8529170229850817`*^9}, {3.852969993461128*^9, 
   3.8529699977805204`*^9}, {3.8530799004922276`*^9, 3.853079902192769*^9}, {
   3.853162999551647*^9, 3.8531630007546716`*^9}, {3.870232551801229*^9, 
   3.8702325603834977`*^9}, 3.8714761725726767`*^9, {3.8837308095381784`*^9, 
   3.883730809965865*^9}},ExpressionUUID->"85798c45-50b7-4988-9061-\
afcd31c248c4"],

Cell[BoxData[
 TagBox[
  FrameBox["\<\"SpinDynamica version 3.7.8m loaded by \\!\\(\\*\\nStyleBox[\\\
\"Mathematica\\\",\\nFontSlant->\\\"Italic\\\"]\\) 12.3 running on Microsoft \
Windows (64-bit).\"\>"],
  DisplayForm]], "Print",
 CellChangeTimes->{3.870856673006444*^9, 3.870871700611477*^9, 
  3.871476174095537*^9, 3.8714941365937853`*^9, 3.8715302340271564`*^9, 
  3.8717512384295697`*^9, 3.8719141226305103`*^9, 3.8728463536237435`*^9, 
  3.874760475222582*^9, 3.883548265741948*^9, 3.8835739922387714`*^9, 
  3.883575767011487*^9, 3.883579602763979*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"69fc4142-9b9c-490b-a8f9-798482b164c5"],

Cell[BoxData[
 TemplateBox[{
  "SetUserLevel", "ini", 
   "\"The user level is being initialized to \\!\\(\\*RowBox[{\\\"2\\\"}]\\). \
The user level may be set to an integer between 1 and \
\\!\\(\\*RowBox[{\\\"3\\\"}]\\) by using SetUserLevel[level]. Low user levels \
provide strong syntax trapping at the expense of slow execution for some \
routines. High user levels relax the syntax trapping in order to provide \
better execution speeds.\"", 2, 3, 1, 27111840185733821828, "Local", 
   "General`UserLevel`SetUserLevel"},
  "MessageTemplate2"]], "Message", "MSG",
 CellChangeTimes->{3.8708566753793945`*^9, 3.8708717034644785`*^9, 
  3.8714761766397905`*^9, 3.8714941380387354`*^9, 3.871530235653629*^9, 
  3.8717512407615566`*^9, 3.871914125916768*^9, 3.872846356511648*^9, 
  3.874760478009884*^9, 3.883548268132743*^9, 3.883573993329644*^9, 
  3.8835757680639887`*^9, 3.8835796044380126`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"53a09a36-c3d1-489f-8eb9-0500b866367c"],

Cell[BoxData[
 TemplateBox[{
  "SetUserLevel", "ul", 
   "\"The user level has been set to \\!\\(\\*RowBox[{\\\"2\\\"}]\\).\"", 2, 
   3, 2, 27111840185733821828, "Local", "General`UserLevel`SetUserLevel"},
  "MessageTemplate2"]], "Message", "MSG",
 CellChangeTimes->{3.8708566753793945`*^9, 3.8708717034644785`*^9, 
  3.8714761766397905`*^9, 3.8714941380387354`*^9, 3.871530235653629*^9, 
  3.8717512407615566`*^9, 3.871914125916768*^9, 3.872846356511648*^9, 
  3.874760478009884*^9, 3.883548268132743*^9, 3.883573993329644*^9, 
  3.8835757680639887`*^9, 3.8835796045116434`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"1bb62115-244a-4ff7-a611-419d8da4a5b5"],

Cell[BoxData[
 TemplateBox[{
  "SetUserLevel", "modsymbs", 
   "\"Additional definitions have been given to the following symbols: \\!\\(\
\\*RowBox[{\\\"{\\\", RowBox[{\\\"Dot\\\", \\\",\\\", \\\"Duration\\\", \\\",\
\\\", \\\"Exp\\\", \\\",\\\", \\\"Expand\\\", \\\",\\\", \\\"Plus\\\", \
\\\",\\\", \\\"Power\\\", \\\",\\\", \\\"Simplify\\\", \\\",\\\", \
\\\"SolidAngle\\\", \\\",\\\", \\\"Times\\\", \\\",\\\", \\\"WignerD\\\"}], \
\\\"}\\\"}]\\)\"", 2, 3, 3, 27111840185733821828, "Local", 
   "General`UserLevel`SetUserLevel"},
  "MessageTemplate2"]], "Message", "MSG",
 CellChangeTimes->{3.8708566753793945`*^9, 3.8708717034644785`*^9, 
  3.8714761766397905`*^9, 3.8714941380387354`*^9, 3.871530235653629*^9, 
  3.8717512407615566`*^9, 3.871914125916768*^9, 3.872846356511648*^9, 
  3.874760478009884*^9, 3.883548268132743*^9, 3.883573993329644*^9, 
  3.8835757680639887`*^9, 3.883579604531595*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"293ec027-6556-4641-9c31-2721d584ac56"],

Cell[BoxData[
 TemplateBox[{
  "SpinDynamica", "badinfo", 
   "\"In some cases, requesting information by executing \\\"?<symbol>\\\") \
generates an infinite loop. I have not been able to identify why this \
happens. In these cases, readable information on a symbol may be generated by \
executing \\\"<symbol>::usage\\\". Apologies from MHL.\"", 2, 3, 4, 
   27111840185733821828, "Local", "Global`SpinDynamica"},
  "MessageTemplate2"]], "Message", "MSG",
 CellChangeTimes->{3.8708566753793945`*^9, 3.8708717034644785`*^9, 
  3.8714761766397905`*^9, 3.8714941380387354`*^9, 3.871530235653629*^9, 
  3.8717512407615566`*^9, 3.871914125916768*^9, 3.872846356511648*^9, 
  3.874760478009884*^9, 3.883548268132743*^9, 3.883573993329644*^9, 
  3.8835757680639887`*^9, 3.8835796045505376`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"d568af73-6886-4e9b-a2a7-c57ceadf94a0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetSpinSystem", "[", "2", "]"}]], "Input",
 CellChangeTimes->{{3.867852201949355*^9, 3.867852205740755*^9}},
 CellLabel->"In[4]:=",ExpressionUUID->"e2ae5211-e862-4757-9062-57f766ba5937"],

Cell[BoxData[
 TemplateBox[{
  "SetSpinSystem", "set", 
   "\"the spin system has been set to \\!\\(\\*RowBox[{\\\"{\\\", \
RowBox[{RowBox[{\\\"{\\\", RowBox[{\\\"1\\\", \\\",\\\", \
FractionBox[\\\"1\\\", \\\"2\\\"]}], \\\"}\\\"}], \\\",\\\", \
RowBox[{\\\"{\\\", RowBox[{\\\"2\\\", \\\",\\\", FractionBox[\\\"1\\\", \\\"2\
\\\"]}], \\\"}\\\"}]}], \\\"}\\\"}]\\)\"", 2, 4, 5, 27111840185733821828, 
   "Local", "QM`Hilbert`SetSpinSystem"},
  "MessageTemplate2"]], "Message", "MSG",
 CellChangeTimes->{3.8708566758152857`*^9, 3.8708717038304963`*^9, 
  3.871476177499736*^9, 3.871494138468914*^9, 3.8715302361181917`*^9, 
  3.8717512413071475`*^9, 3.8719141264644065`*^9, 3.8728463571963067`*^9, 
  3.883548268732017*^9, 3.8835739938734283`*^9, 3.8835757684309273`*^9, 
  3.883579604972944*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"08b96f40-4e51-491c-833f-657dab51a75f"],

Cell[BoxData[
 TemplateBox[{
  "SetBasis", "set", 
   "\"the state basis has been set to \\!\\(\\*RowBox[{\\\"ZeemanBasis\\\", \
\\\"[\\\", RowBox[{RowBox[{\\\"{\\\", RowBox[{RowBox[{\\\"{\\\", \
RowBox[{\\\"1\\\", \\\",\\\", FractionBox[\\\"1\\\", \\\"2\\\"]}], \
\\\"}\\\"}], \\\",\\\", RowBox[{\\\"{\\\", RowBox[{\\\"2\\\", \\\",\\\", \
FractionBox[\\\"1\\\", \\\"2\\\"]}], \\\"}\\\"}]}], \\\"}\\\"}], \\\",\\\", \
RowBox[{\\\"BasisLabels\\\", \\\"\[Rule]\\\", \\\"Automatic\\\"}]}], \
\\\"]\\\"}]\\).\"", 2, 4, 6, 27111840185733821828, "Local", 
   "QM`Hilbert`SetBasis"},
  "MessageTemplate2"]], "Message", "MSG",
 CellChangeTimes->{3.8708566758152857`*^9, 3.8708717038304963`*^9, 
  3.871476177499736*^9, 3.871494138468914*^9, 3.8715302361181917`*^9, 
  3.8717512413071475`*^9, 3.8719141264644065`*^9, 3.8728463571963067`*^9, 
  3.883548268732017*^9, 3.8835739938734283`*^9, 3.8835757684309273`*^9, 
  3.8835796049968805`*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"4f5a186c-9436-4d83-a9d9-1c5bc4bb24af"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetBasis", "[", 
  RowBox[{"SingletTripletBasis", "[", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.869821415593367*^9, 3.8698214225202055`*^9}},
 CellLabel->"In[5]:=",ExpressionUUID->"0415dfe8-f1f6-4aed-a61f-6e562b19aea6"],

Cell[BoxData[
 TemplateBox[{
  "SetBasis", "set", 
   "\"the state basis has been set to \
\\!\\(\\*RowBox[{\\\"SingletTripletBasis\\\", \\\"[\\\", \
RowBox[{RowBox[{\\\"{\\\", RowBox[{RowBox[{\\\"{\\\", RowBox[{\\\"1\\\", \
\\\",\\\", FractionBox[\\\"1\\\", \\\"2\\\"]}], \\\"}\\\"}], \\\",\\\", \
RowBox[{\\\"{\\\", RowBox[{\\\"2\\\", \\\",\\\", FractionBox[\\\"1\\\", \\\"2\
\\\"]}], \\\"}\\\"}]}], \\\"}\\\"}], \\\",\\\", RowBox[{\\\"BasisLabels\\\", \
\\\"\[Rule]\\\", \\\"Automatic\\\"}]}], \\\"]\\\"}]\\).\"", 2, 5, 7, 
   27111840185733821828, "Local", "QM`Hilbert`SetBasis"},
  "MessageTemplate2"]], "Message", "MSG",
 CellChangeTimes->{3.8708566758920813`*^9, 3.8708717039242735`*^9, 
  3.8714761776681986`*^9, 3.8714941385431767`*^9, 3.871530236263791*^9, 
  3.8717512415140896`*^9, 3.8719141266329556`*^9, 3.8728463573696856`*^9, 
  3.8835482688614817`*^9, 3.883573994926567*^9, 3.883575768482559*^9, 
  3.8835796050706873`*^9},
 CellLabel->
  "During evaluation of \
In[5]:=",ExpressionUUID->"c7c29c63-7039-456c-96df-2ec899f8a6b1"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Hamiltonian", "Section",
 CellChangeTimes->{{3.8698158743636246`*^9, 3.8698158756916738`*^9}, {
  3.8698159783467293`*^9, 
  3.8698159794430237`*^9}},ExpressionUUID->"d1b5b305-0230-4197-8335-\
8a91c4a884a4"],

Cell["\<\
Hamiltonian for a nearly-equivalent spin system (equation 24) \
\>", "Text",
 CellChangeTimes->{{3.883574151345195*^9, 3.8835741672172675`*^9}},
 Background->RGBColor[
  0.87, 0.94, 1],ExpressionUUID->"fff671ab-a8da-42f0-939f-9d2bf96318a6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"H0", "=", 
  RowBox[{"\[CapitalOmega]", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Sin", "[", "\[Theta]", "]"}], "/", "2"}], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"opI", "[", 
         RowBox[{"1", ",", "\"\<z\>\""}], "]"}], "-", 
        RowBox[{"opI", "[", 
         RowBox[{"2", ",", "\"\<z\>\""}], "]"}]}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"Cos", "[", "\[Theta]", "]"}], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"opI", "[", "1", "]"}], ".", 
         RowBox[{"opI", "[", "2", "]"}]}], "+", 
        RowBox[{
         RowBox[{"1", "/", "4"}], " ", 
         RowBox[{"UnityOperator", "[", "]"}]}]}], ")"}]}]}], 
    ")"}]}]}]], "Input",
 CellChangeTimes->{{3.8686819090970697`*^9, 3.868681909358418*^9}, {
   3.8686819512947817`*^9, 3.868681957326753*^9}, {3.868685457525487*^9, 
   3.8686854700571055`*^9}, {3.868697679067564*^9, 3.8686976792259765`*^9}, {
   3.869041561941145*^9, 3.869041564156642*^9}, {3.869132435374628*^9, 
   3.8691324355013924`*^9}, 3.869815981626952*^9, 3.869816082661998*^9, {
   3.86984317502136*^9, 3.86984318071693*^9}, {3.8702325041526866`*^9, 
   3.8702325165978413`*^9}, {3.8702325684354854`*^9, 3.870232592636981*^9}, {
   3.8835740066187525`*^9, 3.883574030444171*^9}},
 CellLabel->"In[6]:=",ExpressionUUID->"8d810ca2-45a7-4e42-8d0f-da5b4bf0109f"],

Cell[BoxData[
 RowBox[{"\[CapitalOmega]", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       TagBox[
        SubscriptBox["I", 
         RowBox[{"1", "z"}]],
        DisplayForm], "-", 
       TagBox[
        SubscriptBox["I", 
         RowBox[{"2", "z"}]],
        DisplayForm]}], ")"}], " ", 
     RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "+", 
    RowBox[{
     RowBox[{"Cos", "[", "\[Theta]", "]"}], " ", 
     RowBox[{"(", 
      RowBox[{
       TagBox[
        RowBox[{
         TagBox[
          SubscriptBox["I", 
           RowBox[{"1", "x"}]],
          DisplayForm], 
         AdjustmentBox["\[Bullet]",
          BoxMargins->{{-0.3, 0}, {0, 0}}], 
         TagBox[
          SubscriptBox["I", 
           RowBox[{"2", "x"}]],
          DisplayForm]}],
        DisplayForm], "+", 
       TagBox[
        RowBox[{
         TagBox[
          SubscriptBox["I", 
           RowBox[{"1", "y"}]],
          DisplayForm], 
         AdjustmentBox["\[Bullet]",
          BoxMargins->{{-0.3, 0}, {0, 0}}], 
         TagBox[
          SubscriptBox["I", 
           RowBox[{"2", "y"}]],
          DisplayForm]}],
        DisplayForm], "+", 
       TagBox[
        RowBox[{
         TagBox[
          SubscriptBox["I", 
           RowBox[{"1", "z"}]],
          DisplayForm], 
         AdjustmentBox["\[Bullet]",
          BoxMargins->{{-0.3, 0}, {0, 0}}], 
         TagBox[
          SubscriptBox["I", 
           RowBox[{"2", "z"}]],
          DisplayForm]}],
        DisplayForm], "+", 
       FractionBox["\<\"\[DoubleStruckOne]\"\>", "4"]}], ")"}]}]}], 
   ")"}]}]], "Output",
 CellChangeTimes->{
  3.8702325928678074`*^9, 3.870346578911893*^9, 3.8708535478965693`*^9, 
   3.8708566759539146`*^9, 3.8708717040020547`*^9, {3.8714761858743553`*^9, 
   3.8714761963434258`*^9}, 3.87149414077112*^9, 3.871530238807418*^9, 
   3.872846357800484*^9, 3.883548271265901*^9, {3.8835739972708015`*^9, 
   3.8835740307017784`*^9}, 3.883575768532199*^9, 3.883579605153474*^9},
 CellLabel->"Out[6]=",ExpressionUUID->"fec3e9d9-4564-4d8e-98a7-009545b9bded"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"MatrixRepresentation", "[", "H0", "]"}], "//", 
  "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.8702325932636843`*^9, 3.870232599254883*^9}, {
  3.8714692968892293`*^9, 3.871469300127285*^9}, {3.8835740012608275`*^9, 
  3.883574001381655*^9}},
 CellLabel->"In[7]:=",ExpressionUUID->"18997f02-bf80-462a-aa95-13512bf35acd"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], " ", "\[CapitalOmega]", " ", 
       RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "0", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[CapitalOmega]", " ", 
       RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "0"},
     {"0", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[CapitalOmega]", " ", 
       RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "0", "0"},
     {
      RowBox[{
       FractionBox["1", "2"], " ", "\[CapitalOmega]", " ", 
       RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "0", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[CapitalOmega]", " ", 
       RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "0"},
     {"0", "0", "0", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[CapitalOmega]", " ", 
       RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[
   SparseArray[
    Automatic, {4, 4}, 0, {
     1, {{0, 2, 3, 5, 6}, {{1}, {3}, {2}, {1}, {3}, {4}}}, {
      Rational[-1, 2] $CellContext`\[CapitalOmega] Cos[$CellContext`\[Theta]],
        Rational[1, 2] $CellContext`\[CapitalOmega] 
       Sin[$CellContext`\[Theta]], 
       Rational[1, 2] $CellContext`\[CapitalOmega] Cos[$CellContext`\[Theta]],
        Rational[1, 2] $CellContext`\[CapitalOmega] 
       Sin[$CellContext`\[Theta]], 
       Rational[1, 2] $CellContext`\[CapitalOmega] Cos[$CellContext`\[Theta]],
        Rational[1, 2] $CellContext`\[CapitalOmega] 
       Cos[$CellContext`\[Theta]]}}]]]]], "Output",
 CellChangeTimes->{{3.870232596183276*^9, 3.8702325995186987`*^9}, 
   3.870346579000654*^9, 3.8708535479933133`*^9, 3.870856676014753*^9, 
   3.8708717040708504`*^9, {3.871469300484702*^9, 3.871469305175625*^9}, {
   3.871476187346404*^9, 3.871476196569202*^9}, 3.8714941410543146`*^9, 
   3.8715302390528135`*^9, 3.8728463581989684`*^9, {3.8835739985815215`*^9, 
   3.8835740316478376`*^9}, 3.88357576858506*^9, 3.8835796052770305`*^9},
 CellLabel->
  "Out[7]//MatrixForm=",ExpressionUUID->"3a30e733-2852-488a-a371-\
b330ceee4c66"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["time shifted spin echo", "Section",
 CellChangeTimes->{{3.8698158743636246`*^9, 3.8698158756916738`*^9}, {
  3.869817205568797*^9, 3.869817215792103*^9}, {3.8698200616258545`*^9, 
  3.8698200631732306`*^9}, {3.8702326249558835`*^9, 3.8702326262259893`*^9}, {
  3.8835766168346963`*^9, 
  3.8835766220557795`*^9}},ExpressionUUID->"4f28c91d-5dad-4a67-9fb1-\
0fb06e214162"],

Cell[TextData[{
 "\[Pi]-pulses are equivalent to a z-rotation in the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["S", "0"], TraditionalForm]],
  FormatType->TraditionalForm,ExpressionUUID->
  "14d3fe16-0bde-43eb-9a2f-f78d7f0f2696"],
 " / ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["T", "0"], TraditionalForm]],
  FormatType->TraditionalForm,ExpressionUUID->
  "5f28f08d-f629-4c45-9d46-06693794bb43"],
 "  subspace up to an overall phase of i."
}], "Text",
 CellChangeTimes->{{3.883574151345195*^9, 3.8835742328689322`*^9}, {
  3.8835742923211794`*^9, 3.883574310740134*^9}, {3.8835743515919504`*^9, 
  3.883574359330364*^9}},
 Background->RGBColor[
  0.87, 0.94, 1],ExpressionUUID->"17581026-39bc-4b55-9330-e528b8619a04"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"MatrixRepresentation", "[", 
   RowBox[{"RotationOperator", "[", 
    RowBox[{"{", 
     RowBox[{"\[Pi]", ",", "\"\<y\>\""}], "}"}], "]"}], "]"}], "//", 
  "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.8835741900234103`*^9, 3.8835741988512545`*^9}},
 CellLabel->"In[8]:=",ExpressionUUID->"416f063b-f36d-4bd9-b0be-58e04d60eaf2"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0", "0", "0"},
     {"0", "0", "0", "1"},
     {"0", "0", 
      RowBox[{"-", "1"}], "0"},
     {"0", "1", "0", "0"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[
   SparseArray[
    Automatic, {4, 4}, 0, {
     1, {{0, 1, 2, 3, 4}, {{1}, {4}, {3}, {2}}}, {1, 1, -1, 1}}]]]]], "Output",
 CellChangeTimes->{{3.8835741959255877`*^9, 3.8835741990674076`*^9}, 
   3.8835757686247797`*^9, 3.883579605339735*^9},
 CellLabel->
  "Out[8]//MatrixForm=",ExpressionUUID->"cd6b5714-345f-4466-9518-\
831898dff4a9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DiagonalMatrix", "[", 
    RowBox[{"{", 
     RowBox[{"I", ",", "1", ",", "I", ",", "1"}], "}"}], "]"}], ".", 
   RowBox[{"MatrixRepresentation", "[", 
    RowBox[{"Exp", "[", 
     RowBox[{
      RowBox[{"-", "I"}], " ", "\[Pi]", "*", 
      RowBox[{"SingleTransitionOperator", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "3"}], "}"}], ",", "\"\<z\>\""}], "]"}]}], "]"}], 
    "]"}]}], "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.8835743182597113`*^9, 3.88357434767519*^9}},
 CellLabel->"In[9]:=",ExpressionUUID->"69c75c6d-c27c-4677-888b-865880c68787"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0", "0", "0"},
     {"0", "1", "0", "0"},
     {"0", "0", 
      RowBox[{"-", "1"}], "0"},
     {"0", "0", "0", "1"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.8835743261386642`*^9, 3.883574347948697*^9}, 
   3.883575768662013*^9, 3.8835796054131594`*^9},
 CellLabel->
  "Out[9]//MatrixForm=",ExpressionUUID->"0d03925b-9e6e-419f-bb80-\
adbab995ae5e"]
}, Open  ]],

Cell[TextData[{
 "It follows that \[Pi]-pulses do not mix ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["S", "0"], TraditionalForm]],
  FormatType->TraditionalForm,ExpressionUUID->
  "28743fe6-914e-460d-8b5d-e6b5704b5d4c"],
 " / ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["T", "0"], TraditionalForm]],
  FormatType->TraditionalForm,ExpressionUUID->
  "00ce2018-0965-450e-ab79-eb4da96cb89f"],
 " with ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["T", 
    RowBox[{"+", "1"}]], TraditionalForm]],
  FormatType->TraditionalForm,ExpressionUUID->
  "72d11acf-29bb-42c0-a57e-d16c1cec4411"],
 " / ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["T", 
    RowBox[{"-", "1"}]], TraditionalForm]],
  FormatType->TraditionalForm,ExpressionUUID->
  "467920e6-0c40-47ef-99df-efe50d80a82d"],
 ". We can thus extract the Hamiltonian for the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["S", "0"], TraditionalForm]],
  FormatType->TraditionalForm,ExpressionUUID->
  "18c0842d-8981-4de6-8383-922045f2aa07"],
 " - ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["T", "0"], TraditionalForm]],
  FormatType->TraditionalForm,ExpressionUUID->
  "553c57c1-e3c7-4ed9-8b44-2f1d7f870d3e"],
 " subspace and focus on this part."
}], "Text",
 CellChangeTimes->{{3.883574151345195*^9, 3.8835741835393295`*^9}, {
  3.883574235189148*^9, 3.883574286729309*^9}},
 Background->RGBColor[
  0.87, 0.94, 1],ExpressionUUID->"7439d992-c337-407e-b9ec-b9f731617cfc"],

Cell[BoxData[
 RowBox[{
  RowBox[{"HS0T0", "=", 
   RowBox[{
    RowBox[{"MatrixRepresentation", "[", "H0", "]"}], "\[LeftDoubleBracket]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}]}], "\[RightDoubleBracket]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.8701715123542027`*^9, 3.870171541208441*^9}, {
  3.8701908754334383`*^9, 3.8701909569060593`*^9}, {3.8702326612697415`*^9, 
  3.8702326684486074`*^9}, {3.8708552577254095`*^9, 3.870855262270091*^9}, {
  3.8835740575976295`*^9, 3.883574064143486*^9}},
 CellLabel->"In[10]:=",ExpressionUUID->"47656a27-619a-414f-94b6-d5e34dea4f3f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HS0T0", "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.8708552642204723`*^9, 3.870855269333555*^9}, 
   3.8835741103695607`*^9},
 CellLabel->"In[11]:=",ExpressionUUID->"ea6ae162-c0ad-4320-9a26-34b0032ed501"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], " ", "\[CapitalOmega]", " ", 
       RowBox[{"Cos", "[", "\[Theta]", "]"}]}], 
      RowBox[{
       FractionBox["1", "2"], " ", "\[CapitalOmega]", " ", 
       RowBox[{"Sin", "[", "\[Theta]", "]"}]}]},
     {
      RowBox[{
       FractionBox["1", "2"], " ", "\[CapitalOmega]", " ", 
       RowBox[{"Sin", "[", "\[Theta]", "]"}]}], 
      RowBox[{
       FractionBox["1", "2"], " ", "\[CapitalOmega]", " ", 
       RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[
   SparseArray[
    Automatic, {2, 2}, 0, {
     1, {{0, 2, 4}, {{1}, {2}, {1}, {2}}}, {
      Rational[-1, 2] $CellContext`\[CapitalOmega] Cos[$CellContext`\[Theta]],
        Rational[1, 2] $CellContext`\[CapitalOmega] 
       Sin[$CellContext`\[Theta]], 
       Rational[1, 2] $CellContext`\[CapitalOmega] Sin[$CellContext`\[Theta]],
        Rational[1, 2] $CellContext`\[CapitalOmega] 
       Cos[$CellContext`\[Theta]]}}]]]]], "Output",
 CellChangeTimes->{3.870855269604657*^9, 3.870856676124459*^9, 
  3.870871704188534*^9, 3.87147619939637*^9, 3.8714941438769236`*^9, 
  3.87153024173215*^9, 3.872846358854897*^9, 3.883548415883656*^9, 
  3.8835741109249296`*^9, 3.8835757687130156`*^9, 3.883579605528672*^9},
 CellLabel->
  "Out[11]//MatrixForm=",ExpressionUUID->"9a518918-2f81-42d6-83e6-\
39e10c715140"]
}, Open  ]],

Cell["define spin-1/2 spin angular momentum operator", "Text",
 CellChangeTimes->{{3.883574151345195*^9, 3.8835741835393295`*^9}, {
  3.883574235189148*^9, 3.883574286729309*^9}, {3.8835750927415276`*^9, 
  3.883575116688829*^9}},
 Background->RGBColor[
  0.87, 0.94, 1],ExpressionUUID->"5de2e783-951b-4f62-8a99-fdc472304d7c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Svec", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"Sx", ",", "Sy", ",", "Sz"}], "}"}], "=", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"PauliMatrix", "[", "1", "]"}], ",", 
       RowBox[{"PauliMatrix", "[", "2", "]"}], ",", 
       RowBox[{"PauliMatrix", "[", "3", "]"}]}], "}"}], "/", "2"}]}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.8702377205825343`*^9, 3.87023773042422*^9}, {
  3.883575077941391*^9, 3.8835750813113556`*^9}, {3.883575639560416*^9, 
  3.883575640233673*^9}},
 CellLabel->"In[12]:=",ExpressionUUID->"d684ea61-e0b5-4e23-9b07-d806949a637a"],

Cell["define a generic time-shifted echo :", "Text",
 CellChangeTimes->{{3.883574151345195*^9, 3.8835741835393295`*^9}, {
   3.883574235189148*^9, 3.883574267148384*^9}, {3.8835743656521654`*^9, 
   3.8835743690731983`*^9}, 3.8835744571129894`*^9},
 Background->RGBColor[
  0.87, 0.94, 1],ExpressionUUID->"67eba4d4-2621-4baf-bf1a-badfaeb995ee"],

Cell[BoxData[{
 RowBox[{"Clear", "[", "shiftedechoXY", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"shiftedechoXY", "=", 
   RowBox[{
    RowBox[{"MatrixExp", "[", 
     RowBox[{
      RowBox[{"-", "I"}], " ", "\[Tau]", " ", "HS0T0"}], "]"}], " ", ".", 
    RowBox[{"MatrixExp", "[", 
     RowBox[{
      RowBox[{"-", "I"}], " ", "\[Pi]", " ", "Sz"}], "]"}], ".", 
    RowBox[{"MatrixExp", "[", 
     RowBox[{
      RowBox[{"-", "I"}], " ", 
      RowBox[{"(", 
       RowBox[{"\[Tau]", "+", "\[Delta]\[Tau]"}], ")"}], " ", "HS0T0"}], 
     "]"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.870194185030485*^9, 3.870194195127334*^9}, {
  3.870194244932421*^9, 3.8701943268199863`*^9}, {3.8701946389850225`*^9, 
  3.870194649622913*^9}, {3.870196964355118*^9, 3.870196970364913*^9}, {
  3.870232742937948*^9, 3.870232791695655*^9}, {3.8702328826815434`*^9, 
  3.8702328832126684`*^9}, {3.8702329212424927`*^9, 3.870232943037812*^9}, {
  3.870233033703017*^9, 3.8702330465354185`*^9}, {3.8835740752365475`*^9, 
  3.8835740834644065`*^9}, {3.88357441318711*^9, 3.883574415506241*^9}, {
  3.883574464815892*^9, 3.8835744864941125`*^9}, {3.883574631350669*^9, 
  3.883574638340881*^9}, {3.8835749861555953`*^9, 3.883574987236394*^9}, {
  3.8835750871012964`*^9, 3.8835750873112936`*^9}},
 CellLabel->"In[13]:=",ExpressionUUID->"d5a4f5d4-ec22-445f-af0c-c3b1a95e0e92"],

Cell["Enforce a pure transverse rotation:", "Text",
 CellChangeTimes->{{3.883574151345195*^9, 3.8835741835393295`*^9}, {
  3.883574235189148*^9, 3.883574267148384*^9}, {3.8835743656521654`*^9, 
  3.8835743690731983`*^9}, {3.88357444687392*^9, 3.8835744554323215`*^9}},
 Background->RGBColor[
  0.87, 0.94, 1],ExpressionUUID->"c539b3b4-9bb4-437f-9016-4c594a34a8c0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Tau]cond", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"FullSimplify", "[", 
     RowBox[{
      RowBox[{"\[Tau]", "/.", 
       RowBox[{
        RowBox[{"Solve", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"FullSimplify", "[", 
            RowBox[{"Tr", "[", 
             RowBox[{"shiftedechoXY", ".", "Sz"}], "]"}], "]"}], "\[Equal]", 
           "0"}], ",", "\[Tau]"}], "]"}], "\[LeftDoubleBracket]", "2", 
        "\[RightDoubleBracket]"}]}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"C", "[", "1", "]"}], "\[Rule]", " ", "0"}], "}"}]}], "]"}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"ArcCos", "[", 
       RowBox[{"-", "a_"}], "]"}], "\[RuleDelayed]", 
      RowBox[{"\[Pi]", "-", 
       RowBox[{"ArcCos", "[", "a", "]"}]}]}], "}"}]}], "//", 
   "Expand"}]}]], "Input",
 CellChangeTimes->{{3.870232885790183*^9, 3.870232985760681*^9}, {
   3.8702330493785877`*^9, 3.870233052516864*^9}, 3.870234000627493*^9, {
   3.8702340387443967`*^9, 3.87023405563027*^9}, {3.870234130335437*^9, 
   3.870234163868859*^9}, {3.870234352053173*^9, 3.870234370904821*^9}, {
   3.8702344058333797`*^9, 3.870234451645425*^9}, {3.8702346706089463`*^9, 
   3.870234698870599*^9}, {3.870234745800275*^9, 3.8702347647761087`*^9}, {
   3.8702350743599224`*^9, 3.870235079170225*^9}, {3.8702356505462446`*^9, 
   3.870235673995615*^9}, {3.870235844134491*^9, 3.87023585406912*^9}, {
   3.8702359409346385`*^9, 3.870235956598755*^9}, {3.8702361742273383`*^9, 
   3.870236183351582*^9}, {3.870236562458621*^9, 3.8702365774339533`*^9}, 
   3.8702366798715425`*^9, {3.870237205946617*^9, 3.870237206118453*^9}, {
   3.8702373178533235`*^9, 3.8702373225865126`*^9}, {3.8702385954994545`*^9, 
   3.870238610785991*^9}, {3.8835744207841125`*^9, 3.8835744421550894`*^9}, {
   3.883575130929413*^9, 3.8835751311723614`*^9}},
 CellLabel->"In[15]:=",ExpressionUUID->"56aeb567-e2a8-4d6b-a8c6-fcee0fad0818"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["\[Delta]\[Tau]", "2"]}], "+", 
  FractionBox["\[Pi]", "\[CapitalOmega]"], "-", 
  FractionBox[
   RowBox[{"ArcCos", "[", 
    RowBox[{
     RowBox[{"Cos", "[", 
      FractionBox[
       RowBox[{"\[Delta]\[Tau]", " ", "\[CapitalOmega]"}], "2"], "]"}], " ", 
     SuperscriptBox[
      RowBox[{"Tan", "[", "\[Theta]", "]"}], "2"]}], "]"}], 
   "\[CapitalOmega]"]}]], "Output",
 CellChangeTimes->{{3.8702329057648325`*^9, 3.8702329179728947`*^9}, {
   3.870232950175575*^9, 3.8702329860274134`*^9}, 3.870233054651723*^9, 
   3.8702340036110897`*^9, 3.870234057911045*^9, {3.8702341329441586`*^9, 
   3.870234164259368*^9}, 3.8702343729511657`*^9, {3.870234425428895*^9, 
   3.8702344537542267`*^9}, {3.8702346730301847`*^9, 3.870234700807522*^9}, {
   3.8702347476591206`*^9, 3.870234766604746*^9}, 3.870235081309003*^9, {
   3.870235654635495*^9, 3.870235675609146*^9}, {3.8702358518447547`*^9, 
   3.870235854303341*^9}, {3.8702359430122194`*^9, 3.870235958669614*^9}, 
   3.870236185710273*^9, {3.870236567850351*^9, 3.870236579292905*^9}, 
   3.870236681089916*^9, 3.870237136442399*^9, 3.870237207930405*^9, 
   3.870237324077769*^9, {3.870238608690383*^9, 3.870238611221012*^9}, 
   3.8703465811986427`*^9, 3.8708535504771185`*^9, 3.8708566780860667`*^9, 
   3.870871706405935*^9, 3.8714762033327427`*^9, 3.8714941462756033`*^9, 
   3.871530244540159*^9, 3.8728463628128796`*^9, 3.883548419184601*^9, 
   3.88357409573551*^9, 3.883574493975773*^9, 3.8835746506433325`*^9, 
   3.883574993235512*^9, {3.883575128490262*^9, 3.883575131777566*^9}, 
   3.883575770642437*^9, 3.8835796087162523`*^9},
 CellLabel->"Out[15]=",ExpressionUUID->"373ab23d-b937-4322-b812-89c9a81a9f50"]
}, Open  ]],

Cell["check validity range of the solution", "Text",
 CellChangeTimes->{{3.883574151345195*^9, 3.8835741835393295`*^9}, {
  3.883574235189148*^9, 3.883574267148384*^9}, {3.8835743656521654`*^9, 
  3.8835743690731983`*^9}, {3.88357444687392*^9, 3.8835744554323215`*^9}, {
  3.883574660971348*^9, 3.883574665659684*^9}},
 Background->RGBColor[
  0.87, 0.94, 1],ExpressionUUID->"69c3883e-cba3-4b58-83f7-f3ef0137daf1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"\[Tau]cond", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[Theta]", "\[Rule]", " ", "0.3"}], ",", 
       RowBox[{"\[CapitalOmega]", "\[Rule]", " ", 
        RowBox[{"2", "\[Pi]"}]}]}], "}"}]}], "//", "Evaluate"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Delta]\[Tau]", ",", 
     RowBox[{
      RowBox[{"-", "1"}], "/", "2"}], ",", 
     RowBox[{"1", "/", "2"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8702357010486946`*^9, 3.870235715264494*^9}, {
   3.87025072012114*^9, 3.8702507204961414`*^9}, {3.870250820008642*^9, 
   3.8702508496748137`*^9}, {3.8702508796949005`*^9, 
   3.8702508798198957`*^9}, {3.8702511623152423`*^9, 
   3.8702511880210876`*^9}, {3.8702512901688957`*^9, 3.870251328234232*^9}, {
   3.8702513801652164`*^9, 3.8702514430034065`*^9}, {3.8702515421709137`*^9, 
   3.87025154383552*^9}, 3.883574658132656*^9, {3.883574996529154*^9, 
   3.8835749974460926`*^9}},
 CellLabel->"In[16]:=",ExpressionUUID->"669aab98-5ab0-446b-9890-744eda1f5d5b"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwt1Gs01HkYB/DBKivlUhKFXLIqa7tMVJavtDoKibQ4NtdDbQlrGTpj7dDI
2LVRaXe2VauY5BJLalLDzyVMyW0YM2aYf1E2bY6ECdltZ8/ZF895zuc83+fl
81hExPlFqdNoNG9V/dftsfrVhw8UUbCNlKqOuHkrzvwCReKLlIfu/03hj9tb
baZnKWKmIypPfE9hm613xNhfFGE8jw0fV1Jw1GfLnkgostAp7RBNUHAdnXr8
axVFouLsL/PkFPyyOsu3h1Ikv+OluiefQnI3+9SxBgVpax6n58dS6O9f9qop
fJhsCSkSy3sUMG2MW+W4bojkXO8TMpwVuHPyoabusIykpZrkCiuGEZaz9c1g
xiChr7vHv6g7jLkLTA6BlNSb7zM+lzqEohUKY+6zAfLa7tq4aEiOggNbE/qy
xeRc1Bq7bMiREROesnF/P5l66tQTUCEDU6MsOWFCRFyiqyo/0ZEhnNVtPXCz
lwjoGosajEFcqn/BLTjRQyZyvX/eNSLFfcpWp8Kyixy4PqO03iOFlZ6rm//V
DrLr0w2dpmUS1GzinBgZFZK8WG7XeU0JqNbq9Q4ObWTxHkPNOnIAL+wubSN3
W8j6uY3ivsdi6KeVOtirNRGfVTZvq6zFsHOYtONNC4i/vntiLacfZ76Y6KlL
4RPr7ZPpZYo+GPpX5gUZ1ZDodzGSMoc+1ChbdYXWZcSAPmP+nisCT/7ip3H2
VSJ0camaed2Lo77rauWRbHI4Q5LxpWcv6rSZ4uakMxgLetP/trwHO0bUzNID
f8e5Wsbw9PtuWL15ML+7uRTmHLNJ9ztd2F802HkwsAYjPsfUVvp2wt3bQGP2
Dh/2BlSn81QHckMlrC18AczuG3rRSx6j/aDp8kMGTYhk3HL0xCNMWBimiS63
oFqXsSZtoh1JiZvDc1e34fCj1KTKwjZIhvT8ooVCSHfqXmzc0Yqw05//udSr
AzqZDH/2sxa0bHb8oUWzC6smjZaoxTXD5mPBy2KPHnzwOh6ZvbIJpoKT7pqc
Xqxf+LbNgklAW1AvTRgRQemjns2+IMA73/qQ1g39iDEJ/vqzwTrI6aFrN7DF
iPdn0W1G7yI+QE/fcmgAdOPhEuHcbRjnPw/8yFSKgluyGLlLNSqDC0umUwZR
IKPzaecrEOD8vYewXgZ2RlXWd0tKUB1yynL3ohx0h72s2UvXMKe9V6PuyDC4
rtntWsG/wK/XycGUq0DjvJ+WoJgDbadlTYIrCsSncFh2bhw0Fcs8vypSIEwp
6i6gsrAl5XT4b5UKsNZCmWqShRXm/BzjVgV6hq4kOuVl4lHMtlHDtwrQIp8I
q5kZcNXamLfCi0Ihd2+tHi8Fc9/MmVT6qjx+d2KcSkaVvJ3nHUDh6Tvqn2aT
ZJhVRT/IiVC5IfNWYl4SFo8Uj2mfpsAqTw8bYCaAX2TuvPQGhcbbhSxb3nHE
Lp9sv1GuumvxWkuJyTHYJDf47atW5Y24BZl5Ucg/cPR4pkCVfzlvM8KMQMLU
5Ysafaq5fVDtdl4gNgWfMCuSqmw4uyY37wiePdxV6qZQ2Wdz0CumHw5xpQ3p
4xRotGj1PTwPaKnf3G8xqTLEY0qmG8jJ5P7GGZXPWgUG8XaCId4XGrag8tyS
hGyeLf7/X6p9WsiP6h4u/wII63kr
       "]]},
     Annotation[#, "Charting`Private`Tag$9268#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  LabelStyle->Directive[FontFamily -> "Helvetica", FontSize -> 14],
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->NCache[{{
      Rational[-1, 2], 
      Rational[1, 2]}, {0., 0.4999999907723359}}, {{-0.5, 0.5}, {0., 
    0.4999999907723359}}],
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.870235713066896*^9, 3.87023571548318*^9}, 
   3.870235859929253*^9, 3.870235958778994*^9, 3.87023618583524*^9, {
   3.8702365688501396`*^9, 3.870236579402254*^9}, 3.870236681989649*^9, 
   3.8702372091022468`*^9, 3.8702373253297296`*^9, 3.8702386206052403`*^9, 
   3.8702507208709817`*^9, {3.870250820633455*^9, 3.8702508502839427`*^9}, {
   3.8702511629868574`*^9, 3.8702511882554293`*^9}, {3.870251296573455*^9, 
   3.8702513285309706`*^9}, {3.8702513807431326`*^9, 
   3.8702514432131796`*^9}, {3.870251524173402*^9, 3.8702515441009836`*^9}, 
   3.87034658161353*^9, 3.8708535506307077`*^9, 3.8708566785004654`*^9, 
   3.87087170680641*^9, 3.8714762043259745`*^9, 3.8714941467109575`*^9, 
   3.8715302450294304`*^9, 3.872846363659498*^9, 3.883548419437499*^9, {
   3.8835746585261374`*^9, 3.8835746672019253`*^9}, 3.8835749977862263`*^9, 
   3.8835757709416513`*^9, 3.8835796092258835`*^9},
 CellLabel->"Out[16]=",ExpressionUUID->"5c05bb5c-5877-4c54-81e2-b276a4e7f586"]
}, Open  ]],

Cell["extract rotation axis:", "Text",
 CellChangeTimes->{{3.883574151345195*^9, 3.8835741835393295`*^9}, {
   3.883574235189148*^9, 3.883574267148384*^9}, {3.8835743656521654`*^9, 
   3.8835743690731983`*^9}, {3.88357444687392*^9, 3.8835744554323215`*^9}, {
   3.883574660971348*^9, 3.883574665659684*^9}, {3.883574726790719*^9, 
   3.8835747290389833`*^9}, 3.8835747748280373`*^9},
 Background->RGBColor[
  0.87, 0.94, 1],ExpressionUUID->"019954a0-39ed-4644-96d9-3a172af30813"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"shiftedechoXY", ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tr", "/@", 
    RowBox[{"(", 
     RowBox[{"2", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"%", ".", "Sx"}], ",", 
        RowBox[{"%", ".", "Sy"}], ",", 
        RowBox[{"%", ".", "Sz"}], ",", 
        RowBox[{
         RowBox[{"%", ".", 
          RowBox[{"PauliMatrix", "[", "4", "]"}]}], "/", "2"}]}], "}"}]}], 
     ")"}]}], "//", "FullSimplify"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Assuming", "[", 
   RowBox[{
    RowBox[{"0", "<", "\[Theta]", "<", 
     RowBox[{"\[Pi]", "/", "2"}]}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"%", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
        ",", 
        RowBox[{"%", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
        ",", 
        RowBox[{"%", "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"}]}],
        "}"}], "/", 
      RowBox[{"Sin", "[", 
       RowBox[{"ArcCos", "[", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{
         "%", "\[LeftDoubleBracket]", "4", "\[RightDoubleBracket]"}]}], "]"}],
        "]"}]}], "//", "Simplify"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Assuming", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"0", "<", "\[Theta]", "<", 
      RowBox[{"\[Pi]", "/", "2"}]}], "&&", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\[Delta]\[Tau]", ",", "\[CapitalOmega]"}], "}"}], 
      "\[Element]", "Reals"}], "&&", 
     RowBox[{"\[Delta]\[Tau]", ">", "0"}], "&&", 
     RowBox[{"\[CapitalOmega]", ">", "0"}]}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"I", "/", "2"}], "%"}], ")"}], "/.", 
      RowBox[{"{", 
       RowBox[{"\[Tau]", "\[Rule]", "\[Tau]cond"}], "}"}]}], "//", 
     "FullSimplify"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Assuming", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"\[CapitalDelta]", ">", "0"}], "&&", 
     RowBox[{"J", ">", "0"}], "&&", 
     RowBox[{"J", ">", "\[CapitalDelta]"}]}], ",", 
    RowBox[{
     RowBox[{"%", "/.", 
      RowBox[{"{", 
       RowBox[{"\[Theta]", "->", " ", 
        RowBox[{"ArcTan", "[", 
         RowBox[{"\[CapitalDelta]", "/", "J"}], "]"}]}], "}"}]}], "//", 
     "FullSimplify"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"nvec", "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"%", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"J", "->", " ", 
         RowBox[{"\[CapitalOmega]", "*", 
          RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}], ",", 
        RowBox[{"\[CapitalDelta]", "->", " ", 
         RowBox[{"\[CapitalOmega]", " ", 
          RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}]}], "}"}]}], "//", 
     "FullSimplify"}], "//", "PowerExpand"}], "//", 
   "FullSimplify"}]}]}], "Input",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGAQAWIQnWavFn7+6hvHE7+uRoLolqDwVhDNEHFsOoieMG3i
HBDNEyWwDkwn9h4C0Zv+1p8G0csCV50H0evmtNwG0Ue2Z90H0cYd05+CaLM1
0hwXgHTVh3X8IHrKJ+v5IPr2+4tgWi3u0WoQfa8scg2Ifh382vwRkJ7zYo4F
iI6r22QDoju3fHMD0W8/ywaC6Fq9nGAQ7SqzJhVE3/pjkgOi2Z5H1oHotN3Z
9SB6fcj1jyB6z4G+LyA62lmP9zGQ3nLQBkwn/fi0LeT9G8e56zZuB9EFKWx7
QDRfUeVeEG3iZHIbRD/f9QtMs5rUvAPRJ5ZlfALRAEvzxo4=
  "],
 CellLabel->"In[17]:=",ExpressionUUID->"4c5155b3-6d75-42a9-bc3d-256f0cbb1ca9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{"Cos", "[", 
     FractionBox[
      RowBox[{"\[Delta]\[Tau]", " ", "\[CapitalOmega]"}], "2"], "]"}], 
    SqrtBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"Cos", "[", "\[Theta]", "]"}], "2"], "+", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"Cos", "[", 
         FractionBox[
          RowBox[{"\[Delta]\[Tau]", " ", "\[CapitalOmega]"}], "2"], "]"}], 
        "2"], " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}]]], ",", 
   FractionBox[
    RowBox[{
     RowBox[{"Cos", "[", "\[Theta]", "]"}], " ", 
     RowBox[{"Sin", "[", 
      FractionBox[
       RowBox[{"\[Delta]\[Tau]", " ", "\[CapitalOmega]"}], "2"], "]"}]}], 
    SqrtBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"Cos", "[", "\[Theta]", "]"}], "2"], "+", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"Cos", "[", 
         FractionBox[
          RowBox[{"\[Delta]\[Tau]", " ", "\[CapitalOmega]"}], "2"], "]"}], 
        "2"], " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}]]], ",", "0"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.870197118344403*^9, 3.8702330941623373`*^9, {3.8702331336210704`*^9, 
   3.8702331448030205`*^9}, {3.870233229822234*^9, 3.8702332439724474`*^9}, {
   3.8702333981644173`*^9, 3.870233443010894*^9}, 3.8702335972411547`*^9, {
   3.8702345170700703`*^9, 3.870234533913791*^9}, 3.8702347355066395`*^9, 
   3.870235099550892*^9, {3.870235661544269*^9, 3.870235677357924*^9}, 
   3.870235875532281*^9, 3.8702362052598433`*^9, 3.87023686106148*^9, 
   3.870237220071699*^9, 3.870237336827652*^9, 3.8703465883360004`*^9, 
   3.870853556708252*^9, 3.8708566840009365`*^9, 3.8708717173560266`*^9, 
   3.871476223770892*^9, 3.8714941590152116`*^9, 3.8715302564608755`*^9, 
   3.872846381583413*^9, 3.8835484377977824`*^9, {3.8835747565037775`*^9, 
   3.883574769566761*^9}, 3.8835750156911793`*^9, {3.8835751755322437`*^9, 
   3.883575189600644*^9}, 3.883575777334334*^9, 3.883579620421073*^9},
 CellLabel->"Out[22]=",ExpressionUUID->"c01888fd-8cff-467a-aa76-2d6b1a4308cb"]
}, Open  ]],

Cell["extract rotation angle:", "Text",
 CellChangeTimes->{{3.883574151345195*^9, 3.8835741835393295`*^9}, {
  3.883574235189148*^9, 3.883574267148384*^9}, {3.8835743656521654`*^9, 
  3.8835743690731983`*^9}, {3.88357444687392*^9, 3.8835744554323215`*^9}, {
  3.883574660971348*^9, 3.883574665659684*^9}, {3.883574726790719*^9, 
  3.8835747290389833`*^9}, {3.8835747748280373`*^9, 3.883574783280619*^9}},
 Background->RGBColor[
  0.87, 0.94, 1],ExpressionUUID->"ba7cd9bb-8b73-4dbd-8795-88850e8b704f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ang", "=", 
  RowBox[{"Assuming", "[", 
   RowBox[{
    RowBox[{"0", "<", "\[Theta]", "<", 
     RowBox[{"\[Pi]", "/", "2"}]}], ",", 
    RowBox[{"2", "*", 
     RowBox[{"ArcCos", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"Tr", "[", 
          RowBox[{"(", 
           RowBox[{"shiftedechoXY", ".", 
            RowBox[{"PauliMatrix", "[", "4", "]"}]}], ")"}], "]"}]}], "/.", 
        RowBox[{"{", 
         RowBox[{"\[Tau]", "\[Rule]", "\[Tau]cond"}], "}"}]}], "//", 
       "FullSimplify"}], "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.87019756788858*^9, 3.870197615937257*^9}, {
  3.870197669820223*^9, 3.8701976840604615`*^9}, {3.8702332524638643`*^9, 
  3.8702333418097486`*^9}, {3.870234548976723*^9, 3.8702345528021274`*^9}, {
  3.870236051416812*^9, 3.870236060101026*^9}, {3.8702362143529387`*^9, 
  3.8702362209716444`*^9}, {3.8702369497350836`*^9, 3.8702369500631256`*^9}, {
  3.870237023839002*^9, 3.870237048172759*^9}, {3.8702371512929916`*^9, 
  3.8702371559321976`*^9}, {3.870237276853223*^9, 3.8702372770562973`*^9}, {
  3.8835747847661943`*^9, 3.8835748128704815`*^9}},
 CellLabel->"In[23]:=",ExpressionUUID->"ef0c76c7-3c93-420a-9a91-46b477031482"],

Cell[BoxData[
 RowBox[{"2", " ", 
  RowBox[{"ArcCos", "[", 
   RowBox[{
    RowBox[{"Cos", "[", "\[Theta]", "]"}], " ", 
    SqrtBox[
     RowBox[{"1", "-", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"Cos", "[", 
         FractionBox[
          RowBox[{"\[Delta]\[Tau]", " ", "\[CapitalOmega]"}], "2"], "]"}], 
        "2"], " ", 
       SuperscriptBox[
        RowBox[{"Tan", "[", "\[Theta]", "]"}], "4"]}]}]]}], "]"}]}]], "Output",
 CellChangeTimes->{{3.8701975855367446`*^9, 3.8701976135939035`*^9}, {
   3.870197671201615*^9, 3.8701976944906936`*^9}, {3.8702332821903543`*^9, 
   3.870233293183592*^9}, {3.870233327583973*^9, 3.870233342012123*^9}, 
   3.8702336076374054`*^9, 3.8702345605034657`*^9, 3.870234809095439*^9, 
   3.8702351101167517`*^9, 3.870235691977213*^9, 3.8702358899193554`*^9, 
   3.8702360683507314`*^9, {3.87023622649636*^9, 3.8702362320374184`*^9}, 
   3.8702368702313027`*^9, 3.8702369517032804`*^9, {3.870237033008506*^9, 
   3.8702370556675763`*^9}, 3.870237163260019*^9, 3.8702372335347176`*^9, 
   3.870237284443551*^9, 3.8702373523433657`*^9, 3.8703465986555014`*^9, 
   3.8708535695079894`*^9, 3.8708566927109337`*^9, 3.8708717275175996`*^9, 
   3.87147623921787*^9, 3.871494169128295*^9, 3.871530265326674*^9, 
   3.8728463947341223`*^9, 3.8835484521400385`*^9, {3.883574807439456*^9, 
   3.883574820918292*^9}, 3.883575024081374*^9, 3.8835751974222903`*^9, 
   3.883575784667856*^9, 3.8835796330367155`*^9},
 CellLabel->"Out[23]=",ExpressionUUID->"fc86c653-0bde-43b9-8207-0b01db2e6a0d"]
}, Open  ]],

Cell[TextData[{
 "In the limit of small ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Theta]", "ST"], TraditionalForm]],
  FormatType->TraditionalForm,ExpressionUUID->
  "dff566aa-d0e0-424e-8a78-5503840a0903"],
 " the rotation axis and the rotation angle reduce to the following"
}], "Text",
 CellChangeTimes->{{3.883574151345195*^9, 3.8835741835393295`*^9}, {
  3.883574235189148*^9, 3.883574267148384*^9}, {3.8835743656521654`*^9, 
  3.8835743690731983`*^9}, {3.88357444687392*^9, 3.8835744554323215`*^9}, {
  3.883574660971348*^9, 3.883574665659684*^9}, {3.883574726790719*^9, 
  3.8835747290389833`*^9}, {3.8835747748280373`*^9, 3.883574783280619*^9}, {
  3.8835748585755606`*^9, 3.8835748741931467`*^9}, {3.88357502962741*^9, 
  3.883575032927346*^9}, {3.8835752048920794`*^9, 3.883575246153208*^9}},
 Background->RGBColor[
  0.87, 0.94, 1],ExpressionUUID->"8bdbaf79-1915-4e86-88b1-e5032bc6a27b"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Assuming", "[", 
  RowBox[{
   RowBox[{"0", "<", "\[Theta]", "<", 
    RowBox[{"\[Pi]", "/", "2"}]}], ",", 
   RowBox[{
    RowBox[{"Normal", "@", 
     RowBox[{"Series", "[", 
      RowBox[{"nvec", ",", 
       RowBox[{"{", 
        RowBox[{"\[Theta]", ",", "0", ",", "1"}], "}"}]}], "]"}]}], "//", 
    "Simplify"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Assuming", "[", 
  RowBox[{
   RowBox[{"0", "<", "\[Theta]", "<", 
    RowBox[{"\[Pi]", "/", "2"}]}], ",", 
   RowBox[{
    RowBox[{"Normal", "@", 
     RowBox[{"Series", "[", 
      RowBox[{"ang", ",", 
       RowBox[{"{", 
        RowBox[{"\[Theta]", ",", "0", ",", "1"}], "}"}]}], "]"}]}], "//", 
    "Simplify"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.870239010468687*^9, 3.870239058352141*^9}, {
  3.8835748416765532`*^9, 3.8835748473166156`*^9}, {3.8835748792273493`*^9, 
  3.8835748883851843`*^9}},
 CellLabel->"In[24]:=",ExpressionUUID->"9d6f5eb4-49ae-4ce0-97a7-9aa079a5c784"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Cos", "[", 
    FractionBox[
     RowBox[{"\[Delta]\[Tau]", " ", "\[CapitalOmega]"}], "2"], "]"}], ",", 
   RowBox[{"Sin", "[", 
    FractionBox[
     RowBox[{"\[Delta]\[Tau]", " ", "\[CapitalOmega]"}], "2"], "]"}], ",", 
   "0"}], "}"}]], "Output",
 CellChangeTimes->{{3.870239018372985*^9, 3.8702390587895355`*^9}, 
   3.8703466057214103`*^9, 3.8708535784181805`*^9, 3.870856698909552*^9, 
   3.870871734152437*^9, 3.871476251798956*^9, 3.871494176051486*^9, 
   3.8715302721417084`*^9, 3.872846404335186*^9, 3.8835484627289877`*^9, 
   3.8835748486031275`*^9, {3.8835748803046985`*^9, 3.8835748886170473`*^9}, 
   3.8835750589902987`*^9, 3.883575199602252*^9, 3.8835757847878523`*^9, 
   3.883579633150425*^9},
 CellLabel->"Out[24]=",ExpressionUUID->"eb2f64b2-000c-4568-b97a-ad0da46cf99d"],

Cell[BoxData[
 RowBox[{"2", " ", "\[Theta]"}]], "Output",
 CellChangeTimes->{{3.870239018372985*^9, 3.8702390587895355`*^9}, 
   3.8703466057214103`*^9, 3.8708535784181805`*^9, 3.870856698909552*^9, 
   3.870871734152437*^9, 3.871476251798956*^9, 3.871494176051486*^9, 
   3.8715302721417084`*^9, 3.872846404335186*^9, 3.8835484627289877`*^9, 
   3.8835748486031275`*^9, {3.8835748803046985`*^9, 3.8835748886170473`*^9}, 
   3.8835750589902987`*^9, 3.883575199602252*^9, 3.8835757847878523`*^9, 
   3.8835796339627867`*^9},
 CellLabel->"Out[25]=",ExpressionUUID->"d25dfe89-fa43-4300-99be-5e5c5d824349"]
}, Open  ]],

Cell[TextData[{
 "The rotation angle is thus given by ~ 2",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Theta]", "ST"], TraditionalForm]],
  FormatType->TraditionalForm,ExpressionUUID->
  "3a737ec8-707e-4dc7-9c71-8c0a2ba8d838"],
 " and the rotation may be represented as cos(\[Phi]) ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["I", "x"], TraditionalForm]],
  FormatType->TraditionalForm,ExpressionUUID->
  "cb3c47e7-eaac-4160-89ff-9940f774c7b9"],
 " + sin(\[Phi]) ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["I", "y"], TraditionalForm]],
  FormatType->TraditionalForm,ExpressionUUID->
  "16d4b96f-4d42-4d12-973e-aefc088fac1a"],
 ", where the phase is given by \[Phi] = 1/2\[Times]\[Delta]\[Tau] \
\[CapitalOmega]. \n\nThese expressions correspond to equations 33 and 35."
}], "Text",
 CellChangeTimes->{{3.883574151345195*^9, 3.8835741835393295`*^9}, {
  3.883574235189148*^9, 3.883574267148384*^9}, {3.8835743656521654`*^9, 
  3.8835743690731983`*^9}, {3.88357444687392*^9, 3.8835744554323215`*^9}, {
  3.883574660971348*^9, 3.883574665659684*^9}, {3.883574726790719*^9, 
  3.8835747290389833`*^9}, {3.8835747748280373`*^9, 3.883574783280619*^9}, {
  3.8835748585755606`*^9, 3.8835748741931467`*^9}, {3.88357502962741*^9, 
  3.883575032927346*^9}, {3.8835752048920794`*^9, 3.883575328712968*^9}},
 Background->RGBColor[
  0.87, 0.94, 1],ExpressionUUID->"b1f864e5-2e58-4fb1-a2e7-73ad00de0b38"]
}, Open  ]],

Cell[CellGroupData[{

Cell["numerical test", "Section",
 CellChangeTimes->{{3.8698158743636246`*^9, 3.8698158756916738`*^9}, {
  3.869817205568797*^9, 3.869817215792103*^9}, {3.8698200616258545`*^9, 
  3.8698200631732306`*^9}, {3.8702326249558835`*^9, 3.8702326262259893`*^9}, {
  3.870237488094673*^9, 
  3.870237489486377*^9}},ExpressionUUID->"c60245b1-a839-41a9-a440-\
1bc15608cead"],

Cell["a numerical comparison validates the approximations:", "Text",
 CellChangeTimes->{{3.883574151345195*^9, 3.8835741835393295`*^9}, {
  3.883574235189148*^9, 3.883574267148384*^9}, {3.8835743656521654`*^9, 
  3.8835743690731983`*^9}, {3.88357444687392*^9, 3.8835744554323215`*^9}, {
  3.883574660971348*^9, 3.883574665659684*^9}, {3.883574726790719*^9, 
  3.8835747290389833`*^9}, {3.8835747748280373`*^9, 3.883574783280619*^9}, {
  3.8835748585755606`*^9, 3.8835748741931467`*^9}, {3.88357502962741*^9, 
  3.883575032927346*^9}, {3.8835752048920794`*^9, 3.883575357252722*^9}},
 Background->RGBColor[
  0.87, 0.94, 1],ExpressionUUID->"2ccf15e0-ef94-43b7-af43-d2725c415ac8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"NPropagationOperator", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Repeat", "[", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"None", ",", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"\[Tau]cond", "+", "\[Delta]\[Tau]"}], "/.", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"\[Theta]", "\[Rule]", "0.3"}], ",", 
               RowBox[{"\[CapitalOmega]", "\[Rule]", 
                RowBox[{"2", "\[Pi]"}]}], ",", 
               RowBox[{"\[Delta]\[Tau]", "\[Rule]", " ", 
                RowBox[{"1", "/", "2"}]}]}], "}"}]}], ")"}]}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"RotationSuperoperator", "[", 
          RowBox[{"{", 
           RowBox[{"\[Pi]", ",", "\"\<y\>\""}], "}"}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"None", ",", 
           RowBox[{"(", 
            RowBox[{"\[Tau]cond", "/.", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"\[Theta]", "\[Rule]", "0.3"}], ",", 
               RowBox[{"\[CapitalOmega]", "\[Rule]", 
                RowBox[{"2", "\[Pi]"}]}], ",", 
               RowBox[{"\[Delta]\[Tau]", "\[Rule]", 
                RowBox[{"1", "/", "2"}]}]}], "}"}]}], ")"}]}], "}"}]}], 
        "\[IndentingNewLine]", "}"}], ",", "6"}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"BackgroundGenerator", "\[Rule]", 
      RowBox[{"(", 
       RowBox[{"H0", "/.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\[Theta]", "\[Rule]", "0.3"}], ",", 
          RowBox[{"\[CapitalOmega]", "\[Rule]", 
           RowBox[{"2", "\[Pi]"}]}]}], "}"}]}], ")"}]}]}], 
    "\[IndentingNewLine]", "]"}], "//", "MatrixRepresentation"}], "//", 
  "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.8702375057825813`*^9, 3.870237549827239*^9}, {
  3.8702375861441298`*^9, 3.8702376698059406`*^9}, {3.8702379501185617`*^9, 
  3.8702379530786257`*^9}, {3.8702515982521796`*^9, 3.870251625757848*^9}, {
  3.870343456144865*^9, 3.870343478397393*^9}, {3.8708542545089383`*^9, 
  3.8708542556442204`*^9}, {3.8708542949011173`*^9, 3.870854299541244*^9}, {
  3.8835753769050245`*^9, 3.8835753954252186`*^9}, {3.8835754707799687`*^9, 
  3.883575471306083*^9}, {3.883575519687923*^9, 3.8835755197783012`*^9}},
 CellLabel->"In[26]:=",ExpressionUUID->"dac221b2-b089-47a5-90b4-f26f741d0445"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0.22720209469308666`", "0", "0.9738476308781954`", "0"},
     {"0", 
      RowBox[{
       RowBox[{"-", "0.912703741302719`"}], "-", 
       RowBox[{"0.40862192869695596`", " ", "\[ImaginaryI]"}]}], "0", "0"},
     {
      RowBox[{"-", "0.9738476308781947`"}], "0", "0.22720209469308683`", "0"},
     {"0", "0", "0", 
      RowBox[{
       RowBox[{"-", "0.912703741302719`"}], "-", 
       RowBox[{"0.40862192869695596`", " ", "\[ImaginaryI]"}]}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[
   SparseArray[
    Automatic, {4, 4}, 0, {
     1, {{0, 2, 3, 5, 6}, {{1}, {3}, {2}, {1}, {3}, {4}}}, {
      0.22720209469308666`, 0.9738476308781954, 
       Complex[-0.912703741302719, -0.40862192869695596`], \
-0.9738476308781947, 0.22720209469308683`, 
       Complex[-0.912703741302719, -0.40862192869695596`]}}]]]]], "Output",
 CellChangeTimes->{{3.870237608068*^9, 3.870237670102744*^9}, 
   3.8702379534232707`*^9, 3.8702516261795225`*^9, {3.870343459865221*^9, 
   3.870343479292446*^9}, 3.87034660633173*^9, 3.8708535789088697`*^9, {
   3.8708542511752605`*^9, 3.8708542565333147`*^9}, 3.870854299802516*^9, 
   3.870856699532325*^9, 3.8708572853287644`*^9, 3.87087173465762*^9, {
   3.883575386301497*^9, 3.883575395866929*^9}, 3.883575477807691*^9, 
   3.8835755201864614`*^9, 3.8835757854292126`*^9, 3.8835796341153803`*^9},
 CellLabel->
  "Out[26]//MatrixForm=",ExpressionUUID->"d651b482-6e87-42cd-a916-\
4437d2565f0b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"DiagonalMatrix", "[", 
    RowBox[{"{", 
     RowBox[{"I", ",", "I"}], "}"}], "]"}], ".", 
   RowBox[{"MatrixExp", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "I"}], " ", "ang", 
      RowBox[{"(", 
       RowBox[{"nvec", ".", "Svec"}], ")"}]}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[Theta]", "\[Rule]", "0.3"}], ",", 
       RowBox[{"\[CapitalOmega]", "\[Rule]", 
        RowBox[{"2", "\[Pi]"}]}], ",", 
       RowBox[{"\[Delta]\[Tau]", "\[Rule]", " ", 
        RowBox[{"1", "/", "2"}]}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MatrixPower", "[", 
    RowBox[{"%", ",", "6"}], "]"}], "//", "Chop"}], "//", 
  "MatrixForm"}]}], "Input",
 CellChangeTimes->{{3.870237674025432*^9, 3.8702378281793137`*^9}, {
  3.870237981787882*^9, 3.8702379824969664`*^9}, {3.870239747466369*^9, 
  3.8702397539503727`*^9}, {3.8702516308488264`*^9, 3.8702516337927628`*^9}, {
  3.8702541870375786`*^9, 3.870254202757038*^9}, {3.870254499758685*^9, 
  3.870254530984377*^9}, {3.870254585826972*^9, 3.870254588568429*^9}, {
  3.8702550427153115`*^9, 3.8702550438899546`*^9}, {3.8703401332469463`*^9, 
  3.8703401370931673`*^9}, {3.870340172179728*^9, 3.8703401723046093`*^9}, {
  3.8708542353255005`*^9, 3.8708542637734346`*^9}, {3.870856867690846*^9, 
  3.8708568707445097`*^9}, {3.8835754004379807`*^9, 3.8835754301078854`*^9}, {
  3.883575466540897*^9, 3.8835755173098392`*^9}, {3.8835756487355146`*^9, 
  3.8835756494518294`*^9}},
 CellLabel->"In[27]:=",ExpressionUUID->"cd85b9b7-d4e2-4a0b-9b01-0f1f49b4f941"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0.22720209469308789`", "0.9738476308781947`"},
     {
      RowBox[{"-", "0.9738476308781947`"}], "0.2272020946930876`"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.870237739409541*^9, 3.8702377494801474`*^9}, {
   3.870237810914126*^9, 3.8702378286167088`*^9}, 3.8702379829576836`*^9, 
   3.8702397570794353`*^9, 3.8702516341051245`*^9, {3.8702541932495933`*^9, 
   3.870254210577281*^9}, {3.8702545109997215`*^9, 3.870254531205584*^9}, 
   3.8702545901598787`*^9, 3.8702550441442986`*^9, 3.870340137655465*^9, 
   3.870340172570202*^9, 3.870346606390083*^9, 3.870853578967712*^9, {
   3.8708542438636456`*^9, 3.8708542571895123`*^9}, 3.8708543012024918`*^9, 
   3.8708566996769376`*^9, 3.87085688074481*^9, 3.870857286053851*^9, 
   3.8708717347054915`*^9, {3.8835754220085793`*^9, 3.883575433142644*^9}, {
   3.8835754684028425`*^9, 3.883575517602216*^9}, 3.8835756496831746`*^9, 
   3.8835757854691315`*^9, 3.883579634244033*^9},
 CellLabel->
  "Out[28]//MatrixForm=",ExpressionUUID->"fe9152a4-0929-45ff-baf4-\
76f8c744916f"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["geometric phase", "Section",
 CellChangeTimes->{{3.8698158743636246`*^9, 3.8698158756916738`*^9}, {
  3.869817205568797*^9, 3.869817215792103*^9}, {3.8698200616258545`*^9, 
  3.8698200631732306`*^9}, {3.8702326249558835`*^9, 3.8702326262259893`*^9}, {
  3.870237488094673*^9, 3.870237489486377*^9}, {3.8702376810313225`*^9, 
  3.8702376824528522`*^9}, {3.870237936613577*^9, 3.870237946958558*^9}, {
  3.8703384250058737`*^9, 
  3.8703384275522137`*^9}},ExpressionUUID->"58e1628a-3e40-4129-bb88-\
60e58bed4b50"],

Cell[CellGroupData[{

Cell["effective phase for the spherical lune", "Subsection",
 CellChangeTimes->{{3.8698158743636246`*^9, 3.8698158756916738`*^9}, {
  3.869817205568797*^9, 3.869817215792103*^9}, {3.8698200616258545`*^9, 
  3.8698200631732306`*^9}, {3.8702326249558835`*^9, 3.8702326262259893`*^9}, {
  3.870237488094673*^9, 3.870237489486377*^9}, {3.8702376810313225`*^9, 
  3.8702376824528522`*^9}, {3.870237936613577*^9, 3.870237946958558*^9}, {
  3.8703384250058737`*^9, 3.8703384275522137`*^9}, {3.870338592503579*^9, 
  3.8703385939563427`*^9}, {3.870932858425844*^9, 3.870932859347493*^9}, {
  3.8835756194110394`*^9, 
  3.8835756253507605`*^9}},ExpressionUUID->"2a5f48e2-80a2-4187-a48f-\
3379ddb21a40"],

Cell[TextData[{
 "the phase for the first arc of the lune is \[Phi] = \[Pi]/2, so that the \
rotation axis is given by {0,1,0}. Here, ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Tau]", "e"], TraditionalForm]],
  FormatType->TraditionalForm,ExpressionUUID->
  "4e395e26-daed-41de-abb0-bdaa9cdea01b"],
 " represents the duration of a single echo (equation 75). "
}], "Text",
 CellChangeTimes->{{3.883574151345195*^9, 3.8835741835393295`*^9}, {
  3.883574235189148*^9, 3.883574267148384*^9}, {3.8835743656521654`*^9, 
  3.8835743690731983`*^9}, {3.88357444687392*^9, 3.8835744554323215`*^9}, {
  3.883574660971348*^9, 3.883574665659684*^9}, {3.883574726790719*^9, 
  3.8835747290389833`*^9}, {3.8835747748280373`*^9, 3.883574783280619*^9}, {
  3.8835748585755606`*^9, 3.8835748741931467`*^9}, {3.88357502962741*^9, 
  3.883575032927346*^9}, {3.8835752048920794`*^9, 3.883575357252722*^9}, {
  3.883575796934701*^9, 3.8835758348544855`*^9}, {3.883576080340189*^9, 
  3.883576145084046*^9}},
 Background->RGBColor[
  0.87, 0.94, 1],ExpressionUUID->"cf30df41-064e-4dc6-a6ef-a5c2e9db8dff"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Psi]1", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Assuming", "[", 
      RowBox[{
       RowBox[{"0", "<", "\[Theta]", "<", 
        RowBox[{"\[Pi]", "/", "2"}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"MatrixExp", "[", 
           RowBox[{
            RowBox[{"+", "I"}], " ", "t", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"\[CapitalOmega]", "/", "2"}], " ", 
                RowBox[{"Cos", "[", "\[Theta]", "]"}]}], ")"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"\[Pi]", "/", "2"}], ")"}], "/", "\[Tau]e"}]}], ")"}],
             " ", 
            RowBox[{"IdentityMatrix", "[", "2", "]"}]}], "]"}], ")"}], ".", 
         RowBox[{"(", 
          RowBox[{"MatrixExp", "[", 
           RowBox[{
            RowBox[{"-", "I"}], " ", "t", " ", "2", 
            RowBox[{"\[Theta]", "/", "\[Tau]e"}], 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"0", ",", "1", ",", "0"}], "}"}], ".", "Svec"}], 
             ")"}]}], "]"}], ")"}]}], "//", "FullSimplify"}]}], "]"}], ".", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "//", "FullSimplify"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.870342423258357*^9, 3.870342443795593*^9}, {
   3.8703427472698107`*^9, 3.8703427706380568`*^9}, {3.870343763138403*^9, 
   3.870343775617245*^9}, {3.8703467490487237`*^9, 3.8703467512962456`*^9}, {
   3.870347545166904*^9, 3.8703475526613636`*^9}, 3.8703478095865045`*^9, {
   3.870349345034319*^9, 3.8703493462626467`*^9}, {3.8703497077344723`*^9, 
   3.8703497090445914`*^9}, {3.8708550255020037`*^9, 3.870855025836138*^9}, {
   3.870855085848172*^9, 3.870855086116451*^9}, {3.870855474917617*^9, 
   3.870855475212812*^9}, 3.870855692653634*^9, {3.870855972297153*^9, 
   3.8708560001562724`*^9}, 3.8708560307990465`*^9, {3.870856203381797*^9, 
   3.870856204812747*^9}, {3.8835756571713543`*^9, 3.8835756577018642`*^9}, {
   3.8835761338161936`*^9, 3.8835761354240155`*^9}},
 CellLabel->"In[29]:=",ExpressionUUID->"0e944dc3-042b-4fae-bef3-a3eaeb040146"],

Cell["spin state after application of the first arc ", "Text",
 CellChangeTimes->{{3.883574151345195*^9, 3.8835741835393295`*^9}, {
   3.883574235189148*^9, 3.883574267148384*^9}, {3.8835743656521654`*^9, 
   3.8835743690731983`*^9}, {3.88357444687392*^9, 3.8835744554323215`*^9}, {
   3.883574660971348*^9, 3.883574665659684*^9}, {3.883574726790719*^9, 
   3.8835747290389833`*^9}, {3.8835747748280373`*^9, 3.883574783280619*^9}, {
   3.8835748585755606`*^9, 3.8835748741931467`*^9}, {3.88357502962741*^9, 
   3.883575032927346*^9}, {3.8835752048920794`*^9, 3.883575357252722*^9}, {
   3.883575796934701*^9, 3.8835758533775325`*^9}, 3.8835759879591227`*^9},
 Background->RGBColor[
  0.87, 0.94, 1],ExpressionUUID->"74265767-38ba-4d12-9479-8e47ce6c7fda"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Psi]1", "/.", 
   RowBox[{"{", 
    RowBox[{"t", "\[Rule]", 
     RowBox[{"n", "*", "\[Tau]e"}]}], "}"}]}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"n", "*", "\[Theta]"}], "\[Rule]", 
    RowBox[{"\[Pi]", "/", "2"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.8703437793799047`*^9, 3.8703438014892073`*^9}, 
   3.870346752832493*^9, 3.8708561855396776`*^9, 3.8835761486041417`*^9},
 CellLabel->"In[30]:=",ExpressionUUID->"9fffcc84-9a30-4573-b0fd-4fea1a049416"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", "n", " ", 
      RowBox[{"(", 
       RowBox[{"\[Pi]", "+", 
        RowBox[{"\[Tau]e", " ", "\[CapitalOmega]", " ", 
         RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}], ")"}]}]]}], ",", "0"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.870343780252872*^9, 3.8703438016687293`*^9}, 
   3.8703466077545614`*^9, 3.870346754770357*^9, 3.8703478169123726`*^9, 
   3.8703493665097637`*^9, 3.8703497697089734`*^9, 3.870853580960232*^9, 
   3.87085508724345*^9, 3.8708554765014396`*^9, 3.870855721932308*^9, {
   3.8708559762209454`*^9, 3.8708560322423296`*^9}, {3.8708561596032295`*^9, 
   3.8708562067281165`*^9}, 3.870856701693528*^9, 3.8708570291969433`*^9, 
   3.870871741353063*^9, 3.883575923797495*^9, 3.8835761488872833`*^9, 
   3.8835796347594695`*^9},
 CellLabel->"Out[30]=",ExpressionUUID->"54327e60-b121-439e-a13f-8357e2129708"]
}, Open  ]],

Cell["\<\
contribution to the dynamic phase for the first arc of the lune (equation 76)\
\>", "Text",
 CellChangeTimes->{{3.883574151345195*^9, 3.8835741835393295`*^9}, {
  3.883574235189148*^9, 3.883574267148384*^9}, {3.8835743656521654`*^9, 
  3.8835743690731983`*^9}, {3.88357444687392*^9, 3.8835744554323215`*^9}, {
  3.883574660971348*^9, 3.883574665659684*^9}, {3.883574726790719*^9, 
  3.8835747290389833`*^9}, {3.8835747748280373`*^9, 3.883574783280619*^9}, {
  3.8835748585755606`*^9, 3.8835748741931467`*^9}, {3.88357502962741*^9, 
  3.883575032927346*^9}, {3.8835752048920794`*^9, 3.883575357252722*^9}, {
  3.883575796934701*^9, 3.8835758533775325`*^9}, {3.8835760134981976`*^9, 
  3.883576033311266*^9}},
 Background->RGBColor[
  0.87, 0.94, 1],ExpressionUUID->"b48f44f5-aae1-4507-b855-d9a00601c1bd"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"dyncontlune1", "=", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{"FullSimplify", "[", 
       RowBox[{"ComplexExpand", "[", 
        RowBox[{
         RowBox[{"-", "I"}], " ", 
         RowBox[{
          RowBox[{"Conjugate", "[", "\[Psi]1", "]"}], ".", 
          RowBox[{"D", "[", 
           RowBox[{"\[Psi]1", ",", "t"}], "]"}]}]}], "]"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{"n", "*", "\[Tau]e"}]}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.870338439654484*^9, 3.8703385730966625`*^9}, 
   3.870338651023349*^9, {3.8703387265759745`*^9, 3.8703387320710297`*^9}, {
   3.870338830918388*^9, 3.8703388595517836`*^9}, {3.8703389202634897`*^9, 
   3.87033897917424*^9}, {3.870339019531275*^9, 3.870339035867601*^9}, {
   3.8703391117423625`*^9, 3.8703391124671974`*^9}, {3.8703392920552998`*^9, 
   3.8703393591929226`*^9}, {3.870339466853375*^9, 3.8703394754577255`*^9}, {
   3.8703395061164017`*^9, 3.8703395710573516`*^9}, {3.870339607774358*^9, 
   3.870339632515786*^9}, {3.870340063421317*^9, 3.8703401091288195`*^9}, 
   3.8703401786229935`*^9, {3.8703417983259983`*^9, 3.8703419316707*^9}, {
   3.870341964761854*^9, 3.870341998510003*^9}, {3.8703420883701506`*^9, 
   3.870342103357911*^9}, {3.870342147757763*^9, 3.870342232597229*^9}, {
   3.870342384162696*^9, 3.8703424081558905`*^9}, {3.8703424460116887`*^9, 
   3.87034245054377*^9}, {3.8703425885435834`*^9, 3.8703425891979575`*^9}, {
   3.8703427801904154`*^9, 3.8703427808453145`*^9}, {3.8703438467631664`*^9, 
   3.8703438471541295`*^9}, 3.870346757122946*^9, 3.8708550929573326`*^9, {
   3.883575936651327*^9, 3.8835759620720067`*^9}, {3.883575997694401*^9, 
   3.8835760080225024`*^9}, 3.883576152317181*^9, {3.883576198257022*^9, 
   3.8835761985631895`*^9}},
 CellLabel->"In[31]:=",ExpressionUUID->"0d4d0997-f8ed-40ef-930d-dc3cdef2040a"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", "n", " ", 
  RowBox[{"(", 
   RowBox[{"\[Pi]", "+", 
    RowBox[{"\[Tau]e", " ", "\[CapitalOmega]", " ", 
     RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}], ")"}]}]], "Output",
 CellChangeTimes->{{3.870338478593271*^9, 3.8703385733778343`*^9}, 
   3.8703386514294987`*^9, 3.870338862285515*^9, 3.8703389298394966`*^9, 
   3.870339120145179*^9, {3.8703392988348083`*^9, 3.870339326372345*^9}, {
   3.870339497655343*^9, 3.870339571853936*^9}, 3.870340180825476*^9, {
   3.870341843795539*^9, 3.870341890801375*^9}, {3.8703419218866568`*^9, 
   3.8703419319429674`*^9}, {3.870341969679992*^9, 3.8703419878212385`*^9}, {
   3.87034209374605*^9, 3.8703421038142357`*^9}, {3.8703421561998577`*^9, 
   3.8703422328649044`*^9}, {3.870342384692242*^9, 3.8703424085333633`*^9}, 
   3.870342450880255*^9, 3.870342589606115*^9, {3.870342781431543*^9, 
   3.8703427839608493`*^9}, 3.870343808631231*^9, 3.870343847485037*^9, 
   3.8703466078737917`*^9, 3.8703467578494425`*^9, 3.8703478175461807`*^9, 
   3.8703493707245555`*^9, 3.8703497722170095`*^9, 3.870853581028054*^9, 
   3.87085499872058*^9, {3.870855088069743*^9, 3.870855093296398*^9}, 
   3.8708554772282853`*^9, 3.8708557225724277`*^9, 3.870855977624192*^9, {
   3.8708560098363748`*^9, 3.8708560330362644`*^9}, {3.8708561607471113`*^9, 
   3.870856209322494*^9}, 3.8708567017773314`*^9, 3.870857029283742*^9, 
   3.8708717414178886`*^9, {3.8835759472934356`*^9, 3.883575962577676*^9}, 
   3.8835760611329613`*^9, 3.883576152658936*^9, 3.8835762191211767`*^9, 
   3.883579634827323*^9},
 CellLabel->"Out[31]=",ExpressionUUID->"a653fbe6-1b95-4e22-9b4a-7777d1457145"]
}, Open  ]],

Cell["\<\
contribution to the dynamic phase for the second arc of the lune\
\>", "Text",
 CellChangeTimes->{{3.883574151345195*^9, 3.8835741835393295`*^9}, {
   3.883574235189148*^9, 3.883574267148384*^9}, {3.8835743656521654`*^9, 
   3.8835743690731983`*^9}, {3.88357444687392*^9, 3.8835744554323215`*^9}, {
   3.883574660971348*^9, 3.883574665659684*^9}, {3.883574726790719*^9, 
   3.8835747290389833`*^9}, {3.8835747748280373`*^9, 3.883574783280619*^9}, {
   3.8835748585755606`*^9, 3.8835748741931467`*^9}, {3.88357502962741*^9, 
   3.883575032927346*^9}, {3.8835752048920794`*^9, 3.883575357252722*^9}, {
   3.883575796934701*^9, 3.8835758533775325`*^9}, {3.8835760134981976`*^9, 
   3.883576033311266*^9}, {3.8835760703301516`*^9, 3.8835760709502845`*^9}, 
   3.883576159773348*^9, {3.883576359566972*^9, 3.883576361579986*^9}},
 Background->RGBColor[
  0.87, 0.94, 1],ExpressionUUID->"15f9b616-2607-46ed-a1e6-4a20b3ee668d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Psi]2", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Assuming", "[", 
      RowBox[{
       RowBox[{"0", "<", "\[Theta]", "<", 
        RowBox[{"\[Pi]", "/", "2"}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"MatrixExp", "[", 
           RowBox[{
            RowBox[{"+", "I"}], " ", "t", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"\[CapitalOmega]", "/", "2"}], " ", 
                RowBox[{"Cos", "[", "\[Theta]", "]"}]}], ")"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"\[Pi]", "/", "2"}], ")"}], "/", "\[Tau]e"}]}], ")"}],
             " ", 
            RowBox[{"IdentityMatrix", "[", "2", "]"}]}], "]"}], ")"}], ".", 
         RowBox[{"(", 
          RowBox[{"MatrixExp", "[", 
           RowBox[{
            RowBox[{"-", "I"}], " ", "t", " ", "2", 
            RowBox[{"\[Theta]", "/", "\[Tau]e"}], 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"Cos", "[", "\[Phi]", "]"}], ",", 
                RowBox[{"Sin", "[", "\[Phi]", "]"}], ",", "0"}], "}"}], ".", 
              "Svec"}], ")"}]}], "]"}], ")"}]}], "//", "FullSimplify"}]}], 
      "]"}], ".", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"\[Psi]1", "/.", 
        RowBox[{"{", 
         RowBox[{"t", "\[Rule]", 
          RowBox[{"n", "*", "\[Tau]e"}]}], "}"}]}], "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"n", "*", "\[Theta]"}], "\[Rule]", 
         RowBox[{"\[Pi]", "/", "2"}]}], "}"}]}], ")"}]}], "//", 
    "FullSimplify"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.870342457369277*^9, 3.8703424790180817`*^9}, {
   3.870342515544634*^9, 3.870342568792803*^9}, {3.8703428000636673`*^9, 
   3.8703428193742867`*^9}, {3.8703428507293377`*^9, 3.8703428671126766`*^9}, 
   3.8703437266591873`*^9, {3.870343818139921*^9, 3.870343842227564*^9}, {
   3.8703438846583652`*^9, 3.870343898490048*^9}, {3.8703467617364454`*^9, 
   3.87034679845117*^9}, {3.870347326502855*^9, 3.8703473334465275`*^9}, {
   3.870347382725789*^9, 3.8703473844715347`*^9}, {3.8703475715834727`*^9, 
   3.8703475775237265`*^9}, {3.8703493859923525`*^9, 
   3.8703493881745515`*^9}, {3.8703497754949417`*^9, 3.870349777714785*^9}, {
   3.870349830156608*^9, 3.8703498316604695`*^9}, {3.870349875237122*^9, 
   3.8703498828759575`*^9}, {3.8703500879301147`*^9, 3.870350091256426*^9}, {
   3.870350167184414*^9, 3.8703501686086135`*^9}, {3.8703503004237103`*^9, 
   3.8703503036388645`*^9}, 3.8708556954291043`*^9, 3.8708559732304225`*^9, {
   3.8708569239946594`*^9, 3.870856931664717*^9}, {3.870857007635567*^9, 
   3.870857008040517*^9}, 3.883576073666134*^9, {3.8835761622875404`*^9, 
   3.883576169283231*^9}},
 CellLabel->"In[32]:=",ExpressionUUID->"8aff2281-d13b-465f-8726-b5ee45b54fc3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dyncontlune2", "=", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{"FullSimplify", "[", 
       RowBox[{"ComplexExpand", "[", 
        RowBox[{
         RowBox[{"-", "I"}], " ", 
         RowBox[{
          RowBox[{"Conjugate", "[", "\[Psi]1", "]"}], ".", 
          RowBox[{"D", "[", 
           RowBox[{"\[Psi]1", ",", "t"}], "]"}]}]}], "]"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{"n", " ", "\[Tau]e"}]}], "}"}]}], "]"}], "//", 
   "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.8703425181424265`*^9, 3.8703425359670177`*^9}, {
   3.870342577038517*^9, 3.870342600509411*^9}, {3.8703428335677004`*^9, 
   3.870342856055435*^9}, {3.87034385220409*^9, 3.8703438592525406`*^9}, {
   3.870346777737507*^9, 3.870346778711913*^9}, {3.870346943448516*^9, 
   3.8703469497609835`*^9}, {3.8703473383976293`*^9, 
   3.8703473429806895`*^9}, {3.8703498862912407`*^9, 3.87034988865055*^9}, {
   3.870350031073266*^9, 3.8703500551065*^9}, {3.8703503078076377`*^9, 
   3.8703503106774025`*^9}, 3.8708550967976*^9, {3.8835761826370792`*^9, 
   3.8835762030534945`*^9}},
 CellLabel->"In[33]:=",ExpressionUUID->"0c7520db-ba7a-4065-adb3-270bf2ec36ca"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", "n", " ", 
  RowBox[{"(", 
   RowBox[{"\[Pi]", "+", 
    RowBox[{"\[Tau]e", " ", "\[CapitalOmega]", " ", 
     RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}], ")"}]}]], "Output",
 CellChangeTimes->{{3.870342583279007*^9, 3.870342602908959*^9}, {
   3.870342828379227*^9, 3.8703428393535185`*^9}, 3.8703428790932274`*^9, 
   3.8703437361104045`*^9, 3.870343860682675*^9, 3.870343910562162*^9, 
   3.8703466142377563`*^9, {3.8703467840009193`*^9, 3.870346808626709*^9}, 
   3.8703469509841137`*^9, 3.870347344680616*^9, 3.8703473907759285`*^9, 
   3.87034758629762*^9, 3.8703493958953514`*^9, 3.8703497906750574`*^9, 
   3.8703498376544724`*^9, 3.8703498998167944`*^9, {3.870350036118438*^9, 
   3.8703500553348875`*^9}, 3.8703500999216127`*^9, 3.870350178358717*^9, 
   3.870350312303602*^9, 3.8708535861012526`*^9, 3.8708550211559105`*^9, 
   3.8708551039897585`*^9, 3.8708554868709183`*^9, {3.870855697596881*^9, 
   3.8708557263364673`*^9}, 3.8708559849192457`*^9, {3.870856017909794*^9, 
   3.870856039522087*^9}, {3.870856191500383*^9, 3.870856218309622*^9}, 
   3.870856706437665*^9, 3.870856938124389*^9, {3.870857013026499*^9, 
   3.870857033814794*^9}, 3.8708717458331213`*^9, {3.883576192706027*^9, 
   3.88357622159778*^9}, 3.8835796411258254`*^9},
 CellLabel->"Out[33]=",ExpressionUUID->"de7fe56a-514d-4f59-80b1-9919c995e426"]
}, Open  ]],

Cell["dynamic phase for the lune (equation 79)", "Text",
 CellChangeTimes->{{3.883574151345195*^9, 3.8835741835393295`*^9}, {
   3.883574235189148*^9, 3.883574267148384*^9}, {3.8835743656521654`*^9, 
   3.8835743690731983`*^9}, {3.88357444687392*^9, 3.8835744554323215`*^9}, {
   3.883574660971348*^9, 3.883574665659684*^9}, {3.883574726790719*^9, 
   3.8835747290389833`*^9}, {3.8835747748280373`*^9, 3.883574783280619*^9}, {
   3.8835748585755606`*^9, 3.8835748741931467`*^9}, {3.88357502962741*^9, 
   3.883575032927346*^9}, {3.8835752048920794`*^9, 3.883575357252722*^9}, {
   3.883575796934701*^9, 3.8835758533775325`*^9}, {3.8835760134981976`*^9, 
   3.883576033311266*^9}, {3.8835760703301516`*^9, 3.8835760709502845`*^9}, 
   3.883576159773348*^9, {3.883576359566972*^9, 3.8835763845070896`*^9}},
 Background->RGBColor[
  0.87, 0.94, 1],ExpressionUUID->"e6a8c3b9-9f66-41df-86ae-930abea3b922"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dynlune", "=", 
  RowBox[{"Collect", "[", 
   RowBox[{
    RowBox[{"dyncontlune1", "+", "dyncontlune2"}], ",", "n", ",", 
    "FullSimplify"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.870342595018339*^9, 3.870342664535592*^9}, {
   3.87034270561613*^9, 3.8703427142627764`*^9}, {3.8703428844792533`*^9, 
   3.87034292238447*^9}, {3.8703430758895593`*^9, 3.870343090145794*^9}, {
   3.87034391487619*^9, 3.87034393547408*^9}, {3.870350206432557*^9, 
   3.870350212319188*^9}, 3.8708550185173693`*^9, 3.870855100531886*^9, {
   3.883576209815133*^9, 3.883576217173142*^9}},
 CellLabel->"In[34]:=",ExpressionUUID->"1f676e2b-1ce2-4997-9088-2ba5056a47dd"],

Cell[BoxData[
 RowBox[{"n", " ", 
  RowBox[{"(", 
   RowBox[{"\[Pi]", "+", 
    RowBox[{"\[Tau]e", " ", "\[CapitalOmega]", " ", 
     RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}], ")"}]}]], "Output",
 CellChangeTimes->{{3.8703426353791323`*^9, 3.8703426648337936`*^9}, {
   3.8703427082795925`*^9, 3.8703427144669523`*^9}, {3.8703428846844373`*^9, 
   3.87034291594932*^9}, {3.8703430768250866`*^9, 3.8703430903741875`*^9}, 
   3.870343751331063*^9, 3.870343862971713*^9, {3.8703439119263134`*^9, 
   3.870343936099472*^9}, 3.8703466143235536`*^9, 3.8703468107368364`*^9, 
   3.870346952885533*^9, 3.8703473524985332`*^9, 3.8703473930680227`*^9, 
   3.87034939785623*^9, 3.870349791786166*^9, 3.8703498378654127`*^9, 
   3.8703499027679825`*^9, 3.870350058789032*^9, 3.8703501015951242`*^9, 
   3.8703501785641813`*^9, 3.870350212620639*^9, 3.8708535861701517`*^9, 
   3.870855104153262*^9, 3.870855487012542*^9, {3.870855697739499*^9, 
   3.8708557274916134`*^9}, 3.870855985066351*^9, {3.870856018051444*^9, 
   3.870856039685656*^9}, {3.870856192036947*^9, 3.870856218448251*^9}, 
   3.8708567065244455`*^9, 3.870856943765525*^9, {3.8708570132130136`*^9, 
   3.8708570339031553`*^9}, 3.8708717459109144`*^9, 3.883576222843924*^9, 
   3.883579641174631*^9},
 CellLabel->"Out[34]=",ExpressionUUID->"8fe9599d-e734-41b7-8626-3f018a2b68b3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{"dynlune", "/.", 
     RowBox[{"{", 
      RowBox[{"\[Tau]e", "\[Rule]", 
       RowBox[{"\[Pi]", "/", "\[CapitalOmega]"}]}], "}"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"\[Theta]", ",", "0", ",", "1"}], "}"}]}], "]"}], "//", 
  "Normal"}]], "Input",
 CellChangeTimes->{{3.883576470491802*^9, 3.883576484400815*^9}},
 CellLabel->"In[35]:=",ExpressionUUID->"f5bc03d3-62f8-495c-897c-123fb8e94f52"],

Cell[BoxData[
 RowBox[{"2", " ", "n", " ", "\[Pi]"}]], "Output",
 CellChangeTimes->{{3.883576472232255*^9, 3.883576484654714*^9}, 
   3.8835796412279034`*^9},
 CellLabel->"Out[35]=",ExpressionUUID->"2b1b4947-c92c-4f3c-907c-778eafed9227"]
}, Open  ]],

Cell["total phase for the lune (equation 82)", "Text",
 CellChangeTimes->{{3.883574151345195*^9, 3.8835741835393295`*^9}, {
   3.883574235189148*^9, 3.883574267148384*^9}, {3.8835743656521654`*^9, 
   3.8835743690731983`*^9}, {3.88357444687392*^9, 3.8835744554323215`*^9}, {
   3.883574660971348*^9, 3.883574665659684*^9}, {3.883574726790719*^9, 
   3.8835747290389833`*^9}, {3.8835747748280373`*^9, 3.883574783280619*^9}, {
   3.8835748585755606`*^9, 3.8835748741931467`*^9}, {3.88357502962741*^9, 
   3.883575032927346*^9}, {3.8835752048920794`*^9, 3.883575357252722*^9}, {
   3.883575796934701*^9, 3.8835758533775325`*^9}, {3.8835760134981976`*^9, 
   3.883576033311266*^9}, {3.8835760703301516`*^9, 3.8835760709502845`*^9}, 
   3.883576159773348*^9, {3.8835762420783253`*^9, 3.883576245346283*^9}, {
   3.8835763876188264`*^9, 3.8835764023202877`*^9}},
 Background->RGBColor[
  0.87, 0.94, 1],ExpressionUUID->"74ed6e7b-72f1-451b-940b-041c78a34f9e"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"MatrixExp", "[", 
     RowBox[{
      RowBox[{"+", "I"}], " ", "n", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"\[Tau]e", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"\[CapitalOmega]", "/", "2"}], " ", 
           RowBox[{"Cos", "[", "\[Theta]", "]"}]}], ")"}]}], "+", 
        RowBox[{"(", 
         RowBox[{"\[Pi]", "/", "2"}], ")"}]}], ")"}], " ", 
      RowBox[{"IdentityMatrix", "[", "2", "]"}]}], "]"}], ".", 
    RowBox[{"MatrixExp", "[", 
     RowBox[{
      RowBox[{"-", "I"}], " ", "\[Pi]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Cos", "[", "\[Phi]", "]"}], ",", 
          RowBox[{"Sin", "[", "\[Phi]", "]"}], ",", "0"}], "}"}], ".", 
        "Svec"}], ")"}]}], "]"}], ".", 
    RowBox[{"MatrixExp", "[", 
     RowBox[{
      RowBox[{"+", "I"}], " ", "n", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"\[Tau]e", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"\[CapitalOmega]", "/", "2"}], " ", 
           RowBox[{"Cos", "[", "\[Theta]", "]"}]}], ")"}]}], "+", 
        RowBox[{"(", 
         RowBox[{"\[Pi]", "/", "2"}], ")"}]}], ")"}], " ", 
      RowBox[{"IdentityMatrix", "[", "2", "]"}]}], "]"}], ".", 
    RowBox[{"MatrixExp", "[", 
     RowBox[{
      RowBox[{"-", "I"}], " ", "\[Pi]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "1", ",", "0"}], "}"}], ".", "Svec"}], ")"}]}], 
     "]"}], ".", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}]}], "//", "FullSimplify"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"%", ".", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}]}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a_.", 
     RowBox[{"Exp", "[", "arg_", "]"}]}], "\[RuleDelayed]", 
    RowBox[{"a", " ", 
     RowBox[{"Exp", "[", 
      RowBox[{"FullSimplify", "[", "arg", "]"}], "]"}]}]}], 
   "}"}]}], "\[IndentingNewLine]", 
 RowBox[{"totlune", "=", 
  RowBox[{"Collect", "[", 
   RowBox[{
    RowBox[{"%", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a_.", 
        RowBox[{"Exp", "[", "arg_", "]"}]}], "\[RuleDelayed]", 
       RowBox[{
        RowBox[{"arg", "/", "I"}], "+", 
        RowBox[{"Arg", "[", "a", "]"}]}]}], "}"}]}], ",", "n", ",", 
    "FullSimplify"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.8703431031551847`*^9, 3.8703432097801666`*^9}, 
   3.870343255980344*^9, {3.8703439433459387`*^9, 3.8703440159065*^9}, {
   3.870344049180634*^9, 3.870344088277214*^9}, {3.87034697890473*^9, 
   3.870347033645564*^9}, 3.8703470880636215`*^9, {3.8703501340006776`*^9, 
   3.870350135873494*^9}, {3.870350186936041*^9, 3.870350193959713*^9}, {
   3.870855107215068*^9, 3.8708551266522923`*^9}, {3.8708554877328243`*^9, 
   3.8708554880195923`*^9}, {3.8708557687858887`*^9, 
   3.8708558415717583`*^9}, {3.870855896709838*^9, 3.870855925444373*^9}, {
   3.870855992620068*^9, 3.8708560450372133`*^9}, {3.8708561017577095`*^9, 
   3.8708561245952015`*^9}, {3.8708562218198476`*^9, 3.870856225699711*^9}, {
   3.8708569538278885`*^9, 3.8708569606925654`*^9}, {3.8708570051225815`*^9, 
   3.8708570053201776`*^9}, {3.883576248045302*^9, 3.8835762692971315`*^9}},
 CellLabel->"In[36]:=",ExpressionUUID->"3e9b7554-8377-4379-b6af-af44ae6111d0"],

Cell[BoxData[
 RowBox[{"\[ImaginaryI]", " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"\[ImaginaryI]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"n", " ", "\[Pi]"}], "+", "\[Phi]", "+", 
      RowBox[{"n", " ", "\[Tau]e", " ", "\[CapitalOmega]", " ", 
       RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}], ")"}]}]]}]], "Output",
 CellChangeTimes->{{3.8703431097333164`*^9, 3.870343209967577*^9}, {
   3.870343944610303*^9, 3.8703440168130636`*^9}, {3.8703440577771215`*^9, 
   3.870344088527623*^9}, 3.8703466156945095`*^9, {3.870346981784404*^9, 
   3.8703470352020903`*^9}, 3.870349811865594*^9, 3.8703498431468916`*^9, 
   3.870350061649449*^9, 3.8703501037953444`*^9, 3.870350137695943*^9, {
   3.8703501800206738`*^9, 3.870350195636871*^9}, 3.8708535894346757`*^9, {
   3.8708551133591957`*^9, 3.8708551284274626`*^9}, {3.8708554885237713`*^9, 
   3.8708554928059483`*^9}, {3.870855699288647*^9, 3.870855728680565*^9}, {
   3.87085580188239*^9, 3.870855842261881*^9}, {3.870855898702874*^9, 
   3.87085592626031*^9}, 3.870855986157955*^9, {3.870856023101907*^9, 
   3.8708560459893246`*^9}, 3.8708561254713583`*^9, 3.8708561936005287`*^9, {
   3.870856223760831*^9, 3.8708562268133097`*^9}, 3.8708567074115667`*^9, 
   3.87085697322199*^9, {3.8708570068106637`*^9, 3.870857034640154*^9}, 
   3.870871746933345*^9, {3.883576260610755*^9, 3.8835762745820513`*^9}, 
   3.8835796419502397`*^9},
 CellLabel->"Out[37]=",ExpressionUUID->"cdcf333c-ee77-4518-bba0-3910e710b034"],

Cell[BoxData[
 RowBox[{
  FractionBox["\[Pi]", "2"], "+", "\[Phi]", "+", 
  RowBox[{"n", " ", 
   RowBox[{"(", 
    RowBox[{"\[Pi]", "+", 
     RowBox[{"\[Tau]e", " ", "\[CapitalOmega]", " ", 
      RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}], ")"}]}]}]], "Output",
 CellChangeTimes->{{3.8703431097333164`*^9, 3.870343209967577*^9}, {
   3.870343944610303*^9, 3.8703440168130636`*^9}, {3.8703440577771215`*^9, 
   3.870344088527623*^9}, 3.8703466156945095`*^9, {3.870346981784404*^9, 
   3.8703470352020903`*^9}, 3.870349811865594*^9, 3.8703498431468916`*^9, 
   3.870350061649449*^9, 3.8703501037953444`*^9, 3.870350137695943*^9, {
   3.8703501800206738`*^9, 3.870350195636871*^9}, 3.8708535894346757`*^9, {
   3.8708551133591957`*^9, 3.8708551284274626`*^9}, {3.8708554885237713`*^9, 
   3.8708554928059483`*^9}, {3.870855699288647*^9, 3.870855728680565*^9}, {
   3.87085580188239*^9, 3.870855842261881*^9}, {3.870855898702874*^9, 
   3.87085592626031*^9}, 3.870855986157955*^9, {3.870856023101907*^9, 
   3.8708560459893246`*^9}, 3.8708561254713583`*^9, 3.8708561936005287`*^9, {
   3.870856223760831*^9, 3.8708562268133097`*^9}, 3.8708567074115667`*^9, 
   3.87085697322199*^9, {3.8708570068106637`*^9, 3.870857034640154*^9}, 
   3.870871746933345*^9, {3.883576260610755*^9, 3.8835762745820513`*^9}, 
   3.8835796419582253`*^9},
 CellLabel->"Out[38]=",ExpressionUUID->"291af7e2-81f4-4235-9932-e865e2096d51"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{"totlune", "/.", 
     RowBox[{"{", 
      RowBox[{"\[Tau]e", "\[Rule]", 
       RowBox[{"\[Pi]", "/", "\[CapitalOmega]"}]}], "}"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"\[Theta]", ",", "0", ",", "1"}], "}"}]}], "]"}], "//", 
  "Normal"}]], "Input",
 CellChangeTimes->{{3.8835764472697563`*^9, 3.883576456128786*^9}, {
  3.8835764878351583`*^9, 3.8835764879747534`*^9}},
 CellLabel->"In[39]:=",ExpressionUUID->"fdb736bf-09b2-465a-9732-9cc4748f9f85"],

Cell[BoxData[
 RowBox[{
  FractionBox["\[Pi]", "2"], "+", 
  RowBox[{"2", " ", "n", " ", "\[Pi]"}], "+", "\[Phi]"}]], "Output",
 CellChangeTimes->{{3.883576448451933*^9, 3.8835764571335917`*^9}, 
   3.8835764881938553`*^9, 3.88357964201307*^9},
 CellLabel->"Out[39]=",ExpressionUUID->"fdc638f4-b4f7-48e6-81b1-5fbf83d45fc7"]
}, Open  ]],

Cell["geometric phase for the lune (equation 43)", "Text",
 CellChangeTimes->{{3.883574151345195*^9, 3.8835741835393295`*^9}, {
   3.883574235189148*^9, 3.883574267148384*^9}, {3.8835743656521654`*^9, 
   3.8835743690731983`*^9}, {3.88357444687392*^9, 3.8835744554323215`*^9}, {
   3.883574660971348*^9, 3.883574665659684*^9}, {3.883574726790719*^9, 
   3.8835747290389833`*^9}, {3.8835747748280373`*^9, 3.883574783280619*^9}, {
   3.8835748585755606`*^9, 3.8835748741931467`*^9}, {3.88357502962741*^9, 
   3.883575032927346*^9}, {3.8835752048920794`*^9, 3.883575357252722*^9}, {
   3.883575796934701*^9, 3.8835758533775325`*^9}, {3.8835760134981976`*^9, 
   3.883576033311266*^9}, {3.8835760703301516`*^9, 3.8835760709502845`*^9}, 
   3.883576159773348*^9, {3.8835762420783253`*^9, 3.883576245346283*^9}, {
   3.883576331205925*^9, 3.883576356426906*^9}, {3.883576417928141*^9, 
   3.883576418369014*^9}, {3.8835778295819883`*^9, 3.8835778300499754`*^9}},
 Background->RGBColor[
  0.87, 0.94, 1],ExpressionUUID->"cb50e266-ea45-4646-8d49-d7a4267e3211"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"geolune", "=", 
  RowBox[{"Collect", "[", 
   RowBox[{
    RowBox[{"totlune", "-", "dynlune"}], ",", "n", ",", "FullSimplify"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.870347042678037*^9, 3.87034706804007*^9}, {
  3.870347196542816*^9, 3.8703471979418488`*^9}, {3.870856651995415*^9, 
  3.8708566528891983`*^9}, {3.8835762712351255`*^9, 3.883576279545142*^9}},
 CellLabel->"In[40]:=",ExpressionUUID->"f3c2ae9f-ebff-458e-b5ac-e6031439164b"],

Cell[BoxData[
 RowBox[{
  FractionBox["\[Pi]", "2"], "+", "\[Phi]"}]], "Output",
 CellChangeTimes->{{3.87034704513098*^9, 3.8703470683103466`*^9}, 
   3.8703471983377895`*^9, 3.870350065573462*^9, 3.8703501065168962`*^9, 
   3.8703501392036095`*^9, 3.8703501990985174`*^9, 3.8708535917699146`*^9, 
   3.8708551310521193`*^9, 3.870855493305652*^9, {3.8708557004995565`*^9, 
   3.8708557294622374`*^9}, 3.870855804418274*^9, 3.8708559295830193`*^9, 
   3.8708559863001614`*^9, 3.8708560470654764`*^9, 3.8708561335992823`*^9, 
   3.8708561945031366`*^9, 3.870856228062831*^9, 3.8708566595215282`*^9, 
   3.8708567075851035`*^9, 3.8708569787872696`*^9, {3.8708570190709047`*^9, 
   3.8708570348057103`*^9}, 3.8708717470326004`*^9, 3.8835762798657*^9, 
   3.883579642136325*^9},
 CellLabel->"Out[40]=",ExpressionUUID->"928a56d9-82f4-4b8d-9685-831952c8c729"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["effective phase for the spherical drop", "Subsection",
 CellChangeTimes->{{3.8698158743636246`*^9, 3.8698158756916738`*^9}, {
  3.869817205568797*^9, 3.869817215792103*^9}, {3.8698200616258545`*^9, 
  3.8698200631732306`*^9}, {3.8702326249558835`*^9, 3.8702326262259893`*^9}, {
  3.870237488094673*^9, 3.870237489486377*^9}, {3.8702376810313225`*^9, 
  3.8702376824528522`*^9}, {3.870237936613577*^9, 3.870237946958558*^9}, {
  3.8703384250058737`*^9, 3.8703384275522137`*^9}, {3.870338592503579*^9, 
  3.8703385939563427`*^9}, {3.8708577135034733`*^9, 3.8708577160771904`*^9}, {
  3.8714570906981215`*^9, 3.87145709208245*^9}, {3.883576638695695*^9, 
  3.8835766418427677`*^9}},ExpressionUUID->"fd7935cc-9ec2-475a-8cdb-\
fe1aec2f2d62"],

Cell[BoxData[
 RowBox[{"Clear", "[", 
  RowBox[{"\[Psi]1", ",", "\[Psi]2", ",", "\[Psi]3"}], "]"}]], "Input",
 CellChangeTimes->{{3.8708561417171946`*^9, 3.870856155875373*^9}, {
   3.870936583678886*^9, 3.87093658925327*^9}, {3.870939510492793*^9, 
   3.8709395163949738`*^9}, 3.883576731908517*^9},
 CellLabel->"In[41]:=",ExpressionUUID->"fd56e617-e9dd-4851-a52e-a0d5e300a245"],

Cell["\<\
Calculate the spin state along the three arcs of the spherical drop\
\>", "Text",
 CellChangeTimes->{{3.883574151345195*^9, 3.8835741835393295`*^9}, {
   3.883574235189148*^9, 3.883574267148384*^9}, {3.8835743656521654`*^9, 
   3.8835743690731983`*^9}, {3.88357444687392*^9, 3.8835744554323215`*^9}, {
   3.883574660971348*^9, 3.883574665659684*^9}, {3.883574726790719*^9, 
   3.8835747290389833`*^9}, {3.8835747748280373`*^9, 3.883574783280619*^9}, {
   3.8835748585755606`*^9, 3.8835748741931467`*^9}, {3.88357502962741*^9, 
   3.883575032927346*^9}, {3.8835752048920794`*^9, 3.883575357252722*^9}, {
   3.883575796934701*^9, 3.8835758533775325`*^9}, {3.8835760134981976`*^9, 
   3.883576033311266*^9}, {3.8835760703301516`*^9, 3.8835760709502845`*^9}, 
   3.883576159773348*^9, {3.8835762420783253`*^9, 3.883576245346283*^9}, {
   3.883576331205925*^9, 3.883576356426906*^9}, {3.883576417928141*^9, 
   3.883576418369014*^9}, {3.8835778295819883`*^9, 3.8835778300499754`*^9}, {
   3.88357903131911*^9, 3.883579042801799*^9}},
 Background->RGBColor[
  0.87, 0.94, 1],ExpressionUUID->"a5c7c6a4-7b25-4867-b9b5-93b01ce4ad4f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Psi]1", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Assuming", "[", 
      RowBox[{
       RowBox[{"0", "<", "\[Theta]", "<", 
        RowBox[{"\[Pi]", "/", "2"}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"MatrixExp", "[", 
           RowBox[{
            RowBox[{"+", "I"}], " ", "t", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"\[CapitalOmega]", "/", "2"}], " ", 
                RowBox[{"Cos", "[", "\[Theta]", "]"}]}], ")"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"\[Pi]", "/", "2"}], ")"}], "/", "\[Tau]e"}]}], ")"}],
             " ", 
            RowBox[{"IdentityMatrix", "[", "2", "]"}]}], "]"}], ")"}], ".", 
         RowBox[{"(", 
          RowBox[{"MatrixExp", "[", 
           RowBox[{
            RowBox[{"-", "I"}], " ", "t", " ", "2", 
            RowBox[{"\[Theta]", "/", "\[Tau]e"}], 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"0", ",", "1", ",", "0"}], "}"}], ".", "Svec"}], 
             ")"}]}], "]"}], ")"}]}], "//", "FullSimplify"}]}], "]"}], ".", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "//", "FullSimplify"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Psi]2", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Assuming", "[", 
      RowBox[{
       RowBox[{"0", "<", "\[Theta]", "<", 
        RowBox[{"\[Pi]", "/", "2"}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"MatrixExp", "[", 
           RowBox[{
            RowBox[{"+", "I"}], " ", "t", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"\[CapitalOmega]", "/", "2"}], " ", 
                RowBox[{"Cos", "[", "\[Theta]", "]"}]}], ")"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"\[Pi]", "/", "2"}], ")"}], "/", "\[Tau]e"}]}], ")"}],
             " ", 
            RowBox[{"IdentityMatrix", "[", "2", "]"}]}], "]"}], ")"}], ".", 
         RowBox[{"(", 
          RowBox[{"MatrixExp", "[", 
           RowBox[{
            RowBox[{"-", "I"}], " ", "t", " ", "2", 
            RowBox[{"\[Theta]", "/", "\[Tau]e"}], 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"Cos", "[", 
                 RowBox[{"\[Gamma]", "/", "2"}], "]"}], ",", 
                RowBox[{"Sin", "[", 
                 RowBox[{"\[Gamma]", "/", "2"}], "]"}], ",", "0"}], "}"}], 
              ".", "Svec"}], ")"}]}], "]"}], ")"}]}], "//", 
        "FullSimplify"}]}], "]"}], ".", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"\[Psi]1", "/.", 
        RowBox[{"{", 
         RowBox[{"t", "\[Rule]", 
          RowBox[{"n", "*", "\[Tau]e"}]}], "}"}]}], "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"n", " ", "\[Theta]"}], "\[Rule]", 
         RowBox[{"\[Pi]", "/", "4"}]}], "}"}]}], ")"}]}], "//", 
    "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Psi]3", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Assuming", "[", 
      RowBox[{
       RowBox[{"0", "<", "\[Theta]", "<", 
        RowBox[{"\[Pi]", "/", "2"}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"MatrixExp", "[", 
           RowBox[{
            RowBox[{"+", "I"}], " ", "t", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"\[CapitalOmega]", "/", "2"}], " ", 
                RowBox[{"Cos", "[", "\[Theta]", "]"}]}], ")"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"\[Pi]", "/", "2"}], ")"}], "/", "\[Tau]e"}]}], ")"}],
             " ", 
            RowBox[{"IdentityMatrix", "[", "2", "]"}]}], "]"}], ")"}], ".", 
         RowBox[{"(", 
          RowBox[{"MatrixExp", "[", 
           RowBox[{
            RowBox[{"-", "I"}], " ", "t", " ", "2", 
            RowBox[{"\[Theta]", "/", "\[Tau]e"}], 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"Cos", "[", 
                 RowBox[{"\[Gamma]", "-", 
                  RowBox[{"\[Pi]", "/", "2"}]}], "]"}], ",", 
                RowBox[{"Sin", "[", 
                 RowBox[{"\[Gamma]", "-", 
                  RowBox[{"\[Pi]", "/", "2"}]}], "]"}], ",", "0"}], "}"}], 
              ".", "Svec"}], ")"}]}], "]"}], ")"}]}], "//", 
        "FullSimplify"}]}], "]"}], ".", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"\[Psi]2", "/.", 
        RowBox[{"{", 
         RowBox[{"t", "\[Rule]", 
          RowBox[{"2", "n", "*", "\[Tau]e"}]}], "}"}]}], "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"n", " ", "\[Theta]"}], "\[Rule]", 
         RowBox[{"\[Pi]", "/", "4"}]}], "}"}]}], ")"}]}], "//", 
    "FullSimplify"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.870342423258357*^9, 3.870342443795593*^9}, {
   3.8703427472698107`*^9, 3.8703427706380568`*^9}, {3.870343763138403*^9, 
   3.870343775617245*^9}, {3.8703467490487237`*^9, 3.8703467512962456`*^9}, {
   3.870347545166904*^9, 3.8703475526613636`*^9}, 3.8703478095865045`*^9, {
   3.870349345034319*^9, 3.8703493462626467`*^9}, {3.8703497077344723`*^9, 
   3.8703497090445914`*^9}, {3.8708550255020037`*^9, 3.870855025836138*^9}, {
   3.870855085848172*^9, 3.870855086116451*^9}, {3.870855474917617*^9, 
   3.870855475212812*^9}, 3.870855692653634*^9, {3.870855972297153*^9, 
   3.8708560001562724`*^9}, 3.8708560307990465`*^9, {3.870856203381797*^9, 
   3.870856204812747*^9}, {3.870939447342419*^9, 3.8709395029729867`*^9}, {
   3.8709395629240303`*^9, 3.8709395996593647`*^9}, 3.870940394972679*^9, {
   3.8709405107158327`*^9, 3.8709405257045712`*^9}, {3.8709406340177693`*^9, 
   3.870940638806904*^9}, {3.8709407070556154`*^9, 3.870940709291608*^9}, {
   3.8709407978148513`*^9, 3.8709408348454046`*^9}, {3.8709470723879824`*^9, 
   3.8709470881925273`*^9}, {3.8728464091583347`*^9, 
   3.8728464284436097`*^9}, {3.872846493681682*^9, 3.8728464963991747`*^9}, {
   3.872848213876712*^9, 3.872848225377722*^9}, {3.8728488826279306`*^9, 
   3.8728488889898367`*^9}, {3.8835768151419973`*^9, 3.883576826989519*^9}},
 CellLabel->"In[42]:=",ExpressionUUID->"181e7623-41f0-4117-8629-b1bb90706497"],

Cell["dynamic contributions for a spherical drop", "Text",
 CellChangeTimes->{{3.883574151345195*^9, 3.8835741835393295`*^9}, {
   3.883574235189148*^9, 3.883574267148384*^9}, {3.8835743656521654`*^9, 
   3.8835743690731983`*^9}, {3.88357444687392*^9, 3.8835744554323215`*^9}, {
   3.883574660971348*^9, 3.883574665659684*^9}, {3.883574726790719*^9, 
   3.8835747290389833`*^9}, {3.8835747748280373`*^9, 3.883574783280619*^9}, {
   3.8835748585755606`*^9, 3.8835748741931467`*^9}, {3.88357502962741*^9, 
   3.883575032927346*^9}, {3.8835752048920794`*^9, 3.883575357252722*^9}, {
   3.883575796934701*^9, 3.8835758533775325`*^9}, {3.8835760134981976`*^9, 
   3.883576033311266*^9}, {3.8835760703301516`*^9, 3.8835760709502845`*^9}, 
   3.883576159773348*^9, {3.8835762420783253`*^9, 3.883576245346283*^9}, {
   3.883576331205925*^9, 3.883576356426906*^9}, {3.883576417928141*^9, 
   3.883576418369014*^9}, {3.8835778295819883`*^9, 3.8835778300499754`*^9}, {
   3.88357903131911*^9, 3.883579042801799*^9}, {3.8835790957317266`*^9, 
   3.8835791024228983`*^9}},
 Background->RGBColor[
  0.87, 0.94, 1],ExpressionUUID->"48787fde-7db6-4c71-a77b-fd48e906ba26"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"dyncont1", "=", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"FullSimplify", "[", 
      RowBox[{"ComplexExpand", "[", 
       RowBox[{
        RowBox[{"-", "I"}], " ", 
        RowBox[{
         RowBox[{"Conjugate", "[", "\[Psi]1", "]"}], ".", 
         RowBox[{"D", "[", 
          RowBox[{"\[Psi]1", ",", "t"}], "]"}]}]}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{"n", "*", "\[Tau]e"}]}], "}"}]}], "]"}]}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.870338439654484*^9, 3.8703385730966625`*^9}, 
   3.870338651023349*^9, {3.8703387265759745`*^9, 3.8703387320710297`*^9}, {
   3.870338830918388*^9, 3.8703388595517836`*^9}, {3.8703389202634897`*^9, 
   3.87033897917424*^9}, {3.870339019531275*^9, 3.870339035867601*^9}, {
   3.8703391117423625`*^9, 3.8703391124671974`*^9}, {3.8703392920552998`*^9, 
   3.8703393591929226`*^9}, {3.870339466853375*^9, 3.8703394754577255`*^9}, {
   3.8703395061164017`*^9, 3.8703395710573516`*^9}, {3.870339607774358*^9, 
   3.870339632515786*^9}, {3.870340063421317*^9, 3.8703401091288195`*^9}, 
   3.8703401786229935`*^9, {3.8703417983259983`*^9, 3.8703419316707*^9}, {
   3.870341964761854*^9, 3.870341998510003*^9}, {3.8703420883701506`*^9, 
   3.870342103357911*^9}, {3.870342147757763*^9, 3.870342232597229*^9}, {
   3.870342384162696*^9, 3.8703424081558905`*^9}, {3.8703424460116887`*^9, 
   3.87034245054377*^9}, {3.8703425885435834`*^9, 3.8703425891979575`*^9}, {
   3.8703427801904154`*^9, 3.8703427808453145`*^9}, {3.8703438467631664`*^9, 
   3.8703438471541295`*^9}, 3.870346757122946*^9, 3.8708550929573326`*^9, 
   3.870939528429651*^9, {3.8835790505025816`*^9, 3.8835790638239803`*^9}},
 CellLabel->"In[45]:=",ExpressionUUID->"fb5be6de-3b21-4566-9bd1-e570d3a296c4"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", "n", " ", 
  RowBox[{"(", 
   RowBox[{"\[Pi]", "+", 
    RowBox[{"\[Tau]e", " ", "\[CapitalOmega]", " ", 
     RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}], ")"}]}]], "Output",
 CellChangeTimes->{{3.870338478593271*^9, 3.8703385733778343`*^9}, 
   3.8703386514294987`*^9, 3.870338862285515*^9, 3.8703389298394966`*^9, 
   3.870339120145179*^9, {3.8703392988348083`*^9, 3.870339326372345*^9}, {
   3.870339497655343*^9, 3.870339571853936*^9}, 3.870340180825476*^9, {
   3.870341843795539*^9, 3.870341890801375*^9}, {3.8703419218866568`*^9, 
   3.8703419319429674`*^9}, {3.870341969679992*^9, 3.8703419878212385`*^9}, {
   3.87034209374605*^9, 3.8703421038142357`*^9}, {3.8703421561998577`*^9, 
   3.8703422328649044`*^9}, {3.870342384692242*^9, 3.8703424085333633`*^9}, 
   3.870342450880255*^9, 3.870342589606115*^9, {3.870342781431543*^9, 
   3.8703427839608493`*^9}, 3.870343808631231*^9, 3.870343847485037*^9, 
   3.8703466078737917`*^9, 3.8703467578494425`*^9, 3.8703478175461807`*^9, 
   3.8703493707245555`*^9, 3.8703497722170095`*^9, 3.870853581028054*^9, 
   3.87085499872058*^9, {3.870855088069743*^9, 3.870855093296398*^9}, 
   3.8708554772282853`*^9, 3.8708557225724277`*^9, 3.870855977624192*^9, {
   3.8708560098363748`*^9, 3.8708560330362644`*^9}, {3.8708561607471113`*^9, 
   3.870856209322494*^9}, 3.8708567017773314`*^9, 3.870857029283742*^9, 
   3.8708717414178886`*^9, {3.8709395255104723`*^9, 3.870939528754753*^9}, 
   3.8709404112928157`*^9, 3.8709405343772955`*^9, {3.8709406674559393`*^9, 
   3.870940680349324*^9}, 3.870940748052472*^9, 3.870940804086008*^9, 
   3.8709408422853885`*^9, 3.87094709330875*^9, 3.8728465256062474`*^9, 
   3.87284822884663*^9, 3.8728489016320443`*^9, 3.8835775834639215`*^9, 
   3.8835791126171*^9, 3.8835796586180477`*^9},
 CellLabel->"Out[45]=",ExpressionUUID->"88f4bc19-099b-453d-87df-035cbdb949ae"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dyncont2", "=", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"FullSimplify", "[", 
     RowBox[{"ComplexExpand", "[", 
      RowBox[{
       RowBox[{"-", "I"}], " ", 
       RowBox[{
        RowBox[{"Conjugate", "[", "\[Psi]2", "]"}], ".", 
        RowBox[{"D", "[", 
         RowBox[{"\[Psi]2", ",", "t"}], "]"}]}]}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", 
      RowBox[{"2", "n", "*", "\[Tau]e"}]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8703425181424265`*^9, 3.8703425359670177`*^9}, {
   3.870342577038517*^9, 3.870342600509411*^9}, {3.8703428335677004`*^9, 
   3.870342856055435*^9}, {3.87034385220409*^9, 3.8703438592525406`*^9}, {
   3.870346777737507*^9, 3.870346778711913*^9}, {3.870346943448516*^9, 
   3.8703469497609835`*^9}, {3.8703473383976293`*^9, 
   3.8703473429806895`*^9}, {3.8703498862912407`*^9, 3.87034988865055*^9}, {
   3.870350031073266*^9, 3.8703500551065*^9}, {3.8703503078076377`*^9, 
   3.8703503106774025`*^9}, 3.8708550967976*^9, {3.87093961981124*^9, 
   3.8709396218018727`*^9}, {3.8728465301129436`*^9, 
   3.8728465304387445`*^9}, {3.883579070027013*^9, 3.883579077852129*^9}},
 CellLabel->"In[46]:=",ExpressionUUID->"af66615d-e0b1-4e19-9e46-dd233dca91a9"],

Cell[BoxData[
 RowBox[{"n", " ", 
  RowBox[{"(", 
   RowBox[{"\[Pi]", "+", 
    RowBox[{"2", " ", "\[Theta]", " ", 
     RowBox[{"Cos", "[", 
      FractionBox["\[Gamma]", "2"], "]"}]}], "+", 
    RowBox[{"\[Tau]e", " ", "\[CapitalOmega]", " ", 
     RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}], ")"}]}]], "Output",
 CellChangeTimes->{{3.870342583279007*^9, 3.870342602908959*^9}, {
   3.870342828379227*^9, 3.8703428393535185`*^9}, 3.8703428790932274`*^9, 
   3.8703437361104045`*^9, 3.870343860682675*^9, 3.870343910562162*^9, 
   3.8703466142377563`*^9, {3.8703467840009193`*^9, 3.870346808626709*^9}, 
   3.8703469509841137`*^9, 3.870347344680616*^9, 3.8703473907759285`*^9, 
   3.87034758629762*^9, 3.8703493958953514`*^9, 3.8703497906750574`*^9, 
   3.8703498376544724`*^9, 3.8703498998167944`*^9, {3.870350036118438*^9, 
   3.8703500553348875`*^9}, 3.8703500999216127`*^9, 3.870350178358717*^9, 
   3.870350312303602*^9, 3.8708535861012526`*^9, 3.8708550211559105`*^9, 
   3.8708551039897585`*^9, 3.8708554868709183`*^9, {3.870855697596881*^9, 
   3.8708557263364673`*^9}, 3.8708559849192457`*^9, {3.870856017909794*^9, 
   3.870856039522087*^9}, {3.870856191500383*^9, 3.870856218309622*^9}, 
   3.870856706437665*^9, 3.870856938124389*^9, {3.870857013026499*^9, 
   3.870857033814794*^9}, 3.8708717458331213`*^9, 3.870939623174181*^9, 
   3.870940413091983*^9, 3.8709405350564265`*^9, 3.870940681525178*^9, 
   3.87094074813428*^9, 3.870940805435393*^9, 3.870940842367169*^9, 
   3.8709470937725344`*^9, {3.872846529472576*^9, 3.872846531150138*^9}, 
   3.872848229745062*^9, 3.872848903746586*^9, 3.8835775856679626`*^9, 
   3.8835791140928116`*^9, 3.8835796640485697`*^9},
 CellLabel->"Out[46]=",ExpressionUUID->"458df871-3607-494b-85c6-d2387d9da901"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dyncont3", "=", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"FullSimplify", "[", 
     RowBox[{"ComplexExpand", "[", 
      RowBox[{
       RowBox[{"-", "I"}], " ", 
       RowBox[{
        RowBox[{"Conjugate", "[", "\[Psi]3", "]"}], ".", 
        RowBox[{"D", "[", 
         RowBox[{"\[Psi]3", ",", "t"}], "]"}]}]}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", 
      RowBox[{"n", "*", "\[Tau]e"}]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.870939633334921*^9, 3.870939639474435*^9}, {
  3.8835790800632386`*^9, 3.8835790848338947`*^9}},
 CellLabel->"In[47]:=",ExpressionUUID->"b386b64b-a48e-4b0c-9d4f-2a8c80f9f869"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", "n", " ", 
  RowBox[{"(", 
   RowBox[{"\[Pi]", "+", 
    RowBox[{"\[Tau]e", " ", "\[CapitalOmega]", " ", 
     RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}], ")"}]}]], "Output",
 CellChangeTimes->{3.870939641063137*^9, 3.8709404159223824`*^9, 
  3.8709405359988947`*^9, 3.870940682487561*^9, 3.870940748270885*^9, 
  3.8709408064925175`*^9, 3.870940842452968*^9, 3.8709470943998194`*^9, 
  3.8728465369328623`*^9, 3.8728482356024475`*^9, 3.872848450603413*^9, 
  3.872848904419787*^9, 3.8835775862184334`*^9, 3.8835791144952974`*^9, 
  3.8835796658725896`*^9},
 CellLabel->"Out[47]=",ExpressionUUID->"6e9a2115-b990-4c3c-9471-e3213d85fb9b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dyndrop", "=", 
  RowBox[{"Collect", "[", 
   RowBox[{
    RowBox[{"dyncont1", "+", "dyncont2", "+", "dyncont3"}], ",", "n", ",", 
    "FullSimplify"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.870342595018339*^9, 3.870342664535592*^9}, {
   3.87034270561613*^9, 3.8703427142627764`*^9}, {3.8703428844792533`*^9, 
   3.87034292238447*^9}, {3.8703430758895593`*^9, 3.870343090145794*^9}, {
   3.87034391487619*^9, 3.87034393547408*^9}, {3.870350206432557*^9, 
   3.870350212319188*^9}, 3.8708550185173693`*^9, 3.870855100531886*^9, {
   3.8709396453626184`*^9, 3.8709396466262307`*^9}, {3.8709399024817123`*^9, 
   3.870939920281901*^9}, 3.8709399585521207`*^9, {3.883577594775958*^9, 
   3.8835775955467257`*^9}, {3.883579706169829*^9, 3.883579709805005*^9}},
 CellLabel->"In[57]:=",ExpressionUUID->"2622e847-c6a4-496a-9053-128ca13285cb"],

Cell[BoxData[
 RowBox[{"2", " ", "n", " ", 
  RowBox[{"(", 
   RowBox[{"\[Pi]", "+", 
    RowBox[{"\[Theta]", " ", 
     RowBox[{"Cos", "[", 
      FractionBox["\[Gamma]", "2"], "]"}]}], "+", 
    RowBox[{"\[Tau]e", " ", "\[CapitalOmega]", " ", 
     RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}], ")"}]}]], "Output",
 CellChangeTimes->{{3.8703426353791323`*^9, 3.8703426648337936`*^9}, {
   3.8703427082795925`*^9, 3.8703427144669523`*^9}, {3.8703428846844373`*^9, 
   3.87034291594932*^9}, {3.8703430768250866`*^9, 3.8703430903741875`*^9}, 
   3.870343751331063*^9, 3.870343862971713*^9, {3.8703439119263134`*^9, 
   3.870343936099472*^9}, 3.8703466143235536`*^9, 3.8703468107368364`*^9, 
   3.870346952885533*^9, 3.8703473524985332`*^9, 3.8703473930680227`*^9, 
   3.87034939785623*^9, 3.870349791786166*^9, 3.8703498378654127`*^9, 
   3.8703499027679825`*^9, 3.870350058789032*^9, 3.8703501015951242`*^9, 
   3.8703501785641813`*^9, 3.870350212620639*^9, 3.8708535861701517`*^9, 
   3.870855104153262*^9, 3.870855487012542*^9, {3.870855697739499*^9, 
   3.8708557274916134`*^9}, 3.870855985066351*^9, {3.870856018051444*^9, 
   3.870856039685656*^9}, {3.870856192036947*^9, 3.870856218448251*^9}, 
   3.8708567065244455`*^9, 3.870856943765525*^9, {3.8708570132130136`*^9, 
   3.8708570339031553`*^9}, 3.8708717459109144`*^9, 3.8709396470341015`*^9, {
   3.8709399029394674`*^9, 3.870939916980768*^9}, 3.870939958841324*^9, 
   3.870940417555993*^9, 3.870940536831682*^9, 3.870940683513818*^9, 
   3.8709407483457117`*^9, 3.87094080736119*^9, 3.870940842535743*^9, 
   3.870947095017191*^9, 3.8728465398390493`*^9, 3.8728482371873574`*^9, 
   3.872848451118828*^9, 3.8728489045664244`*^9, 3.883577586259325*^9, 
   3.8835776499615016`*^9, 3.883579114907346*^9, 3.883579665971381*^9, 
   3.883579710203106*^9},
 CellLabel->"Out[57]=",ExpressionUUID->"9dd2bafc-4191-45fd-85f2-d5935719ef9d"]
}, Open  ]],

Cell["the result below corresponds to equation 90", "Text",
 CellChangeTimes->{{3.883574151345195*^9, 3.8835741835393295`*^9}, {
   3.883574235189148*^9, 3.883574267148384*^9}, {3.8835743656521654`*^9, 
   3.8835743690731983`*^9}, {3.88357444687392*^9, 3.8835744554323215`*^9}, {
   3.883574660971348*^9, 3.883574665659684*^9}, {3.883574726790719*^9, 
   3.8835747290389833`*^9}, {3.8835747748280373`*^9, 3.883574783280619*^9}, {
   3.8835748585755606`*^9, 3.8835748741931467`*^9}, {3.88357502962741*^9, 
   3.883575032927346*^9}, {3.8835752048920794`*^9, 3.883575357252722*^9}, {
   3.883575796934701*^9, 3.8835758533775325`*^9}, {3.8835760134981976`*^9, 
   3.883576033311266*^9}, {3.8835760703301516`*^9, 3.8835760709502845`*^9}, 
   3.883576159773348*^9, {3.8835762420783253`*^9, 3.883576245346283*^9}, {
   3.883576331205925*^9, 3.883576356426906*^9}, {3.883576417928141*^9, 
   3.883576418369014*^9}, {3.8835778295819883`*^9, 3.8835778300499754`*^9}, {
   3.88357903131911*^9, 3.883579042801799*^9}, {3.8835790957317266`*^9, 
   3.8835791644408083`*^9}},
 Background->RGBColor[
  0.87, 0.94, 1],ExpressionUUID->"3de08dcd-55fc-43dd-8f95-9d005cd36de5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"dyndrop", "/.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"2", "n", " ", "\[Theta]"}], "->", " ", 
          RowBox[{"\[Pi]", "/", "2"}]}], "}"}]}], "/.", 
       RowBox[{"{", 
        RowBox[{"\[Tau]e", "\[Rule]", " ", 
         RowBox[{"\[Pi]", "/", "\[CapitalOmega]"}]}], "}"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"\[Theta]", ",", "0", ",", "1"}], "}"}]}], "]"}], "//", 
    "Normal"}], "//", "FullSimplify"}], "//", "Expand"}]], "Input",
 CellChangeTimes->{
  3.883579234136324*^9, {3.8835796962609444`*^9, 3.8835797005875664`*^9}},
 CellLabel->"In[58]:=",ExpressionUUID->"3f884dd8-2cb9-4e52-b9c7-3bb237c5bfff"],

Cell[BoxData[
 RowBox[{
  RowBox[{"4", " ", "n", " ", "\[Pi]"}], "+", 
  RowBox[{"2", " ", "n", " ", "\[Theta]", " ", 
   RowBox[{"Cos", "[", 
    FractionBox["\[Gamma]", "2"], "]"}]}]}]], "Output",
 CellChangeTimes->{3.8835791235339327`*^9, 3.883579666054778*^9, 
  3.883579711802925*^9},
 CellLabel->"Out[58]=",ExpressionUUID->"17701492-c9d6-4ea1-afea-ba171341d9b3"]
}, Open  ]],

Cell["total phase acquired during a spherical droplet experiment:", "Text",
 CellChangeTimes->{{3.883574151345195*^9, 3.8835741835393295`*^9}, {
   3.883574235189148*^9, 3.883574267148384*^9}, {3.8835743656521654`*^9, 
   3.8835743690731983`*^9}, {3.88357444687392*^9, 3.8835744554323215`*^9}, {
   3.883574660971348*^9, 3.883574665659684*^9}, {3.883574726790719*^9, 
   3.8835747290389833`*^9}, {3.8835747748280373`*^9, 3.883574783280619*^9}, {
   3.8835748585755606`*^9, 3.8835748741931467`*^9}, {3.88357502962741*^9, 
   3.883575032927346*^9}, {3.8835752048920794`*^9, 3.883575357252722*^9}, {
   3.883575796934701*^9, 3.8835758533775325`*^9}, {3.8835760134981976`*^9, 
   3.883576033311266*^9}, {3.8835760703301516`*^9, 3.8835760709502845`*^9}, 
   3.883576159773348*^9, {3.8835762420783253`*^9, 3.883576245346283*^9}, {
   3.883576331205925*^9, 3.883576356426906*^9}, {3.883576417928141*^9, 
   3.883576418369014*^9}, {3.8835778295819883`*^9, 3.8835778300499754`*^9}, {
   3.88357903131911*^9, 3.883579042801799*^9}, {3.8835790957317266`*^9, 
   3.8835791905722485`*^9}},
 Background->RGBColor[
  0.87, 0.94, 1],ExpressionUUID->"302b6163-48b8-4b2d-8c06-667c2b538aa1"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Udrop", "=", 
   RowBox[{
    RowBox[{"Dot", "@@", 
     RowBox[{"Reverse", "@", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"MatrixExp", "[", 
            RowBox[{
             RowBox[{"+", "I"}], " ", "n", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"\[Tau]e", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"\[CapitalOmega]", "/", "2"}], " ", 
                  RowBox[{"Cos", "[", "\[Theta]", "]"}]}], ")"}]}], "+", 
               RowBox[{"(", 
                RowBox[{"\[Pi]", "/", "2"}], ")"}]}], ")"}], " ", 
             RowBox[{"IdentityMatrix", "[", "2", "]"}]}], "]"}], ")"}], ".", 
          RowBox[{"(", 
           RowBox[{"MatrixExp", "[", 
            RowBox[{
             RowBox[{"-", "I"}], " ", 
             RowBox[{"\[Pi]", "/", "2"}], 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"0", ",", "1", ",", "0"}], "}"}], ".", "Svec"}], 
              ")"}]}], "]"}], ")"}]}], "//", "FullSimplify"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"MatrixExp", "[", 
            RowBox[{
             RowBox[{"+", "I"}], " ", "2", "n", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"\[Tau]e", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"\[CapitalOmega]", "/", "2"}], " ", 
                  RowBox[{"Cos", "[", "\[Theta]", "]"}]}], ")"}]}], "+", 
               RowBox[{"(", 
                RowBox[{"\[Pi]", "/", "2"}], ")"}]}], ")"}], " ", 
             RowBox[{"IdentityMatrix", "[", "2", "]"}]}], "]"}], ")"}], ".", 
          RowBox[{"(", 
           RowBox[{"MatrixExp", "[", 
            RowBox[{
             RowBox[{"-", "I"}], " ", "\[Pi]", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"Cos", "[", 
                  RowBox[{"\[Gamma]", "/", "2"}], "]"}], ",", 
                 RowBox[{"Sin", "[", 
                  RowBox[{"\[Gamma]", "/", "2"}], "]"}], ",", "0"}], "}"}], 
               ".", "Svec"}], ")"}]}], "]"}], ")"}]}], "//", "FullSimplify"}],
         ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"MatrixExp", "[", 
            RowBox[{
             RowBox[{"+", "I"}], " ", "n", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"\[Tau]e", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"\[CapitalOmega]", "/", "2"}], " ", 
                  RowBox[{"Cos", "[", "\[Theta]", "]"}]}], ")"}]}], "+", 
               RowBox[{"(", 
                RowBox[{"\[Pi]", "/", "2"}], ")"}]}], ")"}], " ", 
             RowBox[{"IdentityMatrix", "[", "2", "]"}]}], "]"}], ")"}], ".", 
          RowBox[{"(", 
           RowBox[{"MatrixExp", "[", 
            RowBox[{
             RowBox[{"-", "I"}], " ", 
             RowBox[{"\[Pi]", "/", "2"}], 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"Cos", "[", 
                  RowBox[{"\[Gamma]", "-", 
                   RowBox[{"\[Pi]", "/", "2"}]}], "]"}], ",", 
                 RowBox[{"Sin", "[", 
                  RowBox[{"\[Gamma]", "-", 
                   RowBox[{"\[Pi]", "/", "2"}]}], "]"}], ",", "0"}], "}"}], 
               ".", "Svec"}], ")"}]}], "]"}], ")"}]}], "//", 
         "FullSimplify"}]}], "\[IndentingNewLine]", "}"}]}]}], "//", 
    "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Udrop", ".", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}]}], "//", "Simplify"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"%", ".", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a_.", 
       RowBox[{"Exp", "[", "arg_", "]"}]}], "\[RuleDelayed]", 
      RowBox[{"a", " ", 
       RowBox[{"Exp", "[", 
        RowBox[{"FullSimplify", "[", "arg", "]"}], "]"}]}]}], "}"}]}], "//", 
   "FullSimplify"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"totdrop", "=", 
  RowBox[{"Collect", "[", 
   RowBox[{
    RowBox[{"%", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a_.", 
        RowBox[{"Exp", "[", "arg_", "]"}]}], "\[RuleDelayed]", 
       RowBox[{
        RowBox[{"arg", "/", "I"}], "+", 
        RowBox[{"Arg", "[", "a", "]"}]}]}], "}"}]}], ",", "m", ",", 
    "FullSimplify"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.8703431031551847`*^9, 3.8703432097801666`*^9}, 
   3.870343255980344*^9, {3.8703439433459387`*^9, 3.8703440159065*^9}, {
   3.870344049180634*^9, 3.870344088277214*^9}, {3.87034697890473*^9, 
   3.870347033645564*^9}, 3.8703470880636215`*^9, {3.8703501340006776`*^9, 
   3.870350135873494*^9}, {3.870350186936041*^9, 3.870350193959713*^9}, {
   3.870855107215068*^9, 3.8708551266522923`*^9}, {3.8708554877328243`*^9, 
   3.8708554880195923`*^9}, {3.8708557687858887`*^9, 
   3.8708558415717583`*^9}, {3.870855896709838*^9, 3.870855925444373*^9}, {
   3.870855992620068*^9, 3.8708560450372133`*^9}, {3.8708561017577095`*^9, 
   3.8708561245952015`*^9}, {3.8708562218198476`*^9, 3.870856225699711*^9}, {
   3.8708569538278885`*^9, 3.8708569606925654`*^9}, {3.8708570051225815`*^9, 
   3.8708570053201776`*^9}, {3.870939665938978*^9, 3.870939878008438*^9}, {
   3.8709399504050083`*^9, 3.870939984382756*^9}, {3.8709403314133687`*^9, 
   3.8709403532118254`*^9}, {3.870940688344864*^9, 3.870940703398431*^9}, {
   3.87094085483871*^9, 3.870940859196968*^9}, {3.8728465970817213`*^9, 
   3.8728466400066414`*^9}, 3.872846686984456*^9, {3.872848244945328*^9, 
   3.8728482509377112`*^9}, {3.872848753666999*^9, 3.872848758999183*^9}, {
   3.8728488709231806`*^9, 3.872848874882962*^9}, {3.8835776001562047`*^9, 
   3.8835776307871385`*^9}, 3.883579200127373*^9},
 CellLabel->"In[51]:=",ExpressionUUID->"fa0398f2-2c8e-4eaf-ab5c-c3f5f1acf7dc"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{"\[Pi]", "+", 
    RowBox[{"4", " ", "n", " ", "\[Pi]"}], "+", "\[Gamma]", "+", 
    RowBox[{"4", " ", "n", " ", "\[Tau]e", " ", "\[CapitalOmega]", " ", 
     RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}], ")"}]}]], "Output",
 CellChangeTimes->{
  3.870940354495351*^9, 3.870940540974533*^9, {3.870940686733159*^9, 
   3.870940691846426*^9}, 3.870940749481634*^9, 3.8709408105236907`*^9, {
   3.870940843758432*^9, 3.870940859995823*^9}, 3.870947097491514*^9, 
   3.8728467264712*^9, 3.8728482519581985`*^9, 3.872848451818963*^9, {
   3.872848759442397*^9, 3.8728487701677313`*^9}, 3.87284890518509*^9, {
   3.8835776227223434`*^9, 3.8835776324344807`*^9}, 3.8835792005858383`*^9, 
   3.883579670325287*^9},
 CellLabel->"Out[54]=",ExpressionUUID->"7ebe99ce-6a6c-4cae-9cab-f178e6e23afb"]
}, Open  ]],

Cell["the result below corresponds to equation 93", "Text",
 CellChangeTimes->{{3.883574151345195*^9, 3.8835741835393295`*^9}, {
   3.883574235189148*^9, 3.883574267148384*^9}, {3.8835743656521654`*^9, 
   3.8835743690731983`*^9}, {3.88357444687392*^9, 3.8835744554323215`*^9}, {
   3.883574660971348*^9, 3.883574665659684*^9}, {3.883574726790719*^9, 
   3.8835747290389833`*^9}, {3.8835747748280373`*^9, 3.883574783280619*^9}, {
   3.8835748585755606`*^9, 3.8835748741931467`*^9}, {3.88357502962741*^9, 
   3.883575032927346*^9}, {3.8835752048920794`*^9, 3.883575357252722*^9}, {
   3.883575796934701*^9, 3.8835758533775325`*^9}, {3.8835760134981976`*^9, 
   3.883576033311266*^9}, {3.8835760703301516`*^9, 3.8835760709502845`*^9}, 
   3.883576159773348*^9, {3.8835762420783253`*^9, 3.883576245346283*^9}, {
   3.883576331205925*^9, 3.883576356426906*^9}, {3.883576417928141*^9, 
   3.883576418369014*^9}, {3.8835778295819883`*^9, 3.8835778300499754`*^9}, {
   3.88357903131911*^9, 3.883579042801799*^9}, {3.8835790957317266`*^9, 
   3.8835791644408083`*^9}, {3.883579248373252*^9, 3.883579248454118*^9}},
 Background->RGBColor[
  0.87, 0.94, 1],ExpressionUUID->"3a35ef88-ea1d-4605-b80e-1f9d3b6b0b17"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"totdrop", "/.", 
       RowBox[{"{", 
        RowBox[{"\[Tau]e", "\[Rule]", " ", 
         RowBox[{"\[Pi]", "/", "\[CapitalOmega]"}]}], "}"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"\[Theta]", ",", "0", ",", "1"}], "}"}]}], "]"}], "//", 
    "Normal"}], "//", "FullSimplify"}], "//", "Expand"}]], "Input",
 CellChangeTimes->{{3.8728489334486237`*^9, 3.872848992328088*^9}, {
  3.8835776535168037`*^9, 3.88357766672727*^9}, {3.883579202212328*^9, 
  3.8835792030346713`*^9}},
 CellLabel->"In[55]:=",ExpressionUUID->"87dc2fd1-e28e-46e7-9fd5-d0bcdc9bda2f"],

Cell[BoxData[
 RowBox[{
  FractionBox["\[Pi]", "2"], "+", 
  RowBox[{"4", " ", "n", " ", "\[Pi]"}], "+", 
  FractionBox["\[Gamma]", "2"]}]], "Output",
 CellChangeTimes->{{3.8728489358761797`*^9, 3.8728489925975833`*^9}, {
   3.8835776394362917`*^9, 3.8835776637861404`*^9}, 3.8835778212997885`*^9, 
   3.8835792063453703`*^9, 3.88357924020195*^9, 3.8835796705087996`*^9},
 CellLabel->"Out[55]=",ExpressionUUID->"15ab1a34-c066-426a-b13f-4d124b340ec7"]
}, Open  ]],

Cell["geometric phase for the spherical drop (equation 52)", "Text",
 CellChangeTimes->{{3.883574151345195*^9, 3.8835741835393295`*^9}, {
   3.883574235189148*^9, 3.883574267148384*^9}, {3.8835743656521654`*^9, 
   3.8835743690731983`*^9}, {3.88357444687392*^9, 3.8835744554323215`*^9}, {
   3.883574660971348*^9, 3.883574665659684*^9}, {3.883574726790719*^9, 
   3.8835747290389833`*^9}, {3.8835747748280373`*^9, 3.883574783280619*^9}, {
   3.8835748585755606`*^9, 3.8835748741931467`*^9}, {3.88357502962741*^9, 
   3.883575032927346*^9}, {3.8835752048920794`*^9, 3.883575357252722*^9}, {
   3.883575796934701*^9, 3.8835758533775325`*^9}, {3.8835760134981976`*^9, 
   3.883576033311266*^9}, {3.8835760703301516`*^9, 3.8835760709502845`*^9}, 
   3.883576159773348*^9, {3.8835762420783253`*^9, 3.883576245346283*^9}, {
   3.883576331205925*^9, 3.883576356426906*^9}, {3.883576417928141*^9, 
   3.883576418369014*^9}, {3.8835778295819883`*^9, 3.8835778300499754`*^9}, {
   3.88357903131911*^9, 3.883579042801799*^9}, {3.8835790957317266`*^9, 
   3.8835791644408083`*^9}, {3.8835792550146046`*^9, 3.8835792759744506`*^9}},
 Background->RGBColor[
  0.87, 0.94, 1],ExpressionUUID->"e33ceec3-a95c-43b1-bdac-d7ec2e2eb181"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Collect", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Simplify", "[", 
     RowBox[{"totdrop", "-", "dyndrop"}], "]"}], "/.", 
    RowBox[{"{", 
     RowBox[{"n", "->", " ", 
      RowBox[{"\[Pi]", "/", 
       RowBox[{"(", 
        RowBox[{"4", "\[Theta]"}], ")"}]}]}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Gamma]", ",", 
     RowBox[{"Cos", "[", 
      RowBox[{"\[Gamma]", "/", "2"}], "]"}]}], "}"}], ",", "FullSimplify"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.88357927768019*^9, 3.883579359012227*^9}, {
  3.883579504913312*^9, 3.8835795462851906`*^9}},
 CellLabel->"In[59]:=",ExpressionUUID->"c9aa4d49-0fcb-4861-af39-b6c7b4a2b67d"],

Cell[BoxData[
 RowBox[{
  FractionBox["\[Pi]", "2"], "+", 
  FractionBox["\[Gamma]", "2"], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", "\[Pi]", " ", 
   RowBox[{"Cos", "[", 
    FractionBox["\[Gamma]", "2"], "]"}]}]}]], "Output",
 CellChangeTimes->{{3.8835792817520657`*^9, 3.883579285509244*^9}, {
   3.8835793263357267`*^9, 3.8835793592511964`*^9}, {3.883579510333892*^9, 
   3.88357954661213*^9}, 3.883579670898391*^9, 3.8835797189543257`*^9},
 CellLabel->"Out[59]=",ExpressionUUID->"7b79858c-07aa-4184-98d9-de4a08331b88"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1016.25, 617.625},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
TaggingRules->Association["TryRealOnly" -> False],
Magnification:>1.3 Inherited,
FrontEndVersion->"12.3 for Microsoft Windows (64-bit) (May 11, 2021)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"920f4264-7209-475a-99c3-debe12ce855e"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 700, 13, 62, "Input",ExpressionUUID->"85798c45-50b7-4988-9061-afcd31c248c4"],
Cell[1283, 37, 665, 13, 43, "Print",ExpressionUUID->"69fc4142-9b9c-490b-a8f9-798482b164c5"],
Cell[1951, 52, 1006, 18, 79, "Message",ExpressionUUID->"53a09a36-c3d1-489f-8eb9-0500b866367c"],
Cell[2960, 72, 684, 13, 29, "Message",ExpressionUUID->"1bb62115-244a-4ff7-a611-419d8da4a5b5"],
Cell[3647, 87, 1010, 18, 55, "Message",ExpressionUUID->"293ec027-6556-4641-9c31-2721d584ac56"],
Cell[4660, 107, 893, 16, 78, "Message",ExpressionUUID->"d568af73-6886-4e9b-a2a7-c57ceadf94a0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5590, 128, 210, 3, 36, "Input",ExpressionUUID->"e2ae5211-e862-4757-9062-57f766ba5937"],
Cell[5803, 133, 898, 17, 48, "Message",ExpressionUUID->"08b96f40-4e51-491c-833f-657dab51a75f"],
Cell[6704, 152, 1036, 19, 48, "Message",ExpressionUUID->"4f5a186c-9436-4d83-a9d9-1c5bc4bb24af"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7777, 176, 248, 4, 36, "Input",ExpressionUUID->"0415dfe8-f1f6-4aed-a61f-6e562b19aea6"],
Cell[8028, 182, 1044, 19, 48, "Message",ExpressionUUID->"c7c29c63-7039-456c-96df-2ec899f8a6b1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9109, 206, 213, 4, 86, "Section",ExpressionUUID->"d1b5b305-0230-4197-8335-8a91c4a884a4"],
Cell[9325, 212, 250, 5, 66, "Text",ExpressionUUID->"fff671ab-a8da-42f0-939f-9d2bf96318a6"],
Cell[CellGroupData[{
Cell[9600, 221, 1401, 33, 36, "Input",ExpressionUUID->"8d810ca2-45a7-4e42-8d0f-da5b4bf0109f"],
Cell[11004, 256, 2116, 68, 60, "Output",ExpressionUUID->"fec3e9d9-4564-4d8e-98a7-009545b9bded"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13157, 329, 358, 7, 36, "Input",ExpressionUUID->"18997f02-bf80-462a-aa95-13512bf35acd"],
Cell[13518, 338, 2428, 57, 160, "Output",ExpressionUUID->"3a30e733-2852-488a-a371-b330ceee4c66"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15995, 401, 376, 6, 86, "Section",ExpressionUUID->"4f28c91d-5dad-4a67-9fb1-0fb06e214162"],
Cell[16374, 409, 724, 19, 66, "Text",ExpressionUUID->"17581026-39bc-4b55-9330-e528b8619a04"],
Cell[CellGroupData[{
Cell[17123, 432, 364, 8, 36, "Input",ExpressionUUID->"416f063b-f36d-4bd9-b0be-58e04d60eaf2"],
Cell[17490, 442, 892, 26, 124, "Output",ExpressionUUID->"cd6b5714-345f-4466-9518-831898dff4a9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18419, 473, 637, 16, 62, "Input",ExpressionUUID->"69c75c6d-c27c-4677-888b-865880c68787"],
Cell[19059, 491, 791, 23, 124, "Output",ExpressionUUID->"0d03925b-9e6e-419f-bb80-adbab995ae5e"]
}, Open  ]],
Cell[19865, 517, 1420, 44, 96, "Text",ExpressionUUID->"7439d992-c337-407e-b9ec-b9f731617cfc"],
Cell[21288, 563, 675, 15, 36, "Input",ExpressionUUID->"47656a27-619a-414f-94b6-d5e34dea4f3f"],
Cell[CellGroupData[{
Cell[21988, 582, 238, 4, 36, "Input",ExpressionUUID->"ea6ae162-c0ad-4320-9a26-34b0032ed501"],
Cell[22229, 588, 1769, 44, 96, "Output",ExpressionUUID->"9a518918-2f81-42d6-83e6-39e10c715140"]
}, Open  ]],
Cell[24013, 635, 326, 5, 66, "Text",ExpressionUUID->"5de2e783-951b-4f62-8a99-fdc472304d7c"],
Cell[24342, 642, 624, 16, 36, "Input",ExpressionUUID->"d684ea61-e0b5-4e23-9b07-d806949a637a"],
Cell[24969, 660, 344, 5, 66, "Text",ExpressionUUID->"67eba4d4-2621-4baf-bf1a-badfaeb995ee"],
Cell[25316, 667, 1369, 27, 62, "Input",ExpressionUUID->"d5a4f5d4-ec22-445f-af0c-c3b1a95e0e92"],
Cell[26688, 696, 364, 5, 66, "Text",ExpressionUUID->"c539b3b4-9bb4-437f-9016-4c594a34a8c0"],
Cell[CellGroupData[{
Cell[27077, 705, 1950, 40, 62, "Input",ExpressionUUID->"56aeb567-e2a8-4d6b-a8c6-fcee0fad0818"],
Cell[29030, 747, 1733, 31, 68, "Output",ExpressionUUID->"373ab23d-b937-4322-b812-89c9a81a9f50"]
}, Open  ]],
Cell[30778, 781, 414, 6, 66, "Text",ExpressionUUID->"69c3883e-cba3-4b58-83f7-f3ef0137daf1"],
Cell[CellGroupData[{
Cell[31217, 791, 1060, 23, 36, "Input",ExpressionUUID->"669aab98-5ab0-446b-9890-744eda1f5d5b"],
Cell[32280, 816, 4450, 91, 317, "Output",ExpressionUUID->"5c05bb5c-5877-4c54-81e2-b276a4e7f586"]
}, Open  ]],
Cell[36745, 910, 479, 7, 66, "Text",ExpressionUUID->"019954a0-39ed-4644-96d9-3a172af30813"],
Cell[CellGroupData[{
Cell[37249, 921, 3364, 95, 161, "Input",ExpressionUUID->"4c5155b3-6d75-42a9-bc3d-256f0cbb1ca9"],
Cell[40616, 1018, 2143, 51, 85, "Output",ExpressionUUID->"c01888fd-8cff-467a-aa76-2d6b1a4308cb"]
}, Open  ]],
Cell[42774, 1072, 500, 7, 66, "Text",ExpressionUUID->"ba7cd9bb-8b73-4dbd-8795-88850e8b704f"],
Cell[CellGroupData[{
Cell[43299, 1083, 1262, 27, 62, "Input",ExpressionUUID->"ef0c76c7-3c93-420a-9a91-46b477031482"],
Cell[44564, 1112, 1534, 29, 65, "Output",ExpressionUUID->"fc86c653-0bde-43b9-8207-0b01db2e6a0d"]
}, Open  ]],
Cell[46113, 1144, 903, 17, 66, "Text",ExpressionUUID->"8bdbaf79-1915-4e86-88b1-e5032bc6a27b"],
Cell[CellGroupData[{
Cell[47041, 1165, 975, 26, 62, "Input",ExpressionUUID->"9d6f5eb4-49ae-4ce0-97a7-9aa079a5c784"],
Cell[48019, 1193, 844, 17, 59, "Output",ExpressionUUID->"eb2f64b2-000c-4568-b97a-ad0da46cf99d"],
Cell[48866, 1212, 602, 9, 41, "Output",ExpressionUUID->"d25dfe89-fa43-4300-99be-5e5c5d824349"]
}, Open  ]],
Cell[49483, 1224, 1396, 30, 157, "Text",ExpressionUUID->"b1f864e5-2e58-4fb1-a2e7-73ad00de0b38"]
}, Open  ]],
Cell[CellGroupData[{
Cell[50916, 1259, 364, 6, 86, "Section",ExpressionUUID->"c60245b1-a839-41a9-a440-1bc15608cead"],
Cell[51283, 1267, 678, 9, 66, "Text",ExpressionUUID->"2ccf15e0-ef94-43b7-af43-d2725c415ac8"],
Cell[CellGroupData[{
Cell[51986, 1280, 2494, 56, 210, "Input",ExpressionUUID->"dac221b2-b089-47a5-90b4-f26f741d0445"],
Cell[54483, 1338, 1815, 41, 124, "Output",ExpressionUUID->"d651b482-6e87-42cd-a916-4437d2565f0b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[56335, 1384, 1618, 36, 62, "Input",ExpressionUUID->"cd85b9b7-d4e2-4a0b-9b01-0f1f49b4f941"],
Cell[57956, 1422, 1464, 30, 78, "Output",ExpressionUUID->"fe9152a4-0929-45ff-baf4-76f8c744916f"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[59469, 1458, 517, 8, 86, "Section",ExpressionUUID->"58e1628a-3e40-4129-bb88-60e58bed4b50"],
Cell[CellGroupData[{
Cell[60011, 1470, 693, 10, 70, "Subsection",ExpressionUUID->"2a5f48e2-80a2-4187-a48f-3379ddb21a40"],
Cell[60707, 1482, 1086, 20, 96, "Text",ExpressionUUID->"cf30df41-064e-4dc6-a6ef-a5c2e9db8dff"],
Cell[61796, 1504, 2219, 50, 111, "Input",ExpressionUUID->"0e944dc3-042b-4fae-bef3-a3eaeb040146"],
Cell[64018, 1556, 754, 10, 66, "Text",ExpressionUUID->"74265767-38ba-4d12-9479-8e47ce6c7fda"],
Cell[CellGroupData[{
Cell[64797, 1570, 504, 12, 36, "Input",ExpressionUUID->"9fffcc84-9a30-4573-b0fd-4fea1a049416"],
Cell[65304, 1584, 1000, 20, 57, "Output",ExpressionUUID->"54327e60-b121-439e-a13f-8357e2129708"]
}, Open  ]],
Cell[66319, 1607, 813, 13, 66, "Text",ExpressionUUID->"b48f44f5-aae1-4507-b855-d9a00601c1bd"],
Cell[CellGroupData[{
Cell[67157, 1624, 1979, 36, 87, "Input",ExpressionUUID->"0d4d0997-f8ed-40ef-930d-dc3cdef2040a"],
Cell[69139, 1662, 1666, 26, 59, "Output",ExpressionUUID->"a653fbe6-1b95-4e22-9b4a-7777d1457145"]
}, Open  ]],
Cell[70820, 1691, 930, 14, 66, "Text",ExpressionUUID->"15f9b616-2607-46ed-a1e6-4a20b3ee668d"],
Cell[71753, 1707, 2934, 66, 136, "Input",ExpressionUUID->"8aff2281-d13b-465f-8726-b5ee45b54fc3"],
Cell[CellGroupData[{
Cell[74712, 1777, 1265, 27, 87, "Input",ExpressionUUID->"0c7520db-ba7a-4065-adb3-270bf2ec36ca"],
Cell[75980, 1806, 1386, 22, 59, "Output",ExpressionUUID->"de7fe56a-514d-4f59-80b1-9919c995e426"]
}, Open  ]],
Cell[77381, 1831, 900, 12, 66, "Text",ExpressionUUID->"e6a8c3b9-9f66-41df-86ae-930abea3b922"],
Cell[CellGroupData[{
Cell[78306, 1847, 675, 12, 36, "Input",ExpressionUUID->"1f676e2b-1ce2-4997-9088-2ba5056a47dd"],
Cell[78984, 1861, 1335, 21, 41, "Output",ExpressionUUID->"8fe9599d-e734-41b7-8626-3f018a2b68b3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[80356, 1887, 471, 12, 36, "Input",ExpressionUUID->"f5bc03d3-62f8-495c-897c-123fb8e94f52"],
Cell[80830, 1901, 237, 4, 41, "Output",ExpressionUUID->"2b1b4947-c92c-4f3c-907c-778eafed9227"]
}, Open  ]],
Cell[81082, 1908, 952, 13, 66, "Text",ExpressionUUID->"74ed6e7b-72f1-451b-940b-041c78a34f9e"],
Cell[CellGroupData[{
Cell[82059, 1925, 3325, 87, 161, "Input",ExpressionUUID->"3e9b7554-8377-4379-b6af-af44ae6111d0"],
Cell[85387, 2014, 1488, 24, 41, "Output",ExpressionUUID->"cdcf333c-ee77-4518-bba0-3910e710b034"],
Cell[86878, 2040, 1409, 23, 56, "Output",ExpressionUUID->"291af7e2-81f4-4235-9932-e865e2096d51"]
}, Open  ]],
Cell[CellGroupData[{
Cell[88324, 2068, 526, 13, 36, "Input",ExpressionUUID->"fdb736bf-09b2-465a-9732-9cc4748f9f85"],
Cell[88853, 2083, 323, 6, 56, "Output",ExpressionUUID->"fdc638f4-b4f7-48e6-81b1-5fbf83d45fc7"]
}, Open  ]],
Cell[89191, 2092, 1052, 14, 66, "Text",ExpressionUUID->"cb50e266-ea45-4646-8d49-d7a4267e3211"],
Cell[CellGroupData[{
Cell[90268, 2110, 469, 9, 36, "Input",ExpressionUUID->"f3c2ae9f-ebff-458e-b5ac-e6031439164b"],
Cell[90740, 2121, 852, 13, 56, "Output",ExpressionUUID->"928a56d9-82f4-4b8d-9685-831952c8c729"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[91641, 2140, 742, 10, 70, "Subsection",ExpressionUUID->"fd7935cc-9ec2-475a-8cdb-fe1aec2f2d62"],
Cell[92386, 2152, 379, 6, 36, "Input",ExpressionUUID->"fd56e617-e9dd-4851-a52e-a0d5e300a245"],
Cell[92768, 2160, 1134, 17, 66, "Text",ExpressionUUID->"a5c7c6a4-7b25-4867-b9b5-93b01ce4ad4f"],
Cell[93905, 2179, 6450, 161, 359, "Input",ExpressionUUID->"181e7623-41f0-4117-8629-b1bb90706497"],
Cell[100358, 2342, 1155, 16, 66, "Text",ExpressionUUID->"48787fde-7db6-4c71-a77b-fd48e906ba26"],
Cell[CellGroupData[{
Cell[101538, 2362, 1827, 33, 62, "Input",ExpressionUUID->"fb5be6de-3b21-4566-9bd1-e570d3a296c4"],
Cell[103368, 2397, 1908, 29, 59, "Output",ExpressionUUID->"88f4bc19-099b-453d-87df-035cbdb949ae"]
}, Open  ]],
Cell[CellGroupData[{
Cell[105313, 2431, 1269, 25, 36, "Input",ExpressionUUID->"af66615d-e0b1-4e19-9e46-dd233dca91a9"],
Cell[106585, 2458, 1760, 28, 56, "Output",ExpressionUUID->"458df871-3607-494b-85c6-d2387d9da901"]
}, Open  ]],
Cell[CellGroupData[{
Cell[108382, 2491, 688, 17, 36, "Input",ExpressionUUID->"b386b64b-a48e-4b0c-9d4f-2a8c80f9f869"],
Cell[109073, 2510, 689, 13, 59, "Output",ExpressionUUID->"6e9a2115-b990-4c3c-9471-e3213d85fb9b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[109799, 2528, 862, 14, 36, "Input",ExpressionUUID->"2622e847-c6a4-496a-9053-128ca13285cb"],
Cell[110664, 2544, 1887, 30, 56, "Output",ExpressionUUID->"9dd2bafc-4191-45fd-85f2-d5935719ef9d"]
}, Open  ]],
Cell[112566, 2577, 1156, 16, 66, "Text",ExpressionUUID->"3de08dcd-55fc-43dd-8f95-9d005cd36de5"],
Cell[CellGroupData[{
Cell[113747, 2597, 760, 20, 62, "Input",ExpressionUUID->"3f884dd8-2cb9-4e52-b9c7-3bb237c5bfff"],
Cell[114510, 2619, 368, 8, 56, "Output",ExpressionUUID->"17701492-c9d6-4ea1-afea-ba171341d9b3"]
}, Open  ]],
Cell[114893, 2630, 1172, 16, 66, "Text",ExpressionUUID->"302b6163-48b8-4b2d-8c06-667c2b538aa1"],
Cell[CellGroupData[{
Cell[116090, 2650, 6217, 150, 285, "Input",ExpressionUUID->"fa0398f2-2c8e-4eaf-ab5c-c3f5f1acf7dc"],
Cell[122310, 2802, 864, 16, 59, "Output",ExpressionUUID->"7ebe99ce-6a6c-4cae-9cab-f178e6e23afb"]
}, Open  ]],
Cell[123189, 2821, 1202, 16, 66, "Text",ExpressionUUID->"3a35ef88-ea1d-4605-b80e-1f9d3b6b0b17"],
Cell[CellGroupData[{
Cell[124416, 2841, 662, 16, 36, "Input",ExpressionUUID->"87dc2fd1-e28e-46e7-9fd5-d0bcdc9bda2f"],
Cell[125081, 2859, 450, 8, 56, "Output",ExpressionUUID->"15ab1a34-c066-426a-b13f-4d124b340ec7"]
}, Open  ]],
Cell[125546, 2870, 1215, 16, 66, "Text",ExpressionUUID->"e33ceec3-a95c-43b1-bdac-d7ec2e2eb181"],
Cell[CellGroupData[{
Cell[126786, 2890, 672, 18, 36, "Input",ExpressionUUID->"c9aa4d49-0fcb-4861-af39-b6c7b4a2b67d"],
Cell[127461, 2910, 529, 11, 59, "Output",ExpressionUUID->"7b79858c-07aa-4184-98d9-de4a08331b88"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

