%This short code plots the Shapley value as a function of Delta
%Delta captures the multiplier by which the payoff of the grand coalition
%blows up if and when all countries join
%The Shapley value (y) needs to calculated separately as per TUGLab. The
%input value (x) is Delta.

%Example below: Russia (assuming that Russia is smallest player)

x = [1, 1.1, 1.5, 2, 3, 10];
y = [1.5, 1.75, 2.75, 4, 6.5, 24];

scatter(x,y,'k')

% fit y to a third order polynomial
p=polyfit(x,y,3);
% Calculate Y values of fit line
fitY = polyval(p,x);
hold on
plot(x,fitY)

hline = refline([1 0]);
hline.Color = 'k';
hline.LineStyle = ':';
hline.HandleVisibility = 'off';

grid on
hold off
