function coreset(A)
%  CORESET Draws the core of a balanced TU game.
% 
%  INPUT
% 
%  For $3$ players the characteristic function must be introduced with vector
%  A=[v{1} v{2} v{3} v{12} v{13} v{23} v{123}].
%  For $4$ players the characteristic function must be introduced with vector
%  A=[v{1} v{2} v{3} v{4} v{12} v{13} v{14} v{23} v{24} v{34} v{123} v{124} v{134}
%  v{234} v{1234}].
% 
%  OUTPUT
% 
%  It displays the core of the game defined by A.
% 
%  COMMENTS
% 
%  The core consists of all the stable imputations, that is,
%  $$
%  C(v)=\{x\in I(v) : x(S)=\sum_{i\in S} x_i\geq v(S), \forall S\subset N\}.
%  $$
%  The core allocations provide the agents with an incentive to maintain the grand coalition.
%  The core can be empty.
% 
%  EXAMPLE
% 
% A=[0 0 0 0 1 2 1 1 1 1 4 3 2 1 7];
% imputationset(A),hold on,axis(axis)
% coreset(A)
% 
% See also COREVERTICES, COREINFO, BALANCEDGAME, TOTALBALANCEDGAME,
% BELONGTOCORE.
%
% NOTE
% This file is part of the TUGlab project: a Matlab base program for the
% teaching of transferable utility (TU) games theory.
%
% AUTHORS
% Miguel Angel Miras calvo (mmiras@uvigo.es). Department of Mathematics.
% University of Vigo
% Estela Sanchez Rodriguez (esanchez@uvigo.es). Department of Statistics
% and Operations Research. University of Vigo
% July, 2005
%


    tamanho=size(A);
    if tamanho==[1 7]
    jugadores=3;
    coreset3(A);
    elseif tamanho==[1 15]
    jugadores=4;
    coreset4(A);
    else
    error('Argument must be a vector of dimension 1x7 (3 players) or 1x15 (4 players)')
    end    
    
function coreset3(A)
%CORESET3 Draws the core of  a balanced TU game.
v1=A(1);v2=A(2);v3=A(3);
v123=A(7);


[Cextremes,hiperplanos,faces,numpuntos,numplanos,planosactivos,puntosxplano,MPC]=coreinfo(A);%los vertices del core
M=CCimputation3(A);%la matriz de proyeccion en el triangulo equilatero

switch numpuntos
    case 0
        warning('The core is empty')
        return
    case 1
        vertices=M*Cextremes';
plot(vertices(1),vertices(2),'*','Color',[0.5 0.5 0.5])
    case 2
vertices=M*Cextremes';
plot(vertices(1,:),vertices(2,:),'-*','Color',[0.5 0.5 0.5])
    otherwise
%los vertices en el equilatero de R2.
vertices=M*Cextremes';
% ordenamos los vertices para el dibujo de la poligonal
vertices=poligonorder(vertices')'; 
color=[0.5 0.5 0.5];
fill(vertices(1,:),vertices(2,:),color)
end
%
%
function coreset4(A)
%CORESET4 Draws the core of  a balanced TU game.

v1=A(1);v2=A(2);v3=A(3);v4=A(4);
v12=A(5);v13=A(6);v14=A(7);v23=A(8);v24=A(9);v34=A(10);
v123=A(11);v124=A(12);v134=A(13);v234=A(14);
v1234=A(15);


%llamamos a la funcion coreinfo
[Cextremes,hiperplanos,faces,numpuntos,numplanos,planosactivos,puntosxplano,MPC]=coreinfo(A);%los vertices del core

switch numpuntos
    case 0
        warning('The core is empty')
        return
    case 1
plot3(Cextremes(1),Cextremes(2),Cextremes(3),'*','Color',[0.5 0.5 0.5])
    case 2
plot3(Cextremes(:,1)',Cextremes(:,2)',Cextremes(:,3),'-*','Color',[0.5 0.5 0.5])
    otherwise
vertices=Cextremes(:,1:3);%quitamos la ultima componente
%definimos la matriz de colores de los vertices
tonos=[];
for ii=1:numpuntos
tonos(ii,:)=[0.5 0.5 0.5];    
end
patch('Vertices', vertices, 'Faces', faces,...
'FaceVertexCData',tonos,'FaceColor','flat','FaceAlpha',0.5)
camlight; 
lighting gouraud; 
hold off
end