# Starting and loading packages 
rm(list = ls())
pacman::p_load(pacman, party, rio, tidyverse, ggplot2)

# PLEASE NOTE THAT PLOTTING DOESNT SEEM TO BE WORKING WITH THE NEWEST VERSION OF HIVER -- GO BACK TO OLD VERSION!

#This command didn't really work:
# packageurl <- "https://cran.r-project.org/src/contrib/Archive/HiveR/HiveR_0.2-27.tar.gz"
# install.packages(packageurl, repos=NULL, type="source")

# This works: 
# require(devtools)
# install_version("HiveR", version = "0.2.55", repos = "http://cran.us.r-project.org")


 #load the packages
library(readr)
library("igraph")
library("plyr")
library("HiveR")
library("RColorBrewer")

?HiveR


#read the CN file that lists domestic patent citations only
# The first read didn't work, hence the repeated output of the csv file from OpenRefine and the funny file name.
# Important to leave as is or it won't work. 
library(readr)
dataSet <- read.csv("data/USA/USPatentDataEdgeListFINAL2-csv-csv.csv")
# dataSet <- as.character(dataSet)

############################################################################################
# Create a graph. Use simplify to ensure that there are no duplicated edges or self loops
gD <- simplify(graph.data.frame(dataSet, directed=TRUE))

# Take a look at the edge list
E(gD)

# Extend the dataset to include column names as variables
dataSet.ext <- ddply(dataSet, .variables=c("Publication", "citesPatent", "Region"))


############################################################################################
# Now the new (HiveR) part

# Create a hive plot from the data frame
hive1 <- edge2HPD(edge_df = dataSet.ext)
sumHPD(hive1)
warnings()



# Assign nodes to a radius based on their degree (number of edges they are touching)
hive2 <- mineHPD(hive1, option = "rad <- tot.edge.count")
sumHPD(hive2)

# Assign nodes to axes based on their position in the edge list 
# (this function assumes direct graphs, so it considers the first column to be a source and 
# second column to be a sink )
hive3 <- mineHPD(hive2, option = "axis <- source.man.sink")
sumHPD(hive3)

# Change edge colour
hive3$edges$color <- ifelse(dataSet.ext$Region == "Domestic", "green","red")


# Removing zero edges for better visualization 
hive4 <- mineHPD(hive3, option = "remove zero edge")
sumHPD(hive4)


hive4$edges$weight <- 0.5


# And finally, plotting our graph

plotHive(hive4, dr.nodes = FALSE, ch = 1,
         axLabs = c("USA: Source", "Hub", "Sink"),
         method = "abs",
         # action =  c(2, 2, 2),
         axLab.pos = 1,
         bkgn = "white",
         axLab.gpar = gpar(fontsize = 10, col = "black", lwd = 5),
         arrow = c("degree", 150, 100, 180, 70), np = FALSE)
# grid.text("native units", x = 0.5, y = 0.05, default.units = "npc", gp = gpar(fontsize = 10, col = "black"))


