clear all


set(0,'defaultlinelinewidth',2 ... 
    ,'defaulttextfontsize',24 ... %16
    ,'defaultaxesfontsize',24, ...%16
    'defaulttextfontname','CMU Serif' ...% 'CMU Serif' ...
    ,'defaultaxesfontname','CMU Serif' ...% 'CMU Serif' ...
    )
posx = 50;
posy = 50;
width = 1600;
height = 900;

current = 13.8:0.1:16;
power = [0.0307, 0.246, 0.67, 1.02, 1.55, 1.44, 2.14, 3.44, 4.55, 4.97, 5.25, 5.56, 6.49, 7.27, 7.31, 8.35, 8.93, 8.73, 9.08, 10.12, 9.82, 10.29, 10.51];

Ppower(:,:) = 0.5951 * current(:,:)  - 5.585;

files = dir("*.CSV");

for i = 1 : 21;
    
   CurrentFile = files(i).name; 
  
   data = readmatrix(CurrentFile, "HeaderLines", 34);
   wl = ( data( :,1));
   spectrum = ( data (:,2));
   

currentI = Ppower(i+2)+zeros(3001,1);

CurrentI(:,i) = currentI(:,1);
WL(:,i) = wl(:,1);
Spectrum(:,i) = spectrum(:,1);


end

figure()
surf(CurrentI,WL,Spectrum,'EdgeColor', 'none');
colormap plasma
caxis([-80, -40]);
ylim([998, 1010]);
xlim([2.5, 3.937])
view(90,-90);


figure(99)
subplot(2,3,3)
surf(CurrentI,WL,Spectrum,'EdgeColor', 'none');
colormap plasma
caxis([-80, -40]);
ylim([998, 1010]);
xlim([2.5, 3.937])
view(90,-90);
ylabel("Wavelength [nm]")
title("30 \mum")


