clear all

set(0,'defaultlinelinewidth',2 ... 
    ,'defaulttextfontsize',24 ... %16
    ,'defaultaxesfontsize',24, ...%16
    'defaulttextfontname','CMU Serif' ...% 'CMU Serif' ...
    ,'defaultaxesfontname','CMU Serif' ...% 'CMU Serif' ...
    )

posx = 50;
posy = 50;
width = 1600;
height = 900;

current = 13.6:0.1:16;
power = [0.0295, 0.0301, 0.184, 0.355, 0.611, 1.1, 1.32, 1.56, 1.72, 2.26, 3.1, 3.35, 2.67, 3.15, 3.8, 4.32, 4.54, 4.87, 5.2, 5.59, 5.9, 5.54, 6.09, 6.32, 6.77];

Ppower(:,:) = 0.5951 * current(:,:)  - 5.585;

files = dir("*.CSV");

for i = 1 : 23;
    
   CurrentFile = files(i).name; 
   
   data = readmatrix(CurrentFile, "HeaderLines", 34);
   wl = ( data( :,1));
   spectrum = ( data (:,2));
  

currentI = Ppower(i+2)+zeros(3001,1);


CurrentI(:,i) = currentI(:,1);
WL(:,i) = wl(:,1);
Spectrum(:,i) = spectrum(:,1);

end

figure()
surf(CurrentI,WL,Spectrum,'EdgeColor', 'none');
colormap plasma
caxis([-80, -40]);
ylim([998, 1010]);
xlim([2.5, 3.937])
view(90,-90);

figure(99)
subplot(2,3,4)
surf(CurrentI,WL,Spectrum,'EdgeColor', 'none');
colormap plasma
caxis([-80, -40]);
ylim([998, 1010]);
xlim([2.5, 3.937])
view(90,-90);
ylabel("Wavelength [nm]")
xlabel("Pump power [W]")
title("40 \mum")

