clear all
close all

set(0,'defaultlinelinewidth',1.5 ... 
    ,'defaulttextfontsize',30 ... %16
    ,'defaultaxesfontsize',30, ...%16
    'defaulttextfontname','CMU Serif'...% 'CMU Serif' ...
    ,'defaultaxesfontname','CMU Serif' ...% 'CMU Serif' ...
    )

posx = 50;
posy = 50;
width = 1100;
height = 900;


current = [11, 11.5, 12, 12.1, 12.2, 12.3, 12.4 , 12.5, 13 , 13.5, 14, 14.5 ,15 ,15.5, 16, 16.5];

Ppower(:,:) = 0.5951 * current(:,:)  - 5.585;

power = [33.5e-6, 43.4e-6, 53.7e-6, 55.4e-6, 57.5e-6, 1.274e-3 , 4.723e-3, 10.05e-3, 28.79e-3, 49.27e-3, 76.67e-3, 107.1e-3, 134.2e-3, 153.3e-3, 181.2e-3, 209.7e-3];

p1 = 0.08428;
p2 = -0.1505;

fcurrent = 11:0.1:16.5;
for i = 1:length(fcurrent)
    fpump(i) = 0.5951 * fcurrent(i)  - 5.585;
    fpower(i) = p1*fpump(i) + p2;
end
figure()
hold on
plot(Ppower, power, '.', 'MarkerSize',20)
plot(fpump,fpower);
hold off
ylim([0 0.25])
ylabel("MECSEL Power [W]")
xlabel("Pump Power [W]")
set(gcf,'units','pixels','position',[posx,posy,width,height])



posx = 50;
posy = 50;
width = 600;
height = 900;

data = readmatrix("W0023.csv", "HeaderLines", 34);
wl = ( data( :,1));
spectrum = ( data (:,2));

figure()
plot(wl,spectrum);
xlim([1005 1007.5]);
ylim([-80 -30]);
ylabel("Intensity [dBm]")
xlabel("Wavelength [nm]")
set(gcf,'units','pixels','position',[posx,posy,width,height])


