clear all


set(0,'defaultlinelinewidth',2 ... 
    ,'defaulttextfontsize',24 ... %16
    ,'defaultaxesfontsize',24, ...%16
    'defaulttextfontname','CMU Serif' ...% 'CMU Serif' ...
    ,'defaultaxesfontname','CMU Serif' ...% 'CMU Serif' ...
    )
current = 13.5:0.1:16;
power = [0.0287, 0.0293, 0.0299, 0.52, 0.93, 1.35, 2.06, 3.38, 4.86, 5.26, 6.97, 7.33, 8.67, 8.71, 9.51, 10.8, 11.3, 12.1, 12.8, 14.0, 14.6, 14.7, 15.7, 16.1, 16.1, 17.4];

Ppower(:,:) = 0.5951 * current(:,:)  - 5.585;

files = dir("*.CSV");

for i = 1 : 24;
    
   CurrentFile = files(i).name; 
   
   data = readmatrix(CurrentFile, "HeaderLines", 34);
   wl = ( data( :,1));
   spectrum = ( data (:,2));
   

currentI = Ppower(i+2)+zeros(2501,1);



CurrentI(:,i) = currentI(:,1);
WL(:,i) = wl(:,1);
Spectrum(:,i) = spectrum(:,1);


end


figure()
surf(CurrentI,WL,Spectrum,'EdgeColor', 'none');
colormap plasma
caxis([-80, -40]);
ylim([998, 1010]);
xlim([2.5, 3.937])
view(90,-90);


figure(99)
subplot(2,3,1)
surf(CurrentI,WL,Spectrum,'EdgeColor', 'none');
colormap plasma
caxis([-80, -40]);
ylim([998, 1010]);
xlim([2.5, 3.937])
view(90,-90);
ylabel("Wavelength [nm]")
xlabel("Pump power [W]")
title("10 \mum")


