clear all
% close all

set(0,'defaultlinelinewidth',2 ... 
    ,'defaulttextfontsize',24 ... %16
    ,'defaultaxesfontsize',24, ...%16
    'defaulttextfontname','CMU Serif' ...% 'CMU Serif' ...
    ,'defaultaxesfontname','CMU Serif' ...% 'CMU Serif' ...
    )

posx = 50;
posy = 50;
width = 1600;
height = 900;

current = 13.3:0.1:16;
power = [0.0277, 0.235, 0.842, 1.75, 2.73, 3.43, 4.66, 4.75, 5.63, 5.54, 6.75, 7.58, 8.01, 8.64, 8.91, 10.3, 11.3 ,11.7, 11.7, 12.4, 13.1, 13.8, 14.4, 16.1, 15.8, 15.9, 17, 18];

Ppower(:,:) = 0.5951 * current(:,:)  - 5.585;

files = dir("*.CSV");

for i = 1 : 27;
    
   CurrentFile = files(i).name; 
   
   data = readmatrix(CurrentFile, "HeaderLines", 34);
   wl = ( data( :,1));
   spectrum = ( data (:,2));
   
currentI = Ppower(i+1)+zeros(3001,1);

CurrentI(:,i) = currentI(:,1);
WL(:,i) = wl(:,1);
Spectrum(:,i) = spectrum(:,1);


end

figure()
surf(CurrentI,WL,Spectrum,'EdgeColor', 'none');
colormap plasma
caxis([-80, -40]);
ylim([998, 1010]);
xlim([2.5, 3.937])
view(90,-90);


figure(99)
subplot(2,3,2)
surf(CurrentI,WL,Spectrum,'EdgeColor', 'none');
colormap plasma
caxis([-80, -40]);
ylim([998, 1010]);
xlim([2.5, 3.937])
view(90,-90);
ylabel("Wavelength [nm]")
title("20 \mum")

