clear all


set(0,'defaultlinelinewidth',2 ... 
    ,'defaulttextfontsize',24 ... %16
    ,'defaultaxesfontsize',24, ...%16
    'defaulttextfontname','CMU Serif' ...% 'CMU Serif' ...
    ,'defaultaxesfontname','CMU Serif' ...% 'CMU Serif' ...
    )

posx = 50;
posy = 50;
width = 1600;
height = 900;

current = 12.4:0.1:16;

Ppower(:,:) = 0.5951 * current(:,:)  - 5.585;

files = dir("*.CSV");

for i = 1 : 36;
    
   CurrentFile = files(i).name; 
   
   data = readmatrix(CurrentFile, "HeaderLines", 34);
   wl = ( data( :,1));
   spectrum = ( data (:,2));
   

currentI = Ppower(i+1)+zeros(3001,1);


CurrentI(:,i) = currentI(:,1);
WL(:,i) = wl(:,1);
Spectrum(:,i) = spectrum(:,1);

end

figure(99)
subplot(2,3,6)
surf(CurrentI,WL,Spectrum,'EdgeColor', 'none');
colormap plasma
caxis([-80, -40]);
ylim([998, 1010]);
xlim([2.5, 3.937])
view(90,-90);
ylabel("Wavelength [nm]")
title("Unmasked")


figure()
surf(CurrentI,WL,Spectrum,'EdgeColor', 'none');
colormap plasma
caxis([-80, -40]);
ylim([998, 1010]);
xlim([2.5, 3.937])
view(90,-90);
ylabel("Wavelength [nm]")
title("Unmasked")


