clear all
close all 


set(0,'defaultlinelinewidth',3 ... 
    ,'defaulttextfontsize',30 ... %16
    ,'defaultaxesfontsize',30, ...%16
    'defaulttextfontname','CMU Serif'...% 'CMU Serif' ...
    ,'defaultaxesfontname','CMU Serif' ...% 'CMU Serif' ...
    )

c = physconst("LightSpeed");

posx = 50;
posy = 50;
width = 1600;
height = 900;

x = linspace (995e-9, 1015e-9, 100000);
f = c ./ x;

L = 350.035e-6;

fsr_F = c / ( 2 *2.59 * L);
tau_F = 1/fsr_F;

D = zeros(1,100000);

phi = pi  * tau_F .* f;

A_up = (1-0.196)*(1-0.021);
A_down = (1 - sqrt(0.196*0.021)^2) + 4 * sqrt(0.196*0.021).*sin(phi).^2;

A = A_up ./ A_down;

plot(f,A);

wl = flip( c./f,2) *1e9;

A = A .* 100;

figure(1)
plot(wl,A)

max = max(A);
min = min(A);

Ratio = min/max;
loss = 1-Ratio

figure(1)
yyaxis left
yline(max-5.1, '--', 'linewidth', 3.5, 'fontsize', 24, 'fontname','CMU Serif')
xlim([1000 1005])
xticks([1000, 1001, 1002, 1003, 1004, 1005])
ylabel("Transmission [%]")
xlabel("Wavelength [nm]")
set(gca,'YColor', [0, 0.45, 0.74])
set(gcf,'units','pixels','position',[posx,posy,width,height])

files = dir("*.CSV");

for i = 1 : 24;
    
   CurrentFile = files(i).name; 
   
   data = readmatrix(CurrentFile, "HeaderLines", 34);
   wl = ( data( :,1));
   spectrum = ( data (:,2));
  

figure(1)
yyaxis right
hold on
ylim([-80 0])
plot(wl, spectrum, '-')
ylabel("Intensity [dBm]")


end
