clear all
close all

set(0,'defaultlinelinewidth',2 ... 
    ,'defaulttextfontsize',24 ... %16
    ,'defaultaxesfontsize',24, ...%16
    'defaulttextfontname','CMU Serif' ...% 'CMU Serif' ...
    ,'defaultaxesfontname','CMU Serif' ...% 'CMU Serif' ...
    )
posx = 50;
posy = 50;
width = 1400;
height = 700;

current = 13.3:0.1:16;
Ppower(:,:) = 0.5951 * current(:,:)  - 5.585;

data = readmatrix("W0027.csv", "HeaderLines", 34);
wl = ( data( :,1));
spectrum = ( data (:,2));

figure()
plot(wl,spectrum)
ylim([-75, -30])
xlabel('Wavelength [nm]')
ylabel('Power [dBm]')
xlim([1000 1010])

set(gcf,'units','pixels','position',[posx,posy,width,height])