close all
clear all

set(0,'defaultlinelinewidth',2 ... 
    ,'defaulttextfontsize',24 ... %16
    ,'defaultaxesfontsize',24, ...%16
    'defaulttextfontname','CMU Serif' ... %'Times New Roman' ... 
    ,'defaultaxesfontname','CMU Serif'... %'Times New Roman' ...
    )

posx = 50;
posy = 50;
width = 1400;
height = 800;


File = 'Averaged_Blocked.csv';

T = readtable(File, 'HeaderLines',45);

BlockedF = table2array(T(:,1)) ./1e9;
BlockedI = table2array( T(:,2));


File = 'Averaged_Unblocked.csv';

T = readtable(File, 'HeaderLines',45);

UnblockedF = table2array(T(:,1))./1e9;
UnblockedI = table2array( T(:,2));

ResidualI = UnblockedI - BlockedI;

figure()
subplot(3,1,[ 1,2])
hold on
box on
plot(BlockedF,BlockedI)
plot(UnblockedF,UnblockedI)
xline(2.03,'k--' , "Cavity FSR", 'linewidth', 2, 'fontsize', 24, 'fontname','CMU Serif');
hold off
set(gca, 'Xticklabel',[]);
ylabel("Power [dBm]")
ylim([-86 -70])
legend(["Background" , "Signal"])
set(gcf,'units','pixels','position',[posx,posy,width,height])
subplot(3,1,3)
hold on 
box on
plot(BlockedF,ResidualI)
xline(2.03,'k--', 'linewidth', 2)
hold off
ylim([-4 4])
yticks([-4 -2 0 2 4])
set(gca, 'Position', [0.13, 0.12, 0.775, 0.26]);
xlabel("Frequency [GHz]")
ylabel("Power [dBm]")
