function [uplus, yplus] = profile(y, utau, kappa, s, delta, PI, nu)

delta_plus  = delta*utau/nu/1000;
yplus       = y*utau/nu/1000;
eta         = y/delta;
yp_musk     = [0,logspace(log10(0.001),log10(yplus(end)),10^6-1)];

% profile buffer layer
% Musker 1979
dudy        = (yp_musk.^2/kappa + 1/s)./(yp_musk.^3 + yp_musk.^2/kappa + 1/s);
u_musk      = cumtrapz(yp_musk, dudy);
u0_musk     = interp1(yp_musk, u_musk, delta_plus);
u_musk      = interp1(yp_musk, u_musk, yplus);


% bump function
% Nagib & Chauhan (2008)
M1          = 30;
M2          = 2.85;
u_bump      = exp(-log(yp_musk/M1).^2)/M2;
u0_bump     = interp1(yp_musk, u_bump, delta_plus);
u_bump      = interp1(yp_musk, u_bump, yplus);

% wake function
w           = wake_exp(eta,PI);
w0          = wake_exp(1,PI);

% obtain composite velocity profile
I           = find(eta<1,1,'last'); % truncate eta
uplus       = u_musk(1:I) + u_bump(1:I) + 2*PI/kappa*w(1:I);
uplus       = [uplus, (u0_musk + u0_bump + 2*PI/kappa*w0)*ones(1,length(y)-I)];