function [axa,txt] = setSubFigTitle(ax,loc)
%put subfigure title: (a), (b), ...
%input:
%ax = all axes
%loc = location, 'topcenter' or 'topleft' (default: 'topcenter')

fontsize = ax{1}.FontSize; %follows parent axes' font size
alphabet = ['a' 'b' 'c' 'd' 'e' 'f' 'g' 'h' 'i' 'j' 'k' 'l' 'm',...
    'n' 'o' 'p' 'q' 'r' 's' 't' 'u' 'v' 'w' 'x' 'y' 'z'];
for i = 1:size(ax,2)
    pos = ax{i}.Position;
%     d = ax{i}.OuterPosition; d = d(1);
%     axa{i} = axes('Position',[d pos(2)+pos(4) 1 1],'Visible','off');
%     d = 1;
%     axa{i} = axes('Position',[pos(1)-d pos(2)+pos(4)+d/4 1 1],'Visible','off');

    if nargin == 1 || strcmpi(loc,'topcenter')% default: top center
        axa{i} = axes('Position',[pos(1)+0.5*pos(3) pos(2)+pos(4) 1 1],'Visible','off');
        txt{i} = text(0,0,['(',alphabet(i),')'],...
        'HorizontalAlignment','center','VerticalAlignment','bottom','Margin',0.1,'FontSize',fontsize);
    elseif strcmpi(loc,'topleft')
        axa{i} = axes('Position',[pos(1) pos(2)+pos(4) 1 1],'Visible','off');
        txt{i} = text(0,0,['(',alphabet(i),')'],...
        'HorizontalAlignment','left','VerticalAlignment','bottom','Margin',0.1,'FontSize',fontsize);
    end
    
end
end

