function [yplus,uplus,S] = wake_jones(kappa, B, PI, delta_plus)
%Based on the wake function of Jones, et al (2001)
%To be used with the algorithm to find C_f vs Re_x (Monty, et al, 2016)

yplus = (0:delta_plus)';
eta = yplus./delta_plus;

uplus = 1/kappa.*log(yplus) + B ...
    - 1/(3*kappa).*eta.^3 + 2*PI/kappa.*eta.^2.*(3-2*eta);

uplus(1) = 0; %force wall to zero

S = 1/kappa.*log(delta_plus) + B ...
    - 1/(3*kappa) + 2*PI/kappa;
end

