function w  =wake_exp(eta,PI)
% Chauhan, K. A., Monkewitz, P. A., & Nagib, H. M. (2009). Criteria for 
% assessing experiments in zero pressure gradient boundary layers. 
% Fluid Dynamics Research, 41(2), 021404.
a2          = 132.8410;
a3          = -166.2041;
a4          = 71.9114;

aux1        =-(1/4)*(5*a2+6*a3+7*a4).*(eta.^4) + ...
    a2*(eta.^5) + ...
    a3*(eta.^6) + ...
    a4*(eta.^7);
aux2        = -(1/4)*(a2+2*a3+3*a4);
w           = ((1 - exp(aux1))./(1-exp(aux2))).*(1-log(eta)/2/PI);