%%% function for generating the MZI spectrum
% Created by: Callum Stirling, University of Southampton, UK
% Date: 2021-04-22

function [Po1c, Po2c] = MZI(lambda,F)
Delta_L = 20e3; % length difference of the arms in nm
linewidth = 0.7; % in cm-1
n_g = 4.2125; % group index
% vars for converting polynomial to MMI output
A = 0.1;
B = 0.5;
C = pi/15;

% convert wavelength to unitless variable for polynomial
dWL = max(lambda)-min(lambda);
WLc = lambda(round(length(lambda)/2));
auxlambda = (lambda-WLc)./(dWL);
% propagaton constant
beta = 2*pi*n_g./lambda;
% wavenumber
waveno = 1e7./lambda;

% excitation
Ei1 = 1; % amplitde in input 1
Ei2 = 0; % amplitude in input 2
% ideal MMI parameters
phi0 = pi/2; % phase shift between outputs (radians)
a0 = 1/sqrt(2); % cross amplitude coefficient
b0 = 1/sqrt(2); % bar amplitude coefficient

%% calculate shape for performance
N = length(F);
F = reshape(F,3,N/3);
pa = F(1,1:N/3);
pb = F(2,1:N/3);
pc = F(3,1:N/3);
shapeA = polyval(pa,auxlambda);
shapeB = polyval(pb,auxlambda);
shapeC = polyval(pc,auxlambda);

% convert to performance
phi = phi0 + C*shapeC;
a = a0 + A*shapeA;
b = b0 + B*shapeB;

%% laser linewidth

centre = waveno(round(length(waveno)/2));
spec = lorentz(waveno,centre,linewidth);

%% calculate outputs
% MZI output
Po1 = abs((a.^2 .* exp(Delta_L*(1i*beta)) + b.^2 .* exp(1i*2*phi)).*Ei1 + (a.*b.*exp(1i*phi).*(1+exp(Delta_L*(1i*beta)))).*Ei2).^2;
Po2 = abs( (a.*b.*exp(1i*phi).*(1+exp(Delta_L*(1i.*beta))).*Ei1 + (b.^2 .* exp(1i*2*phi).*exp(Delta_L*(1i*beta))+ a.^2).*Ei2)).^2;

% convolute with Lorentzian
Po1c = conv(Po1,spec,'same');
m1 = max(Po1)/max(Po1c);
Po1c = 10*log10(Po1c.*m1);

Po2c = conv(Po2,spec,'same');
m2 = max(Po2)/max(Po2c);
Po2c = 10*log10(Po2c.*m2);
end
