#! /usr/bin/env Rscript

colours = c( "#0000FF", "#FF0000", "#00FF00" );

cairo_pdf( "graphs/tissue_params.pdf", onefile = TRUE,
	width = 6, height = 5 );

#plot( c( 0, 1 ), c( 0, 1 ),
	#type = "n", axes = FALSE,
	#xlab = "", ylab = "", main = "Padding" );

par( mar = c( 3, 3, 2, 0 ) + 0.3, cex = 0.5, mgp = c( 2, 1, 0 ) );

layout( matrix( c( 1, 3, 2, 4, 5, 5 ), 2, 3 ),
	width = c( 3, 3, 1 ), TRUE );

params <- read.csv( "data/tissue_params.csv", header = TRUE );

plot( params$distance + ( params$mass - 100 ) / 20, params$Rs,
	type = "p", log = "",
	ylim = c( 0, 200 ),
	#ylim = c( 20, 2e3 ),
	main = "Series Resistance", 
	xlab = "Distance / mm + ( Mass / g - 100 ) / 20", 
	ylab = "Resistance / Ω", 
	pch = params$mass / 50,
	col = sapply( params$dampness, function( d ) {
		if ( d == "w" ) "#007293" else "#BA000A"; } ) );
#legend( x = "bottomleft",
	#col = c( "#000000", "#000000", "#000000", "#007298", "#BA000A" ),
	#pch = c( 1, 2, 3, 19, 19 ),
	#legend = c( "50g", "100g", "150g", "Wet", "Dry" ) );

plot( params$distance + ( params$mass - 100 ) / 20, params$Rp,
	type = "p", log = "y",
	ylim = c( 5e4, 5e7 ),
	main = "Parallel Resistance", 
	xlab = "Distance / mm + ( Mass / g - 100 ) / 20", 
	ylab = "Resistance / Ω", 
	pch = params$mass / 50,
	col = sapply( params$dampness, function( d ) {
		if ( d == "w" ) "#007293" else "#BA000A"; } ) );
#legend( x = "topright",
#	col = c( "#000000", "#000000", "#000000", "#007298", "#BA000A" ),
#	pch = c( 1, 2, 3, 19, 19 ),
#	legend = c( "50g", "100g", "150g", "Wet", "Dry" ) );

plot( params$distance + ( params$mass - 100 ) / 20, params$Cp,
	type = "p", log = "y",
	ylim = c( 1e-11, 5e-8 ),
	main = "Parallel Capacitance", 
	xlab = "Distance / mm + ( Mass / g - 100 ) / 20", 
	ylab = "Capacitance / F", 
	pch = params$mass / 50,
	col = sapply( params$dampness, function( d ) {
		if ( d == "w" ) "#007293" else "#BA000A"; } ) );
#legend( x = "topleft",
#	col = c( "#000000", "#000000", "#000000", "#007298", "#BA000A" ),
#	pch = c( 1, 2, 3, 19, 19 ),
#	legend = c( "50g", "100g", "150g", "Wet", "Dry" ) );

plot( params$distance + ( params$mass - 100 ) / 20, params$alpha,
	type = "p", 
	ylim = c( 0, 0.4 ),
	main = "Parallel Capacitance Alpha", 
	xlab = "Distance / mm + ( Mass / g - 100 ) / 20", 
	ylab = "Alpha", 
	pch = params$mass / 50,
	col = sapply( params$dampness, function( d ) {
		if ( d == "w" ) "#007293" else "#BA000A"; } ) );

par( mar = c( 0, 0, 0, 0 ) );
plot( c( 0, 1 ), c( 0, 1 ),
	axes = FALSE, xlab = "", ylab = "", type = "n" );
legend( x = "center",
	col = c( "#000000", "#000000", "#000000", "#007298", "#BA000A" ),
	pch = c( 1, 2, 3, 19, 19 ),
	legend = c( "50g", "100g", "150g", "Wet", "Dry" ) );
