#!/usr/bin/env Rscript

colours <- c( "#007293", "#8A0065", "#00811C", "#c3b200" );

data <- read.csv( "data/comsol_wobble.csv", header = FALSE );
colnames( data ) <- c( "w", "freq", "imp" );

cairo_pdf( "graphs/comsol_wobble.pdf", width = 3, height = 3 );
par( xaxs = "i", bty = "l", cex = 0.5, mgp = c( 2, 1, 0 ) );

layout( matrix( c( 1, 2 ), 2, 1 ), TRUE );

par( mar = c( 0, 3, 3, 1 ) + 0.3, cex = 0.5 );

plot( data$freq, Mod( data$imp ),
	type = "n", log = "xy", axes = FALSE,
	xlab = "", ylab = "Impedance / Ω",
	main = "Impedance with Uneven Layer Boundaries" );

for ( i in seq( 4, 1 ) ) {

	w = i / 4 - 0.25;

	lines( data$freq[data$w == w], Mod( data$imp[data$w == w] ),
		col = colours[i] );

}

box();
axis( side = 2 );

legend( x = "topright", lty = "solid", col = colours,
	title = "Deviation size",
	legend = c( "0%", "25%", "50%", "75%" ) );

par( mar = c( 4, 3, 0, 1 ) + 0.3 );

plot( data$freq, Arg( data$imp ) * 180 / pi, 
	type = "n", log = "x",
	xlab = "Frequency / Hz", ylab = "Phase / °" );

for ( i in seq( 4, 1 ) ) {

	w = i / 4 - 0.25;

	lines( data$freq[data$w == w],
		Arg( data$imp[data$w == w] ) * 180 / pi,
		col = colours[i] );

}
