#!/usr/bin/env Rscript

colours <- c( "#007293", "#8A0065", "#008020" );

cairo_pdf( "graphs/meter_error.pdf", onefile = TRUE,
	width = 6.0, height = 3.0 );
par( xaxs = "i", cex = 0.5, lwd = 0.5, mgp = c( 2, 1, 0 ), bty = "l" );
layout( matrix( c( 1, 2, 3, 3 ), 2, 2 ), TRUE );

t = 0.85e-8 * 1.14;
R = 18e3 * 0.135;
LC = 28e-12 * 707e-9 * 1.005;
LoC = 707e-9 / 28e-12 * 0.47;
C = sqrt( LC / LoC );
L = sqrt( LC * LoC );

data <- read.csv( "data/meter_error/100-10n-100k.csv", header = TRUE );
colnames( data ) <- c( "freq", "mag", "phase" );
data$imp <- data$mag * exp( 1i * data$phase / 180 * pi );
data$model <- ( 100 + 1 / (
		1 / 100e3 +
		( 2i * pi * data$freq * 8.3e-9 ) ^ ( 0.97 ) ) +
	1 / (
		1 / R + 
		2i * pi * data$freq * C +
		1 / ( 2i * pi * data$freq * L ) ) ) * 
	exp( -2i * pi * data$freq * t * ( data$freq > 1e6 ) );

data$free <- 100 + 1 / (
		1 / 100e3 +
		( 2i * pi * data$freq * 8.3e-9 ) ^ 0.97 )

data <- data[data$freq > 5e4,];

f = 10^seq( 1.5, 8, 0.001 );
f = f[f > min( data$freq ) & f < max( data$freq )];
deets <- ( 100 + 1 / (
		1 / 100e3 +
		( 2i * pi * f * 8.3e-9 ) ^ ( 0.97 ) ) +
	1 / (
		1 / R +
		2i * pi * f * C +
		1 / ( 2i * pi * f * L ) ) ) *
	exp( -2i * pi * f * t * ( f > 1e6 ) );

par( mar = c( 0, 3, 3, 1 ) + 0.3, cex = 0.5 );

plot( range( data$freq ), range( Mod( c( data$imp, data$model ) ) ),
	type = "n", log = "xy", axes = FALSE,
	xlab = "", ylab = "Impedance / Ω",
	main = "Test Impedance Compensation Model" );

lines( data$freq, Mod( data$free ), lty = "solid", col = colours[3] );
lines( data$freq, Mod( data$model ), lty = "solid", col = colours[2] );
lines( data$freq, Mod( data$imp ), col = colours[1] );

box();
axis( side = 2 );

legend( x = "topleft", lty = "solid", col = colours,
	legend = c( "Recorded", "Simulated", "Error Free" ),
	inset = c( 0.02, 0 ) );

par( mar = c( 3, 3, 0, 1 ) + 0.3 );

plot( range( data$freq ),
	range( Arg( c( data$imp, data$model ) ) * 180 / pi ),
	type = "n", log = "x",
	xlab = "Frequency / Hz", ylab = "Phase / °" );
lines( data$freq, Arg( data$free ) * 180 / pi,
	lty = "solid", col = colours[3] );
lines( data$freq, Arg( data$model ) * 180 / pi,
	lty = "solid", col = colours[2] );
lines( data$freq, Arg( data$imp ) * 180 / pi, col = colours[1] );

par( mar = c( 8, 3, 8, 1 ) + 0.3 );

plot( range( data$freq ), range( Mod( data$imp - data$model ) ),
	type = "n", log = "x", axes = TRUE,
	xlab = "Frequency / Hz", ylab = "Impedance Difference / Ω",
	main = "Test Impedance Residual Error" );
lines( data$freq, Mod( data$imp - data$model ),
	lty = "solid", col = colours[2] );
box();

layout( matrix( c( 2, 1, 1, 2 ), 1, 4 ), TRUE );
par( cex = 0.5 );
plot( range( Re( c( data$imp, data$model, deets ) ) ),
	range( Im( c( data$imp, data$model, deets ) ) ),
	type = "n", asp = 1 );
lines( Re( data$imp ), Im( data$imp ),
	lty = "solid", col = colours[1] );
lines( Re( data$model ), Im( data$model ),
	lty = "solid", col = colours[2] );
#lines( Re( data$model - data$imp ), Im( data$model - data$imp ),
	#lty = "solid", col = colours[3] );
lines( Re( deets ), Im( deets ),
	lty = "solid", col = colours[3] );

abline( v = 0, lwd = 0.5 );
abline( h = 0, lwd = 0.5);

for ( i in seq( dim( data )[1] ) ) {

	print( data[i,] );
	row <- data[i,];

	segments( x0 = Re( row$imp ), y0 = Im( row$imp ),
		x1 = Re( row$model ), y1 = Im( row$model ) );
	#segments(
		#x0 = Re( row$model - row$imp ), y0 = Im( row$model - row$imp ),
		#x1 = Re( row$model ), y1 = Im( row$model ),
		#lwd = 0.2 );

}
