function [dp, hit, far] = mafc_dprime(resp,gt)

    % % % % % % % % % % % %         INPUT       % % % % % % % % % % % %
    
    % resp = column vector containing human responses
    % gt = column vector containing ground-truth labels
    
    % % % % % % % % % % % %         OUTPUT       % % % % % % % % % % % %
    
    % dp = estimate of d-prime
    % hit = proportion hits
    % far = proportion false alarms
    
    % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % 
    
    % find hit and false alarm rate per category
    cats = unique(gt); 
    nc = length(cats);
    nh = 0;
    nht = 0;
    nfa = 0;
    nfat = 0;
    
    % no need to compute if response has zero variance
    if length(unique(resp)) == 1
        dp = 0;
    else

        for i = 1:nc

            targ = cats(i);

            % number of hits
            nh = nh + sum(resp == targ & gt == targ);

            % number of i trials
            nht = nht + sum(gt == targ);

            % number of false alarms
            nfa = nfa + sum(resp == targ & gt ~= targ);

            % number of not-i trials
            nfat = nfat + sum(gt ~= targ);

        end

        % if there is an empty cell, impute a single trial to every quadrant
        if ismember(0,[nh,nht,nfa,nfat])
            nh = nh+1;
            nht = nht+2;
            nfa = nfa+1;
            nfat = nfat+2;
        end

        % hits and fas as proportions
        hit = nh/nht;
        far = nfa/nfat;

        % calculate d-prime in the standard way
        dp = norminv(hit)-norminv(far);
        
    end
            
end