function [dp1,dp2] = mafc_dprime_new(resp,gt,pd)

    % % % % % % % % % % % %         INPUT       % % % % % % % % % % % %
    
    % resp = column vector containing human responses
    % gt = column vector containing ground-truth labels
    % pd = 1 X c vector of category probabilities
    
    % % % % % % % % % % % %         OUTPUT       % % % % % % % % % % % %
    
    % dp = estimate of d-prime
    
    % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % 
    
    maxcat = length(pd); 
    cats = 1:maxcat;
    
    nc = length(cats);
    h = zeros(1,nc);
    fa = zeros(1,nc);
    p = zeros(1,nc);
    
    % skip calculation if fixed response. We know this should be d'=0
    if length(unique(resp)) == 1
        dp1 = 0;
        dp2 = 0;
    else

        for i = 1:nc
            hidx = gt == cats(i);        
            p(i) = mean(hidx);

            nh = sum(resp(hidx) == cats(i));
            nht = sum(hidx);

            nfa = sum(resp(~hidx) == cats(i));
            nfat = sum(~hidx);
            
            % correction for no hits: assume random response (use prior)
            if ismember(0,[nh,nht]) || isequal(nh,nht) 
                nh = nh+pd(i);
                nht = nht+1;
            end
            
            % correction for no fas: assume random response (also use prior)
            if ismember(0,[nfa,nfat]) || isequal(nfa,nfat)
                nfa = nfa+(1-pd(i));
                nfat = nfat+1;
            end

            h(i) = nh/nht;
            fa(i) = nfa/nfat;
        end

        % weighted by frequency of ground-truth categories 
        dp1 = sum((norminv(h)-norminv(fa)).*p);

        % weighted uniformly
        dp2 = mean(norminv(h) - norminv(fa));
        
    end

end