clear; clc; close all;

% let's simulate some data just to see whether a 4 and 6 category system
% will produce the same values of d' given the same signal-noise ratio
ncat1 = 4;
ncat2 = 6;

nt = 100000;

gt1 = randi(ncat1,nt,1);
gt2 = randi(ncat2,nt,1);

% let's check signal-to-noise ratios of 1->inf
ntries = 100;
nests = 1;
ninc = round(nt/ntries);

ni1 = ceil(ntries/(1-(1/ncat1)));
ni2 = ceil(ntries/(1-(1/ncat2)));


dp1 = zeros(ntries,nests);
hit1 = zeros(ntries,nests);
fa1 = zeros(ntries,nests);

dp2 = zeros(ntries,nests);
hit2 = zeros(ntries,nests);
fa2 = zeros(ntries,nests);

for i = 1:ni1
    
    for j = 1:nests
        
        % first make all responses match the gt
        resp1 = gt1;

        % then we change n trials (increasing per iteration)
        ntochange = ninc*i;
        ntochange = round(ntochange * (1-(1/ncat1))); % a correct response is more probable when there are fewer categories
        ntochange = min([ntochange,nt]);
        idxchange = 1:nt;
        idxchange = idxchange(randperm(nt));
        idxchange = idxchange(1:ntochange);
        
        % and replace the gt-matched resps with random responses
        replaceval = randi(ncat1,ntochange,1);
        resp1(idxchange) = replaceval;
        [dp1(i,j), hit1(i,j),fa1(i,j)] = mafc_dprime(resp1,gt1);
        
    end
    
end

        
for i = 1:ni2
    
    for j = 1:nests
        
        % first make all responses match the gt
        resp2 = gt2;

        % then we change n trials (increasing per iteration)
        ntochange = ninc*i;
        ntochange = round(ntochange * (1-(1/ncat2))); % a correct response is more probable when there are fewer categories
        ntochange = min([ntochange,nt]);
        idxchange = 1:nt;
        idxchange = idxchange(randperm(nt));
        idxchange = idxchange(1:ntochange);
        
        % and replace the gt-matched resps with random responses
        replaceval = randi(ncat2,ntochange,1);
        resp2(idxchange) = replaceval;
        [dp2(i,j), hit2(i,j),fa2(i,j)] = mafc_dprime(resp2,gt2);
        
    end
    
end

figure;
hold on;
plot(dp1);
plot(dp2);

% now we just need to align the two arrays' x vals so they can be plotted alongside each other
ndp1 = length(dp1);
ndp2 = length(dp2);
dp2idx = linspace(1,ndp2,ndp1);
dp2_long = interp1(1:ndp2,dp2,dp2idx);

figure; hold on;
maxd = max([dp1(:);dp2(:)]);
plt1 = plot([0,maxd],[0,maxd],'Color','k','LineStyle','--','LineWidth',3);
plt2 = plot(flipud(dp1),flipud(dp2),'Color','r','LineWidth',3);
set(gca,'LineWidth',3)
set(gca,'FontSize',17)
xlabel('d prime (4 categories)')
ylabel('d prime (6 Categories)')
xlim([0,maxd])
ylim([0,maxd])
box off
axis square
legend([plt1,plt2],'Predicted','Observed')
legend boxoff

