function [dp_1, hit_1, fa_1, dp_2, hit_2, fa_2, dp_3] = wjafc_dprime(resp,gt)

    % % % % % % % % % % % %         INPUT       % % % % % % % % % % % %
    
    % resp = column vector containing human responses
    % gt = column vector containing ground-truth labels
    
    % % % % % % % % % % % %         OUTPUT       % % % % % % % % % % % %
    
    % dp = estimate of d-prime
    
    % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % 
    
%     % WJA temporarily test out function - task 1, 4 cats
%     resp = resp_temp(1, :);
%     gt = GT_temp(1, :);
    
    % find hit and false alarm rate per category
    hit_1 = 0;
    fa_1 = 0;
    n = length(resp);
    cats = unique(gt); 
    nc = length(cats);
    
    for i = 1:nc
        targ = cats(i);
        
        % number of hits
        nh_ind(i) = sum(resp == targ & gt == targ);
        
        % number of i stimuli (target cat present)
        nht_ind(i) = sum(gt == targ);
        
        % number of false alarms
        nfa_ind(i) = sum(resp == targ & gt ~= targ);
        
        % number of not-i stimuli (target cat absent)
        nfat_ind(i) = sum(gt ~= targ);
        
        % add a trial to each quadrant if we get a 0 (can't calculate dp)
        %%% for matt's method - add trials within each category
        nh = nh_ind(i);
        nht = nht_ind(i);
        nfa = nfa_ind(i);
        nfat = nfat_ind(i);
        if ismember(0,[nh,nht,nfa,nfat])
            nh = nh+1;
            nht = nht+2;
            nfa = nfa+1;
            nfat = nfat+2;
        end

        %%%% Matt's method %%% 
         % category-specific hit rate x weight (i.e. proportion of 
        % all trials that are targ present)
        hit_1 = hit_1 + (nht/n)*(nh/nht);
        % category-specific false-alarm rate
        % nfat/n is proportion of all trials that are targ absent
        % not sure why divide by (nc-1)
        fa_1 = fa_1 + ((nfat/n)*(nfa/nfat))/(nc-1);
        
    end
    %%%% Matt's method %%%
    % calculate d-prime in the standard way
    dp_1 = norminv(hit_1)-norminv(fa_1);
    
    %%% wendy method 1 - combine H, FA etc then hack
    nh_all = sum(nh_ind(:));
    nht_all = sum(nht_ind(:));
    nfa_all = sum(nfa_ind(:));
    nfat_all = sum(nfat_ind(:));
    % add a trial to each quadrant if we get a 0 (can't calculate dp)
        %%% for matt's method - add trials within each category
        if ismember(0,[nh_all,nht_all,nfa_all,nfat_all])
            nh_all = nh_all+1;
            nht_all = nht_all+2;
            nfa_all = nfa_all+1;
            nfat_all = nfat_all+2;
        end
    hit_2 = nh_all/nht_all;
    fa_2 = nfa_all/nfat_all;        
    dp_2 = norminv(hit_2)-norminv(fa_2);
    dp_3 = norminv(hit_2)-norminv(fa_2/(nc-1)); 
end