function dp_adj = adj_dprime(dp, nc, catcmp, dpmatrix, Avals, meanA)

    % % % % % % % % % % % %         INPUT       % % % % % % % % % % % %

    % dp = estimate of dprime using the mafc_dprime2 function
    
    % nc = number of categories used to compute dprime
    
    % catcmp = number of categories in other category system (which dp will be compared to)
    
    % dpmatrix = matrix of dprime vals for different difficulties and
    % different levels of agreement. Pre-generate these using the script
    % Simulations/category_sim_quick_prior.m 
    
    % vector of agreement values used to compute dpmatrix. Make sure they
    % match the vector used to generate dpmatrix. This is important
    
    % nominal value of agreement to be used for comparison
        
    % % % % % % % % % % % %         OUTPUT       % % % % % % % % % % % %
    
    % dp_adj = adjusted dprime value
    
    % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % 
        
    % first we find the row that corresponds to the chosen level of
    % inter-observer agreement
    Arow = find(Avals == meanA);

    % if no perfect match, interpolate between simulated values
    if isempty(Arow)

        % get index of highest negative value
        idxlow = sum((Avals-meanA)<0);

        if idxlow == 0
            error('Simulated data not within range of empirical agreement value')
        end

        % next value up 
        idxhi = idxlow+1;

        % difference between low and high bounds
        deltaA = Avals(idxhi)-Avals(idxlow);
        lowdist = meanA-Avals(idxlow);

        % weights for interpolation
        hiweight = lowdist/deltaA;
        lowweight = 1-hiweight;

        % find weighted mean and check for accuracy
        Ainterp = lowweight*Avals(idxlow) + hiweight*Avals(idxhi);
        if round(Ainterp,5) ~= round(meanA,5)
            error('something wrong')
        end

        % isolate slice of simulated data that corresponds to this
        % level of agreement. do for both the observed category system,
        % and the category system we're comparing it to.
        dvals1 = lowweight.*dpmatrix(nc-1,:,idxlow) + hiweight.*dpmatrix(nc-1,:,idxhi);
        dvals2 = lowweight.*dpmatrix(catcmp-1,:,idxlow) + hiweight.*dpmatrix(catcmp-1,:,idxhi);

    else

        % much simpler - just take the Arow index
        dvals1 = squeeze(dpmatrix(nc-1,:,Arow));
        dvals2 = squeeze(dpmatrix(catcmp-1,:,Arow));

    end

    % difference between simulated (interpolated vals) and empirical dprime
    diffs = dvals1-dp;

    % get index of highest negative value
    idxlow = sum(diffs<0);

    if idxlow == 0
        % use smallest simulated adjustment
        adj = (dvals1(1)-dvals2(1))/2;
        dp_adj = dp-adj;
    elseif idxlow == length(diffs)
        % use largest estimated adjustment
        adj = (dvals1(end)-dvals2(end))/2;
        dp_adj = dp-adj;
    else

        % next value up 
        idxhi = idxlow+1;

        % difference between low and high bounds
        deltad = dvals1(idxhi)-dvals1(idxlow);
        lowdist = dp-dvals1(idxlow);

        % weights for interpolation
        hiweight = lowdist/deltad;
        lowweight = 1-hiweight;

        d1interp = lowweight*dvals1(idxlow) + hiweight*dvals1(idxhi);
        if round(d1interp,5) ~= round(dp,5)
            error('something wrong')
        end

        % now we get the corresponding value for the number of
        % categories we want to compare to
        d2interp = lowweight*dvals2(idxlow) + hiweight*dvals2(idxhi);

        % then we take the mean of the two category systems
        dp_adj = mean([d1interp,d2interp]);

    end

end