clear; clc;

% proportion correct
pc = .95;
method = 2;

% number of simulated trials
nt = 10000;

% first task has 4 categories
ncat1 = 4;

% define correct trials
corr = randi(ncat1,1,round(nt*pc));

% define the trials where an error is made
incorr1 = randi(ncat1,1,round(nt*ncat1));
incorr2 = randi(ncat1,1,round(nt*ncat1));
idxrmv = incorr1 == incorr2;
incorr1(idxrmv) = [];
incorr2(idxrmv) = [];
idxs = 1:round(nt*(1-pc));
incorr1 = incorr1(idxs);
incorr2 = incorr2(idxs);

% combine correct and incorrect trials
resp = [corr,incorr1];
gt = [corr,incorr2];
crosstab(resp,gt)

% now we compute d-prime
[dp1, hit1, fa1] = mafc_dprime2(resp,gt,method);

% now we do the same for the second category system
ncat2 = 6;

% define correct trials
corr = randi(ncat2,1,round(nt*pc));

% define the trials where an error is made
incorr1 = randi(ncat2,1,round(nt*ncat2));
incorr2 = randi(ncat2,1,round(nt*ncat2));
idxrmv = incorr1 == incorr2;
incorr1(idxrmv) = [];
incorr2(idxrmv) = [];
idxs = 1:round(nt*(1-pc));
incorr1 = incorr1(idxs);
incorr2 = incorr2(idxs);

% combine correct and incorrect
resp = [corr,incorr1];
gt = [corr,incorr2];
crosstab(resp,gt)

% now we compute d-prime
[dp2, hit2, fa2] = mafc_dprime2(resp,gt,method);

% dp1 == dp2

