import config
import camera
import gpio
from time import sleep
from datetime import datetime, time, timedelta
import Jetson.GPIO as JGPIO
import time as ti

old_print = print

def timestamped_print(*args, **kwargs):
  old_print(str(datetime.now())[:-4], *args, **kwargs)

print = timestamped_print



# Create a camera object - this object enables camera functionality
cam = camera.cameraclass()

# Initialise the camera. Connect over USB and apply default settings 
# (Gain, Red/Blue balance, RGB8 pixel format, .jpg image type,
# /captures/test/ save directory.)
cam.init()
cam.setgain(4)

# Turn on ultrasound - uses the freuency and time settings in config.py
uswthread = gpio.usw_on()


#variables
valve_beads = 3
save_beads = 'captures/justbeads/beads/'
valve_L1 = 10
save_l1 = 'captures/justbeads/L1/'

 
flushdelay = 45


gpio.pumpdirection(1)

def beads():
    print('pumping beads')
    gpio.pumpenable(False)
    gpio.valve(valve_beads)
    gpio.pumpenable(True)
    ti.sleep(flushdelay)
    #take 250 images
    print('imaging beads')
    cam.setsavedir(save_beads+str(datetime.now().strftime('%d-%m-%Y_%H'))+'/')    
    cam.cap_n_blocking(n=250)

def flush():
    #flush some l1 through to refresh the flow cell
    gpio.pumpenable(False)
    print('pumping l1')
    gpio.valve(valve_L1)
    gpio.pumpenable(enable=True)
    ti.sleep(flushdelay)
    #get 10 bg images
    print('checking bg')
    cam.setsavedir(save_l1+str(datetime.now().strftime('%d-%m-%Y_%H'))+'/')
    cam.cap_n_blocking(n=10)


def sample(uswthread):
    if not uswthread.isAlive():
        print('turning usw back on')
        uswthread = gpio.usw_on()

    #flush some l1 and take images to validate flow cell emptiness
    flush()

    #image beads to test usw
    beads()

    #flush some l1 through to refresh the flow cell
    flush()

    #turn off pump
    gpio.pumpenable(enable=False)
    print('sampling completed')
    gpio.usw_off(uswthread)


def wait_start(starttime,uswthread):
    print('waiting until ' + str(starttime))
    while starttime > datetime.now(): # you can add here any additional variable to break loop if necessary
        sleep(1)# you can change 1 sec interval to any other
    sample(uswthread)

start_time = datetime.now()
sample(uswthread)
sampletimes = [start_time + timedelta(hours=y) for y in [x*6 for x in range(1,40)]]

for time in sampletimes:
    wait_start(time, uswthread)
    print('Done sampling')



# Turn off pump and ultrasound
gpio.pumpenable(enable=False)
gpio.usw_off()
gpio.DDS_reset()

# Close the camera connection (REQUIRED to allow the camera to work later without reconnecting)
cam.closeconnection()

JGPIO.cleanup()
quit()


