import config
import camera
import gpio
from time import sleep
from datetime import datetime, time, timedelta
import Jetson.GPIO as JGPIO
import time as ti

old_print = print

def timestamped_print(*args, **kwargs):
  old_print(str(datetime.now())[:-4], *args, **kwargs)

print = timestamped_print



# Create a camera object - this object enables camera functionality
cam = camera.cameraclass()

# Initialise the camera. Connect over USB and apply default settings 
# (Gain, Red/Blue balance, RGB8 pixel format, .jpg image type,
# /captures/test/ save directory.)
cam.init()
cam.setgain(4)

# Turn on ultrasound - uses the freuency and time settings in config.py
uswthread = gpio.usw_on()


#variables
valve_beads = 3
save_beads = 'captures/rhod_experiment/beads/'
valve_L1 = 10
save_l1 = 'captures/rhod_experiment/L1/'
valve_conc1 = 7
save_conc1 = 'captures/rhod_experiment/conc1/'
valve_conc2 = 9
save_conc2 = 'captures/rhod_experiment/conc2/'
valve_dilute1 = 6
save_dil1 = 'captures/rhod_experiment/dil1/'
valve_dilute2 = 5
save_dil2 = 'captures/rhod_experiment/dil2/'
 
flushdelay = 45


gpio.pumpdirection(1)

# image 1000 images from each every 4 hours for 4 days

def conc1():
    print('pumping conc1')
    gpio.pumpenable(False)
    gpio.valve(valve_conc1)
    gpio.pumpenable(True)
    ti.sleep(flushdelay)
    #take 500 images
    print('imaging conc1')
    cam.setsavedir(save_conc1+str(datetime.now().strftime('%d-%m-%Y_%H')))    
    cam.cap_n_blocking(n=500)

def conc2():
    print('pumping conc2')
    gpio.pumpenable(False)
    gpio.valve(valve_conc2)
    gpio.pumpenable(True)
    ti.sleep(flushdelay)
    #take 500 images
    print('imaging conc2')
    cam.setsavedir(save_conc2+str(datetime.now().strftime('%d-%m-%Y_%H')))    
    cam.cap_n_blocking(n=500)

def dilute1():
    print('pumping dil1')
    gpio.pumpenable(False)
    gpio.valve(valve_dilute1)
    gpio.pumpenable(True)
    ti.sleep(flushdelay)
    #take 1000 images
    print('imaging dil1')
    cam.setsavedir(save_dil1+str(datetime.now().strftime('%d-%m-%Y_%H')))    
    cam.cap_n_blocking(n=500)

def dilute2():
    print('pumping dil2')
    gpio.pumpenable(False)
    gpio.valve(valve_dilute2)
    gpio.pumpenable(True)
    ti.sleep(flushdelay)
    #take 1000 images
    print('imaging dil2')
    cam.setsavedir(save_dil2+str(datetime.now().strftime('%d-%m-%Y_%H')))    
    cam.cap_n_blocking(n=500)

def beads():
    print('pumping beads')
    gpio.pumpenable(False)
    gpio.valve(valve_beads)
    gpio.pumpenable(True)
    ti.sleep(flushdelay)
    #take 250 images
    print('imaging beads')
    cam.setsavedir(save_beads+str(datetime.now().strftime('%d-%m-%Y_%H')))    
    cam.cap_n_blocking(n=250)

def flush():
    #flush some l1 through to refresh the flow cell
    gpio.pumpenable(False)
    print('pumping l1')
    gpio.valve(valve_L1)
    gpio.pumpenable(enable=True)
    ti.sleep(flushdelay)
    #get 10 bg images
    print('checking bg')
    cam.setsavedir(save_l1+str(datetime.now().strftime('%d-%m-%Y_%H')))
    cam.cap_n_blocking(n=10)

def sample(uswthread):
    if not uswthread.isAlive():
        print('turning usw back on')
        uswthread = gpio.usw_on()
    #flush some l1 and take images to validate flow cell emptiness
    flush()

    #image beads to test usw
    beads()

    #swap to conc 1 and capture images
    conc1()

    #flush some l1 through to refresh the flow cell
    flush()

    #swap to conc 2
    conc2()

    #flush some l1 through to refresh the flow cell
    flush()

    #swap to dilute 1
    dilute1()

    #flush some l1 through to refresh the flow cell
    flush()

    #swap to dilute 2
    dilute2()

    #image beads to test usw
    beads()

    #flush some l1 through to refresh the flow cell
    flush()

    #turn off pump
    gpio.pumpenable(enable=False)
    print('sampling completed')
    gpio.usw_off(uswthread)


def wait_start(starttime,uswthread):
    print('waiting until ' + str(starttime))
    while starttime > datetime.now(): # you can add here any additional variable to break loop if necessary
        sleep(1)# you can change 1 sec interval to any other
    sample(uswthread)

start_time = datetime.now()
sample(uswthread)
sampletimes = [start_time + timedelta(hours=y) for y in [x*6 for x in range(1,40)]]

for time in sampletimes:
    wait_start(time, uswthread)
    print('Done sampling')



# Turn off pump and ultrasound
gpio.pumpenable(enable=False)
gpio.usw_off()
gpio.DDS_reset()

# Close the camera connection (REQUIRED to allow the camera to work later without reconnecting)
cam.closeconnection()

JGPIO.cleanup()
quit()
