import config
import camera
import gpio
from time import sleep
from datetime import datetime, time, timedelta
import Jetson.GPIO as JGPIO
import time as ti

old_print = print

def timestamped_print(*args, **kwargs):
  old_print(str(datetime.now())[:-4], *args, **kwargs)

print = timestamped_print



# Create a camera object - this object enables camera functionality
cam = camera.cameraclass()

# Initialise the camera. Connect over USB and apply default settings 
# (Gain, Red/Blue balance, RGB8 pixel format, .jpg image type,
# /captures/test/ save directory.)
cam.init()
cam.setgain(4)

# Turn on ultrasound - uses the freuency and time settings in config.py
uswthread = gpio.usw_on()


#variables

valve_L1 = 10
save_l1 = 'captures/rhod_experiment/L1/'
valve_conc1 = 7
save_conc1 = 'captures/rhod_experiment/conc1/'
valve_conc2 = 9
save_conc2 = 'captures/rhod_experiment/conc2/'
valve_dilute1 = 6
save_dil1 = 'captures/rhod_experiment/dil1/'
valve_dilute2 = 5
save_dil2 = 'captures/rhod_experiment/dil2/'
 
flushdelay = 45


gpio.pumpdirection(1)

# image 1000 images from each every 4 hours for 4 days

def sample(uswthread):
    if not uswthread.isAlive():
        print('turning usw back on')
        uswthread = gpio.usw_on()
    #flush some l1 through to refresh the flow cell
    print('pumping l1')
    gpio.valve(valve_L1)
    gpio.pumpenable(enable=True)
    ti.sleep(flushdelay)
    #get 10 bg images
    print('checking bg')
    cam.setsavedir(save_l1+str(datetime.now().strftime('%d-%m-%Y_%H')))
    cam.cap_n_blocking(n=10)
    #swap to conc 1
    print('pumping conc1')
    gpio.pumpenable(False)
    gpio.valve(valve_conc1)
    gpio.pumpenable(True)
    ti.sleep(flushdelay)
    #take 1000 images
    print('imaging conc1')
    cam.setsavedir(save_conc1+str(datetime.now().strftime('%d-%m-%Y_%H')))    
    cam.cap_n_blocking(n=500)
    #flush some l1 through to refresh the flow cell
    gpio.pumpenable(False)
    gpio.valve(valve_L1)
    gpio.pumpenable(enable=True)
    ti.sleep(flushdelay)
    #swap to conc 2
    print('pumping conc2')
    gpio.pumpenable(False)
    gpio.valve(valve_conc2)
    gpio.pumpenable(True)
    ti.sleep(flushdelay)
    #take 1000 images
    print('imaging conc2')
    cam.setsavedir(save_conc2+str(datetime.now().strftime('%d-%m-%Y_%H')))    
    cam.cap_n_blocking(n=500)
    #flush some l1 through to refresh the flow cell
    gpio.pumpenable(False)
    gpio.valve(valve_L1)
    gpio.pumpenable(enable=True)
    ti.sleep(flushdelay)
    #swap to dilute 1
    print('pumping dil1')
    gpio.pumpenable(False)
    gpio.valve(valve_dilute1)
    gpio.pumpenable(True)
    ti.sleep(flushdelay)
    #take 1000 images
    print('imaging dil1')
    cam.setsavedir(save_dil1+str(datetime.now().strftime('%d-%m-%Y_%H')))    
    cam.cap_n_blocking(n=500)
    #flush some l1 through to refresh the flow cell
    gpio.pumpenable(False)
    gpio.valve(valve_L1)
    gpio.pumpenable(enable=True)
    ti.sleep(flushdelay)
    #swap to dilute 2
    print('pumping dil2')
    gpio.pumpenable(False)
    gpio.valve(valve_dilute2)
    gpio.pumpenable(True)
    ti.sleep(flushdelay)
    #take 1000 images
    print('imaging dil2')
    cam.setsavedir(save_dil2+str(datetime.now().strftime('%d-%m-%Y_%H')))    
    cam.cap_n_blocking(n=500)
    #flush some l1 through to refresh the flow cell
    gpio.pumpenable(False)
    gpio.valve(valve_L1)
    gpio.pumpenable(enable=True)
    ti.sleep(flushdelay + 10)
    #get 10 bg images
    print('checking bg')
    cam.setsavedir(save_l1+str(datetime.now().strftime('%d-%m-%Y_%H')))
    cam.cap_n_blocking(n=10)    
    #turn off pump
    gpio.pumpenable(enable=False)
    print('sampling completed')
    gpio.usw_off(uswthread)


def wait_start(starttime,uswthread):
    print('waiting until ' + str(starttime))
    while starttime > datetime.now(): # you can add here any additional variable to break loop if necessary
        sleep(1)# you can change 1 sec interval to any other
    sample(uswthread)

start_time = datetime.now()
sample(uswthread)
sampletimes = [start_time + timedelta(hours=y) for y in [x*4 for x in range(1,36)]]

for time in sampletimes:
    wait_start(time, uswthread)
    print('Done sampling')



# Turn off pump and ultrasound
gpio.pumpenable(enable=False)
gpio.usw_off()
gpio.DDS_reset()

# Close the camera connection (REQUIRED to allow the camera to work later without reconnecting)
cam.closeconnection()

JGPIO.cleanup()
quit()
