import config
import camera
import gpio
import time
from datetime import datetime
import Jetson.GPIO as JGPIO


old_print = print

def timestamped_print(*args, **kwargs):
  old_print(str(datetime.now())[:-4], *args, **kwargs)

print = timestamped_print



# Create a camera object - this object enables camera functionality
cam = camera.cameraclass()

# Initialise the camera. Connect over USB and apply default settings 
# (Gain, Red/Blue balance, RGB8 pixel format, .jpg image type,
# /captures/test/ save directory.)
cam.init()
cam.setgain(4)

# Turn on ultrasound - uses the freuency and time settings in config.py
uswthread = gpio.usw_on()


#variables
valve_L1 = 10
save_l1 = 'captures/rhod_experiment/L1/'
valve_conc1 = 7
save_conc1 = 'captures/rhod_experiment/conc1/'
valve_conc2 = 9
save_conc2 = 'captures/rhod_experiment/conc2/'
valve_dilute1 = 6
save_dil1 = 'captures/rhod_experiment/dil1/'
valve_dilute2 = 5
save_dil2 = 'captures/rhod_experiment/dil2/'
 
flushdelay = 45


# Turn on the peristaltic pump in forward direction
gpio.pumpdirection(direction=True)
gpio.pumpenable(enable=True)


# image 1000 images from each every 3 hours for 3 days

for i in range(12):
    if not uswthread.isAlive():
        print('turning usw back on')
        uswthread = gpio.usw_on()
    #flush some l1 through to refresh the flow cell
    print('pumping l1')
    gpio.valve(valve_L1)
    gpio.pumpenable(enable=True)
    time.sleep(flushdelay)
    #get 1 bg images
    print('checking bg')
    cam.setsavedir(save_l1)
    cam.cap_n_blocking(n=1)
    #swap to conc 1
    print('pumping conc1')
    gpio.pumpenable(False)
    gpio.valve(valve_conc1)
    gpio.pumpenable(True)
    time.sleep(flushdelay)
    #take 1 images
    print('imaging conc1')
    cam.setsavedir(save_conc1)    
    cam.cap_n_blocking(n=1)
    #flush some l1 through to refresh the flow cell
    gpio.pumpenable(False)
    gpio.valve(valve_L1)
    gpio.pumpenable(enable=True)
    time.sleep(flushdelay)
    #swap to conc 2
    print('pumping conc2')
    gpio.pumpenable(False)
    gpio.valve(valve_conc2)
    gpio.pumpenable(True)
    time.sleep(flushdelay)
    #take 1 images
    print('imaging conc2')
    cam.setsavedir(save_conc2)    
    cam.cap_n_blocking(n=1)
    #flush some l1 through to refresh the flow cell
    gpio.pumpenable(False)
    gpio.valve(valve_L1)
    gpio.pumpenable(enable=True)
    time.sleep(flushdelay)
    #swap to dilute 1
    print('pumping dil1')
    gpio.pumpenable(False)
    gpio.valve(valve_dilute1)
    gpio.pumpenable(True)
    time.sleep(flushdelay)
    #take 1 images
    print('imaging dil1')
    cam.setsavedir(save_dil1)    
    cam.cap_n_blocking(n=1)
    #flush some l1 through to refresh the flow cell
    gpio.pumpenable(False)
    gpio.valve(valve_L1)
    gpio.pumpenable(enable=True)
    time.sleep(flushdelay)
    #swap to dilute 2
    print('pumping dil2')
    gpio.pumpenable(False)
    gpio.valve(valve_dilute2)
    gpio.pumpenable(True)
    time.sleep(flushdelay)
    #take 1 images
    print('imaging dil2')
    cam.setsavedir(save_dil2)    
    cam.cap_n_blocking(n=1)
    #flush some l1 through to refresh the flow cell
    gpio.pumpenable(False)
    gpio.valve(valve_L1)
    gpio.pumpenable(enable=True)
    time.sleep(flushdelay + 10)
    #get 10 bg images
    print('checking bg')
    cam.setsavedir(save_l1)
    cam.cap_n_blocking(n=1)    
    #turn off pump
    gpio.pumpenable(enable=False)
    #wait 30s
    time.sleep(30)
    print('turning USW off until next time')
    gpio.usw_off(uswthread)

# Turn off pump and ultrasound
gpio.pumpenable(enable=False)
gpio.usw_off()
gpio.DDS_reset()

# Close the camera connection (REQUIRED to allow the camera to work later without reconnecting)
cam.closeconnection()

JGPIO.cleanup()
quit()
