'''
Readme to go here
'''
import threading
import Jetson.GPIO as GPIO
import config
import time

GPIO.cleanup()

# Use the pin numbering format printed on the Jetson
mode = GPIO.setmode(GPIO.BOARD)

# All GPIO pins that will/may be used
channels = [
    config.GPIO_DDS_LOAD,
    config.GPIO_DDS_CLOCK,
    config.GPIO_DDS_DATA,
    config.GPIO_DDS_RESET,
    config.GPIO_VALVE_IN1,
    config.GPIO_VALVE_IN2,
    config.GPIO_VALVE_IN3,
    config.GPIO_VALVE_IN4,
    config.GPIO_PUMP_ENABLE,
    config.GPIO_PUMP_DIR,
    config.GPIO_TRANSISTOR_SPARE
]

# Set all the above to output mode with High initial states
# (May want to change this for pump/valve etc)
GPIO.setup(channels, GPIO.OUT, initial=GPIO.HIGH)


def DDS_init():
    ddschannels = [
        config.GPIO_DDS_LOAD,
        config.GPIO_DDS_CLOCK,
        config.GPIO_DDS_DATA,
        config.GPIO_DDS_RESET
    ]
    GPIO.setup(ddschannels, GPIO.OUT, initial=GPIO.HIGH)
    # Sets all DDS pins low
    GPIO.output(config.GPIO_DDS_RESET, GPIO.LOW)
    GPIO.output(config.GPIO_DDS_CLOCK, GPIO.LOW)
    GPIO.output(config.GPIO_DDS_LOAD, GPIO.LOW)
    GPIO.output(config.GPIO_DDS_DATA, GPIO.LOW)
    time.sleep(0.5)


def DDS_reset():
    # Sends pulses on DDS pins to reset AD9850
    GPIO.output(config.GPIO_DDS_LOAD, GPIO.LOW)
    time.sleep(0.01)
    GPIO.output(config.GPIO_DDS_RESET, GPIO.LOW)
    time.sleep(0.01)
    GPIO.output(config.GPIO_DDS_CLOCK, GPIO.LOW)
    time.sleep(0.01)
    GPIO.output(config.GPIO_DDS_RESET, GPIO.HIGH)
    time.sleep(0.01)
    GPIO.output(config.GPIO_DDS_CLOCK, GPIO.HIGH)
    time.sleep(0.01)
    GPIO.output(config.GPIO_DDS_CLOCK, GPIO.LOW)
    time.sleep(0.01)
    GPIO.output(config.GPIO_DDS_RESET, GPIO.LOW)
    GPIO.output(config.GPIO_DDS_LOAD, GPIO.LOW)
    GPIO.output(config.GPIO_DDS_LOAD, GPIO.HIGH)
    GPIO.output(config.GPIO_DDS_LOAD, GPIO.LOW)
    # Full reset of Jetson out pins
    DDSchannels = [
    config.GPIO_DDS_LOAD,
    config.GPIO_DDS_CLOCK,
    config.GPIO_DDS_DATA,
    config.GPIO_DDS_RESET
    ]
    GPIO.setup(DDSchannels, GPIO.OUT, initial=GPIO.HIGH)



def DDS_sweep():
    # The 'business' function: runs a frequency sweep using values set in config.py
    DDS_init()
    DDS_reset()
    while True:
        for freq in range(int(config.DDS_SWEEP_START), int(config.DDS_SWEEP_STOP), int(config.DDS_SWEEP_STEP)):
            sendFrequency(freq)


def DDS_background(start, stop):
    # Same as above but designed to be run in parallel i.e. while other processing is underway
    print('DDS background process started')
    t = threading.currentThread()
    DDS_init()
    #DDS_reset()
    while getattr(t, "do_run", True):
        for freq in range(int(start), int(stop), int(config.DDS_SWEEP_STEP)):
            sendFrequency(freq)
    print('DDS background process terminated')


def usw_on():
    config.DDS_ACTIVE = True
    t = threading.Thread(target=DDS_background, args=(config.DDS_SWEEP_START,config.DDS_SWEEP_STOP))
    t.start()
    return t


def usw_off(t):
    config.DDS_ACTIVE = False
    t.do_run = False
    DDS_reset() # seems to be necessary 12/01/2021 - check!
    time.sleep(0.1)


def outOne():
    # Send a '1' on the data line
    GPIO.output(config.GPIO_DDS_CLOCK, GPIO.LOW)
    GPIO.output(config.GPIO_DDS_DATA, GPIO.HIGH)
    GPIO.output(config.GPIO_DDS_CLOCK, GPIO.HIGH)
    GPIO.output(config.GPIO_DDS_DATA, GPIO.LOW)


def outZero():
    # Send a '0' on the data line
    GPIO.output(config.GPIO_DDS_CLOCK, GPIO.LOW)
    GPIO.output(config.GPIO_DDS_DATA, GPIO.LOW)
    GPIO.output(config.GPIO_DDS_CLOCK, GPIO.HIGH)


def byte_out(byte: int):
    # Sends a byte one bit at a time
    for i in range(8):
        if (byte & 1) == 1:
            outOne()
        else:
            outZero()
        byte = byte >> 1


def sendFrequency(frequency: int):
    # Sends individual frequency by converting to a 'tuning word'
    # and sending this over the data line.
    tuning_word = int((frequency * (2**24)) / (config.DDS_CLOCK/256))
    #print('Current tuning word: ' + str(tuning_word))
    GPIO.output(config.GPIO_DDS_LOAD, GPIO.LOW)
    for i in range(32):
        if tuning_word & 1 == 1:
            outOne()
        else:
            outZero()
        tuning_word = tuning_word >> 1
    byte_out(0x00)
    GPIO.output(config.GPIO_DDS_LOAD, GPIO.HIGH)
    GPIO.output(config.GPIO_DDS_LOAD, GPIO.LOW)


def DDS_exit():
    # Resets DDS and cleans up GPIO
    DDS_reset()
    GPIO.cleanup()


def valve(num: int):
    # Sets the valve control IO pins high to the transistor array
    assert 0 < num < 11  # Check valid valve selected
    # Set up list of IO pin output states for the selected valve
    config.valveselected = num
    outputs = [bool(num & 1),
               bool(num & 2),
               bool(num & 4),
               bool(num & 8)]
    outputs = [GPIO.LOW if o else GPIO.HIGH for o in outputs]
    print(outputs)
    # Pins to set
    pins = [config.GPIO_VALVE_IN1,
            config.GPIO_VALVE_IN2,
            config.GPIO_VALVE_IN3,
            config.GPIO_VALVE_IN4]
    # Set pins to the calculated states
    GPIO.output(pins, outputs)
    time.sleep(0.5)

def pumpenable(enable:bool):
    if enable:
        enable = GPIO.LOW
        config.pumpenable = True
    else:
        enable = GPIO.HIGH
        config.pumpenable = False
    GPIO.output(config.GPIO_PUMP_ENABLE, enable) 
    time.sleep(0.5)

def pumpdirection(direction:bool):
    if direction:
        direction = GPIO.LOW
        config.pumpdirection = 'f'
    else:
        direction = GPIO.HIGH
        config.pumpdirection = 'r'
    GPIO.output(config.GPIO_PUMP_DIR, direction)


# Testing functions:



def testpin(pin):
    # Send a square wave on the indicated pin
    while 1:
        GPIO.output(pin, GPIO.HIGH)
        GPIO.output(pin, GPIO.LOW)


def usw_tone():
    # Rewritten - don't time here. Just turn on and let GUI/user control timing
    #prior_sweep = (config.DDS_SWEEP_START, config.DDS_SWEEP_STOP)
    #config.DDS_SWEEP_START = 5500
    #config.DDS_SWEEP_STOP = 10000
    #usw_on()
    #time.sleep(0.01)
    #config.DDS_SWEEP_START, config.DDS_SWEEP_STOP = prior_sweep
    config.DDS_ACTIVE = True
    t = threading.Thread(target=DDS_background, args=(5000,8000))
    t.start()
    return t


def usw_test(duration=10):
    initiated = time.time()
    endtime = initiated + duration
    print('Sweeping 5.5-10kHz - you should hear this!')
    usw_tone()
    while time.time() < endtime:
        pass
    usw_off()
    print('Finished audible tone test')

