#TODO: Either input validation (integer, positive, 1-12) or combobox/dropdown for valve number
	#Camera recording (gui update cpu cycles may impact performance - check!) buttons (filename, record/stop, record x frames), video mode?

import PySimpleGUI as sg
import cv2
import EasyPySpin
import numpy as np
import camera
import config
import time
import gpio
from datetime import datetime

#This dude will store an object representing the background process controlling acoustic output - this allows it to later be killed
t = None


"""
Displays Controls and Images for PhytoCap IFC
"""


def main():
    imgsize = (480,640)
    sg.theme('Dark')

    acousticframe = sg.Frame('Acoustic Focussing Controls', [
                  [sg.Text('Current Acoustic Sweep Parameters:',font='Helvetica 10 bold')],
                  [sg.Text('Start Frequency:', size=(22, 1), font='Helvetica 8'), 
                   sg.Text(str(config.DDS_SWEEP_START), size=(10, 1), key = '-STARTHZ-', text_color='#bfbfbf', font='Helvetica 12'), 
                   sg.Text('Hz', font='Helvetica 8')],
                  [sg.Text('Stop Frequency:', size=(22, 1), font='Helvetica 8'), 
                   sg.Text(str(config.DDS_SWEEP_STOP), size=(10, 1), key = '-STOPHZ-', text_color='#bfbfbf', font='Helvetica 12'), 
                   sg.Text('Hz', font='Helvetica 8')],
                  [sg.Text('Sweep Duration:', size=(22, 1), font='Helvetica 8'), 
                   sg.Text(str(config.DDS_SWEEP_TIME), size=(10, 1), key = '-SWEEPTIME-', text_color='#bfbfbf', font='Helvetica 12'), 
                   sg.Text('s', font='Helvetica 8')],
                  [sg.Text(' ')],
                  [sg.Text('New Parameters (Set then update):',font='Helvetica 10 bold')],
                  [sg.Text('Start Frequency:', size=(22, 1), font='Helvetica 8'), 
                   sg.InputText(str(config.DDS_SWEEP_START), size=(10, 1), key = '-NEWSTARTHZ-', font='Helvetica 12'), 
                   sg.Text('Hz', font='Helvetica 8')],
                  [sg.Text('Stop Frequency:', size=(22, 1), font='Helvetica 8'), 
                   sg.InputText(str(config.DDS_SWEEP_STOP), size=(10, 1), key = '-NEWSTOPHZ-', font='Helvetica 12'), 
                   sg.Text('Hz', font='Helvetica 8')],
                  [sg.Text('Sweep Duration:', size=(22, 1), font='Helvetica 8'), 
                   sg.InputText(str(config.DDS_SWEEP_TIME), size=(10, 1), key = '-NEWSWEEPTIME-', font='Helvetica 12'), 
                   sg.Text('s', font='Helvetica 8')],
                  [sg.Text('Confirm new values:',font='Helvetica 10'),sg.Button('Update Parameters', size=(14, 1), enable_events=True, key = '-UPDATEUSW-',font='Helvetica 10')],
                  [sg.Text(' ')],
                  [sg.Text('Acoustic Focussing Mode:', font='Helvetica 12')],
                  [sg.Radio('ON', '-USW-',size = (6,1), enable_events=True, key='-USWON-', default=False), sg.Radio('OFF', '-USW-', size=(6,1), enable_events=True, key='-USWOFF-', default=True), sg.Radio('TONE', '-USW-', size=(6,1), enable_events=True, key='-USWCHIRP-', default=False)]
                   ])
    messagelogframe = sg.Frame('Message Log', [[sg.Output(size=(80,16), background_color='black', text_color='white', echo_stdout_stderr = True)]])

    liveviewframe = sg.Frame('Live View Controls', [[
                sg.Button('Toggle Live View', size=(20, 1), enable_events=True, key = '-TOGGLELIVEVIEW-',font='Helvetica 12'),
                sg.Text('Placeholder for FPS', font='Helvetica 12')]])

   
    fluidicframe = sg.Frame('Fluidic Controls',[
                [sg.Text('Current Valve:', size=(14, 1), font='Helvetica 12'), 
                   sg.Text(str(config.valveselected), size=(8, 1), key = '-VALVE-', text_color='#bfbfbf', font='Helvetica 12')],
                [sg.Text('New Valve:', size=(14, 1), font='Helvetica 12'), 
                   sg.InputText(str(config.valveselected), size=(8, 1), key = '-NEWVALVE-', font='Helvetica 12'), sg.Button('Set', enable_events=True, key='-SETVALVE-',)],
                [sg.Text('Pump Enable', size=(14, 1), font='Helvetica 10'), sg.Radio('ON', '-PUMPEN-',size = (7,1), enable_events=True, key='-PUMPON-', default=False), sg.Radio('OFF', '-PUMPEN-', size=(7,1), enable_events=True, key='-PUMPOFF-', default=True)],
                [sg.Text('Pump Direction', size=(14, 1),font='Helvetica 10'), sg.Radio('FORWARD', '-PUMPDIR-',size = (7,1), enable_events=True, key='-PUMPf-', default=True), sg.Radio('REVERSE', '-PUMPDIR-', size=(7,1), enable_events=True, key='-PUMPr-', default=False)],
                ])

    # define the window layout
    layout = [[sg.Text('PhytoCap GUI', size=(40, 1), justification='center', font='Helvetica 20')],
              [sg.Image(filename='', key='image'),
               sg.Column([[acousticframe], [fluidicframe]])],
              [liveviewframe, 
               sg.Button('Exit', size=(10, 1), font='Helvetica 12'),],
              [messagelogframe]
              ]

    # create the window and show it without the plot
    window = sg.Window('PhytoCap GUI',
                       layout, location=(800, 400))

    # ---===--- Event LOOP Read and display frames, operate the GUI --- #
    cap = camera.cameraclass()
    cap.init()
    cap.setgain(10)

    lv = False
    usw = False
    chirping = False
    chirpstart = None
    while True:
        
        event, values = window.read(timeout=20)
        if event == 'Exit' or event == sg.WIN_CLOSED:
            cap.closeconnection()
            return

        elif event == '-TOGGLELIVEVIEW-':
            lv = not lv

        elif event == 'Abort':
            lv = False
            cap.abortcapture()

        elif event == '-USWCHIRP-':
            t = gpio.usw_tone()
            print('Connection Test: Transducer now playing an audible tone!')
            window.FindElement('-UPDATEUSW-').Update(disabled=True)
            window.FindElement('-NEWSTARTHZ-').Update(disabled=True)
            window.FindElement('-NEWSTOPHZ-').Update(disabled=True)
            window.FindElement('-NEWSWEEPTIME-').Update(disabled=True)
            usw = False

        elif event == '-USWON-':
            print('Acoustic Focussing Enabled')
            # turn usw on
            usw = True
            t = gpio.usw_on()
            window.FindElement('-UPDATEUSW-').Update(disabled=True)
            window.FindElement('-NEWSTARTHZ-').Update(disabled=True)
            window.FindElement('-NEWSTOPHZ-').Update(disabled=True)
            window.FindElement('-NEWSWEEPTIME-').Update(disabled=True)

        elif event == '-USWOFF-':
            print('Acoustic Focussing Disabled')
            # turn usw off
            usw = False
            gpio.usw_off(t)
            window.FindElement('-UPDATEUSW-').Update(disabled=False)
            window.FindElement('-NEWSTARTHZ-').Update(disabled=False)
            window.FindElement('-NEWSTOPHZ-').Update(disabled=False)
            window.FindElement('-NEWSWEEPTIME-').Update(disabled=False)
       
        elif event == '-UPDATEUSW-':
            # write parameters into config.py
            new_sweep_start = int(values['-NEWSTARTHZ-'])
            new_sweep_stop = int(values['-NEWSTOPHZ-'])
            new_sweep_time = float(values['-NEWSWEEPTIME-'])
            print(f'Updated USW config. New parameters:\n  Sweep Start: {new_sweep_start}, Sweep Stop: {new_sweep_stop}, Sweep Time: {new_sweep_time}')
            config.DDS_SWEEP_START = new_sweep_start
            config.DDS_SWEEP_STOP = new_sweep_stop
            config.DDS_SWEEP_TIME = new_sweep_time
 
        elif event == '-PUMPON-':
            print('Pump Enabled')
            gpio.pumpenable(True)
          
        elif event == '-PUMPOFF-':
            print('Pump Disabled')
            gpio.pumpenable(False)
          
        elif event == '-PUMPf-':
            print('Pump set to Forward')
            gpio.pumpdirection(False)
          
        elif event == '-PUMPr-':
            print('Pump set to Reverse')
            gpio.pumpdirection(True)

        elif event == '-SETVALVE-':
            valve = int(values['-NEWVALVE-'])
            print(f'Valve set to: {valve}')
            config.valveselected = valve
            gpio.valve(valve)

        if lv:
            frame = cap.grabimage()
            frame = cv2.resize(frame, tuple(reversed(imgsize)), interpolation=cv2.INTER_AREA)
            imgbytes = cv2.imencode('.png', frame)[1].tobytes()  # ditto
            window['image'].update(data=imgbytes)

        if not lv:
            img = np.full(imgsize, 180)
            # this is faster, shorter and needs less includes
            imgbytes = cv2.imencode('.png', img)[1].tobytes()
            window['image'].update(data=imgbytes)


        window.Element('-STARTHZ-').Update(value=str(config.DDS_SWEEP_START))
        window.Element('-STOPHZ-').Update(value=str(config.DDS_SWEEP_STOP))
        window.Element('-SWEEPTIME-').Update(value=str(config.DDS_SWEEP_TIME))
        window.Element('-VALVE-').Update(value=str(config.valveselected))

## Print function for timestamping console messages:
old_print = print

def timestamped_print(*args, **kwargs):
  old_print(str(datetime.now())[:-4], *args, **kwargs)

print = timestamped_print
 
## Welcome console message
print(f'GUI Launched.\nCurrent Valve:  {config.valveselected}\nPump Enable:  {str(config.pumpenable)}\nPump Direction:  {config.pumpdirection}')

## Run main loop
main()
