from threading import Thread
import cv2
import EasyPySpin
import PySpin

def set_cam_properties(cam):
    #TODO: exposure (305). Fix red/blue balance (or are images BGR instead of RGB?).
    # Retrieve Pixel Format node
    node_imageformat = PySpin.CEnumerationPtr(cam.nodemap.GetNode("PixelFormat"))
    # EnumEntry node for RGB8 format
    imageformat_rgb8 = node_imageformat.GetEntryByName("RGB8")
    # Set pixel format to RGB8
    node_imageformat.SetIntValue(imageformat_rgb8.GetValue())
    # Retrieve BalanceRatioSelector and BalanceRatio nodes
    node_balanceratioselector = PySpin.CEnumerationPtr(cam.nodemap.GetNode("BalanceRatioSelector"))
    node_balanceratio = PySpin.CFloatPtr(cam.nodemap.GetNode("BalanceRatio"))
    # Set BalanceRatioSelector to Blue channel
    balance_select_blue = node_balanceratioselector.GetEntryByName("Blue")
    node_balanceratioselector.SetIntValue(balance_select_blue.GetValue())
    # Set blue channel to 1.5
    node_balanceratio.SetValue(1.5)
    # Set BalanceRatioSelector to Red channel
    balance_select_red = node_balanceratioselector.GetEntryByName("Red")
    node_balanceratioselector.SetIntValue(balance_select_red.GetValue())
    # Set red channel to 2.0
    node_balanceratio.SetValue(1.9)
    # Retrieve Gain node
    node_iGain_float = PySpin.CFloatPtr(cam.nodemap.GetNode("Gain"))
    # Set gain to 18 dB
    node_iGain_float.SetValue(19)
    return cam

class VideoGet:
    """
    Class that continuously gets frames from a VideoCapture object
    with a dedicated thread.
    """

    def __init__(self, src=0):
        self.stream = EasyPySpin.VideoCapture(src)
        self.stream = set_cam_properties(self.stream)
        (self.grabbed, self.frame) = self.stream.read()
        self.stopped = False

    def start(self):    
        Thread(target=self.get, args=()).start()
        return self

    def get(self):
        while not self.stopped:
            if not self.grabbed:
                self.stop()
            else:
                (self.grabbed, self.frame) = self.stream.read()

    def stop(self):
        self.stopped = True
