import os
import datetime
import statistics
from matplotlib import pyplot as plt


def get_fps_of_captured_images(folder, plot=True):
    filenames = os.listdir(folder)
    timestamps = [x[:-4] for x in filenames]
    timestamps = [datetime.datetime.strptime(
        x, '%d-%m-%Y-%H_%M_%S_%f') for x in timestamps]
    timestamps.sort()
    timedeltas = [timestamps[i]-timestamps[i-1]
                  for i in range(1, len(timestamps))]
    mean_timedelta = sum(timedeltas, datetime.timedelta(0)) / len(timedeltas)
    median_timedelta = statistics.median(timedeltas)
    min_timedelta = min(timedeltas)
    max_timedelta = max(timedeltas)
    min_fps = datetime.timedelta(0, 1)/max_timedelta
    max_fps = datetime.timedelta(0, 1)/min_timedelta
    mean_fps = datetime.timedelta(0, 1)/mean_timedelta
    median_fps = datetime.timedelta(0, 1)/median_timedelta
    print('min fps = ' + str(min_fps))
    print('max fps = ' + str(max_fps))
    print('average fps = ' + str(mean_fps))
    print('median fps = ' + str(median_fps))
    all_fps = [datetime.timedelta(0, 1)/t for t in timedeltas]
    if plot:
        plt.hist(all_fps, 50)
        plt.xlabel('FPS')
        plt.ylabel('Frequency')
        plt.text(mean_fps-4, 600, str('Mean FPS = ' + str(mean_fps)))
        plt.text(min_fps, 20, str('Min FPS = ' + str(min_fps)))
        plt.text(max_fps, 100, str('Max FPS = ' + str(max_fps)))
        plt.text(median_fps, 900, str('Median FPS = ' + str(median_fps)))
        plt.show()


def get_imaging_duration(folder):
    filenames = os.listdir(folder)
    timestamps = [x[:-4] for x in filenames]
    timestamps = [datetime.datetime.strptime(
        x, '%d-%m-%Y-%H_%M_%S_%f') for x in timestamps]
    timestamps.sort()
    dur = max(timestamps)-min(timestamps)
    print('Imaging lasted ' + str(dur))
    return dur
