''' Contains global variables and commonly used objects'''
# TODO: comments, layout

os = 'Linux'

pumpdirection = 'f'
pumpenable = False

valveselected = 1

loopsave = False
loopcommands = []
loopiterations = 0


### USED IN GPIO CONTROL
# BOARD NUMBERS (https://www.jetsonhacks.com/nvidia-jetson-nano-j41-header-pinout/)
GPIO_VALVE_IN4 = 37
GPIO_VALVE_IN3 = 35
GPIO_VALVE_IN2 = 33
GPIO_VALVE_IN1 = 31
GPIO_PUMP_ENABLE = 29
GPIO_PUMP_DIR = 23
GPIO_TRANSISTOR_SPARE = 21  # Connected to the darlington array but not used yet

GPIO_DDS_LOAD = 13
GPIO_DDS_CLOCK = 15
GPIO_DDS_DATA = 11
GPIO_DDS_RESET = 7

DDS_ACTIVE = True
DDS_CLOCK = 125000000
DDS_1M = 4294967295/125  # Suitable for 125M Crystal
DDS_SWEEP_START =  1700000 #5000 
DDS_SWEEP_STOP =   1800000 #11000  
DDS_SWEEP_TIME = 0.001  # seconds
DDS_STEPS_PER_SEC = 1352
DDS_SWEEP_STEP = (DDS_SWEEP_STOP-DDS_SWEEP_START) / \
    DDS_STEPS_PER_SEC/DDS_SWEEP_TIME




### USED IN ANALYSIS:

backgroundimage = ''  # Path to newest background image
bgblur = None  # Stores a grayscale, resized and blurred copy of the current working background image for analysis

pixelsize = 5.86  # (um) length of (square) pixels of camera
image_h_px = 1200  # pixel height of image
image_w_px = 1920  # pixel width of image
magnification = 10  # magnification (X) of objective
flowcelldepth = 390  # (um) depth of flow cell
flowcellwidth = 6000  # (um) width of full flow cell (not just imaged portion)
cubic_micron_to_ml = 1e-12  # number of cubic micrometres in 1 ml

# TODO: add equations to calculate these (poiseulle flow from COMSOL)
# (um/s) minimum linear velocity of particles (at 1.5ml/min volumetric flow rate in the whole flow cell)
vxmin = 20000
vxmax = 24000  #

image_h_um = image_h_px * (pixelsize / magnification)
image_w_um = image_w_px * (pixelsize / magnification)
image_volume_um = image_h_um * image_w_um * flowcelldepth  # um^3
image_volume_ml = cubic_micron_to_ml * image_volume_um

# (s) minimum time for a particle to cross through the entire FoV in the direction of flow
minpassagetime = image_h_um/vxmax
maxpassagetime = image_h_um/vxmin

# the maximum frame rate that would be required to capture everything within the FoV
maxrequiredfps = 1/minpassagetime
minrequiredfps = 1/maxpassagetime

ratio_imaged_to_full_width = image_w_um/flowcellwidth

images_per_ml = 1/image_volume_ml

resizeratio = 0.5  # resize ratio for image analysis speedup:


