# example_instructions.py
#
# Written by Anthony 16th December 2020
#
# This file demonstrates the functionality of the Jetson-controlled IFC,
# by performing the following imaging instructions from a script:
#
# Select valve 1 
# Turn on acoustic focussing
# Turn the pump on in forward direction and delay 30s for tube to fill
# Take 1000 images
# Select valve 2
# Delay 30s  to replace fluid in the flow cell
# Turn off pump and USW and safely exit


# Imports: 
# These are always required and should be at the top of every instruction script
import config
import camera
import gpio
import time

# Create a camera object - this object enables camera functionality
cam = camera.cameraclass()

# Initialise the camera. Connect over USB and apply default settings 
# (Gain, Red/Blue balance, RGB8 pixel format, .jpg image type,
# /captures/test/ save directory.)
cam.init()

# Turn on ultrasound - uses the freuency and time settings in config.py
gpio.usw_on()

# Actuate the valve selector to connect the pump to valve 1
gpio.valve(1)

# Turn on the peristaltic pump in forward direction
gpio.pumpenable(enable=True)
gpio.pumpdirection(direction=True)

# Wait 20s
time.sleep(30) 

# Take 1000 images at Max FPS and save them to the default directory
cam.capture_n(1000)

# Connect to valve 2
gpio.valve(2)

# Wait 30s
time.sleep(30)

# Turn off pump and ultrasound
gpio.pump(enable=False)
gpio.usw_off()

# Close the camera connection (REQUIRED to allow the camera to work later without reconnecting)
cam.closeconnection()
