from threading import Thread
import cv2
import datetime

class VideoSave:
    """
    Class that continuously shows a frame using a dedicated thread.
    """

    def __init__(self, frame=None):
        self.frame = frame
        self.stopped = False

    def start(self):
        Thread(target=self.save, args=()).start()
        return self

    def save(self):
        while not self.stopped:
            cv2.imwrite(str(datetime.datetime.now().strftime('%d-%m-%Y-%H_%M_%S_%f')[:-3]  + '.jpg'), self.frame)


    def stop(self):
        self.stopped = True
