import argparse
import os
import cv2
from CountsPerSec import CountsPerSec
from VideoGet import VideoGet
from VideoSave import VideoSave


def putIterationsPerSec(frame, iterations_per_sec):
    """
    Add iterations per second text to lower-left corner of a frame.
    """
    cv2.putText(frame, "{:.0f} iterations/sec".format(iterations_per_sec),
        (10, 450), cv2.FONT_HERSHEY_SIMPLEX, 1.0, (255, 255, 255))
    return frame


def threadBoth(source=0):
    """
    Dedicated thread for grabbing video frames with VideoGet object.
    Dedicated thread for showing video frames with VideoShow object.
    Main thread serves only to pass frames between VideoGet and
    VideoShow objects/threads.
    """
    video_getter = VideoGet(source).start()
    video_saver = VideoSave(video_getter.frame).start()
    cps = CountsPerSec().start()
    while True:
        if video_getter.stopped or video_saver.stopped:
            video_saver.stop()
            video_getter.stop()
            break
        frame = video_getter.frame
        frame = putIterationsPerSec(frame, cps.countsPerSec())
        video_saver.frame = frame
        cps.increment()

