function [intensityGradient] = calculateGradient(h,sigmaGauss,scale)
%calculateSmoothedGradient(h,sigmaGauss) smoothes h using a Gaussian filter
%then calculates the gradient and sums its intensity
arguments
    h double % thickness data
    sigmaGauss double = 1 % standard deviation of Gaussian smoothing filter
    scale double = 0.112 % mm/pixel
end

if sigmaGauss > 0
    hFilt = imgaussfilt(h,sigmaGauss,'FilterDomain','spatial');
else
    hFilt = h;
end

% Calculate gradient and gradient intensity
[gradientX,gradientY] = gradient(hFilt,scale); 
intensityGradient = gradientX.^2+gradientY.^2;
end