function [h] = intensityToThickness(intensity,param)
%intensityToThickness Converts from X-ray intensity to air thickness
arguments
    intensity double
    param struct = struct('I0',61099,'lambda',35,'T1',0.71,'Tc',0.054,'H',100) % lambda, H in mm
end
T = intensity / param.I0;
h = param.H + param.lambda * log((T - param.Tc)/param.T1);
end