#!/usr/bin/env Rscript

svg( "ext-abstract-plot.svg", width=7, height=5 );

layout( matrix( c( 1, 3, 2, 4 ), 2, 2 ), TRUE );
par( mgp = c( 2, 1, 0 ), mar = c( 3, 3, 3, 1 ) + 0.1 );

graphs <- data.frame(
	file = c( "gel", "under", "10cm", "20cm" ),
	title = c( "Gel Electrode", "Op-Amp under Knitted Electrode",
		"Op-Amp 10cm Away", "Op-Amp 20cm Away" ),
	invert = c( TRUE, FALSE, FALSE, TRUE ) );

x <- apply( graphs, 1, function( row ) {

	raw <- read.csv(
		paste0( "raw/", row['file'], ".csv" ), header = TRUE );
	smooth <- read.csv(
		paste0( "smooth/", row['file'], ".csv" ), header = TRUE );

	raw <- raw[raw$TIME > -0.5 & raw$TIME < 0.5,];
	smooth <- smooth[smooth$TIME > -0.5 & smooth$TIME < 0.5,];

	if ( row['invert'] ) {
		raw$OUTPUT <- -1 * raw$OUTPUT;
		smooth$AMPLITUDE <- -1 * smooth$AMPLITUDE;
	}

	plot( c( -0.5, 0.5 ), range( c( raw$OUTPUT, smooth$AMPLITUDE ) ),
		type = "n",
		main = row['title'],
		xlab = "Time / s", ylab = "Voltage / V" );

	lines( raw$TIME, raw$OUTPUT, col = "#FF0000", lwd = 1.5 );
	lines( smooth$TIME, smooth$AMPLITUDE, col = "#000000", lwd = 1 );

} );
