#!/usr/bin/env Rscript

box = 1000;
skip = 10;

data <- read.csv( file = "stdin", header = TRUE );

new_data <- data.frame( TIME = c(), AMPLITUDE = c() );

for ( i in seq( 1, length( data$TIME ) - box, skip ) ) {

	write( i / ( length( data$TIME ) - box ), stderr() );

	amp <- sum( data$OUTPUT[i:(i+box)] ) / box;

	new_data <- rbind( new_data,
		data.frame(
			TIME = data$TIME[i + box / 2],
			AMPLITUDE = amp,
			NOISE = data$OUTPUT[i + box / 2] - amp ) );
	
}

write.csv( new_data, file = "/dev/fd/1", row.names = FALSE );
