#
#  Please set MAFpt_YAML_ROOT & MAFpt_YAML_FILE to your unit test versions
#
# This version was built to implement tests for Building a bigger test set
#     It adds in additional graph data (use v3 for alder tests)
import os
from datetime import datetime
#import pandas as pd

# https://stackoverflow.com/questions/45350222/select-nodes-and-edges-form-networkx-graph-with-attributes


import MAFpt_r_params as rpar
import MAFpt_ATTACK_DB_v2 as ATTACK

import networkx as nx

from MAFpt_ATTACK_DB_ATTACK_GRAPHS_DATA_AUTO import ThisAttackTechList 

# Globals
Verbose = True
ATTACK_MAFPT_NX_GRAPH=0


# Write a node in the attack sequence graph.
def WriteATTACKGraphNode(Type, 
                                        ID, 
                                        NodeName, 
                                        ThisCreateDate): 
                                          
            # Use global above.
            global ATTACK_MAFPT_NX_GRAPH 
            global ATTACK_LOCAL_FILE_ROOT
            
            GraphFileFormat = "GEXF"
            
            #print("WAG: " + str(Type) + " and " + str(ID))
             
            # if Graph object not prepared then prepare it
            if ATTACK_MAFPT_NX_GRAPH == 0:
                #print("Intialise")
                if Verbose:
                    print("WriteATTACKGraphNode: InitialiseDataGraph")
            
                # Prepare graph
                ATTACK_MAFPT_NX_GRAPH=nx.MultiDiGraph()
                
            # If we are closing then write the graph file.                
            if Type == "CLOSE":
                if GraphFileFormat == "GEXF":
                    if Verbose:
                        print("WriteATTACKGraphNode: CloseDataGraph")
                    GraphFile=ATTACK_LOCAL_FILE_ROOT + "MAFpt_ATTACKS_GRAPH_v5.gexf"
                    exists = os.path.exists(GraphFile)
                    if (exists):
                       os.remove(GraphFile)
                    # Write out the graph in GEXF format
                    nx.write_gexf(ATTACK_MAFPT_NX_GRAPH, GraphFile)
                    print(str(nx.info(ATTACK_MAFPT_NX_GRAPH)))
                    return()
            if Verbose:
                print("WriteATTACKGraphNode: WriteDataNode : " + str(ID)) 
            if Verbose:
                print("WriteATTACKGraphNode: WriteDataNode : Create Node Type: <" + str(Type) + "> NodeName: <" + str(NodeName) + ">")     
                    
            ATTACK_MAFPT_NX_GRAPH.add_node(str(ID), 
                                                                    name=NodeName, 
                                                                    create_date=str(ThisCreateDate), 
                                                                    type=Type)

def WriteATTACKGraphEdge(
                                        AttackID, 
                                        FromID, 
                                        ToID, 
                                        ThisCreateDate, 
                                        EdgeType, 
                                        Count, 
                                        KC): 
            #  For reference
            #      Type 0= Tech Chain Edge
            #      Type  1= Tech Support Edge
            #       Type 2 = Tactic Chain Edge
            #       Type 3 = Tech Tactic
            #       Type 4 = Support Tech Tactic
            #           # Use global above.
            global ATTACK_MAFPT_NX_GRAPH 
            global ATTACK_LOCAL_FILE_ROOT  
            
            # Type = CWE | CVE | CWE | CAPEC | TOOL | MALWARE 
            # Type = | SUBTECH | TECH | GROUP
            GraphFileFormat = "GEXF"
            
            #print("WAG: " + str(Type) + " and " + str(ID))
             
            # if Graph object not prepared then prepare it
            if ATTACK_MAFPT_NX_GRAPH == 0:
                #print("Intialise")
                if Verbose:
                    print("WriteATTACKGraphNode: InitialiseDataGraph")
            
                # Prepare graph
                ATTACK_MAFPT_NX_GRAPH=nx.MultiDiGraph()
                
            # If we are closing then write the graph file.                
            if ToID == "CLOSE":
                if GraphFileFormat == "GEXF":
                    if Verbose:
                        print("WriteATTACKGraphEdge: CloseDataGraph")
                    GraphFile=ATTACK_LOCAL_FILE_ROOT + "MAFpt_ATTACKS_GRAPH_v5.gexf"
                    exists = os.path.exists(GraphFile)
                    if (exists):
                       os.remove(GraphFile)
                    # Write out the graph in GEXF format
                    nx.write_gexf(ATTACK_MAFPT_NX_GRAPH, GraphFile)
                    print(str(nx.info(ATTACK_MAFPT_NX_GRAPH)))
                    return()
                    
            #G.add_edge(str(FromType + "_" + FromID),
            #                 str(ToType + "_" + ToID), 
            #                 cat=str(FromType + "_EDGE_" + ToType), 
            #                 create_date=str(EdgeCreateDate))
            edge_name=AttackID + "_" + FromID + "_" +  "_" + ToID
            if Verbose:
                print("WriteATTACKGraphEdge: WriteDataEdge : [" +  str(EdgeType) + "] [" +str(Count) + "] " + str(FromID) + " " +
                                                                          str(ToID)  + " " + str(edge_name) + "[" + str(KC) + "]")            
            ATTACK_MAFPT_NX_GRAPH.add_edge(FromID, 
                                                                    ToID, 
                                                                    attack_id=AttackID , 
                                                                    count=Count, 
                                                                    name=edge_name, 
                                                                    create_date=str(ThisCreateDate), 
                                                                    edgetype=EdgeType, 
                                                                    KC=KC
                                                                    )                                                
                                                                    
           



print("<< STARTING ATTACK DB ATTACK GRAPH")

YAML_Root = os.environ.get('MAFpt_YAML_ROOT')
YAML_File = os.environ.get('MAFpt_YAML_FILE')
YAML_File="MAFpt_RunParams.yaml"

YAML_Root = os.getcwd()
YAML_File="/MAFpt_ATTACK_DB_TEST_RunParams.yaml"

#p_obj = MAFpt_r_params.MAFpt_r_params(YAML_Root + YAML_Dir + YAML_File)

p_obj = rpar.MAFpt_r_params(YAML_Root + YAML_File)

ck_load=p_obj.MAFpt_r_ck_load()

if ck_load == 0:
    print("MAFpt: Unable to access parameter file")
    exit(1)

#HELP_RUN=p_obj.MAFpt_r_read("RUN_HELP")
#SUMM_STATS_RUN=p_obj.MAFpt_r_read("RUN_SUMM_STATS")
#TESTS_RUN=p_obj.MAFpt_r_read("RUN_TESTS")

#ATT_SRC=p_obj.MAFpt_r_read("RUN_ATT_SRC")
#CVE_SRC=p_obj.MAFpt_r_read("RUN_CVE_SRC")
DOWNLOAD_ATTACK=p_obj.MAFpt_r_read("RUN_DOWNLOAD_ATTACK")
REINDEX_ATTACK=p_obj.MAFpt_r_read("RUN_REINDEX_ATTACK")
ATTACK_LOCAL_FILE_ROOT = p_obj.MAFpt_r_read('RUN_ATTACK_LOCAL_FILE_ROOT')
ATTACK_TAXII_SERVER = p_obj.MAFpt_r_read('RUN_ATTACK_TAXII_SERVER')
ATTACK_LOCAL_COPY = p_obj.MAFpt_r_read('RUN_ATTACK_LOCAL_COPY')
ATTACK_CVE_SEARCH = p_obj.MAFpt_r_read('RUN_ATTACK_CVE_SEARCH')
ATTACK_MAIN_INDEX = p_obj.MAFpt_r_read('RUN_ATTACK_MAIN_INDEX')
ATTACK_SUB_INDEX = p_obj.MAFpt_r_read('RUN_ATTACK_SUB_INDEX')
ATTACK_CVE_REF_INDEX = p_obj.MAFpt_r_read('RUN_ATTACK_CVE_REF_INDEX')
ATTACK_TTP_INDEX = p_obj.MAFpt_r_read('RUN_ATTACK_TTP_INDEX')
ATTACK_TACTIC_INDEX = p_obj.MAFpt_r_read('RUN_ATTACK_TACTIC_INDEX')
ATTACK_TECH_TO_TACTIC_INDEX = p_obj.MAFpt_r_read('RUN_ATTACK_TECH_TO_TACTIC_INDEX')
ATTACK_REL_INDEX = p_obj.MAFpt_r_read('RUN_ATTACK_REL_INDEX')
ATTACK_TACTIC_BIN_INDEX = p_obj.MAFpt_r_read('RUN_ATTACK_TACTIC_BIN_INDEX')   
ATTACK_TTP_BIN_INDEX = p_obj.MAFpt_r_read('RUN_ATTACK_TTP_BIN_INDEX') 
        

  
ATTACK_obj = ATTACK.MAFpt_ATTACK_DB(DOWNLOAD_ATTACK,
                         ATTACK_TAXII_SERVER,
                         ATTACK_LOCAL_FILE_ROOT,
                         ATTACK_LOCAL_COPY,
                         REINDEX_ATTACK,
                         ATTACK_CVE_SEARCH, 
                         ATTACK_MAIN_INDEX, 
                         ATTACK_SUB_INDEX, 
                         ATTACK_CVE_REF_INDEX, 
                         ATTACK_TTP_INDEX, 
                         ATTACK_TACTIC_INDEX, 
                         ATTACK_TECH_TO_TACTIC_INDEX, 
                         ATTACK_REL_INDEX, 
                         ATTACK_TACTIC_BIN_INDEX, 
                         ATTACK_TTP_BIN_INDEX) 
                         


                         

# Example code to create a graph representation of an attack

# admin@338_001                                               
# TA0001 : Initial Access	T1566.001 : Spearphishing Attachment
# TA0002 : Execution	T1204.002 : Malicious File
# TA0002 : Execution	T1203 : Exploitation for Client Execution
# TA0011 : Command & Control	T1102.002 Web Service: Bidirectional Communication
# TA0011 : Command & Control	T1107.001 Application Layer Protocol : Web Protocols
# TA0011 : Command & Control	T1105 Ingress Tool Transfer
# TA0002 : Execution	T1059.003 Command and Scripting Interpreter: Windows Command Shell
# TA007 Discovery	T1083 File and Directory Discovery
# TA007 Discovery	T1082 System Information Discovery
# TA007 Discovery	T1016 System Network Configuration Discovery
# TA007 Discovery	T1007 System Service Discovery
# TA007 Discovery	T1069.001 Permission Groups Discovery: Local Groups
# TA007 Discovery	T1049 System Network Connections Discovery
# TA0011 : Command & Control	T1105 Ingress Tool Transfer
# TA0002 : Execution	T1059.003 Command and Scripting Interpreter: Windows Command Shell
# TA005 Defense Evasion	T1036.005 Masquerading: Match Legitimate Name or Location

LoadLimit=100
LoadCount=0
# Loop through the Attacks                               
for ThisAttack in ThisAttackTechList:

    # Loop through the attack steps (within each attack) building nodes and edges
    NodesToDate=[]
    TacticNodesToDate=[]
    IDLine=True
    Count=0
    SupportNodeList=[]
    edge_count=0      
    
    for NextNode in ThisAttack:
        
        Count=Count+1
        
        #for NextNode in NextAttack:
        if Verbose:
            print("MainNodeLoop: " + str(NextNode))
            
        # 
        # The following code is creating the graph nodes required to describe this attack
        #  For reference
        #      Type 1 = ID Node
        #      Type 2 = Tech Node
        #       Type 3 = Tactic Node
        #                                  
        
        # Create the ID Node    
        #    
        if IDLine==True:
            IDLine=False
            NodesToDate.append(NextNode["ID"])  
            TacticNodesToDate.append(NextNode["ID"])            
            # Write a root attack identification nade
            AttackIdentifier=NextNode["ID"]
            Type=1
            ID=AttackIdentifier
            NodeName=AttackIdentifier
            ThisCreateDate=datetime.today().strftime('%Y-%m-%d')
            
            WriteATTACKGraphNode(Type, 
                                            ID, 
                                            NodeName, 
                                            ThisCreateDate)   
                                            
            if "PredBy" in NextNode:
                if not NextNode["PredBy"] == "NA":
                    WriteATTACKGraphEdge(AttackIdentifier,                                             
                                            NextNode["PredBy"], 
                                            ID, 
                                            ThisCreateDate, 
                                            EdgeType=4, 
                                            Count=edge_count, 
                                            KC="NP-LMV" # Assume lateral movement for the moment
                                            )
                                                            
            continue
        # Create the Tech Node
        #
        Type=2
        ID=NextNode['Tech']
        # Keep a running ljst so we can go back to preds
        NodesToDate.append(ID)
        NodeName=ID
        ThisCreateDate=datetime.today().strftime('%Y-%m-%d')

        WriteATTACKGraphNode(Type, 
                                            ID, 
                                            NodeName, 
                                            ThisCreateDate) 
        
        # Ctreate the Tactic Node
        #
        Type=3
        TacticID=NextNode['Tactic']
        # Keep a running ljst so we can go back to preds
        TacticNodesToDate.append(TacticID)
        NodeName=TacticID
        ThisCreateDate=datetime.today().strftime('%Y-%m-%d')
 
        WriteATTACKGraphNode(Type, 
                                            TacticID, 
                                            NodeName, 
                                            ThisCreateDate) 
                                            
                                            
        # 
        # The following code is creating the edges to describe the Tech chain and the separate Tactic Chain for this attack
        #  
        #  For reference
        #      Type 0= Tech Chain Edge
        #      Type  1= Tech Support Edge
        #       Type 2 = Tactic Chain Edge
        #       Type 3 = Tech Tactic
        #       Type 4 = Pred Attack Edge (actioned with ID line)
        #                 
      
        if not "-" in NextNode['Pred']:
            #if NextNode['Pred']  == "":
                #Pred=0
            #else:
            # The 0th elements of NodesToDate will be the AttackID Root
            # See above for ID Line code
            Pred=NodesToDate[ int(NextNode['Pred'] )]
            TacticPred=TacticNodesToDate[ int(NextNode['Pred'] )]
            if NextNode['SG'] == "S":
                edge_type=0 #TechStep
                edge_count=edge_count+1
                KC=NextNode['KC']
                WriteATTACKGraphEdge(AttackIdentifier, 
                                            Pred, 
                                            ID, 
                                            ThisCreateDate, 
                                            EdgeType=edge_type, 
                                            Count=edge_count, 
                                            KC=KC
                                            )
                edge_type=2 #TacticStep                                
                WriteATTACKGraphEdge(
                                            AttackIdentifier, 
                                            TacticPred, 
                                            TacticID, 
                                            ThisCreateDate, 
                                            EdgeType=edge_type, 
                                            Count=edge_count, 
                                            KC=KC
                                            )
                                            
                edge_type=3 #TechTactc Edge                              
                WriteATTACKGraphEdge(
                                            AttackIdentifier, 
                                             ID, 
                                            TacticID, 
                                            ThisCreateDate, 
                                            EdgeType=edge_type, 
                                            Count=edge_count, 
                                            KC=KC
                                            )
                                            
                SuppEdge_count=0
                for NextSuppNode in SupportNodeList:
                    SuppEdge_count=edge_count
                    edge_type=1 #TechSupp
                    KC=NextSuppNode['KC']
                    WriteATTACKGraphEdge(AttackIdentifier, 
                                                ID, 
                                                NextSuppNode['Tech'], 
                                                ThisCreateDate, 
                                                EdgeType=edge_type, 
                                                Count=SuppEdge_count, 
                                                KC=KC
                                                )
                                                
                    edge_type=4 #SuppTechTactic Edge                              
                    WriteATTACKGraphEdge(
                                            AttackIdentifier, 
                                            NextSuppNode['Tech'],
                                            NextSuppNode['Tactic'], 
                                            ThisCreateDate, 
                                            EdgeType=edge_type, 
                                            Count=edge_count, 
                                            KC=KC
                                            )
                SupportNodeList=[]
            else:
                edge_count=edge_count+1
                # Store the Node as it is giving us support techniques for Step Node
                SupportNodeList.append(NextNode)
                
            continue
        
        # NO LONGER REQUIRED IN SPECIFICATION - ASSUMING ALL SEQUENTIAL
        # Deal with simple multiple predecessors (form m-n )
        Start=NextNode['Pred'].split('-')[0]
        End=NextNode['Pred'].split('-')[1]
    
        if Verbose:
            print("MainNodeLoop: " + "Start " + str(Start) + " : End " + str(End))
                                        
        for ThisPred in range(int(Start), int(End)+1):
            WriteATTACKGraphEdge(AttackIdentifier, 
                                            NodesToDate[ ThisPred ], 
                                            ID, 
                                            ThisCreateDate)
    
    LoadCount=LoadCount+1
    if LoadCount == LoadLimit:
        break # REMOVE THIS LATER
    
WriteATTACKGraphNode("CLOSE", 
                                            ID, 
                                            NodeName, 
                                            ThisCreateDate)   
                                        
       

exit(0)
