import os
import pandas as pd
import glob
import csv

print("Start the build")
print("Create or Append")
text = input("Create or Append or LoadFile : ")

if text.startswith("C"):
    print("Create")
elif text.startswith("A"):
    print("Append")
elif text.startswith("L"):
    print("CSV")
else:
    print("Invalid")
    exit(0)
    
    
fname="MAFpt_ATTACK_DB_ATTACK_GRAPHS_DATA_AUTO.py"
    
if text.startswith("C"):
    f=open(fname,  "w+")
    f.write("ThisAttackTechList=[\n")
else:
    f=open(fname,  "a")
    f.write("<<< APPENDING FROM HERE MANUAL CLEAN REQUIRED >>>")
    f.write("ThisAttackTechList=[\n")

if not text.startswith("L"):
    ACount=1
    while(True) : 
        print("Attack Count is " + str(ACount))
        text = input("Next Attack Chain ID : ")
        if text == "END":
            f.write("]\n")
            break
        else:
            if not ACount == 1:
                f.write("],\n")
            ACount = ACount + 1
        f.write("[\n")
        #  {"ID":"Transparent_Tribe_001"},
        f.write("{'ID':'" + text + "','Version':'0.1'},\n")
        print("Build lines for this attack")
        LCount=1
        while(True):
            text=[]
            print("Line count is " + str(LCount))
            text.append(input("ID : "))
            if LCount == 1:
                print("")
            else:
                if text[0] == "END":
                    f.write("}\n")
                    break
                else:
                    f.write("},\n")
            text.append(input("Tactic : "))
            text.append(input("Technique : "))
            text.append(input("Pred : "))
            text.append(input("Tinc : "))
            text.append(input("S/G : "))
            text.append(input("KC : "))
            #text=text.split(',')
    
            # {"StepNo":"1", "Tech":"T1566.001", "Pred":"0"}
            f.write("{'StepNo':'" + text[0] + "'"  +
                      ",'Tactic':'" + text[1] + "'"  +
                      ",'Tech':'" + text[2] + "'"  +
                      ",'Pred':'" + text[3] + "'"  +
                      ",'Tinc':'" + text[4] + "'"  +
                      ",'SG':'" + text[5] + "'" + 
                      ",'KC':'" + text[6] + "'" )
            
            LCount = LCount + 1
            
else:
    # Open the CSV file (as a dataframe
    
    # Look in C:\Users\chris\OneDrive - University of Southampton\ATTACK_DB_TEST\AttackModels for the attacks
    # 
    # Get a list of files
    print("<< Loading files >>")   
    IGNORE_LIST=[]
    ONLY_USE_LIST=['ZAPT29_005_META_v0_1.csv']
    res = glob.glob("C:/Users/chris/OneDrive - University of Southampton/ATTACK_DB_TEST/AttackModels/*.csv")
    FirstFile=True
    for fname in res:
        print("Loading: " + fname)
        fname_base=os.path.basename(fname)
        
        # Check this is a file we want to process
        if fname in IGNORE_LIST:
            continue
        
        if len(ONLY_USE_LIST) > 0:
            if not fname_base in ONLY_USE_LIST:
                continue
        
        # Unpack the filename (break up using '_')
        text=os.path.basename(fname).split('.')
        text=text[0].split('_')
        # Version is in the last two elements
        # Not stricty necessary bt put a point in the middel
        Version=text[len(text)-2] + "." + text[len(text)-1]
        # Now create the ID string using the items up to the version number
        # But ignore the META tag if present (this is the latest format version)
        ID=""
        META_VERSION=False
        for frag in text[0:len(text)-2]:
            if not frag == "META":
                ID=ID+ frag + "_"
            else:
                META_VERSION=True
        ID=ID[:-1]
            
        if FirstFile == True:
            FirstFile=False
        else:
            f.write("],\n")
            
        if META_VERSION == False:
            f.write("[\n")                
            f.write("{'ID':'" + ID + "','Version':'" + Version + "'},\n")
        else:
            print("This is a new META version file")
            ThisAttackFile=open(fname)
            csv_reader = csv.reader(ThisAttackFile, delimiter=',')
            PRED="NA"
            for row in csv_reader:
                if row[1] == "Preceded By":
                    PRED=row[2]
                if row[0] == "ID":
                    break
            ThisAttackFile.close()
            
            f.write("[\n")                
            f.write("{'ID':'" + ID + "','Version':'" + Version + "','PredBy':'" + PRED + "'},\n")
            
            # Read the file to find 'Related Attack Patterns' record
            
        print("Header finished")    
        
        #print("About to read csv")
        if META_VERSION == False:
             ThisAttackDF=pd.read_csv(fname, 
                                                           header=2, 
                                                           na_filter=False)
        else:
            ThisAttackDF=pd.read_csv(fname, 
                                                           header=15, 
                                                           na_filter=False)
        #print("Read csv")
                                                           
        # Step through each row of the dataframe
        #for col in ThisAttackDF.columns:
            #print(col)
        
        FirstRow=True
        LCount=0
        for index, row in ThisAttackDF.iterrows():
            #print(row['ID'], row['Tactic'], row['Technique'], row['Pred'], row['TInc'], row['S/G'], row['KC Step'], row['Notes'])
            #print("Line count is " + str(LCount))
            if FirstRow == True:
                FirstRow=False
            else:
                 f.write("},\n")
                 
            f.write("{'StepNo':'" + str(row['ID']) + "'"  +
                      ",'Tactic':'" + str(row['Tactic'][0:6]) + "'"  +
                      ",'Tech':'" + str(row['Technique'].split(" ")[0]) + "'"  +
                      ",'Pred':'" + str(row['Pred']) + "'"  +
                      ",'Tinc':'" + str(row['TInc']) + "'"  +
                      ",'SG':'" + str(row['S/G']) + "'" + 
                      ",'KC':'" + str(row['KC Step']) + "'" )
                      
               
                      
            LCount = LCount + 1
        f.write("}\n") 
        print("Loaded " + str(LCount) + " lines")        
    f.write("]\n")
f.write("]\n")        
f.close()
    
