
#__author__ = "Chris Maidens"
#__copyright__ = "Copyright (C) 2020 Chris Maidens"
#__license__ = "No license granted"
#__version__ = "0.1"

# https://www.datacamp.com/tutorial/markov-chains-python-tutorial
# https://stackoverflow.com/questions/58048810/building-n-th-order-markovian-transition-matrix-from-a-given-sequence
# https://stats.stackexchange.com/questions/147164/fit-and-evaluate-a-second-order-transition-matrix-markov-process-in-r
# https://stats.stackexchange.com/questions/512221/creating-transition-states-for-a-second-order-markov-chain-for-attribution
import os
import numpy as np

import MAFpt_r_params as rpar

import MAFpt_ATTACK_DB_v2 as ATTACK

# https://www.pythonpool.com/viterbi-algorithm-python/
def viterbi_algorithm_v2(observations, states, start_p, trans_p, emit_p):
     V = [{}]
     # Start DEBUG  
     #print("Initialising: First observation is " + str(observations[0]) + "(" + TechList[observations[0]] + ")")
     # End DEBUG  
     for st in states:
         # Start DEBUG  
         #print("For state " + str(st))
         # End DEBUG  
         V[0][st] = {"prob": start_p[st] * emit_p[st][observations[0]], "prev": None}
         # Start DEBUG  
         #print("The prob calc P[X0=" + str(st) + "]*P[Y0=" + str(observations[0]) + "|X0] is  " + str(start_p[st] * emit_p[st][observations[0]]))
         # End DEBUG  
   
     for t in range(1, len(observations)):
         # Start DEBUG  
         #print("<<>><<>> Next observation is : (" + str(t) + ")" + str(observations[t]) + "(" + TechList[observations[t]] + ")")
         # End DEBUG  
         V.append({})
         for st in states:
            # DEBUG
            #print("<<>> Next state calc is for : (" + str(t) + ")" + str(st) + "(" + TacticList[st] + ")")
            #PXN_XNMINUS1 = trans_p[states[t-1]][st]
            #print("P[X" + str(t-1) + "|X" +str(t) + "] is " + str(PXN_XNMINUS1))
            #PYN_XN = emit_p[st][observations[t]]
            #print("P[Y" + str(t) + "|X" +str(t) + "] is " + str(PYN_XN))
            
            #maxMUprev= V[t - 1][states[0]]["prob"]             
            # END DEBUG
            
            max_tr_prob = V[t - 1][states[0]]["prob"] * trans_p[states[0]][st]
            prev_st_selected = states[0]
            prev_st_new_selected = states[0]
            for prev_st in states[1:]:
                # DEBUG
                #if V[t - 1][prev_st]["prob"] > maxMUprev:
                #    maxMUprev = V[t - 1][prev_st]["prob"]
                #    prev_st_new_selected = prev_st
                # END DEBUG
                tr_prob = V[t - 1][prev_st]["prob"] * trans_p[prev_st][st]
                #if tr_prob > max_tr_prob:
                if tr_prob > max_tr_prob:
                    max_tr_prob = tr_prob
                    prev_st_selected = prev_st
            
            # Start DEBUG        
            #print("Max[Xprev] is : (" + str(maxMUprev)  + ")")
            #print("<< == The final calc gives " + str(maxMUprev*PXN_XNMINUS1*PYN_XN) + "/" + str(prev_st_new_selected))
            #max_prob_new=maxMUprev*PXN_XNMINUS1*PYN_XN
            # End DEBUG
 
            max_prob = max_tr_prob * emit_p[st][observations[t]]
            
            
            V[t][st] = {"prob": max_prob, "prev": prev_st_selected}
            # Start DEBUG        
            #print("<< == The final code calc gives " + str(max_prob) + " / " + str(prev_st_selected))
            #V[t][st] = {"prob": max_prob_new, "prev": prev_st_new_selected}
            # End DEBUG
     
     #for line in dptable(V):
        #print(line)
 
     opt = []
     max_prob = 0.0
     best_st = None
 
     for st, data in V[-1].items():
        # if data["prob"] > max_prob:
        #print("<< " + str(st))
        #print("<< " + str(data))
        if data["prob"] >= max_prob:
            max_prob = data["prob"]
            best_st = st
     opt.append(best_st)
     previous = best_st
 
     # DEBUG
     #print("<< " + str(len(V)))
     #print("<< " + str(previous))
     Count=0
     for NextV in V:
         #print("<< Next V " + str(Count))
         Count+=1
         #print(str(NextV))
     # End DEBUG
     
     for t in range(len(V) - 2, -1, -1):
        # DEBUG
        #print("Inserting " + str(V[t + 1][previous]["prev"]) + " from " + str(previous) + "  in " + str(t))
        # END DEBUG
        opt.insert(0, V[t + 1][previous]["prev"])
        previous = V[t + 1][previous]["prev"]
     # print ("The steps of states are " + " ".join(str(opt) ) + " with highest probability of %s" % max_prob)
     #print ("The steps of states are " + str(" ".join(str(opt) )) + " with highest probability of %s" % max_prob)
     
     return(opt)
     
def dptable(V):
     
    yield " ".join(("%12d" % i) for i in range(len(V)))
    for state in V[0]:
        yield "%.7s: " % state + " ".join("%.7s" % ("%f" % v[state]["prob"]) for v in V)

YAML_Root = os.environ.get('MAFpt_YAML_ROOT')
YAML_File = os.environ.get('MAFpt_YAML_FILE')
YAML_File="MAFpt_RunParams.yaml"

YAML_Root = os.getcwd()
YAML_File="/MAFpt_ATTACK_DB_TEST_RunParams.yaml"

p_obj = rpar.MAFpt_r_params(YAML_Root + YAML_File)

DOWNLOAD_ATTACK=p_obj.MAFpt_r_read("RUN_DOWNLOAD_ATTACK")
REINDEX_ATTACK=p_obj.MAFpt_r_read("RUN_REINDEX_ATTACK")
ATTACK_LOCAL_FILE_ROOT = p_obj.MAFpt_r_read('RUN_ATTACK_LOCAL_FILE_ROOT')
ATTACK_TAXII_SERVER = p_obj.MAFpt_r_read('RUN_ATTACK_TAXII_SERVER')
ATTACK_LOCAL_COPY = p_obj.MAFpt_r_read('RUN_ATTACK_LOCAL_COPY')
ATTACK_CVE_SEARCH = p_obj.MAFpt_r_read('RUN_ATTACK_CVE_SEARCH')
ATTACK_MAIN_INDEX = p_obj.MAFpt_r_read('RUN_ATTACK_MAIN_INDEX')
ATTACK_SUB_INDEX = p_obj.MAFpt_r_read('RUN_ATTACK_SUB_INDEX')
ATTACK_CVE_REF_INDEX = p_obj.MAFpt_r_read('RUN_ATTACK_CVE_REF_INDEX')
ATTACK_TTP_INDEX = p_obj.MAFpt_r_read('RUN_ATTACK_TTP_INDEX')
ATTACK_TACTIC_INDEX = p_obj.MAFpt_r_read('RUN_ATTACK_TACTIC_INDEX')
ATTACK_TECH_TO_TACTIC_INDEX = p_obj.MAFpt_r_read('RUN_ATTACK_TECH_TO_TACTIC_INDEX')
ATTACK_REL_INDEX = p_obj.MAFpt_r_read('RUN_ATTACK_REL_INDEX')    
ATTACK_TACTIC_BIN_INDEX = p_obj.MAFpt_r_read('RUN_ATTACK_TACTIC_BIN_INDEX')   
ATTACK_TTP_BIN_INDEX = p_obj.MAFpt_r_read('RUN_ATTACK_TTP_BIN_INDEX') 

ATTACK_obj = ATTACK.MAFpt_ATTACK_DB(DOWNLOAD_ATTACK,
                         ATTACK_TAXII_SERVER,
                         ATTACK_LOCAL_FILE_ROOT,
                         ATTACK_LOCAL_COPY,
                         REINDEX_ATTACK,
                         ATTACK_CVE_SEARCH, 
                         ATTACK_MAIN_INDEX, 
                         ATTACK_SUB_INDEX, 
                         ATTACK_CVE_REF_INDEX, 
                         ATTACK_TTP_INDEX, 
                         ATTACK_TACTIC_INDEX, 
                         ATTACK_TECH_TO_TACTIC_INDEX, 
                         ATTACK_REL_INDEX, 
                         ATTACK_TACTIC_BIN_INDEX, 
                         ATTACK_TTP_BIN_INDEX) 
                         
TacticBinDF=ATTACK_obj.GetTacticBinIndex()
                         

from MAFpt_ATTACK_DB_ATTACK_GRAPHS_DATA_AUTO import ThisAttackTechList 

AttackSeqTacticList=[]
AttackSeqTacticCount=[]
IDList=[]
count=0

ResultDicts=[]





# Fail list
FailList=[]


# This loop extracts the required pairs from the example Attack
DEPTH=2
OBSERVATION_LEN = 6

ONLY_USE=['ZAPT33_001']
ONLY_USE_LIST_FULL=['admin@338_001','ZAPT33_001']
ONLY_USE_LIST_FULL=['admin@338_001',  'Lazarus_Group_001']
ONLY_USE_LIST_26=['admin@338_001',  'Lazarus_Group_001',  'Lazarus_Group_002',  'APT32_001',  'MuddyWater_001',  'MuddyWater_002',
                           'Mustang_Panda_001',  'Sandworm_001',  'Tropic_Trooper_001',  'APT28_001',  'APT28_002',  'APT28_003',  'APT28_004', 
                           'APT29_001',  'APT29_002',  'APT29_003',  'APT29_004',  'APT41_001', 'APT41_002',  'menuPass_001',  'Carbanak_001',  'APT37_001',  'WizardSpider_001', 
                           'OilRig_001',  'FIN7_001',  'APT3_001']
ONLY_USE_LIST_NEXT=['admin@338_001',  'Lazarus_Group_001',  'Lazarus_Group_002',  'APT32_001',  'MuddyWater_001',  'MuddyWater_002',
                           'Mustang_Panda_001',  'Sandworm_001',  'Tropic_Trooper_001',  'APT28_001',  'APT28_002',  'APT28_003',  'APT28_004', 
                           'APT29_001',  'APT29_002',  'APT29_003',  'APT29_004',  'APT41_001', 'APT41_002',  'menuPass_001',  'Carbanak_001',  'APT37_001',  'WizardSpider_001', 
                           'OilRig_001',  'FIN7_001',  'APT3_001',  'Ajax_Security_Team_001',  'Andariel_001',  'APT38_001']
ONLY_USE_LIST_FULL=['admin@338_001',  'Lazarus_Group_001',  'Lazarus_Group_002',  'APT32_001',  'MuddyWater_001',  'MuddyWater_002',
                           'Mustang_Panda_001',  'Sandworm_001',  'Tropic_Trooper_001',  'APT28_001',  'APT28_002',  'APT28_003',  'APT28_004', 
                           'APT29_001',  'APT29_002',  'APT29_003',  'APT29_004',  'APT41_001', 'APT41_002',  'menuPass_001',  'Carbanak_001',  'APT37_001',  'WizardSpider_001', 
                           'OilRig_001',  'FIN7_001',  'APT3_001',  'Ajax_Security_Team_001',  'Andariel_001',  'APT38_001',  'ZAPT33_001', 
                           'ZAPT19_001', 'ZSandworm_002',  'ZAPT28_005',  'ZAPT32_001', 'ZAPT29_005']
ONLY_USE_LIST_FULL=['admin@338_001',  'Lazarus_Group_001',  'Lazarus_Group_002',  'APT32_001',  'MuddyWater_001',  'MuddyWater_002',
                           'Mustang_Panda_001',  'Sandworm_001',  'Tropic_Trooper_001',  'APT28_001',  'APT28_002',  'APT28_003',  'APT28_004', 
                           'APT29_001',  'APT29_002',  'APT29_003',  'APT29_004',  'APT41_001', 'APT41_002',  'menuPass_001',  'Carbanak_001',  'APT37_001',  'WizardSpider_001', 
                           'OilRig_001',  'FIN7_001',  'APT3_001',  'Ajax_Security_Team_001',  'Andariel_001',  'APT38_001']


#####################################################
#   'Train' MC Transition Matrix based on the test data.
####################################################
SuccPred=0
FailPred=0
UnableToPredict=0

print("HMM Predictions - Leave One Out")
print("Using " + str(len(ONLY_USE_LIST_FULL)) + " attacks")

for remove in range(len(ONLY_USE_LIST_FULL)):
    AttackSeqTacticList=[]
    AttackSeqTacticCount=[]
    IDList=[]
    count=0
    
    # For this training set
    
    # Build lists of tactics and techniques for this training set 
    TechList=[]
    TacticList=[]
    # Build a list of Tactic (prev/next) sequence pairs. They will be dicts
    T1givenT0=[]
    # Build a list of Tactic Technique (O) pairs. They will be dicts
    TNON=[]
    
    # Remove item from the list when building the training set
    ONLY_USE_LIST=[]
    TEST_CASE=[]
    AttackInd=0
    
    print("<<NEXT TEST>> Removing " + ONLY_USE_LIST_FULL[remove])
    
    for NextAttack in ONLY_USE_LIST_FULL:
        if not AttackInd == remove:
            ONLY_USE_LIST.append(NextAttack)
        else:
            TEST_CASE.append(NextAttack)
        AttackInd+=1
        
    print("The training set is " + str(ONLY_USE_LIST))
    
    ###############################
    #  STEP 1:
    # Build lists of tactics and techniques in this training set.     
    ################################
    
    for ThisAttack in ThisAttackTechList:
        
        IDLine=True
        PrevTactic=""
        
        for NextNode in ThisAttack:
            
            # Check for the first ID line with meta data in it
            if IDLine==True:
                if not NextNode['ID'] in ONLY_USE_LIST:
                    break
                IDLine=False
                IDList.append(NextNode["ID"])
                count+=1
                
            else:
                
                if NextNode['SG'] == 'G':
                    continue
                    
                Tactic=NextNode['Tactic']
                
                if PrevTactic=="":
                    PrevTactic=Tactic
                else:
                    # Once we have got past the first observation 
                    #      record Tactic Previous Tactic pairs in T1givenT0[]
                    T1givenT0_Dict={'Prev':PrevTactic, 'This':Tactic}
                    
                    InList=False
                    for NextDict in T1givenT0:
                        if NextDict == T1givenT0_Dict:
                            InList=True
                
                    if InList == False:
                        T1givenT0.append(T1givenT0_Dict)
                        
                    PrevTactic=Tactic
                
                # Add this tactic to the list if not already there
                InTacticList=False
                for NextTactic in TacticList:
                    if NextTactic == Tactic:
                        InTacticList=True
                if InTacticList == False:
                    TacticList.append(Tactic)
                           
                TTP=NextNode['Tech']
                InTechList=False
                for NextTech in TechList:
                    if NextTech == TTP:
                        InTechList=True
                if InTechList == False:
                    TechList.append(TTP)
                
                # Add this tech to the list if not already there
                TNON_Dict={'Tactic':Tactic, 'Tech':TTP}
            
                InList=False
                for NextDict in TNON:
                    if NextDict == TNON_Dict:
                        InList=True
                if InList == False:
                    TNON.append(TNON_Dict)
                    
                # Add this tac/tech pair to the list if not already there
                    
    # Now create an empty matrix of the required size
    # rows, columns
    
    # DEBUG
    #print("The tech list is " + str(TechList))
    #print("The tactic list is " + str(TacticList))
    #print("The tactic pair list is" + str(T1givenT0))
    #print("The tactic/tech pair list is" + str(TNON))
    #continue
    
        
    #exit(0)
    # END DEBUG
    
    #M=np.zeros((len(NDepthList), len(TechList)))
    
    ###############################
    #  STEP 2:
    # Keep counts in Transition and Emission Matrices     
    ################################
    
    # Build empty matrices to populate and use for HMM prediction using Viterbi Algorithm
    
    # Display number of states
    print("There are " + str(len(TacticList)) + " States/Tactics in this training set")
    # Build the square transition matrix
    A=np.zeros((len(TacticList), len(TacticList)))
    
    # Display number of observation/emission types
    print("There are " + str(len(TechList)) + " Observations/Techniques in this training set")
    
    # Build the {n x m) emissions matrix
    B=np.zeros((len(TacticList), len(TechList)))
    
    # Build the initial probability matrix
    PI=[]
    for NextTact in TacticList:
        if NextTact == "TA0001":
            PI.append(1)
        else:
            PI.append(0)
    PI=np.array(PI)
    
    #print("The matrix is " + str(A))
    
    # Now put counts in the matrix
    # row is NDepth pattern (index)
    #Column is next Tech
    
    count=0
    for ThisAttack in ThisAttackTechList:
        IDLine=True
        PrevTactic=""
        
        for NextNode in ThisAttack:
            
            # Check for the first ID line with meta data in it
            if IDLine==True:
                if not NextNode['ID'] in ONLY_USE_LIST:
                    break
                IDLine=False
                IDList.append(NextNode["ID"])
                count+=1
                
            else:
                
                if NextNode['SG'] == 'G':
                    continue
                    
                Tactic=NextNode['Tactic']
                
                if PrevTactic=="":
                    PrevTactic=Tactic
                else:
                    # Once we have got past the first observation 
                    #      keep a count of tactic pairs
                                            
                    A[TacticList.index(PrevTactic), TacticList.index(Tactic)]+=1
                    PrevTactic=Tactic
                
                                           
                TTP=NextNode['Tech']
                
                # Add this tech to the list if not already there
                TNON_Dict={'Tactic':Tactic, 'Tech':TTP}
                B[TacticList.index(Tactic), TechList.index(TTP)]+=1
            
    #######################################
    #  STEP 3:
    # Turn counts in Transition and Emission Matrices into probabilities  
    #######################################              
    # 
    ARowSums=A.sum(axis=1)
    BRowSums=B.sum(axis=1)
    
    # For debugging only if required
    Row=0
    ZCount=0
    for NextRow in ARowSums:
        if NextRow == 0:
            #print("Zero row found for NDepth item " + str(NDepthList[Row]))
            ZCount+=1
        Row+=1
    #print(str(ZCount) + " Zero rows found for NDepth item, out of  " + str(str(len(NDepthList))))
    # For debugging if required
    Row=0
    ZCount=0
    for NextRow in BRowSums:
        if NextRow == 0:
            #print("Zero row found for NDepth item " + str(NDepthList[Row]))
            ZCount+=1
        Row+=1
    
    for i in range(len(TacticList)): # Rows   
        for j in range(len(TacticList)): # Columns
            if not ARowSums[i] == 0:
                A[i, j]=A[i, j] / ARowSums[i]
     
    for i in range(len(TacticList)): # Rows   
        for j in range(len(TechList)): # Columns
            if not BRowSums[i] == 0:
                B[i, j]=B[i, j] / BRowSums[i]     
    
    #######################################
    #  STEP 4:
    #   Now for the validation attack
    #          Create a test observation set (of the first OBSERVATION_LEN techniques)
    #######################################        
        
    for ThisAttack in ThisAttackTechList:
        IDLine=True
        ThisNDepthItem=[]
        DepthCount=0
        prevNDepthList=[]
        
        AttackExtract=[]
        AttackTacticExtract=[]
        O_AttackExtract=[]
        O_AttackTacticExtract=[] 
        
        AttackName="UNINITIALISED"
        for NextNode in ThisAttack:
            
            if IDLine==True:
                if not NextNode['ID'] in TEST_CASE:
                    break
                AttackName=NextNode['ID']
                IDLine=False
                IDList.append(NextNode["ID"])
                count+=1
                
            else:
                
                if NextNode['SG'] == 'G':
                    continue
                    
                if len(AttackExtract) < OBSERVATION_LEN:                
                    AttackExtract.append(NextNode['Tech'])
                    AttackTacticExtract.append(NextNode['Tactic'])
                    continue
                else:
                    pass
                    # Get the last DEPTH techs from extract
                    """"AttackExtractToDepth=AttackExtract[-DEPTH:]
                    print("The attack extract for " + AttackName + "is " + str(AttackExtract))
                    print("The depth items are" + str(AttackExtractToDepth) + " (for depth " + str(DEPTH) + ")")
                    # Now get most probable next tech from the relevant matric row
                    ColCount=0
                    MaxCol=0
                    try:
                        for NextCol in M[NDepthList.index(AttackExtractToDepth)]:
                            if NextCol > MaxCol:
                                MaxCol=ColCount
                            ColCount+=1
                    except ValueError:
                        UnableToPredict+=1
                        print("<< WARN>> Cannot predict for " + str(AttackExtractToDepth) + " in " + AttackName) 
                        FailList.append(AttackExtractToDepth)
                        break
                    print("The predicted technique is " + str(TechList[MaxCol]) )
                    print("The real technique is " + str(NextTechAfterExtract)) 
                    if TechList[MaxCol] == NextTechAfterExtract:
                        SuccPred+=1
                    else:
                        FailPred+=1
                    break             
                           
                TTP=NextNode['Tech']"""
                

        
        if not AttackExtract == []:
            print("About to predict for " + AttackName)
            print("The observation extract is " + str(AttackExtract))
            print("The state extract to predict is " + str(AttackTacticExtract))
            #print("The TNON is " + str(TNON))
            #print("The T1givenT0 is " + str(T1givenT0))
            
            #
            # Check to see if we can theoretically predict across the extract
            #
            # First try and convert sequences to their index values
            
            ExtInd=0
            StopIndex=-1
            Invalid=False
            PrevTactic=""
            InvalidPairs=[]

            for NextStep in AttackExtract:
                
                # Is the technique in the training set (LOGICALLY COVERED BY NEXT TEST)
                #try:
                #    O_AttackExtract.append(TechList.index(NextStep))
                #except ValueError:
                #    print("For " + AttackName + " observation " + str(ExtInd) + " --<<UNKNOWN " + NextStep + "TECH IN TRAIN>>")
                #    Invalid=True
                
                # Is the tactic/technique pair in the training set                 
                TacticTechPairFound=False
                for NextPairToCheck in TNON:
                    if NextPairToCheck['Tactic'] == AttackTacticExtract[ExtInd]:
                        if NextPairToCheck['Tech'] == NextStep:
                            #print("Found a match for " + Tactic + " / " + TTP + " in " + AttackName)
                            TacticTechPairFound=True
                if TacticTechPairFound == False:
                    print("For " + AttackName + " observation " + str(ExtInd) + " --<<UNKNOWN Tactic/Tech " + AttackTacticExtract[ExtInd] +
                                                                        "/" +NextStep + " IN TRAIN>>")
                    InvalidPair={'Type':"TacticTech", 
                                      'Tactic':AttackTacticExtract[ExtInd], 
                                      'Tech':NextStep}
                    InvalidPairs.append(InvalidPair)
                    Invalid=True
                    
                # Is the Tactic/Next Tactic pair in the training set                
                TacticPrevNextPairFound=False
                if PrevTactic == "":
                    PrevTactic = AttackTacticExtract[ExtInd]
                else:
                    for NextPairToCheck in T1givenT0:
                        if NextPairToCheck['Prev'] == PrevTactic:
                            if NextPairToCheck['This'] == AttackTacticExtract[ExtInd]:
                            #print("Found a match for " + Tactic + " / " + TTP + " in " + AttackName)
                                TacticPrevNextPairFound=True                                
                    if TacticPrevNextPairFound == False:
                        print("For " + AttackName + " observation " + str(ExtInd) + " --<<UNKNOWN Tactic/Tactic " + PrevTactic +
                                                                        "/" +AttackTacticExtract[ExtInd] + " IN TRAIN>>")
                        InvalidPair={'Type':"TacticTactic", 
                                      'PrevTactic':PrevTactic, 
                                      'Tactic':AttackTacticExtract[ExtInd]}
                        InvalidPairs.append(InvalidPair)
                        Invalid=True
                    PrevTactic = AttackTacticExtract[ExtInd]
                    
                if Invalid == False:
                    O_AttackExtract.append(TechList.index(NextStep))
                    O_AttackTacticExtract.append(TacticList.index(AttackTacticExtract[ExtInd]))
                                    
                ExtInd+=1
            
            print("The indexed observation extract is " + str(O_AttackExtract))
            print("The indexed state extract to predict is " + str(O_AttackTacticExtract))
            
            States=[]
            for NextTactic in TacticList:
                States.append(TacticList.index(NextTactic))
            
            RES=[]
            if len(O_AttackExtract) > 0:
                RES=viterbi_algorithm_v2(O_AttackExtract, States, PI, A, B)
            
            print("The indexed predicted states are " + str(RES))
            
            PredAttackTacticExtract=[]
            for NextPred in RES:
                PredAttackTacticExtract.append(TacticList[NextPred])
                
            print("The predicted states are " + str(PredAttackTacticExtract))
            
            CorrectPred=0
            IncorrectPred=0
            Index=0
            
            for NextItem in PredAttackTacticExtract:
                if NextItem == AttackTacticExtract[Index]:
                    CorrectPred+=1
                else:
                    IncorrectPred+=1
                Index+=1
            
            ResDict={'AttackName':AttackName, 
             'ObsExt':AttackExtract, 
             'StateExt':AttackTacticExtract, 
             'PredState':PredAttackTacticExtract, 
             'IntendedObsLen':len(AttackExtract), 
             'ActualObsLen':len(O_AttackExtract), 
             'InvalidPairs':InvalidPairs, 
             'CorrectPred':CorrectPred, 
             'IncorrectPred':IncorrectPred}
             
            ResultDicts.append(ResDict)
        
TotalValidations=0
FullPreds=0
PartialPreds=0
NoPreds=0
TotalObsPresented=0
TotalObsPredicted=0
TotalInvalidPairsPresented=0
TotalSuccessfulPredictions=0
TotalFailedPredictions=0
for NextItem in ResultDicts:
    #print(str(NextItem))  
    TotalValidations+=1 
    if NextItem['IntendedObsLen'] == NextItem['ActualObsLen']:
       FullPreds+=1 
    if not NextItem['IntendedObsLen'] == NextItem['ActualObsLen']:
        if NextItem['ActualObsLen'] > 0:
            PartialPreds+=1
        else:
            NoPreds+=1
            
    TotalObsPresented+=NextItem['IntendedObsLen']
    TotalObsPredicted+=NextItem['ActualObsLen']
    TotalInvalidPairsPresented+=len(NextItem['InvalidPairs'])
    TotalSuccessfulPredictions+=NextItem['CorrectPred']
    TotalFailedPredictions+=NextItem['IncorrectPred']


print("Final results for " + str(TotalValidations) + " validations :")   
print("FullPreds : " + str(FullPreds))
print("PartialPreds : " + str(PartialPreds))
print("NoPreds : " + str(NoPreds))
print("TotalObsPresented : " + str(TotalObsPresented))
print("TotalObsPredicted : " + str(TotalObsPredicted))
print("TotalInvalidPairsPresented : " + str(TotalInvalidPairsPresented))
print("TotalSuccessfulPredictions : " + str(TotalSuccessfulPredictions))
print("TotalFailedPredictions : " + str(TotalFailedPredictions))


print("The following attacks had invalid combinations in them")
for NextItem in ResultDicts:
    #print(str(NextItem))  
    if not NextItem['IntendedObsLen'] == NextItem['ActualObsLen']:
        print(str(NextItem))
        
print("The following attacks had actual incorrect predictions in them")
for NextItem in ResultDicts:
    #print(str(NextItem))  
    if not NextItem['IncorrectPred'] == 0:
        print(str(NextItem))
                
print("Final result ( " + str(DEPTH) + " ) is success=" + str(SuccPred) + "/failed=" + str(FailPred) + "/unable=" + str(UnableToPredict))
print("Fail list is "  +  str(FailList)  )        
