from MAFpt_ATTACK_DB_ATTACK_GRAPHS_DATA_AUTO import ThisAttackTechList 

import MAFpt_r_params as rpar
import MAFpt_ATTACK_DB_v2 as ATTACK

import os

import pandas as pd
 
#import numpy as np

import matplotlib.pyplot as plt

print("<< STARTING ATTACK DB UKC ANALYSIS")

IGNORE_LIST=[]
ONLY_USE_LIST=['admin@338_001',  'Lazarus_Group_001',  'Lazarus_Group_002',  'APT32_001',  'MuddyWater_001',  'MuddyWater_002',
                           'Mustang_Panda_001',  'Sandworm_001',  'Tropic_Trooper_001',  'APT28_001',  'APT28_002',  'APT28_003',  'APT28_004', 
                           'APT29_001',  'APT29_002',  'APT29_003',  'APT29_004',  'APT41_001', 'APT41_002',  'menuPass_001',  'Carbanak_001',  'APT37_001',  'WizardSpider_001', 
                           'OilRig_001',  'FIN7_001',  'APT3_001']
                           
ONLY_USE_LIST=['admin@338_001',  'Lazarus_Group_001',  'Lazarus_Group_002',  'APT32_001',  'MuddyWater_001',  'MuddyWater_002',
                           'Mustang_Panda_001',  'Sandworm_001',  'Tropic_Trooper_001',  'APT28_001',  'APT28_002',  'APT28_003',  'APT28_004', 
                           'APT29_001',  'APT29_002',  'APT29_003',  'APT29_004',  'APT41_001', 'APT41_002',  'menuPass_001',  'Carbanak_001',  'APT37_001',  'WizardSpider_001', 
                           'OilRig_001',  'FIN7_001',  'APT3_001',   'Ajax_Security_Team_001',  'Andariel_001',  'APT38_001']

                           

YAML_Root = os.environ.get('MAFpt_YAML_ROOT')
YAML_File = os.environ.get('MAFpt_YAML_FILE')
YAML_File="MAFpt_RunParams.yaml"

YAML_Root = os.getcwd()
YAML_File="/MAFpt_ATTACK_DB_TEST_RunParams.yaml"

#p_obj = MAFpt_r_params.MAFpt_r_params(YAML_Root + YAML_Dir + YAML_File)

p_obj = rpar.MAFpt_r_params(YAML_Root + YAML_File)

ck_load=p_obj.MAFpt_r_ck_load()

if ck_load == 0:
    print("MAFpt: Unable to access parameter file")
    exit(1)

#HELP_RUN=p_obj.MAFpt_r_read("RUN_HELP")
#SUMM_STATS_RUN=p_obj.MAFpt_r_read("RUN_SUMM_STATS")
#TESTS_RUN=p_obj.MAFpt_r_read("RUN_TESTS")

#ATT_SRC=p_obj.MAFpt_r_read("RUN_ATT_SRC")
#CVE_SRC=p_obj.MAFpt_r_read("RUN_CVE_SRC")
DOWNLOAD_ATTACK=p_obj.MAFpt_r_read("RUN_DOWNLOAD_ATTACK")
REINDEX_ATTACK=p_obj.MAFpt_r_read("RUN_REINDEX_ATTACK")
ATTACK_LOCAL_FILE_ROOT = p_obj.MAFpt_r_read('RUN_ATTACK_LOCAL_FILE_ROOT')
ATTACK_TAXII_SERVER = p_obj.MAFpt_r_read('RUN_ATTACK_TAXII_SERVER')
ATTACK_LOCAL_COPY = p_obj.MAFpt_r_read('RUN_ATTACK_LOCAL_COPY')
ATTACK_CVE_SEARCH = p_obj.MAFpt_r_read('RUN_ATTACK_CVE_SEARCH')
ATTACK_MAIN_INDEX = p_obj.MAFpt_r_read('RUN_ATTACK_MAIN_INDEX')
ATTACK_SUB_INDEX = p_obj.MAFpt_r_read('RUN_ATTACK_SUB_INDEX')
ATTACK_CVE_REF_INDEX = p_obj.MAFpt_r_read('RUN_ATTACK_CVE_REF_INDEX')
ATTACK_TTP_INDEX = p_obj.MAFpt_r_read('RUN_ATTACK_TTP_INDEX')
ATTACK_TACTIC_INDEX = p_obj.MAFpt_r_read('RUN_ATTACK_TACTIC_INDEX')
ATTACK_TECH_TO_TACTIC_INDEX = p_obj.MAFpt_r_read('RUN_ATTACK_TECH_TO_TACTIC_INDEX')
ATTACK_REL_INDEX = p_obj.MAFpt_r_read('RUN_ATTACK_REL_INDEX')
ATTACK_TACTIC_BIN_INDEX = p_obj.MAFpt_r_read('RUN_ATTACK_TACTIC_BIN_INDEX')   
ATTACK_TTP_BIN_INDEX = p_obj.MAFpt_r_read('RUN_ATTACK_TTP_BIN_INDEX') 
        

  
ATTACK_obj = ATTACK.MAFpt_ATTACK_DB(DOWNLOAD_ATTACK,
                         ATTACK_TAXII_SERVER,
                         ATTACK_LOCAL_FILE_ROOT,
                         ATTACK_LOCAL_COPY,
                         REINDEX_ATTACK,
                         ATTACK_CVE_SEARCH, 
                         ATTACK_MAIN_INDEX, 
                         ATTACK_SUB_INDEX, 
                         ATTACK_CVE_REF_INDEX, 
                         ATTACK_TTP_INDEX, 
                         ATTACK_TACTIC_INDEX, 
                         ATTACK_TECH_TO_TACTIC_INDEX, 
                         ATTACK_REL_INDEX, 
                         ATTACK_TACTIC_BIN_INDEX, 
                         ATTACK_TTP_BIN_INDEX) 
Count=0  
ListOfAttacks=[]
TacticList=ATTACK_obj.GetListOfTacticsInDomain("enterprise-attack")
TechList=ATTACK_obj.GetListOfSelectedTTP("Enterprise", "Any", "attack-pattern")
UKCPhases=['IF-REC','IF-WEP', 'IF-DEL', 'IF-SEN', 'IF-EXP', 'IF-PER', 'IF-DEV', 'IF-C2C', 
                    'NP-DIS', 'NP-PES', 'NP-EXE', 'NP-CAC', 'NP-LMV', 
                    'AO-COL', 'AO-EXF', 'AO-TMA', 'AO-OBJ']
                    
# Create a dataframe with 1 row for each UKC Phase and 1 column for each Tactic
UKCTransdf = pd.DataFrame(0.0, index=UKCPhases, columns=TacticList)

for ThisAttack in ThisAttackTechList:
      
    ThisAttackName=""
    FirstLine=True
    for obs in ThisAttack:
        if FirstLine == True:
            # Next two ifs just allows the test to be run against a subset of all the available attacks
            #
            FirstLine=False
            
            if obs['ID'] in IGNORE_LIST:
                break
        
            if len(ONLY_USE_LIST) > 0:
                if not obs['ID'] in ONLY_USE_LIST:
                    break
                else:
                    ListOfAttacks.append(obs['ID'])
                    ThisAttackName=obs['ID']
                         
            Count+=1
            print("This is [" + str(Count) +"] "+ obs['ID'])
            
            continue
            
                        
        # Check validity of Tactic, Technique, UKC List
        ValidTactic=False
        for NextTactic in TacticList:           
            if NextTactic==obs['Tactic']:
                ValidTactic=True
                
        if ValidTactic == False:
            print("<<WARNING>> : [" + ThisAttackName + "][" + str(obs['StepNo']) + "]: " + "Invalid Tactic " + str(obs['Tactic']))
                
        ValidTech=False
        for NextTech in TechList:            
            if NextTech==obs['Tech']:
                ValidTech=True
                
        if ValidTech == False:
            print("<<WARNING>> : [" + ThisAttackName + "][" + str(obs['StepNo']) + "]: " + "Invalid Technique " + str(obs['Tech']))
            
        KCElems=obs['KC'].split('/')
        for NextUKCElem in KCElems:
            #print("The KCElem is " + NextUKCElem)
            ValidUKC=False
            for NextUKC in UKCPhases:            
                if NextUKC==NextUKCElem:
                    ValidUKC=True
                
        if ValidUKC == False:
            print("<<WARNING>> : [" + ThisAttackName + "][" + str(obs['StepNo']) + "]: " + "Invalid UKC " + str(obs['KC']))
            
            
        for NextUKCElem in KCElems:
            UKCTransdf.at[NextUKCElem, obs['Tactic']]+=1
            pass
            
APTNames=[]
for NextAttack in ListOfAttacks:
    pass
    APTNames.append(NextAttack.split("_")[0])

Uniquelist=list(set(APTNames))    
Uniquelist=sorted(Uniquelist)    
print("<<>><<>> " + str(Uniquelist))


with pd.option_context('display.max_rows', None,
                       'display.max_columns', None,
                       'display.precision', 3,
                       ):
    print(UKCTransdf) 

print(UKCTransdf.to_markdown())    


#fig, ax = plt.subplots(1, 1)
fig, ax = plt.subplots()
#the_table = axs.table(cellText=data, colLabels=columns, loc='center')

the_table = ax.table(cellText=UKCTransdf.values, rowLabels=UKCTransdf.index, colLabels=UKCTransdf.columns, loc='center')
the_table.auto_set_font_size(False)
the_table.set_fontsize(15)
plt.axis('off')
plt.show()
#display(UKCTransdf.to_string())

# Displaying dataframe as an heatmap
# https://matplotlib.org/stable/tutorials/colors/colormaps.html
# with diverging colourmap as RdYlBu
#plt.imshow(UKCTransdf, cmap ="RdYlBu")
#plt.imshow(UKCTransdf, cmap ="autumn")
plt.imshow(UKCTransdf, cmap ="coolwarm")
  
# Displaying a color bar to understand
# which color represents which range of data
plt.colorbar()
  
# Assigning labels of x-axis 
# according to dataframe
#plt.xticks(range(len(UKCTransdf)), UKCTransdf.columns)
plt.xticks(ticks=range(len(UKCTransdf.columns)), labels=UKCTransdf.columns,  rotation=90)
  
# Assigning labels of y-axis 
# according to dataframe
#plt.yticks(range(len(UKCTransdf)), UKCTransdf.index)
plt.yticks(ticks=range(len(UKCTransdf.index)), labels=UKCTransdf.index)
  
# Displaying the figure
plt.show()

# Make a copy of the UKCTransdf
UKCTransdfCopy = UKCTransdf.copy()

for NextCol in UKCTransdfCopy.columns:
    Total = UKCTransdfCopy[NextCol].sum()
    UKCTransdfCopy[NextCol] = (UKCTransdfCopy[NextCol] / Total *100).round(2)
    pass
    
plt.imshow(UKCTransdfCopy, cmap ="coolwarm")
plt.colorbar()
plt.xticks(ticks=range(len(UKCTransdf.columns)), labels=UKCTransdf.columns,  rotation=90)
plt.yticks(ticks=range(len(UKCTransdf.index)), labels=UKCTransdf.index)
plt.show()

