import MAFpt_r_params as rpar
import MAFpt_ATTACK_DB_v2 as ATTACK


import os
import networkx as nx

#from tabulate import tabulate
import numpy as np
#import matplotlib.pyplot as plt

import pandas as pd

from hmmlearn import hmm
#from sklearn.utils import check_random_state

# https://www.pythonpool.com/viterbi-algorithm-python/
def viterbi_algorithm_v2(observations, states, start_p, trans_p, emit_p):
     V = [{}]
     # Start DEBUG  
     print("Initialising: First observation is " + str(observations[0]) + "(" + TechUsedStepList[observations[0]] + ")")
     # End DEBUG  
     for st in states:
         # Start DEBUG  
         print("For state " + str(st))
         # End DEBUG  
         V[0][st] = {"prob": start_p[st] * emit_p[st][observations[0]], "prev": None}
         # Start DEBUG  
         print("The prob calc P[X0=" + str(st) + "]*P[Y0=" + str(observations[0]) + "|X0] is  " + str(start_p[st] * emit_p[st][observations[0]]))
         # End DEBUG  
   
     for t in range(1, len(observations)):
         # Start DEBUG  
         print("<<>><<>> Next observation is : (" + str(t) + ")" + str(observations[t]) + "(" + TechUsedStepList[observations[t]] + ")")
         # End DEBUG  
         V.append({})
         for st in states:
            # DEBUG
            print("<<>> Next state calc is for : (" + str(t) + ")" + str(st) + "(" + HMMTacticList[st] + ")")
            PXN_XNMINUS1 = trans_p[states[t-1]][st]
            print("P[X" + str(t-1) + "|X" +str(t) + "] is " + str(PXN_XNMINUS1))
            PYN_XN = emit_p[st][observations[t]]
            print("P[Y" + str(t) + "|X" +str(t) + "] is " + str(PYN_XN))
            
            maxMUprev= V[t - 1][states[0]]["prob"]             
            # END DEBUG
            
            max_tr_prob = V[t - 1][states[0]]["prob"] * trans_p[states[0]][st]
            prev_st_selected = states[0]
            prev_st_new_selected = states[0]
            for prev_st in states[1:]:
                # DEBUG
                if V[t - 1][prev_st]["prob"] > maxMUprev:
                    maxMUprev = V[t - 1][prev_st]["prob"]
                    prev_st_new_selected = prev_st
                # END DEBUG
                tr_prob = V[t - 1][prev_st]["prob"] * trans_p[prev_st][st]
                #if tr_prob > max_tr_prob:
                if tr_prob > max_tr_prob:
                    max_tr_prob = tr_prob
                    prev_st_selected = prev_st
            
            # Start DEBUG        
            print("Max[Xprev] is : (" + str(maxMUprev)  + ")")
            print("<< == The final calc gives " + str(maxMUprev*PXN_XNMINUS1*PYN_XN) + "/" + str(prev_st_new_selected))
            max_prob_new=maxMUprev*PXN_XNMINUS1*PYN_XN
            # End DEBUG
 
            max_prob = max_tr_prob * emit_p[st][observations[t]]
            
            
            V[t][st] = {"prob": max_prob, "prev": prev_st_selected}
            # Start DEBUG        
            print("<< == The final code calc gives " + str(max_prob) + " / " + str(prev_st_selected))
            V[t][st] = {"prob": max_prob_new, "prev": prev_st_new_selected}
            # End DEBUG
     
     for line in dptable(V):
        print(line)
 
     opt = []
     max_prob = 0.0
     best_st = None
 
     for st, data in V[-1].items():
        # if data["prob"] > max_prob:
        #print("<< " + str(st))
        #print("<< " + str(data))
        if data["prob"] >= max_prob:
            max_prob = data["prob"]
            best_st = st
     opt.append(best_st)
     previous = best_st
 
     # DEBUG
     #print("<< " + str(len(V)))
     #print("<< " + str(previous))
     Count=0
     for NextV in V:
         #print("<< Next V " + str(Count))
         Count+=1
         #print(str(NextV))
     # End DEBUG
     
     for t in range(len(V) - 2, -1, -1):
        # DEBUG
        #print("Inserting " + str(V[t + 1][previous]["prev"]) + " from " + str(previous) + "  in " + str(t))
        # END DEBUG
        opt.insert(0, V[t + 1][previous]["prev"])
        previous = V[t + 1][previous]["prev"]
     # print ("The steps of states are " + " ".join(str(opt) ) + " with highest probability of %s" % max_prob)
     print ("The steps of states are " + str(" ".join(str(opt) )) + " with highest probability of %s" % max_prob)
 

# https://www.pythonpool.com/viterbi-algorithm-python/
def viterbi_algorithm(observations, states, start_p, trans_p, emit_p):
     V = [{}]
     print("Initialising: First observation is " + str(observations[0]) + "(" + TechUsedStepList[observations[0]] + ")")
     for st in states:
         print("For state " + str(st))
         V[0][st] = {"prob": start_p[st] * emit_p[st][observations[0]], "prev": None}
         print("The prob calc P[X0=" + str(st) + "]*P[Y0=" + str(observations[0]) + "|X0] is  " + str(start_p[st] * emit_p[st][observations[0]]))
   
     for t in range(1, len(observations)):
         print("<<>><<>> Next observation is : (" + str(t) + ")" + str(observations[t]) + "(" + TechUsedStepList[observations[t]] + ")")
         V.append({})
         for st in states:
            # DEBUG
            print("<<>> Next state calc is for : (" + str(t) + ")" + str(st) + "(" + HMMTacticList[st] + ")")
            PXN_XNMINUS1 = trans_p[states[t-1]][st]
            print("P[X" + str(t-1) + "|X" +str(t) + "] is " + str(PXN_XNMINUS1))
            PYN_XN = emit_p[st][observations[t]]
            print("P[Y" + str(t) + "|X" +str(t) + "] is " + str(PYN_XN))
            
            maxMUprev= V[t - 1][states[0]]["prob"]             
            # END DEBUG
            
            max_tr_prob = V[t - 1][states[0]]["prob"] * trans_p[states[0]][st]
            prev_st_selected = states[0]
            for prev_st in states[1:]:
                # DEBUG
                if V[t - 1][prev_st]["prob"] > maxMUprev:
                    maxMUprev = V[t - 1][prev_st]["prob"]
                # END DEBUG
                tr_prob = V[t - 1][prev_st]["prob"] * trans_p[prev_st][st]
                #if tr_prob > max_tr_prob:
                if tr_prob > max_tr_prob:
                    max_tr_prob = tr_prob
                    prev_st_selected = prev_st
            
            # Start DEBUG        
            print("Max[Xprev] is : (" + str(maxMUprev)  + ")")
            print("<< == The final calc gives " + str(maxMUprev*PXN_XNMINUS1*PYN_XN))
            # End DEBUG
 
            max_prob = max_tr_prob * emit_p[st][observations[t]]
            # Start DEBUG        
            print("<< == The final code calc gives " + str(max_prob) + " / " + str(prev_st_selected))
            # End DEBUG
            V[t][st] = {"prob": max_prob, "prev": prev_st_selected}
     
     for line in dptable(V):
        print(line)
 
     opt = []
     max_prob = 0.0
     best_st = None
 
     for st, data in V[-1].items():
        # if data["prob"] > max_prob:
        #print("<< " + str(st))
        #print("<< " + str(data))
        if data["prob"] >= max_prob:
            max_prob = data["prob"]
            best_st = st
     opt.append(best_st)
     previous = best_st
 
     # DEBUG
     print("<< " + str(len(V)))
     print("<< " + str(previous))
     Count=0
     for NextV in V:
         print("<< Next V " + str(Count))
         Count+=1
         print(str(NextV))
     # End DEBUG
     
     for t in range(len(V) - 2, -1, -1):
        # DEBUG
        print("Inserting " + str(V[t + 1][previous]["prev"]) + " from " + str(previous) + "  in " + str(t))
        # END DEBUG
        opt.insert(0, V[t + 1][previous]["prev"])
        previous = V[t + 1][previous]["prev"]
     # print ("The steps of states are " + " ".join(str(opt) ) + " with highest probability of %s" % max_prob)
     print ("The steps of states are " + str(" ".join(str(opt) )) + " with highest probability of %s" % max_prob)
 
def dptable(V):
     
    yield " ".join(("%12d" % i) for i in range(len(V)))
    for state in V[0]:
        yield "%.7s: " % state + " ".join("%.7s" % ("%f" % v[state]["prob"]) for v in V)


# https://www.adeveloperdiary.com/data-science/machine-learning/implement-viterbi-algorithm-in-hidden-markov-model-using-python-and-r/
def viterbi_2(V, a, b, initial_distribution):
    T = V.shape[0]
    M = a.shape[0]
 
    omega = np.zeros((T, M))
    omega[0, :] = np.log(initial_distribution * b[:, V[0]])
 
    prev = np.zeros((T - 1, M))
 
    for t in range(1, T):
        for j in range(M):
            # Same as Forward Probability
            probability = omega[t - 1] + np.log(a[:, j]) + np.log(b[j, V[t]])
 
            # This is our most probable state given previous state at time t (1)
            prev[t - 1, j] = np.argmax(probability)
 
            # This is the probability of the most probable state (2)
            omega[t, j] = np.max(probability)
 
    # Path Array
    S = np.zeros(T)
 
    # Find the most probable last hidden state
    last_state = np.argmax(omega[T - 1, :])
 
    S[0] = last_state
 
    backtrack_index = 1
    for i in range(T - 2, -1, -1):
        S[backtrack_index] = prev[i, int(last_state)]
        last_state = prev[i, int(last_state)]
        backtrack_index += 1
 
    # Flip the path array since we were backtracking
    S = np.flip(S, axis=0)
 
    # Convert numeric values to actual hidden states
    result = []
    for s in S:
        if s == 0:
            result.append("A")
        else:
            result.append("B")
 
    return result

# https://gawron.sdsu.edu/compling/course_core/code/viterbi/doc/viterbi.viterbi_search-pysrc.html
###################################################################### 
###################################################################### 
###  M a i n      P r o g r a m 
###################################################################### 
###################################################################### 
  
back = [] 
trellis = [] 
def decode (Stringseq, A, B, states, s0, predict=False): 
     """ 
     Takes a list of strings, C{Stringseq}, each element 
     a word according to the HMM defined by C{A},C{B}, C{states}, 
     and C{s0}.  Returns C{path}, a list of states of length len(Stringseq)+1, 
     representing the highest prob HMM path that accepts Stringseq, as well 
     as the two  tables built in the Viterbi computation. Note: 
     implements the pseudocode of U{J&M, Figure 7.09<http:www-rohan.sdsu.edu/~gawron/compling/chap7/fig07.09.pdf>}. 
  
     C{trellis} is the table the Viterbi algorithm fills in. 
     Therefore, C{trellis} will be an array of length T+1 (length of input + t=0) 
     Each element will be a dictionary with states as keys. 
     trellis[t][s] is the viterbi score of state s at time t [a log prob] 
  
     C{back} (for "backtrace") will be an array with the same dimensions:: 
  
           back[t][s] 
  
     is the best state to have come FROM to get to s at t. 
  
     @param Stringseq: a list of strings representin the sequence input 
                        observations 
     @param A: Transition prob table of HMM 
     @param B: Observation prob table of HMM 
     @param states: A list of states for HMM 
     @param s0: Start state of HMM 
     @rtype: a 4-tuple of C{trellis} (the Viterbi table), C{back} (the backtrace 
             table), the best probability path through the HMM (list), and 
             C{nice_path_string} (a pretty string representation of the best 
             path, suitable for printing). 
     """ 
     global trellis, back 
     T = len(Stringseq) 
     # print 'T: %s' % T 
     trellis = [] 
     back=[] 
     ############################################################################ 
     # Initialize trellis and back. 
     # 
     ############################################################################ 
     #for t in xrange(T+1):  # initialize trellis and back 
     for t in range(T+1):  # initialize trellis and back 
                            # Use xrange rather than range: Efficiency  
         #viterbi_scores = dict(zip(states,[neg_infinity]*len(states)))  # viterbi scores for this t; 
         viterbi_scores = dict(zip(states,[float('-inf')]*len(states)))  # viterbi scores for this t; 
                                                                        # start with easy to beat neg log probs (= low probs) 
         back_states = dict(zip(states,['init']*len(states))) # viterbi states (states to have come from) for this t 
         if t==0:   ## start state is the state you have to be in at t=0 
             viterbi_scores[s0] = 0.0  ## log prob= 0 implies prob = 1 
             back_states[s0] = 'init'  ## placeholder for debugging 
         trellis.append(viterbi_scores) 
         back.append(back_states) 
     ############################################################################ 
     # The main body of the viterbi algorithm 
     #    Fill in trellis with Viterbi values, back with backpointers 
     ############################################################################ 
     #for t in xrange(1,T+1): 
     for t in range(1,T+1): 
         o = Stringseq[t-1]  # o is the current observtaion. 
         # print 't: %s' % t 
         # print 'o: %s' % o 
         try: 
             emission_probs=B[o] 
         except KeyError: 
             print('Illegal input: %s' % o )
             return (trellis,back,B,'') 
         # Fill in next column; using log probs so add to get score 
         for s_to in states: 
            for s_from in states: 
                 # In s at t, coming from s_from at t-1 
                 if predict: 
                     e_state = s_from 
                 else: 
                     e_state = s_to 
                 try: 
                     # print_info(s_from,s_to,A,emission_probs,trellis) 
                     score=trellis[t-1][s_from]+ A[s_from][s_to]+ emission_probs[e_state] 
                 except KeyError: 
                     print('Key error %s %s %s %s' % (s_from,s_to,o, t) )
                     return (trellis,back,[],'') 
                 # print '  score: %s' % score 
                 # print '  trellis[t][s_to]: %s' % trellis[t][s_to] 
                 # print '  trellis[t-1][s_from]: %s' % trellis[t-1][s_from] 
                 if score > trellis[t][s_to]: 
                     trellis[t][s_to]=score 
                     back[t][s_to]=s_from 
                 else: continue 
  
     ############################################################################ 
     # End of main body of the viterbi algorithm 
     #     
     ############################################################################ 
     # Find best state for final piece of input at t=T 
     best=s0  # initial value: arbitrary 
     for s in states: 
         if trellis[T][s] > trellis[T][best]: 
             best=s 
         else: continue 
     path=[best] 
     # nice_path=[nice_names[best]]  ## Use for debugging and display 
     nice_path=[str(best)] # Not all state names are strings. Make sure. 
     #for t in xrange(T,0,-1): # count backwards (T ... 1) 
     for t in range(T,0,-1): # count backwards (T ... 1) 
         best=back[t][best] 
         path[0:0]=[best]  # Python idiom for "push" 
         nice_path[0:0]=[str(best),                      # nice_names[best], 
                         '--%s-->' % (Stringseq[t-1], )] 
         nice_path_string = ' '.join(nice_path) # Make a string consisting of the elements of list nice_path 
                                            # separated by ' ' (space) 
                                            # called as a method on the string ' '. 
     return (trellis,back,path,nice_path_string) 
  
  

#https://stackoverflow.com/questions/9729968/python-implementation-of-viterbi-algorithm
def viterbi(y, A, B, Pi=None):
    """
    Return the MAP estimate of state trajectory of Hidden Markov Model.

    Parameters
    ----------
    y : array (T,)
        Observation state sequence. int dtype.
    A : array (K, K)
        State transition matrix. See HiddenMarkovModel.state_transition  for
        details.
    B : array (K, M)
        Emission matrix. See HiddenMarkovModel.emission for details.
    Pi: optional, (K,)
        Initial state probabilities: Pi[i] is the probability x[0] == i. If
        None, uniform initial distribution is assumed (Pi[:] == 1/K).

    Returns
    -------
    x : array (T,)
        Maximum a posteriori probability estimate of hidden state trajectory,
        conditioned on observation sequence y under the model parameters A, B,
        Pi.
    T1: array (K, T)
        the probability of the most likely path so far
    T2: array (K, T)
        the x_j-1 of the most likely path so far
    """
    # Cardinality of the state space
    K = A.shape[0]
    # Initialize the priors with default (uniform dist) if not given by caller
    Pi = Pi if Pi is not None else np.full(K, 1 / K)
    T = len(y)
    T1 = np.empty((K, T), 'd')
    T2 = np.empty((K, T), 'B')

    # Initilaize the tracking tables from first observation
    T1[:, 0] = Pi * B[:, y[0]]
    T2[:, 0] = 0

    # Iterate throught the observations updating the tracking tables
    for i in range(1, T):
        T1[:, i] = np.max(T1[:, i - 1] * A.T * B[np.newaxis, :, y[i]].T, 1)
        T2[:, i] = np.argmax(T1[:, i - 1] * A.T, 1)

    # Build the output, optimal model trajectory
    x = np.empty(T, 'B')
    x[-1] = np.argmax(T1[:, T - 1])
    for i in reversed(range(1, T)):
        x[i - 1] = T2[x[i], i]

    return x, T1, T2





# import pandas as pd
def NextTechChainEdge(ExpectedNextEdge,
                                        AttackId, 
                                        CurrentNode):
    #print("<< Getting a Tech Chain edge")

    # Now check for next node in Tech Chain
    ReturnEdge=False
    # We need to keep a list of all possible out tech chain edges from this node
    # Then work out which is the right one for the expected edge
    ListOfPossibleEdges=[]
    
    for NextE in G.out_edges(CurrentNode, data=True):
        
        #print(str(NextE))
        # Only keep edges for this attack and part of a tech chain        
        if (NextE[2]['attack_id'] == AttackId) and \
                        (NextE[2]['edgetype'] == 0) :  
            
            ListOfPossibleEdges.append(NextE)
                        
    # Order the list of possible edges by count (ascending)
    # We may have supporting techniques as well which means count not necessarily sequential
    ListOfPossibleEdges.sort(key=lambda tup: tup[2]['count'])
    
    for NextItem in ListOfPossibleEdges:
        if NextItem[2]['count'] >= ExpectedNextEdge:
            
            ReturnEdge=NextItem
            break 
            
    return ReturnEdge
    
def GetTacticForTech(CurrentStep,
                                        AttackId, 
                                        CurrentNode):
    #print("<< Getting a Tech Chain edge")

    # Now check for next node in Tech Chain
    ReturnTactic=False
    # We need to keep a list of all possible out tech chain edges from this node
    # Then work out which is the right one for the expected edge
    ListOfPossibleEdges=[]
    
    for NextE in G.out_edges(CurrentNode, data=True):
        
        # Only keep edges for this attack and part of a tech chain        
        if (NextE[2]['attack_id'] == AttackId) and \
                        (NextE[2]['edgetype'] == 3) :  
            
            ListOfPossibleEdges.append(NextE)
                        
    # Order the list of possible edges by count (ascending)
    # We may have supporting techniques as well which means count not necessarily sequential
    # The tactic edge will have the same step number as the tech
    ListOfPossibleEdges.sort(key=lambda tup: tup[2]['count'])
    
    for NextItem in ListOfPossibleEdges:
        if NextItem[2]['count'] == CurrentStep:
            
            ReturnTactic=NextItem[1]
            break 
            
    return ReturnTactic
    
def GetSuppTechForTech(CurrentStep,
                                        AttackId, 
                                        CurrentNode):
    #print("<< Getting a Tech Chain edge")

    # Now check for next node in Tech Chain
    # We need to keep a list of all possible out tech chain edges from this node
    # Then work out which is the right one for the expected edge
    ListOfPossibleEdges=[]
    
    for NextE in G.out_edges(CurrentNode, data=True):
        
        # Only keep edges for this attack and part of a tech chain        
        if (NextE[2]['attack_id'] == AttackId) and \
                        (NextE[2]['edgetype'] == 1) :  
            
            ListOfPossibleEdges.append(NextE)
                        
    # Order the list of possible edges by count (ascending)
    # We may have supporting techniques as well which means count not necessarily sequential
    # The tactic edge will have the same step number as the tech
    ListOfPossibleEdges.sort(key=lambda tup: tup[2]['count'])
    
    SuppTechList=[]
    for NextItem in ListOfPossibleEdges:
        if NextItem[2]['count'] == CurrentStep:
            
            SuppTechList.append(NextItem[1])
            
    return SuppTechList
    
def GetTacticForSuppTech(CurrentStep,
                                        AttackId, 
                                        CurrentNode):
    #print("<< Getting a Tech Chain edge")

    # Now check for next node in Tech Chain
    ReturnTactic=False
    # We need to keep a list of all possible out tech chain edges from this node
    # Then work out which is the right one for the expected edge
    ListOfPossibleEdges=[]
    
    for NextE in G.out_edges(CurrentNode, data=True):
        
        # Only keep edges for this attack and part of a tech chain        
        if (NextE[2]['attack_id'] == AttackId) and \
                        (NextE[2]['edgetype'] == 4) :  
            
            ListOfPossibleEdges.append(NextE)
                        
    # Order the list of possible edges by count (ascending)
    # We may have supporting techniques as well which means count not necessarily sequential
    # The tactic edge will have the same step number as the tech
    ListOfPossibleEdges.sort(key=lambda tup: tup[2]['count'])
    
    for NextItem in ListOfPossibleEdges:
        if NextItem[2]['count'] == CurrentStep:
            
            ReturnTactic={'Tactic':NextItem[1], 
                                  'KC':NextItem[2]['KC']}
                                  
            break 
            
    return ReturnTactic
    
#   ########################
#  Main code starts here
# ####################

YAML_Root = os.environ.get('MAFpt_YAML_ROOT')
YAML_File = os.environ.get('MAFpt_YAML_FILE')
YAML_File="MAFpt_RunParams.yaml"

YAML_Root = os.getcwd()
YAML_File="/MAFpt_ATTACK_DB_TEST_RunParams.yaml"

p_obj = rpar.MAFpt_r_params(YAML_Root + YAML_File)

DOWNLOAD_ATTACK=p_obj.MAFpt_r_read("RUN_DOWNLOAD_ATTACK")
REINDEX_ATTACK=p_obj.MAFpt_r_read("RUN_REINDEX_ATTACK")
ATTACK_LOCAL_FILE_ROOT = p_obj.MAFpt_r_read('RUN_ATTACK_LOCAL_FILE_ROOT')
ATTACK_TAXII_SERVER = p_obj.MAFpt_r_read('RUN_ATTACK_TAXII_SERVER')
ATTACK_LOCAL_COPY = p_obj.MAFpt_r_read('RUN_ATTACK_LOCAL_COPY')
ATTACK_CVE_SEARCH = p_obj.MAFpt_r_read('RUN_ATTACK_CVE_SEARCH')
ATTACK_MAIN_INDEX = p_obj.MAFpt_r_read('RUN_ATTACK_MAIN_INDEX')
ATTACK_SUB_INDEX = p_obj.MAFpt_r_read('RUN_ATTACK_SUB_INDEX')
ATTACK_CVE_REF_INDEX = p_obj.MAFpt_r_read('RUN_ATTACK_CVE_REF_INDEX')
ATTACK_TTP_INDEX = p_obj.MAFpt_r_read('RUN_ATTACK_TTP_INDEX')
ATTACK_TACTIC_INDEX = p_obj.MAFpt_r_read('RUN_ATTACK_TACTIC_INDEX')
ATTACK_TECH_TO_TACTIC_INDEX = p_obj.MAFpt_r_read('RUN_ATTACK_TECH_TO_TACTIC_INDEX')
ATTACK_REL_INDEX = p_obj.MAFpt_r_read('RUN_ATTACK_REL_INDEX')
ATTACK_TACTIC_BIN_INDEX = p_obj.MAFpt_r_read('RUN_ATTACK_TACTIC_BIN_INDEX')   
ATTACK_TTP_BIN_INDEX = p_obj.MAFpt_r_read('RUN_ATTACK_TTP_BIN_INDEX') 
  
ATTACK_obj = ATTACK.MAFpt_ATTACK_DB(DOWNLOAD_ATTACK,
                         ATTACK_TAXII_SERVER,
                         ATTACK_LOCAL_FILE_ROOT,
                         ATTACK_LOCAL_COPY,
                         REINDEX_ATTACK,
                         ATTACK_CVE_SEARCH, 
                         ATTACK_MAIN_INDEX, 
                         ATTACK_SUB_INDEX, 
                         ATTACK_CVE_REF_INDEX, 
                         ATTACK_TTP_INDEX, 
                         ATTACK_TACTIC_INDEX, 
                         ATTACK_TECH_TO_TACTIC_INDEX, 
                         ATTACK_REL_INDEX, 
                         ATTACK_TACTIC_BIN_INDEX, 
                         ATTACK_TTP_BIN_INDEX) 
                         
print("Starting MAFpt_ATTACK_DB_GRAPH_WALKER")

#-########################
#  Creating a look up table of Techniques
#-########################
#print("Getting a list of Enterprise techniques")
TechList=ATTACK_obj.GetListOfTTPOfType("attack-pattern")
TechList=ATTACK_obj.GetListOfSelectedTTP("Enterprise", "Any", "attack-pattern")
TechCount=[0]*len(TechList)
#print("There are " + str(len(TechList)) + " techniques")
    
#-########################
#  Creating a look up table of Tactics
#-########################
#print("Getting a list of Enterprise tactics")


# Open the graph file
GraphFile=ATTACK_LOCAL_FILE_ROOT + "MAFpt_ATTACKS_GRAPH_v5.gexf"
G=nx.read_gexf(GraphFile)

# Go through the graph database and find each of the attack nodes
#AllAttackNodes=G.nodes(data=True)
AttackStartNodes = [x for x,y in G.nodes(data=True) if y['type']==1]


# Constrain APTs if required
ResultsList=[]
IGNORE_LIST=[]
ONLY_USE_LIST=['admin@338_001',  'Lazarus_Group_001',  'Lazarus_Group_002',  'APT32_001',  'MuddyWater_001',  'MuddyWater_002',
                           'Mustang_Panda_001',  'Sandworm_001',  'Tropic_Trooper_001',  'APT28_001']

# 16.4.1, 16.4.2, 16.4.3 results
ONLY_USE_LIST=['admin@338_001',  'Lazarus_Group_001',  'Lazarus_Group_002',  'APT32_001',  'MuddyWater_001',  'MuddyWater_002',
                           'Mustang_Panda_001',  'Sandworm_001',  'Tropic_Trooper_001']

ONLY_USE_LIST=['APT29_004']

# 16.4.4 results
ONLY_USE_LIST=['admin@338_001',  'Lazarus_Group_001',  'Lazarus_Group_002',  'APT32_001',  'MuddyWater_001',  'MuddyWater_002',
                           'Mustang_Panda_001',  'Sandworm_001',  'Tropic_Trooper_001',  'APT28_001',  'APT28_002',  'APT28_003',  'APT28_004', 
                           'APT29_001',  'APT29_002',  'APT29_003',  'APT29_004']
                           
ONLY_USE_LIST=['APT41_001', 'APT41_002']

ONLY_USE_LIST=['admin@338_001',  'Lazarus_Group_001',  'Lazarus_Group_002',  'APT32_001',  'MuddyWater_001',  'MuddyWater_002',
                           'Mustang_Panda_001',  'Sandworm_001',  'Tropic_Trooper_001',  'APT28_001',  'APT28_002',  'APT28_003',  'APT28_004', 
                           'APT29_001',  'APT29_002',  'APT29_003',  'APT29_004',  'APT41_001', 'APT41_002',  'menuPass_001',  'Carbanak_001',  'APT37_001',  'WizardSpider_001', 
                           'OilRig_001',  'FIN7_001',  'APT3_001']

ONLY_USE_LIST=['admin@338_001',  'Lazarus_Group_001',  'Lazarus_Group_002',  'APT32_001',  'MuddyWater_001',  'MuddyWater_002',
                           'Mustang_Panda_001',  'Sandworm_001',  'Tropic_Trooper_001',  'APT28_001',  'APT28_002',  'APT28_003',  'APT28_004', 
                           'APT29_001',  'APT29_002',  'APT29_003',  'APT29_004',  'APT41_001', 'APT41_002',  'menuPass_001',  'Carbanak_001',  'APT37_001',  'WizardSpider_001', 
                           'OilRig_001',  'FIN7_001',  'APT3_001',  'Ajax_Security_Team_001',  'Andariel_001',  'APT38_001']
                           
ONLY_USE_LIST=['admin@338_001',  'Lazarus_Group_001',  'Lazarus_Group_002',  'APT32_001',  'MuddyWater_001',  'MuddyWater_002',
                           'Mustang_Panda_001',  'Sandworm_001',  'Tropic_Trooper_001',  'APT28_001',  'APT28_002',  'APT28_003',  'APT28_004', 
                           'APT29_001',  'APT29_002',  'APT29_003',  'APT29_004',  'APT41_001', 'APT41_002',  'menuPass_001',  'Carbanak_001',  'APT37_001',  'WizardSpider_001', 
                           'OilRig_001',  'FIN7_001',  'APT3_001',  'Ajax_Security_Team_001',  'Andariel_001',  'APT38_001',  'ZAPT33_001']

                           
UKCPhases=['IF-REC','IF-WEP', 'IF-DEL', 'IF-SEN', 'IF-EXP', 'IF-PER', 'IF-DEV', 'IF-C2C', 
                    'NP-DIS', 'NP-PES', 'NP-EXE', 'NP-CAC', 'NP-LMV', 
                    'AO-COL', 'AO-EXF', 'AO-TMA', 'AO-OBJ']
UKCCount=[0]*len(UKCPhases) # One for every use observed
UKCInstCount=[0]*len(UKCPhases) # One for each each attack with use observed

Remove=1
Count=0

HMMPredDictList=[]

# ####################
# START MAIN LOOP
# ########################

while Remove-1 < len(ONLY_USE_LIST):
    
    TacticList=ATTACK_obj.GetListOfTacticsInDomain("enterprise-attack")
    TacticCount=[0]*len(TacticList)
    TacticInstCount=[0]*len(TacticList)

    TechUsedList=[]
    TechUsedStepList=[]
    TechUsedSuppList=[]

    TotalObsCount=0
    
    Count+=1 # Count of the tests run
    #if not Count== 8:
        #continue
    if Count == 8:
        #exit(0)
        Remove+=1
    
    print("Running test " + str(Count) + " of " + str(len(ONLY_USE_LIST)) + " without " + ONLY_USE_LIST[Remove-1])
    
    if not ONLY_USE_LIST[Remove-1] == "MuddyWater_002":
        pass
        #Remove+=1
        #continue
    
    ListOfAttacks=[] # Keep full list of attacks processed
    
    # Initialise the Tactic Transition Matrix (as dataframe)
    HMMTacticList=[]
    # Get rid of unwanted Tactics (done like this to make removal list clear.
    for NextTactic in TacticList:
        if (not NextTactic == "TA0043") and (not NextTactic == "TA0042"):
            HMMTacticList.append(NextTactic)
    
    TacticTransdf = pd.DataFrame(0.0, index=HMMTacticList, columns=HMMTacticList)
    AttackTotalPerTactic=[0]*len(HMMTacticList)

    ListofEmissionObs=[] # This will be filled up with all Dict/Tech pairs from the attacks
                                # This is used because we won,t know the emissions dataframe columns to use until we are finished
    RemovedAttack=[] # Same for the removed attack (to be used as test)

    for NextNode in AttackStartNodes:
    
        #print("The next node is " + NextNode)
    
        PredTactic="" # Reset for start of a new attack
        PredTech=""
        AttackTacticCount=0 # Count for this attack only
        AttackTechCount=0 # Count for this attack only

    
        # Next two ifs just allows the test to be run against a subset of all the available attacks
        #
        
        if NextNode in IGNORE_LIST:
            continue
        
        if len(ONLY_USE_LIST) > 0:
            if not NextNode in ONLY_USE_LIST:
                continue
            else:
                ListOfAttacks.append(NextNode)
    
        # Check for edges into the Node indicating predecessor chain
        #print("Checking for in edges")
        for NextE in G.in_edges(NextNode, data=True):
            #print("The next edge is " + str(NextE))
        
            # Only keep edges for this attack and part of a tech chain 
       
            if (NextE[2]['attack_id'] == NextNode) and \
                        (NextE[2]['edgetype'] == 4) :  
            
                print("Preceding attack sequence is " + NextE[0])    
    
        ExpectedNextEdge=1
        CurrentNode=NextNode
        AttackId=NextNode
    
        ThisAttackList=[]
    
        while 1:
        
            e=NextTechChainEdge(ExpectedNextEdge, 
                                          AttackId, 
                                          CurrentNode)
                                          

                                          
            if e == False:
                break
            
            TotalObsCount+=1
            
            # Keep a record of the step techniques e[1]
            TechNotCounted=True
            #if NextNode == "Tropic_Trooper_001":
                #print("Step Tech is " + e[1])
            for NextTech in TechUsedList:
                #if NextNode == "Tropic_Trooper_001":
                #print("Stored Tech is " + NextTech)
                if e[1] == NextTech:
                    TechNotCounted = False
            if TechNotCounted==True:
                #if NextNode == "Tropic_Trooper_001":
                    #print("Adding Step Tech " + e[1])
                TechUsedList.append(e[1])
                TechUsedStepList.append(e[1])
        
            TechNotCounted=True    
            for NextTech in TechUsedStepList:
                #if NextNode == "Tropic_Trooper_001":
                        #print("Stored Tech is " + NextTech)
                if e[1] == NextTech:
                    TechNotCounted = False
            if TechNotCounted==True:
                #if NextNode == "Tropic_Trooper_001":
                    #print("Adding Step Tech " + e[1])
                TechUsedStepList.append(e[1])
            
            ExpectedNextEdge=e[2]['count'] + 1
            CurrentNode=e[1]
        
            TechTactic=GetTacticForTech(e[2]['count'],
                                        AttackId, 
                                        CurrentNode)
                                        
            SuppTechList=GetSuppTechForTech(e[2]['count'],
                                        AttackId, 
                                        CurrentNode)
                                        
            SuppTechTacticList=[]
            SuppTechTextString="["
            AllStepUKCPhase=""
        
            for NextSuppTech in SuppTechList:
                # Keep a record of the step techniques e[1]
                TechNotCounted=True
                for NextTech in TechUsedList:
                    if NextSuppTech == NextTech:
                        TechNotCounted = False
                if TechNotCounted==True:
                    TechUsedList.append(NextSuppTech)
                    TechUsedSuppList.append(NextSuppTech)
                
                TacticForSuppTech=GetTacticForSuppTech(e[2]['count'],
                                        AttackId, 
                                        NextSuppTech)
                                        
                SuppTechTacticList.append(TacticForSuppTech['Tactic'])
                AllStepUKCPhase=AllStepUKCPhase+ TacticForSuppTech['KC'] + "/"
            
                SuppTechTextString=SuppTechTextString + "[" + NextSuppTech + "/" + \
                                             TacticForSuppTech['Tactic'] + "/" + \
                                                         TacticForSuppTech['KC'] + "]"
            SuppTechTextString=SuppTechTextString + "]"
                                         
            #print("<<" + NextNode + " : " + str(Count) + ">> " + "[" + str(e[2]['count']) + 
            #    "] The next tech is " + str(e[1]) + 
            #     " with tactic " + str(TechTactic) + 
                 # "(Support is " + str(SuppTechList) + ")" +
            #     "(Support is " + SuppTechTextString + ")" +
            #     " and [KC]" + str(e[2]['KC'])
            #     )
                 
            ThisLineDict={'Tactic': TechTactic, 
                                  'Technique': str(e[1])}
                              
            ThisLineDict={'Attack':NextNode, 
                               'Tactic':str(TechTactic), 
                               'TacticNum':HMMTacticList.index(TechTactic), 
                               'Technique':str(e[1]), 
                               'TechNum':TechUsedStepList.index(str(e[1]))}
            #ThisAttackList.append(ThisStepDict)
            
            # FIX REMOVAL
            if NextNode == ONLY_USE_LIST[Remove-1]:
                    RemovedAttack.append(ThisLineDict)
            #else:
                #ListofEmissionObs.append(ThisLineDict)
            ListofEmissionObs.append(ThisLineDict)
                 
            if not PredTactic == "":
                #print("Adding a Tactic Transition count to row " + PredTactic + " and col " + str(TechTactic))
                if not NextNode == False: #ONLY_USE_LIST[Remove-1]: # Dont add in if attack to remove
                    TacticTransdf.at[PredTactic,TechTactic]+=1
                    AttackTotalPerTactic[HMMTacticList.index(PredTactic)]+=1
                        
            PredTactic=str(TechTactic)
            AttackTacticCount+=1
            PredTech=str(e[1])
            AttackTechCount+=1
                 
            ThisUKCPhaseList=(AllStepUKCPhase+str(e[2]['KC'])).split('/')
            #print("<<< " + str(ThisUKCPhaseList) + " >>>")
        
            # ###
            # Update counts (for display)
            #
            for NextUKCPhase in ThisUKCPhaseList:       
                try:
                    UKCCount[UKCPhases.index(str(NextUKCPhase))]+=1
                except ValueError :
                    print("Invalid UKC value (" + NextUKCPhase + ") in step " + str(e[2]['count'])  + " for " + NextNode)
            
            TacticCount[TacticList.index(str(TechTactic))]+=1
            for NextSuppTechTactic in SuppTechTacticList:
                TacticCount[TacticList.index(str(NextSuppTechTactic))]+=1

    #print(tabulate(TacticTransdf, headers='keys', tablefmt='psql'))

    # Calculate the probalities along each row of HMM A Matrix
    for NextTacticRow in HMMTacticList:
        for NextTacticCol in HMMTacticList:
            #print("Row is " + NextTacticRow + " / Col is " + NextTacticCol + ": " + str(TacticTransdf.at[NextTacticRow,NextTacticCol]) + "/" + str(AttackTotalPerTactic[HMMTacticList.index(NextTacticRow)]))
            TacticTransdf.at[NextTacticRow,NextTacticCol]=TacticTransdf.at[NextTacticRow,NextTacticCol]/AttackTotalPerTactic[HMMTacticList.index(NextTacticRow)]
        
    print("Overall different technique count is " + str(len(TechUsedList)) + " of " + str(len(TechList)))    
    print("Total observation event count is " + str(TotalObsCount) )    
    #print("Overall different technique is " + str(TechUsedList))   
    #print("Overall different step technique is " + str(TechUsedStepList))
    #print("Overall different support technique is " + str(TechUsedSuppList)) 




    # #######################
    # Preparing the HMM parameters
    #

    # Define the N System States
    S=TacticList
    print("Here we have an N of " + str(len(HMMTacticList)) + " states")

    # Define the M Observation possibles
    #    In this case we just use the M Techniques used in the actual steps (we will not use the support techs)
    V=TechUsedStepList
    print("Here we have an M of " + str(len(TechUsedStepList)) + " obs syms")

    # Define the observation sequence
    # To be defined
    O=[]

    # Define the state transition matrix
    A=TacticTransdf

    # Now create the Observation probability matrix
    #  THIS VERSION CREATES A DEFAULT MATRIX JUST BASED ON TECH/TACTIC POSSIBLES
    #    Each row gives the probability of each technique observed being related to the Tactic associated with that row
    ObsProbdf = pd.DataFrame(0.0, index=HMMTacticList, columns=TechUsedStepList)
    # step through each row
    for NextTact in HMMTacticList:
        # Step through each column
        for NextTech in TechUsedStepList:
            # Get the Tactics associated with this technique
            #print("Getting tactics for " + NextTech)
            TacticListForTech=ATTACK_obj.GetTacticsForTTP(NextTech)
            if not NextTact in TacticList:
                ObsProbdf.at[NextTact, NextTech]=0
            else:
                ObsProbdf.at[NextTact, NextTech]=1/len(TacticListForTech)
    
    #  THIS VERSION CREATES A MATRIX DIRECTLY FROM OBSERVATIONS
    #   PROBLEM HERE IS THAT WE END UP WITH NO INFO ON TECHS NOT IN SAMPLES
    #  NOTE COLUMNS ARE TechUsedStepList
    
    ObsProbdf = pd.DataFrame(0.0, index=HMMTacticList, columns=TechUsedStepList)
    #print(str(TechUsedStepList))

    EmissionRowTotal=[0]*len(HMMTacticList)

    for NextEmission in ListofEmissionObs:
        #print(str(NextEmission))
        ObsProbdf.at[NextEmission['Tactic'], NextEmission['Technique']]+=1
        EmissionRowTotal[HMMTacticList.index(NextEmission['Tactic'])]+=1
    
    for NextTacticRow in HMMTacticList:
        for NextTechCol in TechUsedStepList:
            #print("Row is " + NextTacticRow + " / Col is " + NextTacticCol + ": " + str(TacticTransdf.at[NextTacticRow,NextTacticCol]) + "/" + str(AttackTotalPerTactic[HMMTacticList.index(NextTacticRow)]))
            ObsProbdf.at[NextTacticRow,NextTechCol]=ObsProbdf.at[NextTacticRow,NextTechCol]/EmissionRowTotal[HMMTacticList.index(NextTacticRow)]
    
    #  THIS VERSION CREATES A MATRIX BASED ON DEFAULTS AND OBSERVED
    #  First create a matrix with ALL possible techniques in it
    #    Each row gives the probability of each technique observed being related to the Tactic associated with that row
    ObsProbdf = pd.DataFrame(0.0, index=HMMTacticList, columns=TechList)

    # Put in info from emmissions
    EmissionRowTotal=[0]*len(HMMTacticList)
    
    for NextEmission in ListofEmissionObs:
        #print(str(NextEmission))
        ObsProbdf.at[NextEmission['Tactic'], NextEmission['Technique']]+=1
        EmissionRowTotal[HMMTacticList.index(NextEmission['Tactic'])]+=1
        
    #for NextTacticRow in HMMTacticList:
    #    for NextTechCol in TechList:
    #        print("Row is " + NextTacticRow + " / Col is " + NextTechCol + ": " + str(ObsProbdf.at[NextTacticRow,NextTechCol]) + "/" + str(EmissionRowTotal[HMMTacticList.index(NextTact)]))
               
    #exit(0)
    
    # Now add in default info if emissions did not have already give info    
    # Remove techused list from TechList so we can then updated unused with defaults
    TechNotUsedList = [x for x in TechList if x not in TechUsedStepList]
    
    #print(str(TechNotUsedList))
    #exit(0)
    # step through each row
    for NextTact in HMMTacticList:
        # Step through each column
        for NextTech in TechNotUsedList:
            # Get the Tactics associated with this technique
            #print("Getting tactics for " + NextTech + "(in " + NextTact +  ")")
            TacticListForTech=ATTACK_obj.GetTacticsForTTP(NextTech)
            #print("Tactics are " + str(TacticListForTech))
            #if not NextTact in TacticList:
            if not NextTact in TacticListForTech:
                ObsProbdf.at[NextTact, NextTech]=0
            else:
                #ObsProbdf.at[NextTact, NextTech]=1/len(TacticListForTech) 
                #print("Updating tactics for " + NextTech + "(in " + NextTact +  ")")
                ObsProbdf.at[NextTact, NextTech]+=1
                EmissionRowTotal[HMMTacticList.index(NextTact)]+=1
                
    for NextTacticRow in HMMTacticList:
        for NextTechCol in TechList:
            #print("Row is " + NextTacticRow + " / Col is " + NextTechCol + ": " + str(ObsProbdf.at[NextTacticRow,NextTechCol]) + "/" + str(EmissionRowTotal[HMMTacticList.index(NextTacticRow)]))
            ObsProbdf.at[NextTacticRow,NextTechCol]=ObsProbdf.at[NextTacticRow,NextTechCol]/EmissionRowTotal[HMMTacticList.index(NextTacticRow)]
    
    #  THIS VERSION CREATES A MATRIX DIRECTLY FROM OBSERVATIONS
    #   PROBLEM HERE IS THAT WE END UP WITH NO INFO ON TECHS NOT IN SAMPLES
    #  NOTE COLUMNS ARE TechUsedStepList
    
    ObsProbdf = pd.DataFrame(0.0, index=HMMTacticList, columns=TechUsedStepList)
    #print(str(TechUsedStepList))

    EmissionRowTotal=[0]*len(HMMTacticList)

    for NextEmission in ListofEmissionObs:
        #if NextEmission['Technique'] == "T1204.002":
        #    print(str(NextEmission))
        ObsProbdf.at[NextEmission['Tactic'], NextEmission['Technique']]+=1
        EmissionRowTotal[HMMTacticList.index(NextEmission['Tactic'])]+=1
    
    for NextTacticRow in HMMTacticList:
        for NextTechCol in TechUsedStepList:
            #if NextTechCol == "T1204.002":
            #    print("Row is " + NextTacticRow + " / Col is " + NextTechCol + ": " + str(ObsProbdf.at[NextTacticRow,NextTechCol]) + "/" + str(EmissionRowTotal[HMMTacticList.index(NextTacticRow)]))
            ObsProbdf.at[NextTacticRow,NextTechCol]=ObsProbdf.at[NextTacticRow,NextTechCol]/EmissionRowTotal[HMMTacticList.index(NextTacticRow)]
            #if NextTechCol == "T1204.002":
            #    print("Row is " + NextTacticRow + " / Col is " + NextTechCol + ": " + str(ObsProbdf.at[NextTacticRow,NextTechCol])  )
 
    
    #exit(0)
    #print(tabulate(ObsProbdf, headers='keys', tablefmt='psql'))
    B=ObsProbdf

    # Initial State Vecor
    # Here the initial state is assumed to be an Initial Access (TA0001) state all others are zero
    PI=[]
    for NextTact in HMMTacticList:
        if NextTact == "TA0001":
            PI.append(1)
        else:
            PI.append(0)
        
    #print("The Tactic List is " + str(HMMTacticList))
    #print("PI is " + str(PI))

    #mode = hmm.MultinomialHMM(n_components=2)
    # https://stackoverflow.com/questions/55924053/predicting-next-observation-using-hmmlearn-multinomialhmmdiscrete-hmm
    #https://stackoverflow.com/questions/39756006/how-to-map-hidden-states-to-their-corresponding-categories-after-decoding-in-hmm
    # https://hmmlearn.readthedocs.io/en/latest/auto_examples/plot_hmm_sampling_and_decoding.html#sphx-glr-auto-examples-plot-hmm-sampling-and-decoding-py
    #
    # use hmm to predict next step in sequence
    # https://stats.stackexchange.com/questions/110049/predict-observation-using-hidden-markov-models
    # https://stackoverflow.com/questions/53922680/prediction-step-for-time-series-using-continuous-hidden-markov-models
    #
    # https://medium.com/@Ayra_Lux/hidden-markov-models-part-1-the-likelihood-problem-8dd1066a784e
    #

    model = hmm.CategoricalHMM(n_components=len(HMMTacticList), init_params="") 
    # https://github.com/hmmlearn/hmmlearn/issues/340 (and 335)
    #model = hmm.MultinomialHMM(n_components=len(HMMTacticList), init_params="") 
    model.n_features=len(TechUsedStepList)
    #model.n_features=len(TechList)
    model.startprob_=PI
    model.transmat_=A
    model.emissionprob_=B

    X_S=['TA0001',  'TA0001',  'TA0011',  'TA0011',  'TA0002']
    X_O=['T1078',  'T1190',   'T1105',  'T1071.001',  'T1059.003']
    X_O_Num=[]

    #rs = check_random_state(546)
    #X, _ = model.sample(1000, random_state=rs)
    #exit(0)

    for NextObs in X_O:
    #    print("NextObs is " + NextObs + "(" +str(TechUsedStepList.index(NextObs)) + ")")
        X_O_Num.append(TechUsedStepList.index(NextObs))
        #X_O_Num.append(TechList.index(NextObs))
    
    # Create observation sequence from the attack left out.
    DictCount=0
    X_O_Num=[]
    X_O=[]
    X_S=[]
    X_O_TactCount=[]
    TestAttackName=""
    for NextDict in RemovedAttack:
        if NextDict['Attack']  == ONLY_USE_LIST[Remove-1]:
            
            TestAttackName=NextDict['Attack']
            
            if DictCount > -1:
                X_S.append(NextDict['Tactic'])
                X_O_Num.append(NextDict['TechNum'])
                X_O.append(NextDict['Technique'])
                X_O_TactCount.append(len(ATTACK_obj.GetTacticsForTTP(NextDict['Technique'])))
                #print(str(NextDict))
                
            DictCount+=1
            
            if DictCount == 6:
                break
                
    #print("Expected attack tactic string " + str(X_S))
    #print("The test observation attack techs are " + str(X_O))
    #print("The test observation attack string is " + str(X_O_Num))
                
    # APT28_001   Expected TA0006, TA0010
    #print(str(X_O_Num))
    X_O_Num_Arr=np.array(X_O_Num)
    X_O_partial=X_O_Num_Arr
    X_O_Num_Arr = X_O_Num_Arr.reshape(-1, 1)
    #L,  S=model.decode(np.array(X_O_Num).T)
    L,  S=model.decode(X_O_Num_Arr, algorithm='viterbi')
    #print("<< The L is >> " + str(L))
    x, T1,  T2= viterbi(X_O_partial, np.array(A), np.array(B), np.array(PI))
    #print("<< The x is >> " + str(x))
    x_str=[]
    for Nextx in x:
        pass
        x_str.append(HMMTacticList[int(Nextx)])
    print("<< The x_str is >> " + str(x_str))
    
    viterbi_algorithm_v2(X_O_partial, [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11], np.array(PI), np.array(A), np.array(B))
    
    #print("<< The T1 is >> " + str(T1))
    # return (trellis,back,path,nice_path_string)
    #X_O_First=X_S[0]
    #X_O_ToPop=X_O.copy()
    #X_O_ToPop.pop(0)
    #TR,  BK,  PTH,  NPTH = decode(X_O_ToPop, A, B, HMMTacticList, X_O_First, predict=False)
    #print("<< The PTH is " + str(PTH))
    #model=model.fit(np.array(X_O_Num).T)
    #model.predict(X_O)
    #print("Log Lik is " + str(L))
    #print("State seq is " + str(S))
    PredTactStr=[]
    for s in S:
        PredTactStr.append(HMMTacticList[s])
        #print("Next Tactic is " + HMMTacticList[s] )

    #S=model.predict(X_O_Num_Arr)
    #print("State seq is " + str(S))
    #
    # Convert prediction back to readable form
    
    Remove+=1
    
    i=0
    AccCount=0
    for ExpTac in X_S:
        if ExpTac == PredTactStr[i]:
            AccCount+=1
        i+=1
    
    HMMPredDict={'TestAttackName':TestAttackName, 
                            'Observation Stream':X_O,
                            'Tactics Per Tech':X_O_TactCount,  
                            'Expected Tactic Stream':X_S, 
                            'Predicted Tactic Stream':PredTactStr,
                            'LogLik':L, 
                           'Length':len(X_O),  
                            'Accuracy':AccCount}
                            
    print(str(HMMPredDict))
    #if HMMPredDict['LogLik'] < -1000:
        #print("REJECT")
    
    HMMPredDictList.append(HMMPredDict)
    
    #exit(0)

TotExpect=0
TotAcc=0
Failed=0
FailList=[]
# Calculate accuracy across resolved paths
for NextPred in HMMPredDictList:
    if NextPred['LogLik'] > -1000:
        TotExpect=TotExpect+NextPred['Length']
        TotAcc=TotAcc+NextPred['Accuracy']
    else:
        Failed+=1
        FailList.append(NextPred['TestAttackName'])

if not TotExpect == 0:    
    print("Final accuracy is " + str(TotAcc/TotExpect)   + "( Failed " + str(Failed) + " )")
print("Fail list is " + str(FailList))

for NextPred in HMMPredDictList:
    if NextPred['LogLik'] > -1000:
        pass
    else:
        print("For <<" + NextPred['TestAttackName'] + "/" + str(NextPred['Tactics Per Tech']) + ">>" + str(NextPred['Accuracy']))
        print("Expected " + str(NextPred['Expected Tactic Stream']) + " / Actual " + str(NextPred['Predicted Tactic Stream']))

exit(0)
