import MAFpt_r_params as rpar
import MAFpt_ATTACK_DB_v2 as ATTACK


import os
import networkx as nx

#from tabulate import tabulate
#import numpy as np
#import matplotlib.pyplot as plt

import pandas as pd

#import math

#from hmmlearn import hmm
#from sklearn.utils import check_random_state

#from plotnine import *

# import pandas as pd
def NextTechChainEdge(ExpectedNextEdge,
                                        AttackId, 
                                        CurrentNode):
    #print("<< Getting a Tech Chain edge")

    # Now check for next node in Tech Chain
    ReturnEdge=False
    # We need to keep a list of all possible out tech chain edges from this node
    # Then work out which is the right one for the expected edge
    ListOfPossibleEdges=[]
    
    for NextE in G.out_edges(CurrentNode, data=True):
        
        #print(str(NextE))
        # Only keep edges for this attack and part of a tech chain        
        if (NextE[2]['attack_id'] == AttackId) and \
                        (NextE[2]['edgetype'] == 0) :  
            
            ListOfPossibleEdges.append(NextE)
                        
    # Order the list of possible edges by count (ascending)
    # We may have supporting techniques as well which means count not necessarily sequential
    ListOfPossibleEdges.sort(key=lambda tup: tup[2]['count'])
    
    for NextItem in ListOfPossibleEdges:
        if NextItem[2]['count'] >= ExpectedNextEdge:
            
            ReturnEdge=NextItem
            break 
            
    return ReturnEdge
    
def GetTacticForTech(CurrentStep,
                                        AttackId, 
                                        CurrentNode):
    #print("<< Getting a Tech Chain edge")

    # Now check for next node in Tech Chain
    ReturnTactic=False
    # We need to keep a list of all possible out tech chain edges from this node
    # Then work out which is the right one for the expected edge
    ListOfPossibleEdges=[]
    
    for NextE in G.out_edges(CurrentNode, data=True):
        
        # Only keep edges for this attack and part of a tech chain        
        if (NextE[2]['attack_id'] == AttackId) and \
                        (NextE[2]['edgetype'] == 3) :  
            
            ListOfPossibleEdges.append(NextE)
                        
    # Order the list of possible edges by count (ascending)
    # We may have supporting techniques as well which means count not necessarily sequential
    # The tactic edge will have the same step number as the tech
    ListOfPossibleEdges.sort(key=lambda tup: tup[2]['count'])
    
    for NextItem in ListOfPossibleEdges:
        if NextItem[2]['count'] == CurrentStep:
            
            ReturnTactic=NextItem[1]
            break 
            
    return ReturnTactic
    
def GetSuppTechForTech(CurrentStep,
                                        AttackId, 
                                        CurrentNode):
    #print("<< Getting a Tech Chain edge")

    # Now check for next node in Tech Chain
    # We need to keep a list of all possible out tech chain edges from this node
    # Then work out which is the right one for the expected edge
    ListOfPossibleEdges=[]
    
    for NextE in G.out_edges(CurrentNode, data=True):
        
        # Only keep edges for this attack and part of a tech chain        
        if (NextE[2]['attack_id'] == AttackId) and \
                        (NextE[2]['edgetype'] == 1) :  
            
            ListOfPossibleEdges.append(NextE)
                        
    # Order the list of possible edges by count (ascending)
    # We may have supporting techniques as well which means count not necessarily sequential
    # The tactic edge will have the same step number as the tech
    ListOfPossibleEdges.sort(key=lambda tup: tup[2]['count'])
    
    SuppTechList=[]
    for NextItem in ListOfPossibleEdges:
        if NextItem[2]['count'] == CurrentStep:
            
            SuppTechList.append(NextItem[1])
            
    return SuppTechList
    
def GetTacticForSuppTech(CurrentStep,
                                        AttackId, 
                                        CurrentNode):
    #print("<< Getting a Tech Chain edge")

    # Now check for next node in Tech Chain
    ReturnTactic=False
    # We need to keep a list of all possible out tech chain edges from this node
    # Then work out which is the right one for the expected edge
    ListOfPossibleEdges=[]
    
    for NextE in G.out_edges(CurrentNode, data=True):
        
        # Only keep edges for this attack and part of a tech chain        
        if (NextE[2]['attack_id'] == AttackId) and \
                        (NextE[2]['edgetype'] == 4) :  
            
            ListOfPossibleEdges.append(NextE)
                        
    # Order the list of possible edges by count (ascending)
    # We may have supporting techniques as well which means count not necessarily sequential
    # The tactic edge will have the same step number as the tech
    ListOfPossibleEdges.sort(key=lambda tup: tup[2]['count'])
    
    for NextItem in ListOfPossibleEdges:
        if NextItem[2]['count'] == CurrentStep:
            
            ReturnTactic={'Tactic':NextItem[1], 
                                  'KC':NextItem[2]['KC']}
                                  
            break 
            
    return ReturnTactic
    
# https://www.geeksforgeeks.org/python-program-for-longest-common-subsequence/
# Dynamic Programming implementation of LCS problem 
def lcs(X, Y):
    # find the length of the strings
    m = len(X)
    n = len(Y)
 
    # declaring the array for storing the dp values
    L = [[None]*(n + 1) for i in range(m + 1)]
 
    """Following steps build L[m + 1][n + 1] in bottom up fashion
    Note: L[i][j] contains length of LCS of X[0..i-1]
    and Y[0..j-1]"""
    for i in range(m + 1):
        for j in range(n + 1):
            if i == 0 or j == 0 :
                L[i][j] = 0
            elif X[i-1] == Y[j-1]:
                L[i][j] = L[i-1][j-1]+1
            else:
                L[i][j] = max(L[i-1][j], L[i][j-1])
 
    # L[m][n] contains the length of LCS of X[0..n-1] & Y[0..m-1]
    return L[m][n]
# end of function lcs

    
#  ########################
#  Main code starts here
# ####################

YAML_Root = os.environ.get('MAFpt_YAML_ROOT')
YAML_File = os.environ.get('MAFpt_YAML_FILE')
YAML_File="MAFpt_RunParams.yaml"

YAML_Root = os.getcwd()
YAML_File="/MAFpt_ATTACK_DB_TEST_RunParams.yaml"

p_obj = rpar.MAFpt_r_params(YAML_Root + YAML_File)

DOWNLOAD_ATTACK=p_obj.MAFpt_r_read("RUN_DOWNLOAD_ATTACK")
REINDEX_ATTACK=p_obj.MAFpt_r_read("RUN_REINDEX_ATTACK")
ATTACK_LOCAL_FILE_ROOT = p_obj.MAFpt_r_read('RUN_ATTACK_LOCAL_FILE_ROOT')
ATTACK_TAXII_SERVER = p_obj.MAFpt_r_read('RUN_ATTACK_TAXII_SERVER')
ATTACK_LOCAL_COPY = p_obj.MAFpt_r_read('RUN_ATTACK_LOCAL_COPY')
ATTACK_CVE_SEARCH = p_obj.MAFpt_r_read('RUN_ATTACK_CVE_SEARCH')
ATTACK_MAIN_INDEX = p_obj.MAFpt_r_read('RUN_ATTACK_MAIN_INDEX')
ATTACK_SUB_INDEX = p_obj.MAFpt_r_read('RUN_ATTACK_SUB_INDEX')
ATTACK_CVE_REF_INDEX = p_obj.MAFpt_r_read('RUN_ATTACK_CVE_REF_INDEX')
ATTACK_TTP_INDEX = p_obj.MAFpt_r_read('RUN_ATTACK_TTP_INDEX')
ATTACK_TACTIC_INDEX = p_obj.MAFpt_r_read('RUN_ATTACK_TACTIC_INDEX')
ATTACK_TECH_TO_TACTIC_INDEX = p_obj.MAFpt_r_read('RUN_ATTACK_TECH_TO_TACTIC_INDEX')
ATTACK_REL_INDEX = p_obj.MAFpt_r_read('RUN_ATTACK_REL_INDEX')
ATTACK_TACTIC_BIN_INDEX = p_obj.MAFpt_r_read('RUN_ATTACK_TACTIC_BIN_INDEX')   
ATTACK_TTP_BIN_INDEX = p_obj.MAFpt_r_read('RUN_ATTACK_TTP_BIN_INDEX') 
  
ATTACK_obj = ATTACK.MAFpt_ATTACK_DB(DOWNLOAD_ATTACK,
                         ATTACK_TAXII_SERVER,
                         ATTACK_LOCAL_FILE_ROOT,
                         ATTACK_LOCAL_COPY,
                         REINDEX_ATTACK,
                         ATTACK_CVE_SEARCH, 
                         ATTACK_MAIN_INDEX, 
                         ATTACK_SUB_INDEX, 
                         ATTACK_CVE_REF_INDEX, 
                         ATTACK_TTP_INDEX, 
                         ATTACK_TACTIC_INDEX, 
                         ATTACK_TECH_TO_TACTIC_INDEX, 
                         ATTACK_REL_INDEX, 
                         ATTACK_TACTIC_BIN_INDEX, 
                         ATTACK_TTP_BIN_INDEX) 
                         
print("Starting MAFpt_ATTACK_DB_GRAPH_WALKER - MC TEST")

#-########################
#  Creating a look up table of Techniques
#-########################
#print("Getting a list of Enterprise techniques")
TechList=ATTACK_obj.GetListOfTTPOfType("attack-pattern")
# This refines list to just those for Enterprisem domain
TechList=ATTACK_obj.GetListOfSelectedTTP("Enterprise", "Any", "attack-pattern")
TechCount=[0]*len(TechList)
#print("There are " + str(len(TechList)) + " techniques")
    
#-########################
#  Creating a look up table of Tactics
#-########################
#print("Getting a list of Enterprise tactics")
TacticList=ATTACK_obj.GetListOfTacticsInDomain("enterprise-attack")
TacticCount=[0]*len(TacticList)
TacticInstCount=[0]*len(TacticList)

TechUsedList=[]
TechUsedStepList=[]
TechUsedSuppList=[]

AllAttacks=[]

TotalObsCount=0

# Open the graph file
GraphFile=ATTACK_LOCAL_FILE_ROOT + "MAFpt_ATTACKS_GRAPH_v5.gexf"
G=nx.read_gexf(GraphFile)

# Go through the graph database and find each of the attack nodes
#AllAttackNodes=G.nodes(data=True)
AttackStartNodes = [x for x,y in G.nodes(data=True) if y['type']==1]


# Constrain APTs if required
ResultsList=[]
IGNORE_LIST=[]
ONLY_USE_LIST=['admin@338_001',  'Lazarus_Group_001',  'Lazarus_Group_002',  'APT32_001',  'MuddyWater_001',  'MuddyWater_002',
                           'Mustang_Panda_001',  'Sandworm_001',  'Tropic_Trooper_001',  'APT28_001']

# 16.4.1, 16.4.2, 16.4.3 results
ONLY_USE_LIST=['admin@338_001',  'Lazarus_Group_001',  'Lazarus_Group_002',  'APT32_001',  'MuddyWater_001',  'MuddyWater_002',
                           'Mustang_Panda_001',  'Sandworm_001',  'Tropic_Trooper_001']

ONLY_USE_LIST=['APT29_004']

# 16.4.4 results
ONLY_USE_LIST=['admin@338_001',  'Lazarus_Group_001',  'Lazarus_Group_002',  'APT32_001',  'MuddyWater_001',  'MuddyWater_002',
                           'Mustang_Panda_001',  'Sandworm_001',  'Tropic_Trooper_001',  'APT28_001',  'APT28_002',  'APT28_003',  'APT28_004', 
                           'APT29_001',  'APT29_002',  'APT29_003',  'APT29_004']
                           
ONLY_USE_LIST=['APT41_001', 'APT41_002']

ONLY_USE_LIST=['admin@338_001',  'Lazarus_Group_001',  'Lazarus_Group_002',  'APT32_001',  'MuddyWater_001',  'MuddyWater_002',
                           'Mustang_Panda_001',  'Sandworm_001',  'Tropic_Trooper_001',  'APT28_001',  'APT28_002',  'APT28_003',  'APT28_004', 
                           'APT29_001',  'APT29_002',  'APT29_003',  'APT29_004',  'APT41_001', 'APT41_002',  'menuPass_001',  'Carbanak_001',  'APT37_001',  'WizardSpider_001', 
                           'OilRig_001',  'FIN7_001',  'APT3_001']

                           
UKCPhases=['IF-REC','IF-WEP', 'IF-DEL', 'IF-SEN', 'IF-EXP', 'IF-PER', 'IF-DEV', 'IF-C2C', 
                    'NP-DIS', 'NP-PES', 'NP-EXE', 'NP-CAC', 'NP-LMV', 
                    'AO-COL', 'AO-EXF', 'AO-TMA', 'AO-OBJ']
UKCCount=[0]*len(UKCPhases) # One for every use observed
UKCInstCount=[0]*len(UKCPhases) # One for each each attack with use observed

ListOfAttacks=[]

# Initialise the Tactic Transition Matrix (as dataframe)
HMMTacticList=[]
# Get rid of unwanted Tactics (done like this to make removal list clear.
for NextTactic in TacticList:
    if (not NextTactic == "TA0043") and (not NextTactic == "TA0042"):
        HMMTacticList.append(NextTactic)
    
TacticTransdf = pd.DataFrame(0.0, index=HMMTacticList, columns=HMMTacticList)
AttackTotalPerTactic=[0]*len(HMMTacticList)

ListofEmissionObs=[] # This will be filled up with all Dict/Tech pairs from the attacks
                                # This is used because we wont know the dataframe columns to use until we are finished
ListofSupportTTPairs=[] # Similar list of all the support pairs

for NextNode in AttackStartNodes:
    
    print("The next node is " + NextNode)
    
    PredTactic="" # Reset for start of a new attack
    PredTech=""
    AttackTacticCount=0 # Count for this attack only
    AttackTechCount=0 # Count for this attack only

    
    # Next two ifs just allows the test to be run against a subset of all the available attacks
    #
    if NextNode in IGNORE_LIST:
        continue
        
    if len(ONLY_USE_LIST) > 0:
        if not NextNode in ONLY_USE_LIST:
            continue
        else:
            ListOfAttacks.append(NextNode)
    
    # Check for edges into the Node indicating predecessor chain
    print("Checking for in edges")
    for NextE in G.in_edges(NextNode, data=True):
        #print("The next edge is " + str(NextE))
        
        # Only keep edges for this attack and part of a tech chain 
       
        if (NextE[2]['attack_id'] == NextNode) and \
                        (NextE[2]['edgetype'] == 4) :  
            
            print("Preceding attack sequence is " + NextE[0])    
    
    ExpectedNextEdge=1
    CurrentNode=NextNode
    AttackId=NextNode
    
    ThisAttackList=[]
    
    while 1:
        
        e=NextTechChainEdge(ExpectedNextEdge, 
                                          AttackId, 
                                          CurrentNode)
                                          

                                          
        if e == False:
            break
            
        TotalObsCount+=1
        
        # Keep a record of the step techniques e[1]
        TechNotCounted=True
        #if NextNode == "Tropic_Trooper_001":
            #print("Step Tech is " + e[1])
        for NextTech in TechUsedList:
            #if NextNode == "Tropic_Trooper_001":
                 #print("Stored Tech is " + NextTech)
            if e[1] == NextTech:
                TechNotCounted = False
        if TechNotCounted==True:
            #if NextNode == "Tropic_Trooper_001":
                #print("Adding Step Tech " + e[1])
            TechUsedList.append(e[1])
            TechUsedStepList.append(e[1])
        
        TechNotCounted=True    
        for NextTech in TechUsedStepList:
            #if NextNode == "Tropic_Trooper_001":
                 #print("Stored Tech is " + NextTech)
            if e[1] == NextTech:
                TechNotCounted = False
        if TechNotCounted==True:
            #if NextNode == "Tropic_Trooper_001":
                #print("Adding Step Tech " + e[1])
            TechUsedStepList.append(e[1])
            
        ExpectedNextEdge=e[2]['count'] + 1
        CurrentNode=e[1]
        
        TechTactic=GetTacticForTech(e[2]['count'],
                                        AttackId, 
                                        CurrentNode)
                                        
        SuppTechList=GetSuppTechForTech(e[2]['count'],
                                        AttackId, 
                                        CurrentNode)
                                        
        SuppTechTacticList=[]
        SuppTechTextString="["
        AllStepUKCPhase=""
        
        for NextSuppTech in SuppTechList:
            # Keep a record of the step techniques e[1]
            TechNotCounted=True
            for NextTech in TechUsedList:
                if NextSuppTech == NextTech:
                    TechNotCounted = False
            if TechNotCounted==True:
                TechUsedList.append(NextSuppTech)
                TechUsedSuppList.append(NextSuppTech)
                
            TacticForSuppTech=GetTacticForSuppTech(e[2]['count'],
                                        AttackId, 
                                        NextSuppTech)
                                        
            SuppTechTacticList.append(TacticForSuppTech['Tactic'])
            AllStepUKCPhase=AllStepUKCPhase+ TacticForSuppTech['KC'] + "/"
            
            SuppTechTextString=SuppTechTextString + "[" + NextSuppTech + "/" + \
                                             TacticForSuppTech['Tactic'] + "/" + \
                                                         TacticForSuppTech['KC'] + "]"
            
            # Keep a list of all the Tactic/Technique pairs
            # These are the supporting 'G' types here (see below for 'S' items)            
            ThisLineDict={'Tactic': TacticForSuppTech['Tactic'], 
                              'Technique': NextSuppTech}
            ListofSupportTTPairs.append(ThisLineDict)
                              
        SuppTechTextString=SuppTechTextString + "]"
                                         
        #print("<<" + NextNode + ">> " + "[" + str(e[2]['count']) + 
                #"] The next tech is " + str(e[1]) + 
                 #" with tactic " + str(TechTactic) + 
                 # "(Support is " + str(SuppTechList) + ")" +
                 #"(Support is " + SuppTechTextString + ")" +
                 #" and [KC]" + str(e[2]['KC'])
                 #)
        
        # Keep a list of all the Tactic/Technique pairs
        # These are the observed 'S' types here (see above for 'G' items)
        
        ThisLineDict={'Tactic': TechTactic, 
                              'Technique': str(e[1])}
                              
        ThisStepDict={'Attack':NextNode, 
                               'StepNum':str(e[2]['count']), 
                               'TacticName':str(TechTactic), 
                               'TacticNum':HMMTacticList.index(TechTactic), 
                               'TechName':str(e[1]), 
                               'TechNum':TechUsedStepList.index(str(e[1]))}
        ThisAttackList.append(ThisStepDict)
        
        
        ListofEmissionObs.append(ThisLineDict)
                 
        if not PredTactic == "":
            #print("Adding a Tactic Transition count to row " + PredTactic + " and col " + str(TechTactic))
            TacticTransdf.at[PredTactic,TechTactic]+=1
            AttackTotalPerTactic[HMMTacticList.index(PredTactic)]+=1
            
        #if not PredTech == "":
            #print("Adding a Technique Transition count to row " + PredTech + " and col " + str(e[1]))
            
        PredTactic=str(TechTactic)
        AttackTacticCount+=1
        PredTech=str(e[1])
        AttackTechCount+=1
                 
        ThisUKCPhaseList=(AllStepUKCPhase+str(e[2]['KC'])).split('/')
        #print("<<< " + str(ThisUKCPhaseList) + " >>>")
        
        # ###
        # Update counts (for display)
        #
        for NextUKCPhase in ThisUKCPhaseList:       
            try:
                UKCCount[UKCPhases.index(str(NextUKCPhase))]+=1
            except ValueError :
                print("Invalid UKC value (" + NextUKCPhase + ") in step " + str(e[2]['count'])  + " for " + NextNode)
            
        TacticCount[TacticList.index(str(TechTactic))]+=1
        for NextSuppTechTactic in SuppTechTacticList:
            TacticCount[TacticList.index(str(NextSuppTechTactic))]+=1
    
    AllAttacks.append(ThisAttackList)

#print(tabulate(TacticTransdf, headers='keys', tablefmt='psql'))

# Calculate the probalities along each row of HMM A Matrix
for NextTacticRow in HMMTacticList:
    for NextTacticCol in HMMTacticList:
        #print("Row is " + NextTacticRow + " / Col is " + NextTacticCol + ": " + str(TacticTransdf.at[NextTacticRow,NextTacticCol]) + "/" + str(AttackTotalPerTactic[HMMTacticList.index(NextTacticRow)]))
        TacticTransdf.at[NextTacticRow,NextTacticCol]=TacticTransdf.at[NextTacticRow,NextTacticCol]/AttackTotalPerTactic[HMMTacticList.index(NextTacticRow)]

        
print("Overall different technique count is " + str(len(TechUsedList)) + " of " + str(len(TechList)))    
# How many techs used by APTs
APTTechList=[]
for NextTech in TechList:
    #print("For tech " + NextTech)
    GL=ATTACK_obj.GetGroupForTTP(NextTech)
    #print("Len GL = " + str(len(GL)))
    if len(GL) > 0:
        APTTechList.append(NextTech)
    #print("Len APTTechList " + str(len(APTTechList)))
print("Total techs reported as used by APT " + str(len(APTTechList)) )
TechCountCount=[0]*10
for NextTech in APTTechList:
     TacticListForTech=ATTACK_obj.GetTacticsForTTP(NextTech)
     TechCountCount[len(TacticListForTech)]+=1

i=0
for TechCount in TechCountCount:
    print("There are " + str(TechCount) + " techniques that use " + str(i) + " tactics")
    i+=1
    
print("Total observation event count is " + str(TotalObsCount) )    
#print("Overall different technique is " + str(TechUsedList))   
#print("Overall different step technique is " + str(TechUsedStepList))
#print("Overall different support technique is " + str(TechUsedSuppList)) 

# ###############
#
#

ResultsList=[]

# Create a dataframe for Tech transitions
TechTransdf = pd.DataFrame(0.0, index=TechUsedList, columns=TechUsedList)
TechRowSums=[0]*len(TechUsedList)

for NextAttack in AllAttacks:
    
    AttackString="" # Will be a sequence of look up values for techniques
    AttackMainString="" # Will be a sequence of look up values for main techniques
    AttackTacticString="" # Will be a sequence of look up values for main techniques
    
    # Mark for first technique in an attack (i.e. we don't know the pred)
    Pred=False
    for NextObs in NextAttack:
        if NextObs['Attack'] == "APT28_002":
            print("In " + NextObs['Attack'])
            if NextObs['TechName'] == "T1114":
                print("Have found obs and Pred set to " + str(Pred))
        #print("Working on transitions")
        if not Pred == False:
            TechTransdf.at[Pred, NextObs['TechName']]+=1
            TechRowSums[TechUsedList.index(Pred)]+=1
        
        Pred = NextObs['TechName']
        
# The counts are now populated, so divide by row totals
ZeroDivList=[]
for NextRowTech in TechUsedList:    
    for NextColTech in TechUsedList:   
        if not TechTransdf.at[NextRowTech, NextColTech] == 0:
            pass
            #print("For row " + NextRowTech + " and col " + NextColTech + " Tot is " +
            #             str(TechTransdf.at[NextRowTech, NextColTech]) + " (Divide = " + str(TechRowSums[TechUsedList.index(NextRowTech)]) + " )")
        if not TechRowSums[TechUsedList.index(NextRowTech)] == 0:
            TechTransdf.at[NextRowTech, NextColTech]=TechTransdf.at[NextRowTech, NextColTech]/TechRowSums[TechUsedList.index(NextRowTech)]
        else:
            if not NextRowTech in ZeroDivList:
                ZeroDivList.append(NextRowTech)
            
print("Attempted zero divide for " + str(ZeroDivList)  )

print("Removing irrelevant rows and columns")
SafeToDelete=[]
NotSafeToDelete=[]
for NextZero in ZeroDivList:
    # Get the total for the row
    RowSum = TechTransdf.loc[NextZero].sum()
    ColSum = TechTransdf[NextZero].sum()
    if RowSum == 0 and ColSum == 0:
        SafeToDelete.append(NextZero)
    else:
        NotSafeToDelete.append(NextZero)
        
print("Safe to delete is " + str(SafeToDelete))
print("Not safe to delete is " + str(NotSafeToDelete))

# Rempve unnecessay rows and columns
for NextRowCol in SafeToDelete:
    pass
    # Row
    TechTransdf = TechTransdf.drop(NextRowCol, axis=0)
    # Column
    TechTransdf = TechTransdf.drop(NextRowCol, axis=1)
    
# Now use transition matrix on examples

Fail=0
Succeed=0

for NextAttack in AllAttacks:
    pass 
    TestExtract=[]
    EndExtract=False
    ExpectedNextStep=""
    GetNext=False
    TestExtractLen=0
    for NextObs in NextAttack:
        #ThisStepDict={'Attack':NextNode, 
        #                       'StepNum':str(e[2]['count']), 
        #                       'TacticName':str(TechTactic), 
        #                       'TacticNum':HMMTacticList.index(TechTactic), 
        #                       'TechName':str(e[1]), 
        #                       'TechNum':TechUsedStepList.index(str(e[1]))}
        #print("[" + NextObs['Attack'] + "][" + NextObs['StepNum'] + "]")
        # Build example string
        if (EndExtract == True) and (GetNext==True):
            GetNext=False
            ExpectedNextStep=NextObs['TechName']
            pass
        if TestExtractLen < 3:
            TestExtractLen+=1
            TestExtract.append(NextObs['TechName']) 
        else:
            EndExtract=True
            GetNext=True
            
        
        pass
        
    print("Attack extract for " + NextObs['Attack'] + " is " + str(TestExtract) + " next is " + str(ExpectedNextStep))
    
    
    if not ExpectedNextStep == "":
        # Get the row associated with the last technique in the extract
        pass
        PredRow = TechTransdf.loc[TestExtract[-1]]
        
        Max=0
        MaxIndex=""
        for index, value in PredRow.items():
            if value > Max:
                Max=value
                MaxIndex=index
            pass
            
        print("Most likely " + str(MaxIndex))
        
        if MaxIndex == ExpectedNextStep:
            Succeed+=1
        else:
            Fail+=1
    
print("Success " + str(Succeed) + " / Fail " + str(Fail))
