
#__author__ = "Chris Maidens"
#__copyright__ = "Copyright (C) 2020 Chris Maidens"
#__license__ = "No license granted"
#__version__ = "0.1"
import os

import MAFpt_r_params as rpar

import MAFpt_ATTACK_DB_v2 as ATTACK

YAML_Root = os.environ.get('MAFpt_YAML_ROOT')
YAML_File = os.environ.get('MAFpt_YAML_FILE')
YAML_File="MAFpt_RunParams.yaml"

YAML_Root = os.getcwd()
YAML_File="/MAFpt_ATTACK_DB_TEST_RunParams.yaml"

p_obj = rpar.MAFpt_r_params(YAML_Root + YAML_File)

DOWNLOAD_ATTACK=p_obj.MAFpt_r_read("RUN_DOWNLOAD_ATTACK")
REINDEX_ATTACK=p_obj.MAFpt_r_read("RUN_REINDEX_ATTACK")
ATTACK_LOCAL_FILE_ROOT = p_obj.MAFpt_r_read('RUN_ATTACK_LOCAL_FILE_ROOT')
ATTACK_TAXII_SERVER = p_obj.MAFpt_r_read('RUN_ATTACK_TAXII_SERVER')
ATTACK_LOCAL_COPY = p_obj.MAFpt_r_read('RUN_ATTACK_LOCAL_COPY')
ATTACK_CVE_SEARCH = p_obj.MAFpt_r_read('RUN_ATTACK_CVE_SEARCH')
ATTACK_MAIN_INDEX = p_obj.MAFpt_r_read('RUN_ATTACK_MAIN_INDEX')
ATTACK_SUB_INDEX = p_obj.MAFpt_r_read('RUN_ATTACK_SUB_INDEX')
ATTACK_CVE_REF_INDEX = p_obj.MAFpt_r_read('RUN_ATTACK_CVE_REF_INDEX')
ATTACK_TTP_INDEX = p_obj.MAFpt_r_read('RUN_ATTACK_TTP_INDEX')
ATTACK_TACTIC_INDEX = p_obj.MAFpt_r_read('RUN_ATTACK_TACTIC_INDEX')
ATTACK_TECH_TO_TACTIC_INDEX = p_obj.MAFpt_r_read('RUN_ATTACK_TECH_TO_TACTIC_INDEX')
ATTACK_REL_INDEX = p_obj.MAFpt_r_read('RUN_ATTACK_REL_INDEX')    
ATTACK_TACTIC_BIN_INDEX = p_obj.MAFpt_r_read('RUN_ATTACK_TACTIC_BIN_INDEX')   
ATTACK_TTP_BIN_INDEX = p_obj.MAFpt_r_read('RUN_ATTACK_TTP_BIN_INDEX') 

ATTACK_obj = ATTACK.MAFpt_ATTACK_DB(DOWNLOAD_ATTACK,
                         ATTACK_TAXII_SERVER,
                         ATTACK_LOCAL_FILE_ROOT,
                         ATTACK_LOCAL_COPY,
                         REINDEX_ATTACK,
                         ATTACK_CVE_SEARCH, 
                         ATTACK_MAIN_INDEX, 
                         ATTACK_SUB_INDEX, 
                         ATTACK_CVE_REF_INDEX, 
                         ATTACK_TTP_INDEX, 
                         ATTACK_TACTIC_INDEX, 
                         ATTACK_TECH_TO_TACTIC_INDEX, 
                         ATTACK_REL_INDEX, 
                         ATTACK_TACTIC_BIN_INDEX, 
                         ATTACK_TTP_BIN_INDEX) 
                         
TacticBinDF=ATTACK_obj.GetTacticBinIndex()
                         
Tactic="TA0004"

TacticName=ATTACK_obj.GetTacticName(Tactic)

print("Tactic Name for " + Tactic + " : " + TacticName)

TTP="T1059"

Parent_Text=""

if "." in TTP:
    Parent=ATTACK_obj.GetTechForSub(TTP)
    TTPDict=ATTACK_obj.GetTTPDetails(Parent)
    Parent_Text=TTPDict['TTP_Name']

TTPDict=ATTACK_obj.GetTTPDetails(TTP)

print("Technique name for " + TTP + " : " + Parent_Text + " : " +TTPDict['TTP_Name'])

ONLY_USE_LIST_ORIG=['admin@338_001',  'Lazarus_Group_001',  'Lazarus_Group_002',  'APT32_001',  'MuddyWater_001',  'MuddyWater_002',
                           'Mustang_Panda_001',  'Sandworm_001',  'Tropic_Trooper_001',  'APT28_001',  'APT28_002',  'APT28_003',  'APT28_004', 
                           'APT29_001',  'APT29_002',  'APT29_003',  'APT29_004',  'APT41_001', 'APT41_002',  'menuPass_001',  'Carbanak_001',  'APT37_001',  'WizardSpider_001', 
                           'OilRig_001',  'FIN7_001',  'APT3_001']
                           
ONLY_USE_LIST_NEXT=['admin@338_001',  'Lazarus_Group_001',  'Lazarus_Group_002',  'APT32_001',  'MuddyWater_001',  'MuddyWater_002',
                           'Mustang_Panda_001',  'Sandworm_001',  'Tropic_Trooper_001',  'APT28_001',  'APT28_002',  'APT28_003',  'APT28_004', 
                           'APT29_001',  'APT29_002',  'APT29_003',  'APT29_004',  'APT41_001', 'APT41_002',  'menuPass_001',  'Carbanak_001',  'APT37_001',  'WizardSpider_001', 
                           'OilRig_001',  'FIN7_001',  'APT3_001',  'Ajax_Security_Team_001',  'Andariel_001',  'APT38_001']
                           
ONLY_USE_LIST_FULL=['admin@338_001',  'Lazarus_Group_001',  'Lazarus_Group_002',  'APT32_001',  'MuddyWater_001',  'MuddyWater_002',
                           'Mustang_Panda_001',  'Sandworm_001',  'Tropic_Trooper_001',  'APT28_001',  'APT28_002',  'APT28_003',  'APT28_004', 
                           'APT29_001',  'APT29_002',  'APT29_003',  'APT29_004',  'APT41_001', 'APT41_002',  'menuPass_001',  'Carbanak_001',  'APT37_001',  'WizardSpider_001', 
                           'OilRig_001',  'FIN7_001',  'APT3_001',  'Ajax_Security_Team_001',  'Andariel_001',  'APT38_001',  'ZAPT33_001', 
                           'ZAPT19_001', 'ZSandworm_002',  'ZAPT28_005',  'ZAPT32_001', 'ZAPT29_005']


ONLY_USE_LIST=['admin@338_001',  'Lazarus_Group_001',  'Lazarus_Group_002',  'APT32_001',  'MuddyWater_001',  'MuddyWater_002',
                           'Mustang_Panda_001',  'Sandworm_001',  'Tropic_Trooper_001',  'APT28_001',  'APT28_002',  'APT28_003',  'APT28_004', 
                           'APT29_001',  'APT29_002',  'APT29_003',  'APT29_004',  'APT41_001', 'APT41_002',  'menuPass_001',  'Carbanak_001',  'APT37_001',  'WizardSpider_001', 
                           'OilRig_001',  'FIN7_001',  'APT3_001',  'Ajax_Security_Team_001',  'Andariel_001',  'APT38_001',  'ZAPT33_001', 
                           'ZAPT19_001', 'ZSandworm_002',  'ZAPT28_005',  'ZAPT32_001', 'ZAPT29_005']

                           
from MAFpt_ATTACK_DB_ATTACK_GRAPHS_DATA_AUTO import ThisAttackTechList 

AttackSeqTacticList=[]
AttackSeqTacticCount=[]
IDList=[]
count=0
ExamplesList=[]
TacCkList=["TA0008"]
for ThisAttack in ThisAttackTechList:
    IDLine=True
    PrevTac=""
    PrevTech=""
    AttackName=""
    ExampleCount=0
    InExample=False
    for NextNode in ThisAttack:
        if IDLine==True:
            if not NextNode['ID'] in ONLY_USE_LIST:
                    break
            IDLine=False
            IDList.append(NextNode["ID"])
            AttackName=NextNode["ID"]
            count+=1
            
        else:
            if NextNode['SG'] == 'G':
                continue
                    
            #print("The Tactic is " + NextNode['Tactic'])
            if not NextNode['Tactic'] in AttackSeqTacticList:
                AttackSeqTacticList.append(NextNode['Tactic'])
                AttackSeqTacticCount.append(0)
            AttackSeqTacticCount[AttackSeqTacticList.index(NextNode['Tactic'])]+=1
            
            # T1547.001
            if NextNode['Tech'] == 'T1547.001':
                print("For " + NextNode['Tech'] + " the tactic is " + NextNode['Tactic'])
                                               
            if NextNode['Tactic'] in TacCkList:
                ExampleCount+=1
                InExample=True
                
                ThisDict={'Attack':AttackName, 
                                     'ExampleCount':ExampleCount, 
                                     'ID':NextNode['StepNo'], 
                                     'Tactic':PrevTac, 
                                     'Technique':PrevTech}
                ExamplesList.append(ThisDict)
                ThisDict={'Attack':AttackName, 
                                    'ExampleCount':ExampleCount, 
                                    'ID':NextNode['StepNo'], 
                                    'Tactic':NextNode['Tactic'], 
                                    'Technique':NextNode['Tech']}
                ExamplesList.append(ThisDict)
                
            if InExample == True:
                ThisDict={'Attack':AttackName, 
                                    'ExampleCount':ExampleCount, 
                                    'ID':NextNode['StepNo'], 
                                    'Tactic':NextNode['Tactic'], 
                                    'Technique':NextNode['Tech']}
                ExamplesList.append(ThisDict)
                if not NextNode['Tactic'] in TacCkList:
                    InExample=False
                
                
            PrevTac=NextNode['Tactic']
            PrevTech=NextNode['Tech']
            
            
            
            
            
            
IDList.sort()

print(str(count))
print(IDList)

FinalCount=0

for NextTactic in AttackSeqTacticList:
    ThisCount=AttackSeqTacticCount[AttackSeqTacticList.index(NextTactic)]
    print("The count for " + NextTactic + " is " + str(ThisCount))
    FinalCount+= ThisCount
    
print("The total count is " + str(FinalCount))

for NextItem in TacCkList:
    for NextEx in ExamplesList:
        print("For " + NextItem + " Attack: " + str(NextEx['Attack']) + " ID: " + str(NextEx['ID']) 
                                                      + " Count: " + str(NextEx['ExampleCount']) + " Tactic:" + str(NextEx['Tactic']) 
                                                               + " Technique:" + str(NextEx['Technique']))

